
package org.apache.airavata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "ServingState",
    "Path",
    "AccessMode",
    "SharingID",
    "AccessLatency",
    "RetentionPolicy",
    "ExpirationMode",
    "DefaultLifeTime",
    "MaximumLifeTime",
    "Tag",
    "StorageShareCapacityID"
})
public class StorageShare_ {

    /**
     * How the Share is currently serving jobs
     * 
     */
    @JsonProperty("ServingState")
    private StorageShare_.ServingState servingState;
    /**
     * A default namespace where files are logically placed when they are stored in this Share
     * 
     */
    @JsonProperty("Path")
    private String path;
    /**
     * The type of access allowed for this share - AccessMode_t (undefined)
     * 
     */
    @JsonProperty("AccessMode")
    private List<String> accessMode = new ArrayList<String>();
    /**
     * A local identifier common to the set of StorageShares which use the same underling extents
     * 
     */
    @JsonProperty("SharingID")
    private String sharingID;
    /**
     * The maximum latency category under normal operating conditions
     * 
     */
    @JsonProperty("AccessLatency")
    private StorageShare_.AccessLatency accessLatency;
    /**
     * The quality of data retention - RetentionPolicy_t
     * 
     */
    @JsonProperty("RetentionPolicy")
    private String retentionPolicy;
    /**
     * Supported file lifetime modes
     * 
     */
    @JsonProperty("ExpirationMode")
    private List<ExpirationMode> expirationMode = new ArrayList<ExpirationMode>();
    /**
     * The default lifetime assigned to a new file
     * 
     */
    @JsonProperty("DefaultLifeTime")
    private Integer defaultLifeTime;
    /**
     * The maximum lifetime that can be requested for a file
     * 
     */
    @JsonProperty("MaximumLifeTime")
    private Integer maximumLifeTime;
    /**
     * An identifier defined by a UserDomain
     * 
     */
    @JsonProperty("Tag")
    private String tag;
    /**
     * ID of the StorageShareCapacities associated with this share
     * 
     */
    @JsonProperty("StorageShareCapacityID")
    private List<String> storageShareCapacityID = new ArrayList<String>();
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * How the Share is currently serving jobs
     * 
     */
    @JsonProperty("ServingState")
    public StorageShare_.ServingState getServingState() {
        return servingState;
    }

    /**
     * How the Share is currently serving jobs
     * 
     */
    @JsonProperty("ServingState")
    public void setServingState(StorageShare_.ServingState servingState) {
        this.servingState = servingState;
    }

    /**
     * A default namespace where files are logically placed when they are stored in this Share
     * 
     */
    @JsonProperty("Path")
    public String getPath() {
        return path;
    }

    /**
     * A default namespace where files are logically placed when they are stored in this Share
     * 
     */
    @JsonProperty("Path")
    public void setPath(String path) {
        this.path = path;
    }

    /**
     * The type of access allowed for this share - AccessMode_t (undefined)
     * 
     */
    @JsonProperty("AccessMode")
    public List<String> getAccessMode() {
        return accessMode;
    }

    /**
     * The type of access allowed for this share - AccessMode_t (undefined)
     * 
     */
    @JsonProperty("AccessMode")
    public void setAccessMode(List<String> accessMode) {
        this.accessMode = accessMode;
    }

    /**
     * A local identifier common to the set of StorageShares which use the same underling extents
     * 
     */
    @JsonProperty("SharingID")
    public String getSharingID() {
        return sharingID;
    }

    /**
     * A local identifier common to the set of StorageShares which use the same underling extents
     * 
     */
    @JsonProperty("SharingID")
    public void setSharingID(String sharingID) {
        this.sharingID = sharingID;
    }

    /**
     * The maximum latency category under normal operating conditions
     * 
     */
    @JsonProperty("AccessLatency")
    public StorageShare_.AccessLatency getAccessLatency() {
        return accessLatency;
    }

    /**
     * The maximum latency category under normal operating conditions
     * 
     */
    @JsonProperty("AccessLatency")
    public void setAccessLatency(StorageShare_.AccessLatency accessLatency) {
        this.accessLatency = accessLatency;
    }

    /**
     * The quality of data retention - RetentionPolicy_t
     * 
     */
    @JsonProperty("RetentionPolicy")
    public String getRetentionPolicy() {
        return retentionPolicy;
    }

    /**
     * The quality of data retention - RetentionPolicy_t
     * 
     */
    @JsonProperty("RetentionPolicy")
    public void setRetentionPolicy(String retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
    }

    /**
     * Supported file lifetime modes
     * 
     */
    @JsonProperty("ExpirationMode")
    public List<ExpirationMode> getExpirationMode() {
        return expirationMode;
    }

    /**
     * Supported file lifetime modes
     * 
     */
    @JsonProperty("ExpirationMode")
    public void setExpirationMode(List<ExpirationMode> expirationMode) {
        this.expirationMode = expirationMode;
    }

    /**
     * The default lifetime assigned to a new file
     * 
     */
    @JsonProperty("DefaultLifeTime")
    public Integer getDefaultLifeTime() {
        return defaultLifeTime;
    }

    /**
     * The default lifetime assigned to a new file
     * 
     */
    @JsonProperty("DefaultLifeTime")
    public void setDefaultLifeTime(Integer defaultLifeTime) {
        this.defaultLifeTime = defaultLifeTime;
    }

    /**
     * The maximum lifetime that can be requested for a file
     * 
     */
    @JsonProperty("MaximumLifeTime")
    public Integer getMaximumLifeTime() {
        return maximumLifeTime;
    }

    /**
     * The maximum lifetime that can be requested for a file
     * 
     */
    @JsonProperty("MaximumLifeTime")
    public void setMaximumLifeTime(Integer maximumLifeTime) {
        this.maximumLifeTime = maximumLifeTime;
    }

    /**
     * An identifier defined by a UserDomain
     * 
     */
    @JsonProperty("Tag")
    public String getTag() {
        return tag;
    }

    /**
     * An identifier defined by a UserDomain
     * 
     */
    @JsonProperty("Tag")
    public void setTag(String tag) {
        this.tag = tag;
    }

    /**
     * ID of the StorageShareCapacities associated with this share
     * 
     */
    @JsonProperty("StorageShareCapacityID")
    public List<String> getStorageShareCapacityID() {
        return storageShareCapacityID;
    }

    /**
     * ID of the StorageShareCapacities associated with this share
     * 
     */
    @JsonProperty("StorageShareCapacityID")
    public void setStorageShareCapacityID(List<String> storageShareCapacityID) {
        this.storageShareCapacityID = storageShareCapacityID;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Generated("org.jsonschema2pojo")
    public static enum AccessLatency {

        NEARLINE("nearline"),
        OFFLINE("offline"),
        ONLINE("online");
        private final String value;
        private static Map<String, StorageShare_.AccessLatency> constants = new HashMap<String, StorageShare_.AccessLatency>();

        static {
            for (StorageShare_.AccessLatency c: StorageShare_.AccessLatency.values()) {
                constants.put(c.value, c);
            }
        }

        private AccessLatency(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static StorageShare_.AccessLatency fromValue(String value) {
            StorageShare_.AccessLatency constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("org.jsonschema2pojo")
    public static enum ServingState {

        CLOSED("closed"),
        DRAINING("draining"),
        PRODUCTION("production"),
        QUEUEING("queueing");
        private final String value;
        private static Map<String, StorageShare_.ServingState> constants = new HashMap<String, StorageShare_.ServingState>();

        static {
            for (StorageShare_.ServingState c: StorageShare_.ServingState.values()) {
                constants.put(c.value, c);
            }
        }

        private ServingState(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static StorageShare_.ServingState fromValue(String value) {
            StorageShare_.ServingState constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
