/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.monitor.impl.pull.qstat;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.core.monitor.MonitorID;
import org.apache.airavata.gfac.gsissh.security.GSISecurityContext;
import org.apache.airavata.gfac.monitor.HostMonitorData;
import org.apache.airavata.gfac.ssh.security.SSHSecurityContext;
import org.apache.airavata.gsi.ssh.api.SSHApiException;
import org.apache.airavata.gsi.ssh.api.authentication.AuthenticationInfo;
import org.apache.airavata.gsi.ssh.impl.JobStatus;
import org.apache.airavata.gsi.ssh.impl.PBSCluster;
import org.apache.airavata.model.workspace.experiment.JobState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceConnection {
    private static final Logger log = LoggerFactory.getLogger(ResourceConnection.class);
    private PBSCluster cluster;
    private AuthenticationInfo authenticationInfo;

    public ResourceConnection(HostMonitorData hostMonitorData, AuthenticationInfo authInfo) throws SSHApiException {
        MonitorID monitorID = hostMonitorData.getMonitorIDs().get(0);
        try {
            GSISecurityContext securityContext = (GSISecurityContext)monitorID.getJobExecutionContext().getSecurityContext("gsi");
            if (securityContext != null) {
                this.cluster = (PBSCluster)securityContext.getPbsCluster();
            } else {
                SSHSecurityContext sshSecurityContext = (SSHSecurityContext)monitorID.getJobExecutionContext().getSecurityContext("ssh");
                this.cluster = (PBSCluster)sshSecurityContext.getPbsCluster();
            }
            this.authenticationInfo = authInfo;
        }
        catch (GFacException e) {
            log.error("Error reading data from job ExecutionContext");
        }
    }

    public ResourceConnection(HostMonitorData hostMonitorData) throws SSHApiException {
        MonitorID monitorID = hostMonitorData.getMonitorIDs().get(0);
        try {
            GSISecurityContext securityContext = (GSISecurityContext)monitorID.getJobExecutionContext().getSecurityContext("gsi");
            this.cluster = (PBSCluster)securityContext.getPbsCluster();
            this.cluster = new PBSCluster(this.cluster.getServerInfo(), this.authenticationInfo, this.cluster.getJobManagerConfiguration());
        }
        catch (GFacException e) {
            log.error("Error reading data from job ExecutionContext");
        }
    }

    public JobState getJobStatus(MonitorID monitorID) throws SSHApiException {
        String jobID = monitorID.getJobID();
        return this.getStatusFromString(this.cluster.getJobStatus(jobID).toString());
    }

    public Map<String, JobState> getJobStatuses(List<MonitorID> monitorIDs) throws SSHApiException {
        TreeMap<String, JobStatus> treeMap = new TreeMap<String, JobStatus>();
        TreeMap<String, JobState> treeMap1 = new TreeMap<String, JobState>();
        for (MonitorID monitorID : monitorIDs) {
            treeMap.put(monitorID.getJobID(), JobStatus.U);
        }
        String userName = this.cluster.getServerInfo().getUserName();
        this.cluster.getJobStatuses(userName, treeMap);
        for (String key : treeMap.keySet()) {
            treeMap1.put(key, this.getStatusFromString(((JobStatus)treeMap.get(key)).toString()));
        }
        return treeMap1;
    }

    private JobState getStatusFromString(String status) {
        log.info("parsing the job status returned : " + status);
        if (status != null) {
            if ("C".equals(status) || "CD".equals(status) || "E".equals(status) || "CG".equals(status)) {
                return JobState.COMPLETE;
            }
            if ("H".equals(status) || "h".equals(status)) {
                return JobState.HELD;
            }
            if ("Q".equals(status) || "qw".equals(status)) {
                return JobState.QUEUED;
            }
            if ("R".equals(status) || "CF".equals(status) || "r".equals(status)) {
                return JobState.ACTIVE;
            }
            if ("T".equals(status)) {
                return JobState.HELD;
            }
            if ("W".equals(status) || "PD".equals(status)) {
                return JobState.QUEUED;
            }
            if ("S".equals(status)) {
                return JobState.SUSPENDED;
            }
            if ("CA".equals(status)) {
                return JobState.CANCELED;
            }
            if ("F".equals(status) || "NF".equals(status) || "TO".equals(status)) {
                return JobState.FAILED;
            }
            if ("PR".equals(status) || "Er".equals(status)) {
                return JobState.FAILED;
            }
            if ("U".equals(status)) {
                return JobState.UNKNOWN;
            }
        }
        return JobState.UNKNOWN;
    }

    public PBSCluster getCluster() {
        return this.cluster;
    }

    public void setCluster(PBSCluster cluster) {
        this.cluster = cluster;
    }
}

