
package org.apache.airavata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "Description",
    "WWW",
    "ContactID",
    "LocationID"
})
public class Domain {

    /**
     * A description of the Domain
     * 
     */
    @JsonProperty("Description")
    private String description;
    /**
     * URLs of web pages with more information about the Domain
     * 
     */
    @JsonProperty("WWW")
    private List<String> wWW = new ArrayList<String>();
    /**
     * IDs of Contacts for this Domain
     * 
     */
    @JsonProperty("ContactID")
    private List<String> contactID = new ArrayList<String>();
    /**
     * The ID of the primary Location for this Domain
     * 
     */
    @JsonProperty("LocationID")
    private String locationID;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * A description of the Domain
     * 
     */
    @JsonProperty("Description")
    public String getDescription() {
        return description;
    }

    /**
     * A description of the Domain
     * 
     */
    @JsonProperty("Description")
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * URLs of web pages with more information about the Domain
     * 
     */
    @JsonProperty("WWW")
    public List<String> getWWW() {
        return wWW;
    }

    /**
     * URLs of web pages with more information about the Domain
     * 
     */
    @JsonProperty("WWW")
    public void setWWW(List<String> wWW) {
        this.wWW = wWW;
    }

    /**
     * IDs of Contacts for this Domain
     * 
     */
    @JsonProperty("ContactID")
    public List<String> getContactID() {
        return contactID;
    }

    /**
     * IDs of Contacts for this Domain
     * 
     */
    @JsonProperty("ContactID")
    public void setContactID(List<String> contactID) {
        this.contactID = contactID;
    }

    /**
     * The ID of the primary Location for this Domain
     * 
     */
    @JsonProperty("LocationID")
    public String getLocationID() {
        return locationID;
    }

    /**
     * The ID of the primary Location for this Domain
     * 
     */
    @JsonProperty("LocationID")
    public void setLocationID(String locationID) {
        this.locationID = locationID;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
