
package org.apache.airavata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "CreationTime",
    "Validity",
    "ID",
    "Name",
    "OtherInfo",
    "Extension"
})
public class Entity {

    /**
     * The creation time of this entity in the format: CCYY-MM-DDThh:mm:ss[Z|(+|-)hh:mm]
     * 
     */
    @JsonProperty("CreationTime")
    private String creationTime;
    /**
     * The number of seconds after CreationTime that this entity should be considered relevant
     * 
     */
    @JsonProperty("Validity")
    private Integer validity;
    /**
     * A globally unique identifier for this entity
     * 
     */
    @JsonProperty("ID")
    private String iD;
    /**
     * A human-readable name
     * 
     */
    @JsonProperty("Name")
    private String name;
    /**
     * Placeholder for information that does not fit in any other attribute
     * 
     */
    @JsonProperty("OtherInfo")
    private List<String> otherInfo = new ArrayList<String>();
    /**
     * Key/value pairs enabling the association of extra information not captured by the model
     * 
     */
    @JsonProperty("Extension")
    private Extension extension;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * The creation time of this entity in the format: CCYY-MM-DDThh:mm:ss[Z|(+|-)hh:mm]
     * 
     */
    @JsonProperty("CreationTime")
    public String getCreationTime() {
        return creationTime;
    }

    /**
     * The creation time of this entity in the format: CCYY-MM-DDThh:mm:ss[Z|(+|-)hh:mm]
     * 
     */
    @JsonProperty("CreationTime")
    public void setCreationTime(String creationTime) {
        this.creationTime = creationTime;
    }

    /**
     * The number of seconds after CreationTime that this entity should be considered relevant
     * 
     */
    @JsonProperty("Validity")
    public Integer getValidity() {
        return validity;
    }

    /**
     * The number of seconds after CreationTime that this entity should be considered relevant
     * 
     */
    @JsonProperty("Validity")
    public void setValidity(Integer validity) {
        this.validity = validity;
    }

    /**
     * A globally unique identifier for this entity
     * 
     */
    @JsonProperty("ID")
    public String getID() {
        return iD;
    }

    /**
     * A globally unique identifier for this entity
     * 
     */
    @JsonProperty("ID")
    public void setID(String iD) {
        this.iD = iD;
    }

    /**
     * A human-readable name
     * 
     */
    @JsonProperty("Name")
    public String getName() {
        return name;
    }

    /**
     * A human-readable name
     * 
     */
    @JsonProperty("Name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Placeholder for information that does not fit in any other attribute
     * 
     */
    @JsonProperty("OtherInfo")
    public List<String> getOtherInfo() {
        return otherInfo;
    }

    /**
     * Placeholder for information that does not fit in any other attribute
     * 
     */
    @JsonProperty("OtherInfo")
    public void setOtherInfo(List<String> otherInfo) {
        this.otherInfo = otherInfo;
    }

    /**
     * Key/value pairs enabling the association of extra information not captured by the model
     * 
     */
    @JsonProperty("Extension")
    public Extension getExtension() {
        return extension;
    }

    /**
     * Key/value pairs enabling the association of extra information not captured by the model
     * 
     */
    @JsonProperty("Extension")
    public void setExtension(Extension extension) {
        this.extension = extension;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
