
package org.apache.airavata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "Platform",
    "VirtualMachine",
    "TotalInstances",
    "UsedInstances",
    "UnavailableInstances",
    "PhysicalCPUs",
    "LogicalCPUs",
    "CPUMultiplicity",
    "CPUVendor",
    "CPUModel",
    "CPUVersion",
    "CPUClockSpeed",
    "CPUTimeScalingFactor",
    "WallTimeScalingFactor",
    "MainMemorySize",
    "VirtualMemorySize",
    "OSFamily",
    "OSName",
    "OSVersion",
    "ConnectivityIn",
    "ConnectivityOut",
    "NetworkInfo",
    "ApplicationEnvironmentID",
    "BenchmarkID"
})
public class ExecutionEnvironment {

    /**
     * The platform architecture - Platform_t (open enumeration)
     * 
     */
    @JsonProperty("Platform")
    private String platform;
    /**
     * True if the ExecutionEnvironment is a virtual machine
     * 
     */
    @JsonProperty("VirtualMachine")
    private Boolean virtualMachine;
    /**
     * The total number of ExecutionEnvironment instances
     * 
     */
    @JsonProperty("TotalInstances")
    private Integer totalInstances;
    /**
     * The number of ExecutionEnvironment instances in use
     * 
     */
    @JsonProperty("UsedInstances")
    private Integer usedInstances;
    /**
     * The number of ExecutionEnvironment instances that are unavailable
     * 
     */
    @JsonProperty("UnavailableInstances")
    private Integer unavailableInstances;
    /**
     * The number of physical CPUs in one ExecutionEnvironment instance
     * 
     */
    @JsonProperty("PhysicalCPUs")
    private Integer physicalCPUs;
    /**
     * The number of logical CPUs in one ExecutionEnvironment instance
     * 
     */
    @JsonProperty("LogicalCPUs")
    private Integer logicalCPUs;
    /**
     * Information about the CPUs and cores in an execution environment
     * 
     */
    @JsonProperty("CPUMultiplicity")
    private ExecutionEnvironment.CPUMultiplicity cPUMultiplicity;
    /**
     * The name of the manufacturer of the CPU
     * 
     */
    @JsonProperty("CPUVendor")
    private String cPUVendor;
    /**
     * The model of the CPU, as defined by the vendor
     * 
     */
    @JsonProperty("CPUModel")
    private String cPUModel;
    /**
     * The specific version name of the CPU, as defined by the vendor
     * 
     */
    @JsonProperty("CPUVersion")
    private String cPUVersion;
    /**
     * The clock speed of the CPU (MHz)
     * 
     */
    @JsonProperty("CPUClockSpeed")
    private Integer cPUClockSpeed;
    /**
     * The factor used by the ComputingManager to scale the CPU time limit
     * 
     */
    @JsonProperty("CPUTimeScalingFactor")
    private Object cPUTimeScalingFactor;
    /**
     * The factor used by the ComputingManager to scale the wallclock time limit
     * 
     */
    @JsonProperty("WallTimeScalingFactor")
    private Object wallTimeScalingFactor;
    /**
     * The total amount of physical RAM in one ExecutionEnvironment instance (MB)
     * 
     */
    @JsonProperty("MainMemorySize")
    private Integer mainMemorySize;
    /**
     * The total amount of virtual memory (RAM+swap) in one ExecutionEnvironment instance (MB)
     * 
     */
    @JsonProperty("VirtualMemorySize")
    private Integer virtualMemorySize;
    /**
     * The general family of the operating system - OSFamily_t (open enumeration)
     * 
     */
    @JsonProperty("OSFamily")
    private String oSFamily;
    /**
     * The specific name of the operating system - OSName_t (open enumeration)
     * 
     */
    @JsonProperty("OSName")
    private String oSName;
    /**
     * The version of the operating system, as defined by the vendor
     * 
     */
    @JsonProperty("OSVersion")
    private String oSVersion;
    /**
     * True if direct inbound network connectiity is available to a running job
     * 
     */
    @JsonProperty("ConnectivityIn")
    private Boolean connectivityIn;
    /**
     * True if direct outbound network connectiity is available to a running job
     * 
     */
    @JsonProperty("ConnectivityOut")
    private Boolean connectivityOut;
    /**
     * The types of internal network connections between ExecutionEnvironments - NetworkInfo_t (open enumeration)
     * 
     */
    @JsonProperty("NetworkInfo")
    private List<String> networkInfo = new ArrayList<String>();
    /**
     * ID(s) of ApplicationEnvironments available in this ExecutionEnvironment
     * 
     */
    @JsonProperty("ApplicationEnvironmentID")
    private List<String> applicationEnvironmentID = new ArrayList<String>();
    /**
     * ID(s) of Benchmarks associated with this ExecutionEnvironment
     * 
     */
    @JsonProperty("BenchmarkID")
    private List<String> benchmarkID = new ArrayList<String>();
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * The platform architecture - Platform_t (open enumeration)
     * 
     */
    @JsonProperty("Platform")
    public String getPlatform() {
        return platform;
    }

    /**
     * The platform architecture - Platform_t (open enumeration)
     * 
     */
    @JsonProperty("Platform")
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    /**
     * True if the ExecutionEnvironment is a virtual machine
     * 
     */
    @JsonProperty("VirtualMachine")
    public Boolean getVirtualMachine() {
        return virtualMachine;
    }

    /**
     * True if the ExecutionEnvironment is a virtual machine
     * 
     */
    @JsonProperty("VirtualMachine")
    public void setVirtualMachine(Boolean virtualMachine) {
        this.virtualMachine = virtualMachine;
    }

    /**
     * The total number of ExecutionEnvironment instances
     * 
     */
    @JsonProperty("TotalInstances")
    public Integer getTotalInstances() {
        return totalInstances;
    }

    /**
     * The total number of ExecutionEnvironment instances
     * 
     */
    @JsonProperty("TotalInstances")
    public void setTotalInstances(Integer totalInstances) {
        this.totalInstances = totalInstances;
    }

    /**
     * The number of ExecutionEnvironment instances in use
     * 
     */
    @JsonProperty("UsedInstances")
    public Integer getUsedInstances() {
        return usedInstances;
    }

    /**
     * The number of ExecutionEnvironment instances in use
     * 
     */
    @JsonProperty("UsedInstances")
    public void setUsedInstances(Integer usedInstances) {
        this.usedInstances = usedInstances;
    }

    /**
     * The number of ExecutionEnvironment instances that are unavailable
     * 
     */
    @JsonProperty("UnavailableInstances")
    public Integer getUnavailableInstances() {
        return unavailableInstances;
    }

    /**
     * The number of ExecutionEnvironment instances that are unavailable
     * 
     */
    @JsonProperty("UnavailableInstances")
    public void setUnavailableInstances(Integer unavailableInstances) {
        this.unavailableInstances = unavailableInstances;
    }

    /**
     * The number of physical CPUs in one ExecutionEnvironment instance
     * 
     */
    @JsonProperty("PhysicalCPUs")
    public Integer getPhysicalCPUs() {
        return physicalCPUs;
    }

    /**
     * The number of physical CPUs in one ExecutionEnvironment instance
     * 
     */
    @JsonProperty("PhysicalCPUs")
    public void setPhysicalCPUs(Integer physicalCPUs) {
        this.physicalCPUs = physicalCPUs;
    }

    /**
     * The number of logical CPUs in one ExecutionEnvironment instance
     * 
     */
    @JsonProperty("LogicalCPUs")
    public Integer getLogicalCPUs() {
        return logicalCPUs;
    }

    /**
     * The number of logical CPUs in one ExecutionEnvironment instance
     * 
     */
    @JsonProperty("LogicalCPUs")
    public void setLogicalCPUs(Integer logicalCPUs) {
        this.logicalCPUs = logicalCPUs;
    }

    /**
     * Information about the CPUs and cores in an execution environment
     * 
     */
    @JsonProperty("CPUMultiplicity")
    public ExecutionEnvironment.CPUMultiplicity getCPUMultiplicity() {
        return cPUMultiplicity;
    }

    /**
     * Information about the CPUs and cores in an execution environment
     * 
     */
    @JsonProperty("CPUMultiplicity")
    public void setCPUMultiplicity(ExecutionEnvironment.CPUMultiplicity cPUMultiplicity) {
        this.cPUMultiplicity = cPUMultiplicity;
    }

    /**
     * The name of the manufacturer of the CPU
     * 
     */
    @JsonProperty("CPUVendor")
    public String getCPUVendor() {
        return cPUVendor;
    }

    /**
     * The name of the manufacturer of the CPU
     * 
     */
    @JsonProperty("CPUVendor")
    public void setCPUVendor(String cPUVendor) {
        this.cPUVendor = cPUVendor;
    }

    /**
     * The model of the CPU, as defined by the vendor
     * 
     */
    @JsonProperty("CPUModel")
    public String getCPUModel() {
        return cPUModel;
    }

    /**
     * The model of the CPU, as defined by the vendor
     * 
     */
    @JsonProperty("CPUModel")
    public void setCPUModel(String cPUModel) {
        this.cPUModel = cPUModel;
    }

    /**
     * The specific version name of the CPU, as defined by the vendor
     * 
     */
    @JsonProperty("CPUVersion")
    public String getCPUVersion() {
        return cPUVersion;
    }

    /**
     * The specific version name of the CPU, as defined by the vendor
     * 
     */
    @JsonProperty("CPUVersion")
    public void setCPUVersion(String cPUVersion) {
        this.cPUVersion = cPUVersion;
    }

    /**
     * The clock speed of the CPU (MHz)
     * 
     */
    @JsonProperty("CPUClockSpeed")
    public Integer getCPUClockSpeed() {
        return cPUClockSpeed;
    }

    /**
     * The clock speed of the CPU (MHz)
     * 
     */
    @JsonProperty("CPUClockSpeed")
    public void setCPUClockSpeed(Integer cPUClockSpeed) {
        this.cPUClockSpeed = cPUClockSpeed;
    }

    /**
     * The factor used by the ComputingManager to scale the CPU time limit
     * 
     */
    @JsonProperty("CPUTimeScalingFactor")
    public Object getCPUTimeScalingFactor() {
        return cPUTimeScalingFactor;
    }

    /**
     * The factor used by the ComputingManager to scale the CPU time limit
     * 
     */
    @JsonProperty("CPUTimeScalingFactor")
    public void setCPUTimeScalingFactor(Object cPUTimeScalingFactor) {
        this.cPUTimeScalingFactor = cPUTimeScalingFactor;
    }

    /**
     * The factor used by the ComputingManager to scale the wallclock time limit
     * 
     */
    @JsonProperty("WallTimeScalingFactor")
    public Object getWallTimeScalingFactor() {
        return wallTimeScalingFactor;
    }

    /**
     * The factor used by the ComputingManager to scale the wallclock time limit
     * 
     */
    @JsonProperty("WallTimeScalingFactor")
    public void setWallTimeScalingFactor(Object wallTimeScalingFactor) {
        this.wallTimeScalingFactor = wallTimeScalingFactor;
    }

    /**
     * The total amount of physical RAM in one ExecutionEnvironment instance (MB)
     * 
     */
    @JsonProperty("MainMemorySize")
    public Integer getMainMemorySize() {
        return mainMemorySize;
    }

    /**
     * The total amount of physical RAM in one ExecutionEnvironment instance (MB)
     * 
     */
    @JsonProperty("MainMemorySize")
    public void setMainMemorySize(Integer mainMemorySize) {
        this.mainMemorySize = mainMemorySize;
    }

    /**
     * The total amount of virtual memory (RAM+swap) in one ExecutionEnvironment instance (MB)
     * 
     */
    @JsonProperty("VirtualMemorySize")
    public Integer getVirtualMemorySize() {
        return virtualMemorySize;
    }

    /**
     * The total amount of virtual memory (RAM+swap) in one ExecutionEnvironment instance (MB)
     * 
     */
    @JsonProperty("VirtualMemorySize")
    public void setVirtualMemorySize(Integer virtualMemorySize) {
        this.virtualMemorySize = virtualMemorySize;
    }

    /**
     * The general family of the operating system - OSFamily_t (open enumeration)
     * 
     */
    @JsonProperty("OSFamily")
    public String getOSFamily() {
        return oSFamily;
    }

    /**
     * The general family of the operating system - OSFamily_t (open enumeration)
     * 
     */
    @JsonProperty("OSFamily")
    public void setOSFamily(String oSFamily) {
        this.oSFamily = oSFamily;
    }

    /**
     * The specific name of the operating system - OSName_t (open enumeration)
     * 
     */
    @JsonProperty("OSName")
    public String getOSName() {
        return oSName;
    }

    /**
     * The specific name of the operating system - OSName_t (open enumeration)
     * 
     */
    @JsonProperty("OSName")
    public void setOSName(String oSName) {
        this.oSName = oSName;
    }

    /**
     * The version of the operating system, as defined by the vendor
     * 
     */
    @JsonProperty("OSVersion")
    public String getOSVersion() {
        return oSVersion;
    }

    /**
     * The version of the operating system, as defined by the vendor
     * 
     */
    @JsonProperty("OSVersion")
    public void setOSVersion(String oSVersion) {
        this.oSVersion = oSVersion;
    }

    /**
     * True if direct inbound network connectiity is available to a running job
     * 
     */
    @JsonProperty("ConnectivityIn")
    public Boolean getConnectivityIn() {
        return connectivityIn;
    }

    /**
     * True if direct inbound network connectiity is available to a running job
     * 
     */
    @JsonProperty("ConnectivityIn")
    public void setConnectivityIn(Boolean connectivityIn) {
        this.connectivityIn = connectivityIn;
    }

    /**
     * True if direct outbound network connectiity is available to a running job
     * 
     */
    @JsonProperty("ConnectivityOut")
    public Boolean getConnectivityOut() {
        return connectivityOut;
    }

    /**
     * True if direct outbound network connectiity is available to a running job
     * 
     */
    @JsonProperty("ConnectivityOut")
    public void setConnectivityOut(Boolean connectivityOut) {
        this.connectivityOut = connectivityOut;
    }

    /**
     * The types of internal network connections between ExecutionEnvironments - NetworkInfo_t (open enumeration)
     * 
     */
    @JsonProperty("NetworkInfo")
    public List<String> getNetworkInfo() {
        return networkInfo;
    }

    /**
     * The types of internal network connections between ExecutionEnvironments - NetworkInfo_t (open enumeration)
     * 
     */
    @JsonProperty("NetworkInfo")
    public void setNetworkInfo(List<String> networkInfo) {
        this.networkInfo = networkInfo;
    }

    /**
     * ID(s) of ApplicationEnvironments available in this ExecutionEnvironment
     * 
     */
    @JsonProperty("ApplicationEnvironmentID")
    public List<String> getApplicationEnvironmentID() {
        return applicationEnvironmentID;
    }

    /**
     * ID(s) of ApplicationEnvironments available in this ExecutionEnvironment
     * 
     */
    @JsonProperty("ApplicationEnvironmentID")
    public void setApplicationEnvironmentID(List<String> applicationEnvironmentID) {
        this.applicationEnvironmentID = applicationEnvironmentID;
    }

    /**
     * ID(s) of Benchmarks associated with this ExecutionEnvironment
     * 
     */
    @JsonProperty("BenchmarkID")
    public List<String> getBenchmarkID() {
        return benchmarkID;
    }

    /**
     * ID(s) of Benchmarks associated with this ExecutionEnvironment
     * 
     */
    @JsonProperty("BenchmarkID")
    public void setBenchmarkID(List<String> benchmarkID) {
        this.benchmarkID = benchmarkID;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Generated("org.jsonschema2pojo")
    public static enum CPUMultiplicity {

        MULTICPU_MULTICORE("multicpu-multicore"),
        MULTICPU_SINGLECORE("multicpu-singlecore"),
        SINGLECPU_MULTICORE("singlecpu-multicore"),
        SINGLECPU_SINGLECORE("singlecpu-singlecore");
        private final String value;
        private static Map<String, ExecutionEnvironment.CPUMultiplicity> constants = new HashMap<String, ExecutionEnvironment.CPUMultiplicity>();

        static {
            for (ExecutionEnvironment.CPUMultiplicity c: ExecutionEnvironment.CPUMultiplicity.values()) {
                constants.put(c.value, c);
            }
        }

        private CPUMultiplicity(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ExecutionEnvironment.CPUMultiplicity fromValue(String value) {
            ExecutionEnvironment.CPUMultiplicity constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
