
package org.apache.airavata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "Description",
    "EndpointID",
    "ResourceID",
    "ServiceID",
    "ActivityID",
    "MappingPolicyID"
})
public class Share_ {

    /**
     * A human-readable description of the Share
     * 
     */
    @JsonProperty("Description")
    private String description;
    /**
     * The ID(s) of the Endpoints that can be used to access this Share
     * 
     */
    @JsonProperty("EndpointID")
    private List<String> endpointID = new ArrayList<String>();
    /**
     * The ID(s) of the Resources associated with this Share
     * 
     */
    @JsonProperty("ResourceID")
    private List<String> resourceID = new ArrayList<String>();
    /**
     * The ID of the Service this Share participates in
     * 
     */
    @JsonProperty("ServiceID")
    private String serviceID;
    /**
     * The ID(s) of Activities consuming from this Share
     * 
     */
    @JsonProperty("ActivityID")
    private List<String> activityID = new ArrayList<String>();
    /**
     * ID(s) of MappingPolicies associated with this Share
     * 
     */
    @JsonProperty("MappingPolicyID")
    private List<String> mappingPolicyID = new ArrayList<String>();
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * A human-readable description of the Share
     * 
     */
    @JsonProperty("Description")
    public String getDescription() {
        return description;
    }

    /**
     * A human-readable description of the Share
     * 
     */
    @JsonProperty("Description")
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * The ID(s) of the Endpoints that can be used to access this Share
     * 
     */
    @JsonProperty("EndpointID")
    public List<String> getEndpointID() {
        return endpointID;
    }

    /**
     * The ID(s) of the Endpoints that can be used to access this Share
     * 
     */
    @JsonProperty("EndpointID")
    public void setEndpointID(List<String> endpointID) {
        this.endpointID = endpointID;
    }

    /**
     * The ID(s) of the Resources associated with this Share
     * 
     */
    @JsonProperty("ResourceID")
    public List<String> getResourceID() {
        return resourceID;
    }

    /**
     * The ID(s) of the Resources associated with this Share
     * 
     */
    @JsonProperty("ResourceID")
    public void setResourceID(List<String> resourceID) {
        this.resourceID = resourceID;
    }

    /**
     * The ID of the Service this Share participates in
     * 
     */
    @JsonProperty("ServiceID")
    public String getServiceID() {
        return serviceID;
    }

    /**
     * The ID of the Service this Share participates in
     * 
     */
    @JsonProperty("ServiceID")
    public void setServiceID(String serviceID) {
        this.serviceID = serviceID;
    }

    /**
     * The ID(s) of Activities consuming from this Share
     * 
     */
    @JsonProperty("ActivityID")
    public List<String> getActivityID() {
        return activityID;
    }

    /**
     * The ID(s) of Activities consuming from this Share
     * 
     */
    @JsonProperty("ActivityID")
    public void setActivityID(List<String> activityID) {
        this.activityID = activityID;
    }

    /**
     * ID(s) of MappingPolicies associated with this Share
     * 
     */
    @JsonProperty("MappingPolicyID")
    public List<String> getMappingPolicyID() {
        return mappingPolicyID;
    }

    /**
     * ID(s) of MappingPolicies associated with this Share
     * 
     */
    @JsonProperty("MappingPolicyID")
    public void setMappingPolicyID(List<String> mappingPolicyID) {
        this.mappingPolicyID = mappingPolicyID;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
