/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.monitor;

import java.util.ArrayList;
import java.util.List;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.monitor.MonitorID;
import org.apache.airavata.gfac.monitor.exception.AiravataMonitorException;
import org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription;
import org.apache.airavata.model.appcatalog.computeresource.DataMovementProtocol;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionProtocol;

public class HostMonitorData {
    private ComputeResourceDescription computeResourceDescription;
    private JobSubmissionProtocol jobSubmissionProtocol;
    private DataMovementProtocol dataMovementProtocol;
    private List<MonitorID> monitorIDs;

    public HostMonitorData(JobExecutionContext jobExecutionContext) {
        this.computeResourceDescription = jobExecutionContext.getApplicationContext().getComputeResourceDescription();
        this.jobSubmissionProtocol = jobExecutionContext.getPreferredJobSubmissionProtocol();
        this.dataMovementProtocol = jobExecutionContext.getPreferredDataMovementProtocol();
        this.monitorIDs = new ArrayList<MonitorID>();
    }

    public HostMonitorData(JobExecutionContext jobExecutionContext, List<MonitorID> monitorIDs) {
        this.computeResourceDescription = jobExecutionContext.getApplicationContext().getComputeResourceDescription();
        this.jobSubmissionProtocol = jobExecutionContext.getPreferredJobSubmissionProtocol();
        this.dataMovementProtocol = jobExecutionContext.getPreferredDataMovementProtocol();
        this.monitorIDs = monitorIDs;
    }

    public ComputeResourceDescription getComputeResourceDescription() {
        return this.computeResourceDescription;
    }

    public void setComputeResourceDescription(ComputeResourceDescription computeResourceDescription) {
        this.computeResourceDescription = computeResourceDescription;
    }

    public List<MonitorID> getMonitorIDs() {
        return this.monitorIDs;
    }

    public void setMonitorIDs(List<MonitorID> monitorIDs) {
        this.monitorIDs = monitorIDs;
    }

    public void addMonitorIDForHost(MonitorID monitorID) throws AiravataMonitorException {
        this.monitorIDs.add(monitorID);
    }

    public JobSubmissionProtocol getJobSubmissionProtocol() {
        return this.jobSubmissionProtocol;
    }

    public DataMovementProtocol getDataMovementProtocol() {
        return this.dataMovementProtocol;
    }
}

