/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.monitor.handlers;

import java.io.File;
import java.util.Properties;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.logger.AiravataLogger;
import org.apache.airavata.common.logger.AiravataLoggerFactory;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.cpi.BetterGfacImpl;
import org.apache.airavata.gfac.core.handler.GFacHandlerException;
import org.apache.airavata.gfac.core.handler.ThreadedHandler;
import org.apache.airavata.gfac.core.utils.GFacUtils;
import org.apache.airavata.gfac.monitor.HPCMonitorID;
import org.apache.airavata.gfac.monitor.exception.AiravataMonitorException;
import org.apache.airavata.gfac.monitor.impl.pull.qstat.HPCPullMonitor;
import org.apache.airavata.gfac.monitor.util.CommonUtils;
import org.apache.airavata.gsi.ssh.api.authentication.AuthenticationInfo;
import org.apache.airavata.gsi.ssh.impl.authentication.MyProxyAuthenticationInfo;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class GridPullMonitorHandler
extends ThreadedHandler
implements Watcher {
    private static final AiravataLogger logger = AiravataLoggerFactory.getLogger(GridPullMonitorHandler.class);
    private HPCPullMonitor hpcPullMonitor;
    private AuthenticationInfo authenticationInfo;

    public void initProperties(Properties properties) throws GFacHandlerException {
        String myProxyUser = null;
        try {
            myProxyUser = ServerSettings.getSetting((String)"myproxy.username");
            String myProxyPass = ServerSettings.getSetting((String)"myproxy.password");
            String certPath = ServerSettings.getSetting((String)"trusted.cert.location");
            String myProxyServer = ServerSettings.getSetting((String)"myproxy.server");
            this.setAuthenticationInfo((AuthenticationInfo)new MyProxyAuthenticationInfo(myProxyUser, myProxyPass, myProxyServer, 7512, 17280000, certPath));
            if (BetterGfacImpl.getMonitorPublisher() == null) {
                throw new GFacHandlerException("Error initializing Monitor Handler, because Monitor Publisher is null !!!");
            }
            this.hpcPullMonitor = new HPCPullMonitor(BetterGfacImpl.getMonitorPublisher(), this.getAuthenticationInfo());
        }
        catch (ApplicationSettingsException e) {
            e.printStackTrace();
        }
    }

    public void run() {
        this.hpcPullMonitor.run();
    }

    public void invoke(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        super.invoke(jobExecutionContext);
        this.hpcPullMonitor.setGfac(jobExecutionContext.getGfac());
        HPCMonitorID monitorID = new HPCMonitorID(this.getAuthenticationInfo(), jobExecutionContext);
        try {
            ZooKeeper zk = jobExecutionContext.getZk();
            try {
                String experimentEntry = GFacUtils.findExperimentEntry((String)jobExecutionContext.getExperimentID(), (String)jobExecutionContext.getTaskData().getTaskID(), (ZooKeeper)zk);
                String path = experimentEntry + File.separator + "operation";
                Stat exists = zk.exists(path, (Watcher)this);
                if (exists != null) {
                    zk.getData(path, (Watcher)this, exists);
                }
            }
            catch (KeeperException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            CommonUtils.addMonitortoQueue(this.hpcPullMonitor.getQueue(), monitorID, jobExecutionContext);
            CommonUtils.increaseZkJobCount(monitorID);
        }
        catch (AiravataMonitorException e) {
            logger.errorId(monitorID.getJobID(), "Error adding job {} monitorID object to the queue with experiment {}", (Object)monitorID.getJobID(), (Object)monitorID.getExperimentID());
        }
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return this.authenticationInfo;
    }

    public HPCPullMonitor getHpcPullMonitor() {
        return this.hpcPullMonitor;
    }

    public void setAuthenticationInfo(AuthenticationInfo authenticationInfo) {
        this.authenticationInfo = authenticationInfo;
    }

    public void setHpcPullMonitor(HPCPullMonitor hpcPullMonitor) {
        this.hpcPullMonitor = hpcPullMonitor;
    }

    public void process(WatchedEvent watchedEvent) {
        if (Watcher.Event.EventType.NodeDataChanged.equals((Object)watchedEvent.getType())) {
            String[] split;
            logger.info("Experiment is cancelled with this path:" + watchedEvent.getPath());
            for (String element : split = watchedEvent.getPath().split("/")) {
                if (!element.contains("+")) continue;
                logger.info("Adding experimentID+TaskID to be removed from monitoring:" + element);
                this.hpcPullMonitor.getCancelJobList().add(element);
            }
        }
    }
}

