/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.server;

import com.google.common.eventbus.EventBus;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.airavata.appcatalog.cpi.AppCatalog;
import org.apache.aiaravata.application.catalog.data.impl.AppCatalogFactory;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.logger.AiravataLogger;
import org.apache.airavata.common.logger.AiravataLoggerFactory;
import org.apache.airavata.common.utils.AiravataZKUtils;
import org.apache.airavata.common.utils.MonitorPublisher;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.gfac.core.cpi.BetterGfacImpl;
import org.apache.airavata.gfac.core.cpi.GFac;
import org.apache.airavata.gfac.core.utils.GFacThreadPoolExecutor;
import org.apache.airavata.gfac.core.utils.InputHandlerWorker;
import org.apache.airavata.gfac.cpi.GfacService;
import org.apache.airavata.persistance.registry.jpa.impl.RegistryFactory;
import org.apache.airavata.registry.cpi.Registry;
import org.apache.thrift.TException;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class GfacServerHandler
implements GfacService.Iface,
Watcher {
    private static final AiravataLogger logger = AiravataLoggerFactory.getLogger(GfacServerHandler.class);
    private Registry registry;
    private AppCatalog appCatalog;
    private String registryURL;
    private String gatewayName;
    private String airavataUserName;
    private ZooKeeper zk;
    private boolean connected = false;
    private static Integer mutex = -1;
    private MonitorPublisher publisher;
    private String gfacServer;
    private String gfacExperiments;
    private String airavataServerHostPort;
    private List<Future> inHandlerFutures;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GfacServerHandler() {
        try {
            String zkhostPort = AiravataZKUtils.getZKhostPort();
            this.airavataServerHostPort = ServerSettings.getSetting((String)"gfac.server.host") + ":" + ServerSettings.getSetting((String)"gfac.server.port");
            try {
                this.zk = new ZooKeeper(zkhostPort, 6000, (Watcher)this);
                this.gfacServer = ServerSettings.getSetting((String)"gfac-server", (String)"/gfac-server");
                this.gfacExperiments = ServerSettings.getSetting((String)"gfac-experiments", (String)"/gfac-experiments");
                Integer n = mutex;
                synchronized (n) {
                    mutex.wait();
                }
                this.storeServerConfig();
                logger.info("Finished starting ZK: " + this.zk);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (KeeperException e) {
                e.printStackTrace();
            }
        }
        catch (ApplicationSettingsException e) {
            e.printStackTrace();
        }
        try {
            this.publisher = new MonitorPublisher(new EventBus());
            BetterGfacImpl.setMonitorPublisher((MonitorPublisher)this.publisher);
            this.registry = RegistryFactory.getDefaultRegistry();
            this.appCatalog = AppCatalogFactory.getAppCatalog();
            this.setGatewayProperties();
            BetterGfacImpl.startDaemonHandlers();
            BetterGfacImpl.startStatusUpdators((Registry)this.registry, (ZooKeeper)this.zk, (MonitorPublisher)this.publisher);
            this.inHandlerFutures = new ArrayList<Future>();
        }
        catch (Exception e) {
            logger.error("Error initialising GFAC", (Throwable)e);
        }
    }

    private void storeServerConfig() throws KeeperException, InterruptedException, ApplicationSettingsException {
        Stat zkStat = this.zk.exists(this.gfacServer, false);
        if (zkStat == null) {
            this.zk.create(this.gfacServer, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        String instanceId = ServerSettings.getSetting((String)"gfac-server-name");
        String instantNode = this.gfacServer + File.separator + instanceId;
        zkStat = this.zk.exists(instantNode, true);
        if (zkStat == null) {
            this.zk.create(instantNode, this.airavataServerHostPort.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        }
        if ((zkStat = this.zk.exists(this.gfacExperiments, false)) == null) {
            this.zk.create(this.gfacExperiments, this.airavataServerHostPort.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        if ((zkStat = this.zk.exists(this.gfacExperiments + File.separator + instanceId, false)) == null) {
            this.zk.create(this.gfacExperiments + File.separator + instanceId, this.airavataServerHostPort.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        } else {
            logger.error(" Zookeeper is inconsistent state  !!!!!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void process(WatchedEvent watchedEvent) {
        Integer n = mutex;
        synchronized (n) {
            Watcher.Event.KeeperState state = watchedEvent.getState();
            logger.info(state.name());
            if (state == Watcher.Event.KeeperState.SyncConnected) {
                mutex.notify();
                this.connected = true;
            } else if (state == Watcher.Event.KeeperState.Expired || state == Watcher.Event.KeeperState.Disconnected) {
                try {
                    mutex = -1;
                    this.zk = new ZooKeeper(AiravataZKUtils.getZKhostPort(), 6000, (Watcher)this);
                    Integer n2 = mutex;
                    synchronized (n2) {
                        mutex.wait();
                    }
                    this.storeServerConfig();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ApplicationSettingsException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (KeeperException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public String getGFACServiceVersion() throws TException {
        return "0.13.0";
    }

    @Override
    public boolean submitJob(String experimentId, String taskId, String gatewayId) throws TException {
        logger.infoId(experimentId, "GFac Received submit jog request for the Experiment: {} TaskId: {}", (Object)experimentId, (Object)taskId);
        GFac gfac = this.getGfac();
        InputHandlerWorker inputHandlerWorker = new InputHandlerWorker(gfac, experimentId, taskId, gatewayId);
        logger.debugId(experimentId, "Submitted jog to the Gfac Implementation, experiment {}, task {}, gateway {}", new Object[]{experimentId, taskId, gatewayId});
        this.inHandlerFutures.add(GFacThreadPoolExecutor.getFixedThreadPool().submit(inputHandlerWorker));
        return true;
    }

    @Override
    public boolean cancelJob(String experimentId, String taskId) throws TException {
        logger.infoId(experimentId, "GFac Received cancel job request for Experiment: {} TaskId: {} ", (Object)experimentId, (Object)taskId);
        GFac gfac = this.getGfac();
        try {
            if (gfac.cancel(experimentId, taskId, ServerSettings.getDefaultUserGateway())) {
                logger.debugId(experimentId, "Successfully cancelled job, experiment {} , task {}", (Object)experimentId, (Object)taskId);
                return true;
            }
            logger.errorId(experimentId, "Job cancellation failed, experiment {} , task {}", (Object)experimentId, (Object)taskId);
            return false;
        }
        catch (Exception e) {
            logger.errorId(experimentId, "Error cancelling the experiment {}.", (Object)experimentId);
            throw new TException("Error cancelling the experiment : " + e.getMessage(), (Throwable)e);
        }
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public String getGatewayName() {
        return this.gatewayName;
    }

    public void setGatewayName(String gatewayName) {
        this.gatewayName = gatewayName;
    }

    public String getAiravataUserName() {
        return this.airavataUserName;
    }

    public void setAiravataUserName(String airavataUserName) {
        this.airavataUserName = airavataUserName;
    }

    protected void setGatewayProperties() throws ApplicationSettingsException {
        this.setAiravataUserName(ServerSettings.getDefaultUser());
        this.setGatewayName(ServerSettings.getDefaultUserGateway());
    }

    private GFac getGfac() throws TException {
        try {
            return new BetterGfacImpl(this.registry, this.appCatalog, this.zk, this.publisher);
        }
        catch (Exception e) {
            throw new TException("Error initializing gfac instance", (Throwable)e);
        }
    }
}

