/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

/**
 * Autogenerated by Thrift Compiler (0.9.1)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.airavata.experiment.execution;

import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;

import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.server.AbstractNonblockingServer.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterpreterService {

    public interface Iface {

        public String runExperiment(String workflowTemplateName, Map<String,String> workflowInputs, ExperimentAdvanceOptions experimentAdOptions) throws org.apache.thrift.TException;

        public void cancelExperiment(String experimentID) throws org.apache.thrift.TException;

        public void suspendExperiment(String experimentID) throws org.apache.thrift.TException;

        public void resumeExperiment(String experimentID) throws org.apache.thrift.TException;

    }

    public interface AsyncIface {

        public void runExperiment(String workflowTemplateName, Map<String,String> workflowInputs, ExperimentAdvanceOptions experimentAdOptions, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

        public void cancelExperiment(String experimentID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

        public void suspendExperiment(String experimentID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

        public void resumeExperiment(String experimentID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    }

    public static class Client extends org.apache.thrift.TServiceClient implements Iface {
        public static class Factory implements org.apache.thrift.TServiceClientFactory<Client> {
            public Factory() {}
            public Client getClient(org.apache.thrift.protocol.TProtocol prot) {
                return new Client(prot);
            }
            public Client getClient(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
                return new Client(iprot, oprot);
            }
        }

        public Client(org.apache.thrift.protocol.TProtocol prot)
        {
            super(prot, prot);
        }

        public Client(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
            super(iprot, oprot);
        }

        public String runExperiment(String workflowTemplateName, Map<String,String> workflowInputs, ExperimentAdvanceOptions experimentAdOptions) throws org.apache.thrift.TException
        {
            send_runExperiment(workflowTemplateName, workflowInputs, experimentAdOptions);
            return recv_runExperiment();
        }

        public void send_runExperiment(String workflowTemplateName, Map<String,String> workflowInputs, ExperimentAdvanceOptions experimentAdOptions) throws org.apache.thrift.TException
        {
            runExperiment_args args = new runExperiment_args();
            args.setWorkflowTemplateName(workflowTemplateName);
            args.setWorkflowInputs(workflowInputs);
            args.setExperimentAdOptions(experimentAdOptions);
            sendBase("runExperiment", args);
        }

        public String recv_runExperiment() throws org.apache.thrift.TException
        {
            runExperiment_result result = new runExperiment_result();
            receiveBase(result, "runExperiment");
            if (result.isSetSuccess()) {
                return result.success;
            }
            throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "runExperiment failed: unknown result");
        }

        public void cancelExperiment(String experimentID) throws org.apache.thrift.TException
        {
            send_cancelExperiment(experimentID);
            recv_cancelExperiment();
        }

        public void send_cancelExperiment(String experimentID) throws org.apache.thrift.TException
        {
            cancelExperiment_args args = new cancelExperiment_args();
            args.setExperimentID(experimentID);
            sendBase("cancelExperiment", args);
        }

        public void recv_cancelExperiment() throws org.apache.thrift.TException
        {
            cancelExperiment_result result = new cancelExperiment_result();
            receiveBase(result, "cancelExperiment");
            return;
        }

        public void suspendExperiment(String experimentID) throws org.apache.thrift.TException
        {
            send_suspendExperiment(experimentID);
            recv_suspendExperiment();
        }

        public void send_suspendExperiment(String experimentID) throws org.apache.thrift.TException
        {
            suspendExperiment_args args = new suspendExperiment_args();
            args.setExperimentID(experimentID);
            sendBase("suspendExperiment", args);
        }

        public void recv_suspendExperiment() throws org.apache.thrift.TException
        {
            suspendExperiment_result result = new suspendExperiment_result();
            receiveBase(result, "suspendExperiment");
            return;
        }

        public void resumeExperiment(String experimentID) throws org.apache.thrift.TException
        {
            send_resumeExperiment(experimentID);
            recv_resumeExperiment();
        }

        public void send_resumeExperiment(String experimentID) throws org.apache.thrift.TException
        {
            resumeExperiment_args args = new resumeExperiment_args();
            args.setExperimentID(experimentID);
            sendBase("resumeExperiment", args);
        }

        public void recv_resumeExperiment() throws org.apache.thrift.TException
        {
            resumeExperiment_result result = new resumeExperiment_result();
            receiveBase(result, "resumeExperiment");
            return;
        }

    }
    public static class AsyncClient extends org.apache.thrift.async.TAsyncClient implements AsyncIface {
        public static class Factory implements org.apache.thrift.async.TAsyncClientFactory<AsyncClient> {
            private org.apache.thrift.async.TAsyncClientManager clientManager;
            private org.apache.thrift.protocol.TProtocolFactory protocolFactory;
            public Factory(org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.protocol.TProtocolFactory protocolFactory) {
                this.clientManager = clientManager;
                this.protocolFactory = protocolFactory;
            }
            public AsyncClient getAsyncClient(org.apache.thrift.transport.TNonblockingTransport transport) {
                return new AsyncClient(protocolFactory, clientManager, transport);
            }
        }

        public AsyncClient(org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.transport.TNonblockingTransport transport) {
            super(protocolFactory, clientManager, transport);
        }

        public void runExperiment(String workflowTemplateName, Map<String,String> workflowInputs, ExperimentAdvanceOptions experimentAdOptions, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
            checkReady();
            runExperiment_call method_call = new runExperiment_call(workflowTemplateName, workflowInputs, experimentAdOptions, resultHandler, this, ___protocolFactory, ___transport);
            this.___currentMethod = method_call;
            ___manager.call(method_call);
        }

        public static class runExperiment_call extends org.apache.thrift.async.TAsyncMethodCall {
            private String workflowTemplateName;
            private Map<String,String> workflowInputs;
            private ExperimentAdvanceOptions experimentAdOptions;
            public runExperiment_call(String workflowTemplateName, Map<String,String> workflowInputs, ExperimentAdvanceOptions experimentAdOptions, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
                super(client, protocolFactory, transport, resultHandler, false);
                this.workflowTemplateName = workflowTemplateName;
                this.workflowInputs = workflowInputs;
                this.experimentAdOptions = experimentAdOptions;
            }

            public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
                prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("runExperiment", org.apache.thrift.protocol.TMessageType.CALL, 0));
                runExperiment_args args = new runExperiment_args();
                args.setWorkflowTemplateName(workflowTemplateName);
                args.setWorkflowInputs(workflowInputs);
                args.setExperimentAdOptions(experimentAdOptions);
                args.write(prot);
                prot.writeMessageEnd();
            }

            public String getResult() throws org.apache.thrift.TException {
                if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
                    throw new IllegalStateException("Method call not finished!");
                }
                org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
                org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
                return (new Client(prot)).recv_runExperiment();
            }
        }

        public void cancelExperiment(String experimentID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
            checkReady();
            cancelExperiment_call method_call = new cancelExperiment_call(experimentID, resultHandler, this, ___protocolFactory, ___transport);
            this.___currentMethod = method_call;
            ___manager.call(method_call);
        }

        public static class cancelExperiment_call extends org.apache.thrift.async.TAsyncMethodCall {
            private String experimentID;
            public cancelExperiment_call(String experimentID, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
                super(client, protocolFactory, transport, resultHandler, false);
                this.experimentID = experimentID;
            }

            public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
                prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("cancelExperiment", org.apache.thrift.protocol.TMessageType.CALL, 0));
                cancelExperiment_args args = new cancelExperiment_args();
                args.setExperimentID(experimentID);
                args.write(prot);
                prot.writeMessageEnd();
            }

            public void getResult() throws org.apache.thrift.TException {
                if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
                    throw new IllegalStateException("Method call not finished!");
                }
                org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
                org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
                (new Client(prot)).recv_cancelExperiment();
            }
        }

        public void suspendExperiment(String experimentID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
            checkReady();
            suspendExperiment_call method_call = new suspendExperiment_call(experimentID, resultHandler, this, ___protocolFactory, ___transport);
            this.___currentMethod = method_call;
            ___manager.call(method_call);
        }

        public static class suspendExperiment_call extends org.apache.thrift.async.TAsyncMethodCall {
            private String experimentID;
            public suspendExperiment_call(String experimentID, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
                super(client, protocolFactory, transport, resultHandler, false);
                this.experimentID = experimentID;
            }

            public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
                prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("suspendExperiment", org.apache.thrift.protocol.TMessageType.CALL, 0));
                suspendExperiment_args args = new suspendExperiment_args();
                args.setExperimentID(experimentID);
                args.write(prot);
                prot.writeMessageEnd();
            }

            public void getResult() throws org.apache.thrift.TException {
                if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
                    throw new IllegalStateException("Method call not finished!");
                }
                org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
                org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
                (new Client(prot)).recv_suspendExperiment();
            }
        }

        public void resumeExperiment(String experimentID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
            checkReady();
            resumeExperiment_call method_call = new resumeExperiment_call(experimentID, resultHandler, this, ___protocolFactory, ___transport);
            this.___currentMethod = method_call;
            ___manager.call(method_call);
        }

        public static class resumeExperiment_call extends org.apache.thrift.async.TAsyncMethodCall {
            private String experimentID;
            public resumeExperiment_call(String experimentID, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
                super(client, protocolFactory, transport, resultHandler, false);
                this.experimentID = experimentID;
            }

            public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
                prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("resumeExperiment", org.apache.thrift.protocol.TMessageType.CALL, 0));
                resumeExperiment_args args = new resumeExperiment_args();
                args.setExperimentID(experimentID);
                args.write(prot);
                prot.writeMessageEnd();
            }

            public void getResult() throws org.apache.thrift.TException {
                if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
                    throw new IllegalStateException("Method call not finished!");
                }
                org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
                org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
                (new Client(prot)).recv_resumeExperiment();
            }
        }

    }

    public static class Processor<I extends Iface> extends org.apache.thrift.TBaseProcessor<I> implements org.apache.thrift.TProcessor {
        private static final Logger LOGGER = LoggerFactory.getLogger(Processor.class.getName());
        public Processor(I iface) {
            super(iface, getProcessMap(new HashMap<String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>>()));
        }

        protected Processor(I iface, Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
            super(iface, getProcessMap(processMap));
        }

        private static <I extends Iface> Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> getProcessMap(Map<String,  org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
            processMap.put("runExperiment", new runExperiment());
            processMap.put("cancelExperiment", new cancelExperiment());
            processMap.put("suspendExperiment", new suspendExperiment());
            processMap.put("resumeExperiment", new resumeExperiment());
            return processMap;
        }

        public static class runExperiment<I extends Iface> extends org.apache.thrift.ProcessFunction<I, runExperiment_args> {
            public runExperiment() {
                super("runExperiment");
            }

            public runExperiment_args getEmptyArgsInstance() {
                return new runExperiment_args();
            }

            protected boolean isOneway() {
                return false;
            }

            public runExperiment_result getResult(I iface, runExperiment_args args) throws org.apache.thrift.TException {
                runExperiment_result result = new runExperiment_result();
                result.success = iface.runExperiment(args.workflowTemplateName, args.workflowInputs, args.experimentAdOptions);
                return result;
            }
        }

        public static class cancelExperiment<I extends Iface> extends org.apache.thrift.ProcessFunction<I, cancelExperiment_args> {
            public cancelExperiment() {
                super("cancelExperiment");
            }

            public cancelExperiment_args getEmptyArgsInstance() {
                return new cancelExperiment_args();
            }

            protected boolean isOneway() {
                return false;
            }

            public cancelExperiment_result getResult(I iface, cancelExperiment_args args) throws org.apache.thrift.TException {
                cancelExperiment_result result = new cancelExperiment_result();
                iface.cancelExperiment(args.experimentID);
                return result;
            }
        }

        public static class suspendExperiment<I extends Iface> extends org.apache.thrift.ProcessFunction<I, suspendExperiment_args> {
            public suspendExperiment() {
                super("suspendExperiment");
            }

            public suspendExperiment_args getEmptyArgsInstance() {
                return new suspendExperiment_args();
            }

            protected boolean isOneway() {
                return false;
            }

            public suspendExperiment_result getResult(I iface, suspendExperiment_args args) throws org.apache.thrift.TException {
                suspendExperiment_result result = new suspendExperiment_result();
                iface.suspendExperiment(args.experimentID);
                return result;
            }
        }

        public static class resumeExperiment<I extends Iface> extends org.apache.thrift.ProcessFunction<I, resumeExperiment_args> {
            public resumeExperiment() {
                super("resumeExperiment");
            }

            public resumeExperiment_args getEmptyArgsInstance() {
                return new resumeExperiment_args();
            }

            protected boolean isOneway() {
                return false;
            }

            public resumeExperiment_result getResult(I iface, resumeExperiment_args args) throws org.apache.thrift.TException {
                resumeExperiment_result result = new resumeExperiment_result();
                iface.resumeExperiment(args.experimentID);
                return result;
            }
        }

    }

    public static class AsyncProcessor<I extends AsyncIface> extends org.apache.thrift.TBaseAsyncProcessor<I> {
        private static final Logger LOGGER = LoggerFactory.getLogger(AsyncProcessor.class.getName());
        public AsyncProcessor(I iface) {
            super(iface, getProcessMap(new HashMap<String, org.apache.thrift.AsyncProcessFunction<I, ? extends org.apache.thrift.TBase, ?>>()));
        }

        protected AsyncProcessor(I iface, Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
            super(iface, getProcessMap(processMap));
        }

        private static <I extends AsyncIface> Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase,?>> getProcessMap(Map<String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
            processMap.put("runExperiment", new runExperiment());
            processMap.put("cancelExperiment", new cancelExperiment());
            processMap.put("suspendExperiment", new suspendExperiment());
            processMap.put("resumeExperiment", new resumeExperiment());
            return processMap;
        }

        public static class runExperiment<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, runExperiment_args, String> {
            public runExperiment() {
                super("runExperiment");
            }

            public runExperiment_args getEmptyArgsInstance() {
                return new runExperiment_args();
            }

            public AsyncMethodCallback<String> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
                final org.apache.thrift.AsyncProcessFunction fcall = this;
                return new AsyncMethodCallback<String>() {
                    public void onComplete(String o) {
                        runExperiment_result result = new runExperiment_result();
                        result.success = o;
                        try {
                            fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
                            return;
                        } catch (Exception e) {
                            LOGGER.error("Exception writing to internal frame buffer", e);
                        }
                        fb.close();
                    }
                    public void onError(Exception e) {
                        byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
                        org.apache.thrift.TBase msg;
                        runExperiment_result result = new runExperiment_result();
                        {
                            msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
                            msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
                        }
                        try {
                            fcall.sendResponse(fb,msg,msgType,seqid);
                            return;
                        } catch (Exception ex) {
                            LOGGER.error("Exception writing to internal frame buffer", ex);
                        }
                        fb.close();
                    }
                };
            }

            protected boolean isOneway() {
                return false;
            }

            public void start(I iface, runExperiment_args args, org.apache.thrift.async.AsyncMethodCallback<String> resultHandler) throws TException {
                iface.runExperiment(args.workflowTemplateName, args.workflowInputs, args.experimentAdOptions,resultHandler);
            }
        }

        public static class cancelExperiment<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, cancelExperiment_args, Void> {
            public cancelExperiment() {
                super("cancelExperiment");
            }

            public cancelExperiment_args getEmptyArgsInstance() {
                return new cancelExperiment_args();
            }

            public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
                final org.apache.thrift.AsyncProcessFunction fcall = this;
                return new AsyncMethodCallback<Void>() {
                    public void onComplete(Void o) {
                        cancelExperiment_result result = new cancelExperiment_result();
                        try {
                            fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
                            return;
                        } catch (Exception e) {
                            LOGGER.error("Exception writing to internal frame buffer", e);
                        }
                        fb.close();
                    }
                    public void onError(Exception e) {
                        byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
                        org.apache.thrift.TBase msg;
                        cancelExperiment_result result = new cancelExperiment_result();
                        {
                            msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
                            msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
                        }
                        try {
                            fcall.sendResponse(fb,msg,msgType,seqid);
                            return;
                        } catch (Exception ex) {
                            LOGGER.error("Exception writing to internal frame buffer", ex);
                        }
                        fb.close();
                    }
                };
            }

            protected boolean isOneway() {
                return false;
            }

            public void start(I iface, cancelExperiment_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
                iface.cancelExperiment(args.experimentID,resultHandler);
            }
        }

        public static class suspendExperiment<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, suspendExperiment_args, Void> {
            public suspendExperiment() {
                super("suspendExperiment");
            }

            public suspendExperiment_args getEmptyArgsInstance() {
                return new suspendExperiment_args();
            }

            public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
                final org.apache.thrift.AsyncProcessFunction fcall = this;
                return new AsyncMethodCallback<Void>() {
                    public void onComplete(Void o) {
                        suspendExperiment_result result = new suspendExperiment_result();
                        try {
                            fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
                            return;
                        } catch (Exception e) {
                            LOGGER.error("Exception writing to internal frame buffer", e);
                        }
                        fb.close();
                    }
                    public void onError(Exception e) {
                        byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
                        org.apache.thrift.TBase msg;
                        suspendExperiment_result result = new suspendExperiment_result();
                        {
                            msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
                            msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
                        }
                        try {
                            fcall.sendResponse(fb,msg,msgType,seqid);
                            return;
                        } catch (Exception ex) {
                            LOGGER.error("Exception writing to internal frame buffer", ex);
                        }
                        fb.close();
                    }
                };
            }

            protected boolean isOneway() {
                return false;
            }

            public void start(I iface, suspendExperiment_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
                iface.suspendExperiment(args.experimentID,resultHandler);
            }
        }

        public static class resumeExperiment<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, resumeExperiment_args, Void> {
            public resumeExperiment() {
                super("resumeExperiment");
            }

            public resumeExperiment_args getEmptyArgsInstance() {
                return new resumeExperiment_args();
            }

            public AsyncMethodCallback<Void> getResultHandler(final AsyncFrameBuffer fb, final int seqid) {
                final org.apache.thrift.AsyncProcessFunction fcall = this;
                return new AsyncMethodCallback<Void>() {
                    public void onComplete(Void o) {
                        resumeExperiment_result result = new resumeExperiment_result();
                        try {
                            fcall.sendResponse(fb,result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
                            return;
                        } catch (Exception e) {
                            LOGGER.error("Exception writing to internal frame buffer", e);
                        }
                        fb.close();
                    }
                    public void onError(Exception e) {
                        byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
                        org.apache.thrift.TBase msg;
                        resumeExperiment_result result = new resumeExperiment_result();
                        {
                            msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
                            msg = (org.apache.thrift.TBase)new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
                        }
                        try {
                            fcall.sendResponse(fb,msg,msgType,seqid);
                            return;
                        } catch (Exception ex) {
                            LOGGER.error("Exception writing to internal frame buffer", ex);
                        }
                        fb.close();
                    }
                };
            }

            protected boolean isOneway() {
                return false;
            }

            public void start(I iface, resumeExperiment_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws TException {
                iface.resumeExperiment(args.experimentID,resultHandler);
            }
        }

    }

    public static class runExperiment_args implements org.apache.thrift.TBase<runExperiment_args, runExperiment_args._Fields>, java.io.Serializable, Cloneable, Comparable<runExperiment_args>   {
        private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("runExperiment_args");

        private static final org.apache.thrift.protocol.TField WORKFLOW_TEMPLATE_NAME_FIELD_DESC = new org.apache.thrift.protocol.TField("workflowTemplateName", org.apache.thrift.protocol.TType.STRING, (short)1);
        private static final org.apache.thrift.protocol.TField WORKFLOW_INPUTS_FIELD_DESC = new org.apache.thrift.protocol.TField("workflowInputs", org.apache.thrift.protocol.TType.MAP, (short)2);
        private static final org.apache.thrift.protocol.TField EXPERIMENT_AD_OPTIONS_FIELD_DESC = new org.apache.thrift.protocol.TField("experimentAdOptions", org.apache.thrift.protocol.TType.STRUCT, (short)3);

        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        static {
            schemes.put(StandardScheme.class, new runExperiment_argsStandardSchemeFactory());
            schemes.put(TupleScheme.class, new runExperiment_argsTupleSchemeFactory());
        }

        public String workflowTemplateName; // required
        public Map<String,String> workflowInputs; // required
        public ExperimentAdvanceOptions experimentAdOptions; // required

        /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
        public enum _Fields implements org.apache.thrift.TFieldIdEnum {
            WORKFLOW_TEMPLATE_NAME((short)1, "workflowTemplateName"),
            WORKFLOW_INPUTS((short)2, "workflowInputs"),
            EXPERIMENT_AD_OPTIONS((short)3, "experimentAdOptions");

            private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

            static {
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, or null if its not found.
             */
            public static _Fields findByThriftId(int fieldId) {
                switch(fieldId) {
                    case 1: // WORKFLOW_TEMPLATE_NAME
                        return WORKFLOW_TEMPLATE_NAME;
                    case 2: // WORKFLOW_INPUTS
                        return WORKFLOW_INPUTS;
                    case 3: // EXPERIMENT_AD_OPTIONS
                        return EXPERIMENT_AD_OPTIONS;
                    default:
                        return null;
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, throwing an exception
             * if it is not found.
             */
            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = findByThriftId(fieldId);
                if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                return fields;
            }

            /**
             * Find the _Fields constant that matches name, or null if its not found.
             */
            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private final short _thriftId;
            private final String _fieldName;

            _Fields(short thriftId, String fieldName) {
                _thriftId = thriftId;
                _fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return _thriftId;
            }

            public String getFieldName() {
                return _fieldName;
            }
        }

        // isset id assignments
        public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
        static {
            Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.WORKFLOW_TEMPLATE_NAME, new org.apache.thrift.meta_data.FieldMetaData("workflowTemplateName", org.apache.thrift.TFieldRequirementType.DEFAULT,
                    new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
            tmpMap.put(_Fields.WORKFLOW_INPUTS, new org.apache.thrift.meta_data.FieldMetaData("workflowInputs", org.apache.thrift.TFieldRequirementType.DEFAULT,
                    new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP,
                            new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING),
                            new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
            tmpMap.put(_Fields.EXPERIMENT_AD_OPTIONS, new org.apache.thrift.meta_data.FieldMetaData("experimentAdOptions", org.apache.thrift.TFieldRequirementType.DEFAULT,
                    new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ExperimentAdvanceOptions.class)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(runExperiment_args.class, metaDataMap);
        }

        public runExperiment_args() {
        }

        public runExperiment_args(
                String workflowTemplateName,
                Map<String,String> workflowInputs,
                ExperimentAdvanceOptions experimentAdOptions)
        {
            this();
            this.workflowTemplateName = workflowTemplateName;
            this.workflowInputs = workflowInputs;
            this.experimentAdOptions = experimentAdOptions;
        }

        /**
         * Performs a deep copy on <i>other</i>.
         */
        public runExperiment_args(runExperiment_args other) {
            if (other.isSetWorkflowTemplateName()) {
                this.workflowTemplateName = other.workflowTemplateName;
            }
            if (other.isSetWorkflowInputs()) {
                Map<String,String> __this__workflowInputs = new HashMap<String,String>(other.workflowInputs);
                this.workflowInputs = __this__workflowInputs;
            }
            if (other.isSetExperimentAdOptions()) {
                this.experimentAdOptions = new ExperimentAdvanceOptions(other.experimentAdOptions);
            }
        }

        public runExperiment_args deepCopy() {
            return new runExperiment_args(this);
        }

        @Override
        public void clear() {
            this.workflowTemplateName = null;
            this.workflowInputs = null;
            this.experimentAdOptions = null;
        }

        public String getWorkflowTemplateName() {
            return this.workflowTemplateName;
        }

        public runExperiment_args setWorkflowTemplateName(String workflowTemplateName) {
            this.workflowTemplateName = workflowTemplateName;
            return this;
        }

        public void unsetWorkflowTemplateName() {
            this.workflowTemplateName = null;
        }

        /** Returns true if field workflowTemplateName is set (has been assigned a value) and false otherwise */
        public boolean isSetWorkflowTemplateName() {
            return this.workflowTemplateName != null;
        }

        public void setWorkflowTemplateNameIsSet(boolean value) {
            if (!value) {
                this.workflowTemplateName = null;
            }
        }

        public int getWorkflowInputsSize() {
            return (this.workflowInputs == null) ? 0 : this.workflowInputs.size();
        }

        public void putToWorkflowInputs(String key, String val) {
            if (this.workflowInputs == null) {
                this.workflowInputs = new HashMap<String,String>();
            }
            this.workflowInputs.put(key, val);
        }

        public Map<String,String> getWorkflowInputs() {
            return this.workflowInputs;
        }

        public runExperiment_args setWorkflowInputs(Map<String,String> workflowInputs) {
            this.workflowInputs = workflowInputs;
            return this;
        }

        public void unsetWorkflowInputs() {
            this.workflowInputs = null;
        }

        /** Returns true if field workflowInputs is set (has been assigned a value) and false otherwise */
        public boolean isSetWorkflowInputs() {
            return this.workflowInputs != null;
        }

        public void setWorkflowInputsIsSet(boolean value) {
            if (!value) {
                this.workflowInputs = null;
            }
        }

        public ExperimentAdvanceOptions getExperimentAdOptions() {
            return this.experimentAdOptions;
        }

        public runExperiment_args setExperimentAdOptions(ExperimentAdvanceOptions experimentAdOptions) {
            this.experimentAdOptions = experimentAdOptions;
            return this;
        }

        public void unsetExperimentAdOptions() {
            this.experimentAdOptions = null;
        }

        /** Returns true if field experimentAdOptions is set (has been assigned a value) and false otherwise */
        public boolean isSetExperimentAdOptions() {
            return this.experimentAdOptions != null;
        }

        public void setExperimentAdOptionsIsSet(boolean value) {
            if (!value) {
                this.experimentAdOptions = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case WORKFLOW_TEMPLATE_NAME:
                    if (value == null) {
                        unsetWorkflowTemplateName();
                    } else {
                        setWorkflowTemplateName((String)value);
                    }
                    break;

                case WORKFLOW_INPUTS:
                    if (value == null) {
                        unsetWorkflowInputs();
                    } else {
                        setWorkflowInputs((Map<String,String>)value);
                    }
                    break;

                case EXPERIMENT_AD_OPTIONS:
                    if (value == null) {
                        unsetExperimentAdOptions();
                    } else {
                        setExperimentAdOptions((ExperimentAdvanceOptions)value);
                    }
                    break;

            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case WORKFLOW_TEMPLATE_NAME:
                    return getWorkflowTemplateName();

                case WORKFLOW_INPUTS:
                    return getWorkflowInputs();

                case EXPERIMENT_AD_OPTIONS:
                    return getExperimentAdOptions();

            }
            throw new IllegalStateException();
        }

        /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }

            switch (field) {
                case WORKFLOW_TEMPLATE_NAME:
                    return isSetWorkflowTemplateName();
                case WORKFLOW_INPUTS:
                    return isSetWorkflowInputs();
                case EXPERIMENT_AD_OPTIONS:
                    return isSetExperimentAdOptions();
            }
            throw new IllegalStateException();
        }

        @Override
        public boolean equals(Object that) {
            if (that == null)
                return false;
            if (that instanceof runExperiment_args)
                return this.equals((runExperiment_args)that);
            return false;
        }

        public boolean equals(runExperiment_args that) {
            if (that == null)
                return false;

            boolean this_present_workflowTemplateName = true && this.isSetWorkflowTemplateName();
            boolean that_present_workflowTemplateName = true && that.isSetWorkflowTemplateName();
            if (this_present_workflowTemplateName || that_present_workflowTemplateName) {
                if (!(this_present_workflowTemplateName && that_present_workflowTemplateName))
                    return false;
                if (!this.workflowTemplateName.equals(that.workflowTemplateName))
                    return false;
            }

            boolean this_present_workflowInputs = true && this.isSetWorkflowInputs();
            boolean that_present_workflowInputs = true && that.isSetWorkflowInputs();
            if (this_present_workflowInputs || that_present_workflowInputs) {
                if (!(this_present_workflowInputs && that_present_workflowInputs))
                    return false;
                if (!this.workflowInputs.equals(that.workflowInputs))
                    return false;
            }

            boolean this_present_experimentAdOptions = true && this.isSetExperimentAdOptions();
            boolean that_present_experimentAdOptions = true && that.isSetExperimentAdOptions();
            if (this_present_experimentAdOptions || that_present_experimentAdOptions) {
                if (!(this_present_experimentAdOptions && that_present_experimentAdOptions))
                    return false;
                if (!this.experimentAdOptions.equals(that.experimentAdOptions))
                    return false;
            }

            return true;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public int compareTo(runExperiment_args other) {
            if (!getClass().equals(other.getClass())) {
                return getClass().getName().compareTo(other.getClass().getName());
            }

            int lastComparison = 0;

            lastComparison = Boolean.valueOf(isSetWorkflowTemplateName()).compareTo(other.isSetWorkflowTemplateName());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetWorkflowTemplateName()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.workflowTemplateName, other.workflowTemplateName);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            lastComparison = Boolean.valueOf(isSetWorkflowInputs()).compareTo(other.isSetWorkflowInputs());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetWorkflowInputs()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.workflowInputs, other.workflowInputs);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            lastComparison = Boolean.valueOf(isSetExperimentAdOptions()).compareTo(other.isSetExperimentAdOptions());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetExperimentAdOptions()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.experimentAdOptions, other.experimentAdOptions);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
        }

        public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("runExperiment_args(");
            boolean first = true;

            sb.append("workflowTemplateName:");
            if (this.workflowTemplateName == null) {
                sb.append("null");
            } else {
                sb.append(this.workflowTemplateName);
            }
            first = false;
            if (!first) sb.append(", ");
            sb.append("workflowInputs:");
            if (this.workflowInputs == null) {
                sb.append("null");
            } else {
                sb.append(this.workflowInputs);
            }
            first = false;
            if (!first) sb.append(", ");
            sb.append("experimentAdOptions:");
            if (this.experimentAdOptions == null) {
                sb.append("null");
            } else {
                sb.append(this.experimentAdOptions);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws org.apache.thrift.TException {
            // check for required fields
            // check for sub-struct validity
            if (experimentAdOptions != null) {
                experimentAdOptions.validate();
            }
        }

        private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
            try {
                write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
            try {
                read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private static class runExperiment_argsStandardSchemeFactory implements SchemeFactory {
            public runExperiment_argsStandardScheme getScheme() {
                return new runExperiment_argsStandardScheme();
            }
        }

        private static class runExperiment_argsStandardScheme extends StandardScheme<runExperiment_args> {

            public void read(org.apache.thrift.protocol.TProtocol iprot, runExperiment_args struct) throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TField schemeField;
                iprot.readStructBegin();
                while (true)
                {
                    schemeField = iprot.readFieldBegin();
                    if (schemeField.type == org.apache.thrift.protocol.TType.STOP) {
                        break;
                    }
                    switch (schemeField.id) {
                        case 1: // WORKFLOW_TEMPLATE_NAME
                            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                                struct.workflowTemplateName = iprot.readString();
                                struct.setWorkflowTemplateNameIsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        case 2: // WORKFLOW_INPUTS
                            if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                                {
                                    org.apache.thrift.protocol.TMap _map24 = iprot.readMapBegin();
                                    struct.workflowInputs = new HashMap<String,String>(2*_map24.size);
                                    for (int _i25 = 0; _i25 < _map24.size; ++_i25)
                                    {
                                        String _key26;
                                        String _val27;
                                        _key26 = iprot.readString();
                                        _val27 = iprot.readString();
                                        struct.workflowInputs.put(_key26, _val27);
                                    }
                                    iprot.readMapEnd();
                                }
                                struct.setWorkflowInputsIsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        case 3: // EXPERIMENT_AD_OPTIONS
                            if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                                struct.experimentAdOptions = new ExperimentAdvanceOptions();
                                struct.experimentAdOptions.read(iprot);
                                struct.setExperimentAdOptionsIsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        default:
                            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();

                // check for required fields of primitive type, which can't be checked in the validate method
                struct.validate();
            }

            public void write(org.apache.thrift.protocol.TProtocol oprot, runExperiment_args struct) throws org.apache.thrift.TException {
                struct.validate();

                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.workflowTemplateName != null) {
                    oprot.writeFieldBegin(WORKFLOW_TEMPLATE_NAME_FIELD_DESC);
                    oprot.writeString(struct.workflowTemplateName);
                    oprot.writeFieldEnd();
                }
                if (struct.workflowInputs != null) {
                    oprot.writeFieldBegin(WORKFLOW_INPUTS_FIELD_DESC);
                    {
                        oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, struct.workflowInputs.size()));
                        for (Map.Entry<String, String> _iter28 : struct.workflowInputs.entrySet())
                        {
                            oprot.writeString(_iter28.getKey());
                            oprot.writeString(_iter28.getValue());
                        }
                        oprot.writeMapEnd();
                    }
                    oprot.writeFieldEnd();
                }
                if (struct.experimentAdOptions != null) {
                    oprot.writeFieldBegin(EXPERIMENT_AD_OPTIONS_FIELD_DESC);
                    struct.experimentAdOptions.write(oprot);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }

        }

        private static class runExperiment_argsTupleSchemeFactory implements SchemeFactory {
            public runExperiment_argsTupleScheme getScheme() {
                return new runExperiment_argsTupleScheme();
            }
        }

        private static class runExperiment_argsTupleScheme extends TupleScheme<runExperiment_args> {

            @Override
            public void write(org.apache.thrift.protocol.TProtocol prot, runExperiment_args struct) throws org.apache.thrift.TException {
                TTupleProtocol oprot = (TTupleProtocol) prot;
                BitSet optionals = new BitSet();
                if (struct.isSetWorkflowTemplateName()) {
                    optionals.set(0);
                }
                if (struct.isSetWorkflowInputs()) {
                    optionals.set(1);
                }
                if (struct.isSetExperimentAdOptions()) {
                    optionals.set(2);
                }
                oprot.writeBitSet(optionals, 3);
                if (struct.isSetWorkflowTemplateName()) {
                    oprot.writeString(struct.workflowTemplateName);
                }
                if (struct.isSetWorkflowInputs()) {
                    {
                        oprot.writeI32(struct.workflowInputs.size());
                        for (Map.Entry<String, String> _iter29 : struct.workflowInputs.entrySet())
                        {
                            oprot.writeString(_iter29.getKey());
                            oprot.writeString(_iter29.getValue());
                        }
                    }
                }
                if (struct.isSetExperimentAdOptions()) {
                    struct.experimentAdOptions.write(oprot);
                }
            }

            @Override
            public void read(org.apache.thrift.protocol.TProtocol prot, runExperiment_args struct) throws org.apache.thrift.TException {
                TTupleProtocol iprot = (TTupleProtocol) prot;
                BitSet incoming = iprot.readBitSet(3);
                if (incoming.get(0)) {
                    struct.workflowTemplateName = iprot.readString();
                    struct.setWorkflowTemplateNameIsSet(true);
                }
                if (incoming.get(1)) {
                    {
                        org.apache.thrift.protocol.TMap _map30 = new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRING, iprot.readI32());
                        struct.workflowInputs = new HashMap<String,String>(2*_map30.size);
                        for (int _i31 = 0; _i31 < _map30.size; ++_i31)
                        {
                            String _key32;
                            String _val33;
                            _key32 = iprot.readString();
                            _val33 = iprot.readString();
                            struct.workflowInputs.put(_key32, _val33);
                        }
                    }
                    struct.setWorkflowInputsIsSet(true);
                }
                if (incoming.get(2)) {
                    struct.experimentAdOptions = new ExperimentAdvanceOptions();
                    struct.experimentAdOptions.read(iprot);
                    struct.setExperimentAdOptionsIsSet(true);
                }
            }
        }

    }

    public static class runExperiment_result implements org.apache.thrift.TBase<runExperiment_result, runExperiment_result._Fields>, java.io.Serializable, Cloneable, Comparable<runExperiment_result>   {
        private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("runExperiment_result");

        private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRING, (short)0);

        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        static {
            schemes.put(StandardScheme.class, new runExperiment_resultStandardSchemeFactory());
            schemes.put(TupleScheme.class, new runExperiment_resultTupleSchemeFactory());
        }

        public String success; // required

        /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
        public enum _Fields implements org.apache.thrift.TFieldIdEnum {
            SUCCESS((short)0, "success");

            private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

            static {
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, or null if its not found.
             */
            public static _Fields findByThriftId(int fieldId) {
                switch(fieldId) {
                    case 0: // SUCCESS
                        return SUCCESS;
                    default:
                        return null;
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, throwing an exception
             * if it is not found.
             */
            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = findByThriftId(fieldId);
                if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                return fields;
            }

            /**
             * Find the _Fields constant that matches name, or null if its not found.
             */
            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private final short _thriftId;
            private final String _fieldName;

            _Fields(short thriftId, String fieldName) {
                _thriftId = thriftId;
                _fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return _thriftId;
            }

            public String getFieldName() {
                return _fieldName;
            }
        }

        // isset id assignments
        public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
        static {
            Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT,
                    new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(runExperiment_result.class, metaDataMap);
        }

        public runExperiment_result() {
        }

        public runExperiment_result(
                String success)
        {
            this();
            this.success = success;
        }

        /**
         * Performs a deep copy on <i>other</i>.
         */
        public runExperiment_result(runExperiment_result other) {
            if (other.isSetSuccess()) {
                this.success = other.success;
            }
        }

        public runExperiment_result deepCopy() {
            return new runExperiment_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
        }

        public String getSuccess() {
            return this.success;
        }

        public runExperiment_result setSuccess(String success) {
            this.success = success;
            return this;
        }

        public void unsetSuccess() {
            this.success = null;
        }

        /** Returns true if field success is set (has been assigned a value) and false otherwise */
        public boolean isSetSuccess() {
            return this.success != null;
        }

        public void setSuccessIsSet(boolean value) {
            if (!value) {
                this.success = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case SUCCESS:
                    if (value == null) {
                        unsetSuccess();
                    } else {
                        setSuccess((String)value);
                    }
                    break;

            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case SUCCESS:
                    return getSuccess();

            }
            throw new IllegalStateException();
        }

        /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }

            switch (field) {
                case SUCCESS:
                    return isSetSuccess();
            }
            throw new IllegalStateException();
        }

        @Override
        public boolean equals(Object that) {
            if (that == null)
                return false;
            if (that instanceof runExperiment_result)
                return this.equals((runExperiment_result)that);
            return false;
        }

        public boolean equals(runExperiment_result that) {
            if (that == null)
                return false;

            boolean this_present_success = true && this.isSetSuccess();
            boolean that_present_success = true && that.isSetSuccess();
            if (this_present_success || that_present_success) {
                if (!(this_present_success && that_present_success))
                    return false;
                if (!this.success.equals(that.success))
                    return false;
            }

            return true;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public int compareTo(runExperiment_result other) {
            if (!getClass().equals(other.getClass())) {
                return getClass().getName().compareTo(other.getClass().getName());
            }

            int lastComparison = 0;

            lastComparison = Boolean.valueOf(isSetSuccess()).compareTo(other.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetSuccess()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
        }

        public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("runExperiment_result(");
            boolean first = true;

            sb.append("success:");
            if (this.success == null) {
                sb.append("null");
            } else {
                sb.append(this.success);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws org.apache.thrift.TException {
            // check for required fields
            // check for sub-struct validity
        }

        private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
            try {
                write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
            try {
                read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private static class runExperiment_resultStandardSchemeFactory implements SchemeFactory {
            public runExperiment_resultStandardScheme getScheme() {
                return new runExperiment_resultStandardScheme();
            }
        }

        private static class runExperiment_resultStandardScheme extends StandardScheme<runExperiment_result> {

            public void read(org.apache.thrift.protocol.TProtocol iprot, runExperiment_result struct) throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TField schemeField;
                iprot.readStructBegin();
                while (true)
                {
                    schemeField = iprot.readFieldBegin();
                    if (schemeField.type == org.apache.thrift.protocol.TType.STOP) {
                        break;
                    }
                    switch (schemeField.id) {
                        case 0: // SUCCESS
                            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                                struct.success = iprot.readString();
                                struct.setSuccessIsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        default:
                            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();

                // check for required fields of primitive type, which can't be checked in the validate method
                struct.validate();
            }

            public void write(org.apache.thrift.protocol.TProtocol oprot, runExperiment_result struct) throws org.apache.thrift.TException {
                struct.validate();

                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.success != null) {
                    oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                    oprot.writeString(struct.success);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }

        }

        private static class runExperiment_resultTupleSchemeFactory implements SchemeFactory {
            public runExperiment_resultTupleScheme getScheme() {
                return new runExperiment_resultTupleScheme();
            }
        }

        private static class runExperiment_resultTupleScheme extends TupleScheme<runExperiment_result> {

            @Override
            public void write(org.apache.thrift.protocol.TProtocol prot, runExperiment_result struct) throws org.apache.thrift.TException {
                TTupleProtocol oprot = (TTupleProtocol) prot;
                BitSet optionals = new BitSet();
                if (struct.isSetSuccess()) {
                    optionals.set(0);
                }
                oprot.writeBitSet(optionals, 1);
                if (struct.isSetSuccess()) {
                    oprot.writeString(struct.success);
                }
            }

            @Override
            public void read(org.apache.thrift.protocol.TProtocol prot, runExperiment_result struct) throws org.apache.thrift.TException {
                TTupleProtocol iprot = (TTupleProtocol) prot;
                BitSet incoming = iprot.readBitSet(1);
                if (incoming.get(0)) {
                    struct.success = iprot.readString();
                    struct.setSuccessIsSet(true);
                }
            }
        }

    }

    public static class cancelExperiment_args implements org.apache.thrift.TBase<cancelExperiment_args, cancelExperiment_args._Fields>, java.io.Serializable, Cloneable, Comparable<cancelExperiment_args>   {
        private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("cancelExperiment_args");

        private static final org.apache.thrift.protocol.TField EXPERIMENT_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("experimentID", org.apache.thrift.protocol.TType.STRING, (short)1);

        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        static {
            schemes.put(StandardScheme.class, new cancelExperiment_argsStandardSchemeFactory());
            schemes.put(TupleScheme.class, new cancelExperiment_argsTupleSchemeFactory());
        }

        public String experimentID; // required

        /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
        public enum _Fields implements org.apache.thrift.TFieldIdEnum {
            EXPERIMENT_ID((short)1, "experimentID");

            private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

            static {
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, or null if its not found.
             */
            public static _Fields findByThriftId(int fieldId) {
                switch(fieldId) {
                    case 1: // EXPERIMENT_ID
                        return EXPERIMENT_ID;
                    default:
                        return null;
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, throwing an exception
             * if it is not found.
             */
            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = findByThriftId(fieldId);
                if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                return fields;
            }

            /**
             * Find the _Fields constant that matches name, or null if its not found.
             */
            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private final short _thriftId;
            private final String _fieldName;

            _Fields(short thriftId, String fieldName) {
                _thriftId = thriftId;
                _fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return _thriftId;
            }

            public String getFieldName() {
                return _fieldName;
            }
        }

        // isset id assignments
        public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
        static {
            Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.EXPERIMENT_ID, new org.apache.thrift.meta_data.FieldMetaData("experimentID", org.apache.thrift.TFieldRequirementType.DEFAULT,
                    new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(cancelExperiment_args.class, metaDataMap);
        }

        public cancelExperiment_args() {
        }

        public cancelExperiment_args(
                String experimentID)
        {
            this();
            this.experimentID = experimentID;
        }

        /**
         * Performs a deep copy on <i>other</i>.
         */
        public cancelExperiment_args(cancelExperiment_args other) {
            if (other.isSetExperimentID()) {
                this.experimentID = other.experimentID;
            }
        }

        public cancelExperiment_args deepCopy() {
            return new cancelExperiment_args(this);
        }

        @Override
        public void clear() {
            this.experimentID = null;
        }

        public String getExperimentID() {
            return this.experimentID;
        }

        public cancelExperiment_args setExperimentID(String experimentID) {
            this.experimentID = experimentID;
            return this;
        }

        public void unsetExperimentID() {
            this.experimentID = null;
        }

        /** Returns true if field experimentID is set (has been assigned a value) and false otherwise */
        public boolean isSetExperimentID() {
            return this.experimentID != null;
        }

        public void setExperimentIDIsSet(boolean value) {
            if (!value) {
                this.experimentID = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case EXPERIMENT_ID:
                    if (value == null) {
                        unsetExperimentID();
                    } else {
                        setExperimentID((String)value);
                    }
                    break;

            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case EXPERIMENT_ID:
                    return getExperimentID();

            }
            throw new IllegalStateException();
        }

        /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }

            switch (field) {
                case EXPERIMENT_ID:
                    return isSetExperimentID();
            }
            throw new IllegalStateException();
        }

        @Override
        public boolean equals(Object that) {
            if (that == null)
                return false;
            if (that instanceof cancelExperiment_args)
                return this.equals((cancelExperiment_args)that);
            return false;
        }

        public boolean equals(cancelExperiment_args that) {
            if (that == null)
                return false;

            boolean this_present_experimentID = true && this.isSetExperimentID();
            boolean that_present_experimentID = true && that.isSetExperimentID();
            if (this_present_experimentID || that_present_experimentID) {
                if (!(this_present_experimentID && that_present_experimentID))
                    return false;
                if (!this.experimentID.equals(that.experimentID))
                    return false;
            }

            return true;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public int compareTo(cancelExperiment_args other) {
            if (!getClass().equals(other.getClass())) {
                return getClass().getName().compareTo(other.getClass().getName());
            }

            int lastComparison = 0;

            lastComparison = Boolean.valueOf(isSetExperimentID()).compareTo(other.isSetExperimentID());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetExperimentID()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.experimentID, other.experimentID);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
        }

        public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("cancelExperiment_args(");
            boolean first = true;

            sb.append("experimentID:");
            if (this.experimentID == null) {
                sb.append("null");
            } else {
                sb.append(this.experimentID);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws org.apache.thrift.TException {
            // check for required fields
            // check for sub-struct validity
        }

        private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
            try {
                write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
            try {
                read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private static class cancelExperiment_argsStandardSchemeFactory implements SchemeFactory {
            public cancelExperiment_argsStandardScheme getScheme() {
                return new cancelExperiment_argsStandardScheme();
            }
        }

        private static class cancelExperiment_argsStandardScheme extends StandardScheme<cancelExperiment_args> {

            public void read(org.apache.thrift.protocol.TProtocol iprot, cancelExperiment_args struct) throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TField schemeField;
                iprot.readStructBegin();
                while (true)
                {
                    schemeField = iprot.readFieldBegin();
                    if (schemeField.type == org.apache.thrift.protocol.TType.STOP) {
                        break;
                    }
                    switch (schemeField.id) {
                        case 1: // EXPERIMENT_ID
                            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                                struct.experimentID = iprot.readString();
                                struct.setExperimentIDIsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        default:
                            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();

                // check for required fields of primitive type, which can't be checked in the validate method
                struct.validate();
            }

            public void write(org.apache.thrift.protocol.TProtocol oprot, cancelExperiment_args struct) throws org.apache.thrift.TException {
                struct.validate();

                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.experimentID != null) {
                    oprot.writeFieldBegin(EXPERIMENT_ID_FIELD_DESC);
                    oprot.writeString(struct.experimentID);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }

        }

        private static class cancelExperiment_argsTupleSchemeFactory implements SchemeFactory {
            public cancelExperiment_argsTupleScheme getScheme() {
                return new cancelExperiment_argsTupleScheme();
            }
        }

        private static class cancelExperiment_argsTupleScheme extends TupleScheme<cancelExperiment_args> {

            @Override
            public void write(org.apache.thrift.protocol.TProtocol prot, cancelExperiment_args struct) throws org.apache.thrift.TException {
                TTupleProtocol oprot = (TTupleProtocol) prot;
                BitSet optionals = new BitSet();
                if (struct.isSetExperimentID()) {
                    optionals.set(0);
                }
                oprot.writeBitSet(optionals, 1);
                if (struct.isSetExperimentID()) {
                    oprot.writeString(struct.experimentID);
                }
            }

            @Override
            public void read(org.apache.thrift.protocol.TProtocol prot, cancelExperiment_args struct) throws org.apache.thrift.TException {
                TTupleProtocol iprot = (TTupleProtocol) prot;
                BitSet incoming = iprot.readBitSet(1);
                if (incoming.get(0)) {
                    struct.experimentID = iprot.readString();
                    struct.setExperimentIDIsSet(true);
                }
            }
        }

    }

    public static class cancelExperiment_result implements org.apache.thrift.TBase<cancelExperiment_result, cancelExperiment_result._Fields>, java.io.Serializable, Cloneable, Comparable<cancelExperiment_result>   {
        private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("cancelExperiment_result");


        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        static {
            schemes.put(StandardScheme.class, new cancelExperiment_resultStandardSchemeFactory());
            schemes.put(TupleScheme.class, new cancelExperiment_resultTupleSchemeFactory());
        }


        /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
        public enum _Fields implements org.apache.thrift.TFieldIdEnum {
            ;

            private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

            static {
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, or null if its not found.
             */
            public static _Fields findByThriftId(int fieldId) {
                switch(fieldId) {
                    default:
                        return null;
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, throwing an exception
             * if it is not found.
             */
            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = findByThriftId(fieldId);
                if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                return fields;
            }

            /**
             * Find the _Fields constant that matches name, or null if its not found.
             */
            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private final short _thriftId;
            private final String _fieldName;

            _Fields(short thriftId, String fieldName) {
                _thriftId = thriftId;
                _fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return _thriftId;
            }

            public String getFieldName() {
                return _fieldName;
            }
        }
        public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
        static {
            Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(cancelExperiment_result.class, metaDataMap);
        }

        public cancelExperiment_result() {
        }

        /**
         * Performs a deep copy on <i>other</i>.
         */
        public cancelExperiment_result(cancelExperiment_result other) {
        }

        public cancelExperiment_result deepCopy() {
            return new cancelExperiment_result(this);
        }

        @Override
        public void clear() {
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
            }
            throw new IllegalStateException();
        }

        /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }

            switch (field) {
            }
            throw new IllegalStateException();
        }

        @Override
        public boolean equals(Object that) {
            if (that == null)
                return false;
            if (that instanceof cancelExperiment_result)
                return this.equals((cancelExperiment_result)that);
            return false;
        }

        public boolean equals(cancelExperiment_result that) {
            if (that == null)
                return false;

            return true;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public int compareTo(cancelExperiment_result other) {
            if (!getClass().equals(other.getClass())) {
                return getClass().getName().compareTo(other.getClass().getName());
            }

            int lastComparison = 0;

            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
        }

        public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("cancelExperiment_result(");
            boolean first = true;

            sb.append(")");
            return sb.toString();
        }

        public void validate() throws org.apache.thrift.TException {
            // check for required fields
            // check for sub-struct validity
        }

        private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
            try {
                write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
            try {
                read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private static class cancelExperiment_resultStandardSchemeFactory implements SchemeFactory {
            public cancelExperiment_resultStandardScheme getScheme() {
                return new cancelExperiment_resultStandardScheme();
            }
        }

        private static class cancelExperiment_resultStandardScheme extends StandardScheme<cancelExperiment_result> {

            public void read(org.apache.thrift.protocol.TProtocol iprot, cancelExperiment_result struct) throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TField schemeField;
                iprot.readStructBegin();
                while (true)
                {
                    schemeField = iprot.readFieldBegin();
                    if (schemeField.type == org.apache.thrift.protocol.TType.STOP) {
                        break;
                    }
                    switch (schemeField.id) {
                        default:
                            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();

                // check for required fields of primitive type, which can't be checked in the validate method
                struct.validate();
            }

            public void write(org.apache.thrift.protocol.TProtocol oprot, cancelExperiment_result struct) throws org.apache.thrift.TException {
                struct.validate();

                oprot.writeStructBegin(STRUCT_DESC);
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }

        }

        private static class cancelExperiment_resultTupleSchemeFactory implements SchemeFactory {
            public cancelExperiment_resultTupleScheme getScheme() {
                return new cancelExperiment_resultTupleScheme();
            }
        }

        private static class cancelExperiment_resultTupleScheme extends TupleScheme<cancelExperiment_result> {

            @Override
            public void write(org.apache.thrift.protocol.TProtocol prot, cancelExperiment_result struct) throws org.apache.thrift.TException {
                TTupleProtocol oprot = (TTupleProtocol) prot;
            }

            @Override
            public void read(org.apache.thrift.protocol.TProtocol prot, cancelExperiment_result struct) throws org.apache.thrift.TException {
                TTupleProtocol iprot = (TTupleProtocol) prot;
            }
        }

    }

    public static class suspendExperiment_args implements org.apache.thrift.TBase<suspendExperiment_args, suspendExperiment_args._Fields>, java.io.Serializable, Cloneable, Comparable<suspendExperiment_args>   {
        private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("suspendExperiment_args");

        private static final org.apache.thrift.protocol.TField EXPERIMENT_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("experimentID", org.apache.thrift.protocol.TType.STRING, (short)1);

        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        static {
            schemes.put(StandardScheme.class, new suspendExperiment_argsStandardSchemeFactory());
            schemes.put(TupleScheme.class, new suspendExperiment_argsTupleSchemeFactory());
        }

        public String experimentID; // required

        /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
        public enum _Fields implements org.apache.thrift.TFieldIdEnum {
            EXPERIMENT_ID((short)1, "experimentID");

            private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

            static {
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, or null if its not found.
             */
            public static _Fields findByThriftId(int fieldId) {
                switch(fieldId) {
                    case 1: // EXPERIMENT_ID
                        return EXPERIMENT_ID;
                    default:
                        return null;
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, throwing an exception
             * if it is not found.
             */
            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = findByThriftId(fieldId);
                if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                return fields;
            }

            /**
             * Find the _Fields constant that matches name, or null if its not found.
             */
            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private final short _thriftId;
            private final String _fieldName;

            _Fields(short thriftId, String fieldName) {
                _thriftId = thriftId;
                _fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return _thriftId;
            }

            public String getFieldName() {
                return _fieldName;
            }
        }

        // isset id assignments
        public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
        static {
            Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.EXPERIMENT_ID, new org.apache.thrift.meta_data.FieldMetaData("experimentID", org.apache.thrift.TFieldRequirementType.DEFAULT,
                    new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(suspendExperiment_args.class, metaDataMap);
        }

        public suspendExperiment_args() {
        }

        public suspendExperiment_args(
                String experimentID)
        {
            this();
            this.experimentID = experimentID;
        }

        /**
         * Performs a deep copy on <i>other</i>.
         */
        public suspendExperiment_args(suspendExperiment_args other) {
            if (other.isSetExperimentID()) {
                this.experimentID = other.experimentID;
            }
        }

        public suspendExperiment_args deepCopy() {
            return new suspendExperiment_args(this);
        }

        @Override
        public void clear() {
            this.experimentID = null;
        }

        public String getExperimentID() {
            return this.experimentID;
        }

        public suspendExperiment_args setExperimentID(String experimentID) {
            this.experimentID = experimentID;
            return this;
        }

        public void unsetExperimentID() {
            this.experimentID = null;
        }

        /** Returns true if field experimentID is set (has been assigned a value) and false otherwise */
        public boolean isSetExperimentID() {
            return this.experimentID != null;
        }

        public void setExperimentIDIsSet(boolean value) {
            if (!value) {
                this.experimentID = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case EXPERIMENT_ID:
                    if (value == null) {
                        unsetExperimentID();
                    } else {
                        setExperimentID((String)value);
                    }
                    break;

            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case EXPERIMENT_ID:
                    return getExperimentID();

            }
            throw new IllegalStateException();
        }

        /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }

            switch (field) {
                case EXPERIMENT_ID:
                    return isSetExperimentID();
            }
            throw new IllegalStateException();
        }

        @Override
        public boolean equals(Object that) {
            if (that == null)
                return false;
            if (that instanceof suspendExperiment_args)
                return this.equals((suspendExperiment_args)that);
            return false;
        }

        public boolean equals(suspendExperiment_args that) {
            if (that == null)
                return false;

            boolean this_present_experimentID = true && this.isSetExperimentID();
            boolean that_present_experimentID = true && that.isSetExperimentID();
            if (this_present_experimentID || that_present_experimentID) {
                if (!(this_present_experimentID && that_present_experimentID))
                    return false;
                if (!this.experimentID.equals(that.experimentID))
                    return false;
            }

            return true;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public int compareTo(suspendExperiment_args other) {
            if (!getClass().equals(other.getClass())) {
                return getClass().getName().compareTo(other.getClass().getName());
            }

            int lastComparison = 0;

            lastComparison = Boolean.valueOf(isSetExperimentID()).compareTo(other.isSetExperimentID());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetExperimentID()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.experimentID, other.experimentID);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
        }

        public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("suspendExperiment_args(");
            boolean first = true;

            sb.append("experimentID:");
            if (this.experimentID == null) {
                sb.append("null");
            } else {
                sb.append(this.experimentID);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws org.apache.thrift.TException {
            // check for required fields
            // check for sub-struct validity
        }

        private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
            try {
                write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
            try {
                read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private static class suspendExperiment_argsStandardSchemeFactory implements SchemeFactory {
            public suspendExperiment_argsStandardScheme getScheme() {
                return new suspendExperiment_argsStandardScheme();
            }
        }

        private static class suspendExperiment_argsStandardScheme extends StandardScheme<suspendExperiment_args> {

            public void read(org.apache.thrift.protocol.TProtocol iprot, suspendExperiment_args struct) throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TField schemeField;
                iprot.readStructBegin();
                while (true)
                {
                    schemeField = iprot.readFieldBegin();
                    if (schemeField.type == org.apache.thrift.protocol.TType.STOP) {
                        break;
                    }
                    switch (schemeField.id) {
                        case 1: // EXPERIMENT_ID
                            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                                struct.experimentID = iprot.readString();
                                struct.setExperimentIDIsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        default:
                            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();

                // check for required fields of primitive type, which can't be checked in the validate method
                struct.validate();
            }

            public void write(org.apache.thrift.protocol.TProtocol oprot, suspendExperiment_args struct) throws org.apache.thrift.TException {
                struct.validate();

                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.experimentID != null) {
                    oprot.writeFieldBegin(EXPERIMENT_ID_FIELD_DESC);
                    oprot.writeString(struct.experimentID);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }

        }

        private static class suspendExperiment_argsTupleSchemeFactory implements SchemeFactory {
            public suspendExperiment_argsTupleScheme getScheme() {
                return new suspendExperiment_argsTupleScheme();
            }
        }

        private static class suspendExperiment_argsTupleScheme extends TupleScheme<suspendExperiment_args> {

            @Override
            public void write(org.apache.thrift.protocol.TProtocol prot, suspendExperiment_args struct) throws org.apache.thrift.TException {
                TTupleProtocol oprot = (TTupleProtocol) prot;
                BitSet optionals = new BitSet();
                if (struct.isSetExperimentID()) {
                    optionals.set(0);
                }
                oprot.writeBitSet(optionals, 1);
                if (struct.isSetExperimentID()) {
                    oprot.writeString(struct.experimentID);
                }
            }

            @Override
            public void read(org.apache.thrift.protocol.TProtocol prot, suspendExperiment_args struct) throws org.apache.thrift.TException {
                TTupleProtocol iprot = (TTupleProtocol) prot;
                BitSet incoming = iprot.readBitSet(1);
                if (incoming.get(0)) {
                    struct.experimentID = iprot.readString();
                    struct.setExperimentIDIsSet(true);
                }
            }
        }

    }

    public static class suspendExperiment_result implements org.apache.thrift.TBase<suspendExperiment_result, suspendExperiment_result._Fields>, java.io.Serializable, Cloneable, Comparable<suspendExperiment_result>   {
        private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("suspendExperiment_result");


        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        static {
            schemes.put(StandardScheme.class, new suspendExperiment_resultStandardSchemeFactory());
            schemes.put(TupleScheme.class, new suspendExperiment_resultTupleSchemeFactory());
        }


        /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
        public enum _Fields implements org.apache.thrift.TFieldIdEnum {
            ;

            private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

            static {
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, or null if its not found.
             */
            public static _Fields findByThriftId(int fieldId) {
                switch(fieldId) {
                    default:
                        return null;
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, throwing an exception
             * if it is not found.
             */
            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = findByThriftId(fieldId);
                if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                return fields;
            }

            /**
             * Find the _Fields constant that matches name, or null if its not found.
             */
            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private final short _thriftId;
            private final String _fieldName;

            _Fields(short thriftId, String fieldName) {
                _thriftId = thriftId;
                _fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return _thriftId;
            }

            public String getFieldName() {
                return _fieldName;
            }
        }
        public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
        static {
            Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(suspendExperiment_result.class, metaDataMap);
        }

        public suspendExperiment_result() {
        }

        /**
         * Performs a deep copy on <i>other</i>.
         */
        public suspendExperiment_result(suspendExperiment_result other) {
        }

        public suspendExperiment_result deepCopy() {
            return new suspendExperiment_result(this);
        }

        @Override
        public void clear() {
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
            }
            throw new IllegalStateException();
        }

        /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }

            switch (field) {
            }
            throw new IllegalStateException();
        }

        @Override
        public boolean equals(Object that) {
            if (that == null)
                return false;
            if (that instanceof suspendExperiment_result)
                return this.equals((suspendExperiment_result)that);
            return false;
        }

        public boolean equals(suspendExperiment_result that) {
            if (that == null)
                return false;

            return true;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public int compareTo(suspendExperiment_result other) {
            if (!getClass().equals(other.getClass())) {
                return getClass().getName().compareTo(other.getClass().getName());
            }

            int lastComparison = 0;

            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
        }

        public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("suspendExperiment_result(");
            boolean first = true;

            sb.append(")");
            return sb.toString();
        }

        public void validate() throws org.apache.thrift.TException {
            // check for required fields
            // check for sub-struct validity
        }

        private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
            try {
                write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
            try {
                read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private static class suspendExperiment_resultStandardSchemeFactory implements SchemeFactory {
            public suspendExperiment_resultStandardScheme getScheme() {
                return new suspendExperiment_resultStandardScheme();
            }
        }

        private static class suspendExperiment_resultStandardScheme extends StandardScheme<suspendExperiment_result> {

            public void read(org.apache.thrift.protocol.TProtocol iprot, suspendExperiment_result struct) throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TField schemeField;
                iprot.readStructBegin();
                while (true)
                {
                    schemeField = iprot.readFieldBegin();
                    if (schemeField.type == org.apache.thrift.protocol.TType.STOP) {
                        break;
                    }
                    switch (schemeField.id) {
                        default:
                            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();

                // check for required fields of primitive type, which can't be checked in the validate method
                struct.validate();
            }

            public void write(org.apache.thrift.protocol.TProtocol oprot, suspendExperiment_result struct) throws org.apache.thrift.TException {
                struct.validate();

                oprot.writeStructBegin(STRUCT_DESC);
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }

        }

        private static class suspendExperiment_resultTupleSchemeFactory implements SchemeFactory {
            public suspendExperiment_resultTupleScheme getScheme() {
                return new suspendExperiment_resultTupleScheme();
            }
        }

        private static class suspendExperiment_resultTupleScheme extends TupleScheme<suspendExperiment_result> {

            @Override
            public void write(org.apache.thrift.protocol.TProtocol prot, suspendExperiment_result struct) throws org.apache.thrift.TException {
                TTupleProtocol oprot = (TTupleProtocol) prot;
            }

            @Override
            public void read(org.apache.thrift.protocol.TProtocol prot, suspendExperiment_result struct) throws org.apache.thrift.TException {
                TTupleProtocol iprot = (TTupleProtocol) prot;
            }
        }

    }

    public static class resumeExperiment_args implements org.apache.thrift.TBase<resumeExperiment_args, resumeExperiment_args._Fields>, java.io.Serializable, Cloneable, Comparable<resumeExperiment_args>   {
        private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("resumeExperiment_args");

        private static final org.apache.thrift.protocol.TField EXPERIMENT_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("experimentID", org.apache.thrift.protocol.TType.STRING, (short)1);

        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        static {
            schemes.put(StandardScheme.class, new resumeExperiment_argsStandardSchemeFactory());
            schemes.put(TupleScheme.class, new resumeExperiment_argsTupleSchemeFactory());
        }

        public String experimentID; // required

        /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
        public enum _Fields implements org.apache.thrift.TFieldIdEnum {
            EXPERIMENT_ID((short)1, "experimentID");

            private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

            static {
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, or null if its not found.
             */
            public static _Fields findByThriftId(int fieldId) {
                switch(fieldId) {
                    case 1: // EXPERIMENT_ID
                        return EXPERIMENT_ID;
                    default:
                        return null;
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, throwing an exception
             * if it is not found.
             */
            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = findByThriftId(fieldId);
                if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                return fields;
            }

            /**
             * Find the _Fields constant that matches name, or null if its not found.
             */
            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private final short _thriftId;
            private final String _fieldName;

            _Fields(short thriftId, String fieldName) {
                _thriftId = thriftId;
                _fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return _thriftId;
            }

            public String getFieldName() {
                return _fieldName;
            }
        }

        // isset id assignments
        public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
        static {
            Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
            tmpMap.put(_Fields.EXPERIMENT_ID, new org.apache.thrift.meta_data.FieldMetaData("experimentID", org.apache.thrift.TFieldRequirementType.DEFAULT,
                    new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(resumeExperiment_args.class, metaDataMap);
        }

        public resumeExperiment_args() {
        }

        public resumeExperiment_args(
                String experimentID)
        {
            this();
            this.experimentID = experimentID;
        }

        /**
         * Performs a deep copy on <i>other</i>.
         */
        public resumeExperiment_args(resumeExperiment_args other) {
            if (other.isSetExperimentID()) {
                this.experimentID = other.experimentID;
            }
        }

        public resumeExperiment_args deepCopy() {
            return new resumeExperiment_args(this);
        }

        @Override
        public void clear() {
            this.experimentID = null;
        }

        public String getExperimentID() {
            return this.experimentID;
        }

        public resumeExperiment_args setExperimentID(String experimentID) {
            this.experimentID = experimentID;
            return this;
        }

        public void unsetExperimentID() {
            this.experimentID = null;
        }

        /** Returns true if field experimentID is set (has been assigned a value) and false otherwise */
        public boolean isSetExperimentID() {
            return this.experimentID != null;
        }

        public void setExperimentIDIsSet(boolean value) {
            if (!value) {
                this.experimentID = null;
            }
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
                case EXPERIMENT_ID:
                    if (value == null) {
                        unsetExperimentID();
                    } else {
                        setExperimentID((String)value);
                    }
                    break;

            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
                case EXPERIMENT_ID:
                    return getExperimentID();

            }
            throw new IllegalStateException();
        }

        /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }

            switch (field) {
                case EXPERIMENT_ID:
                    return isSetExperimentID();
            }
            throw new IllegalStateException();
        }

        @Override
        public boolean equals(Object that) {
            if (that == null)
                return false;
            if (that instanceof resumeExperiment_args)
                return this.equals((resumeExperiment_args)that);
            return false;
        }

        public boolean equals(resumeExperiment_args that) {
            if (that == null)
                return false;

            boolean this_present_experimentID = true && this.isSetExperimentID();
            boolean that_present_experimentID = true && that.isSetExperimentID();
            if (this_present_experimentID || that_present_experimentID) {
                if (!(this_present_experimentID && that_present_experimentID))
                    return false;
                if (!this.experimentID.equals(that.experimentID))
                    return false;
            }

            return true;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public int compareTo(resumeExperiment_args other) {
            if (!getClass().equals(other.getClass())) {
                return getClass().getName().compareTo(other.getClass().getName());
            }

            int lastComparison = 0;

            lastComparison = Boolean.valueOf(isSetExperimentID()).compareTo(other.isSetExperimentID());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (isSetExperimentID()) {
                lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.experimentID, other.experimentID);
                if (lastComparison != 0) {
                    return lastComparison;
                }
            }
            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
        }

        public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("resumeExperiment_args(");
            boolean first = true;

            sb.append("experimentID:");
            if (this.experimentID == null) {
                sb.append("null");
            } else {
                sb.append(this.experimentID);
            }
            first = false;
            sb.append(")");
            return sb.toString();
        }

        public void validate() throws org.apache.thrift.TException {
            // check for required fields
            // check for sub-struct validity
        }

        private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
            try {
                write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
            try {
                read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private static class resumeExperiment_argsStandardSchemeFactory implements SchemeFactory {
            public resumeExperiment_argsStandardScheme getScheme() {
                return new resumeExperiment_argsStandardScheme();
            }
        }

        private static class resumeExperiment_argsStandardScheme extends StandardScheme<resumeExperiment_args> {

            public void read(org.apache.thrift.protocol.TProtocol iprot, resumeExperiment_args struct) throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TField schemeField;
                iprot.readStructBegin();
                while (true)
                {
                    schemeField = iprot.readFieldBegin();
                    if (schemeField.type == org.apache.thrift.protocol.TType.STOP) {
                        break;
                    }
                    switch (schemeField.id) {
                        case 1: // EXPERIMENT_ID
                            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                                struct.experimentID = iprot.readString();
                                struct.setExperimentIDIsSet(true);
                            } else {
                                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                            }
                            break;
                        default:
                            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();

                // check for required fields of primitive type, which can't be checked in the validate method
                struct.validate();
            }

            public void write(org.apache.thrift.protocol.TProtocol oprot, resumeExperiment_args struct) throws org.apache.thrift.TException {
                struct.validate();

                oprot.writeStructBegin(STRUCT_DESC);
                if (struct.experimentID != null) {
                    oprot.writeFieldBegin(EXPERIMENT_ID_FIELD_DESC);
                    oprot.writeString(struct.experimentID);
                    oprot.writeFieldEnd();
                }
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }

        }

        private static class resumeExperiment_argsTupleSchemeFactory implements SchemeFactory {
            public resumeExperiment_argsTupleScheme getScheme() {
                return new resumeExperiment_argsTupleScheme();
            }
        }

        private static class resumeExperiment_argsTupleScheme extends TupleScheme<resumeExperiment_args> {

            @Override
            public void write(org.apache.thrift.protocol.TProtocol prot, resumeExperiment_args struct) throws org.apache.thrift.TException {
                TTupleProtocol oprot = (TTupleProtocol) prot;
                BitSet optionals = new BitSet();
                if (struct.isSetExperimentID()) {
                    optionals.set(0);
                }
                oprot.writeBitSet(optionals, 1);
                if (struct.isSetExperimentID()) {
                    oprot.writeString(struct.experimentID);
                }
            }

            @Override
            public void read(org.apache.thrift.protocol.TProtocol prot, resumeExperiment_args struct) throws org.apache.thrift.TException {
                TTupleProtocol iprot = (TTupleProtocol) prot;
                BitSet incoming = iprot.readBitSet(1);
                if (incoming.get(0)) {
                    struct.experimentID = iprot.readString();
                    struct.setExperimentIDIsSet(true);
                }
            }
        }

    }

    public static class resumeExperiment_result implements org.apache.thrift.TBase<resumeExperiment_result, resumeExperiment_result._Fields>, java.io.Serializable, Cloneable, Comparable<resumeExperiment_result>   {
        private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("resumeExperiment_result");


        private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
        static {
            schemes.put(StandardScheme.class, new resumeExperiment_resultStandardSchemeFactory());
            schemes.put(TupleScheme.class, new resumeExperiment_resultTupleSchemeFactory());
        }


        /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
        public enum _Fields implements org.apache.thrift.TFieldIdEnum {
            ;

            private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

            static {
                for (_Fields field : EnumSet.allOf(_Fields.class)) {
                    byName.put(field.getFieldName(), field);
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, or null if its not found.
             */
            public static _Fields findByThriftId(int fieldId) {
                switch(fieldId) {
                    default:
                        return null;
                }
            }

            /**
             * Find the _Fields constant that matches fieldId, throwing an exception
             * if it is not found.
             */
            public static _Fields findByThriftIdOrThrow(int fieldId) {
                _Fields fields = findByThriftId(fieldId);
                if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
                return fields;
            }

            /**
             * Find the _Fields constant that matches name, or null if its not found.
             */
            public static _Fields findByName(String name) {
                return byName.get(name);
            }

            private final short _thriftId;
            private final String _fieldName;

            _Fields(short thriftId, String fieldName) {
                _thriftId = thriftId;
                _fieldName = fieldName;
            }

            public short getThriftFieldId() {
                return _thriftId;
            }

            public String getFieldName() {
                return _fieldName;
            }
        }
        public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
        static {
            Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
            metaDataMap = Collections.unmodifiableMap(tmpMap);
            org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(resumeExperiment_result.class, metaDataMap);
        }

        public resumeExperiment_result() {
        }

        /**
         * Performs a deep copy on <i>other</i>.
         */
        public resumeExperiment_result(resumeExperiment_result other) {
        }

        public resumeExperiment_result deepCopy() {
            return new resumeExperiment_result(this);
        }

        @Override
        public void clear() {
        }

        public void setFieldValue(_Fields field, Object value) {
            switch (field) {
            }
        }

        public Object getFieldValue(_Fields field) {
            switch (field) {
            }
            throw new IllegalStateException();
        }

        /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
        public boolean isSet(_Fields field) {
            if (field == null) {
                throw new IllegalArgumentException();
            }

            switch (field) {
            }
            throw new IllegalStateException();
        }

        @Override
        public boolean equals(Object that) {
            if (that == null)
                return false;
            if (that instanceof resumeExperiment_result)
                return this.equals((resumeExperiment_result)that);
            return false;
        }

        public boolean equals(resumeExperiment_result that) {
            if (that == null)
                return false;

            return true;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public int compareTo(resumeExperiment_result other) {
            if (!getClass().equals(other.getClass())) {
                return getClass().getName().compareTo(other.getClass().getName());
            }

            int lastComparison = 0;

            return 0;
        }

        public _Fields fieldForId(int fieldId) {
            return _Fields.findByThriftId(fieldId);
        }

        public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
            schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
        }

        public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
            schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("resumeExperiment_result(");
            boolean first = true;

            sb.append(")");
            return sb.toString();
        }

        public void validate() throws org.apache.thrift.TException {
            // check for required fields
            // check for sub-struct validity
        }

        private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
            try {
                write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
            try {
                read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
            } catch (org.apache.thrift.TException te) {
                throw new java.io.IOException(te);
            }
        }

        private static class resumeExperiment_resultStandardSchemeFactory implements SchemeFactory {
            public resumeExperiment_resultStandardScheme getScheme() {
                return new resumeExperiment_resultStandardScheme();
            }
        }

        private static class resumeExperiment_resultStandardScheme extends StandardScheme<resumeExperiment_result> {

            public void read(org.apache.thrift.protocol.TProtocol iprot, resumeExperiment_result struct) throws org.apache.thrift.TException {
                org.apache.thrift.protocol.TField schemeField;
                iprot.readStructBegin();
                while (true)
                {
                    schemeField = iprot.readFieldBegin();
                    if (schemeField.type == org.apache.thrift.protocol.TType.STOP) {
                        break;
                    }
                    switch (schemeField.id) {
                        default:
                            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
                    }
                    iprot.readFieldEnd();
                }
                iprot.readStructEnd();

                // check for required fields of primitive type, which can't be checked in the validate method
                struct.validate();
            }

            public void write(org.apache.thrift.protocol.TProtocol oprot, resumeExperiment_result struct) throws org.apache.thrift.TException {
                struct.validate();

                oprot.writeStructBegin(STRUCT_DESC);
                oprot.writeFieldStop();
                oprot.writeStructEnd();
            }

        }

        private static class resumeExperiment_resultTupleSchemeFactory implements SchemeFactory {
            public resumeExperiment_resultTupleScheme getScheme() {
                return new resumeExperiment_resultTupleScheme();
            }
        }

        private static class resumeExperiment_resultTupleScheme extends TupleScheme<resumeExperiment_result> {

            @Override
            public void write(org.apache.thrift.protocol.TProtocol prot, resumeExperiment_result struct) throws org.apache.thrift.TException {
                TTupleProtocol oprot = (TTupleProtocol) prot;
            }

            @Override
            public void read(org.apache.thrift.protocol.TProtocol prot, resumeExperiment_result struct) throws org.apache.thrift.TException {
                TTupleProtocol iprot = (TTupleProtocol) prot;
            }
        }

    }

}
