/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
*/

package org.apache.airavata.persistance.registry.jpa.resources;

import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Experiment_Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.persistence.EntityManager;
import java.util.List;

public class ExperimentMetadataResource extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ExperimentMetadataResource.class);
    private String expID;
    private String metadata;

    public String getExpID() {
        return expID;
    }

    public String getMetadata() {
        return metadata;
    }

    public void setExpID(String expID) {
        this.expID = expID;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public Resource create(ResourceType type) {
        logger.error("Unsupported operation for experiment metadata resource "
                + "since there are no child resources generated by experiment metadata resource.. ",
                new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    public void remove(ResourceType type, Object name) {
        logger.error("Unsupported operation for experiment metadata resource "
                + "since there are no child resources generated by experiment metadata resource.. ",
                new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    public Resource get(ResourceType type, Object name) {
        logger.error("Unsupported operation for experiment metadata resource "
                + "since there are no child resources generated by experiment metadata resource.. ",
                new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    public List<Resource> get(ResourceType type) {
        logger.error("Unsupported operation for experiment metadata resource "
                + "since there are no child resources generated by experiment metadata resource.. ",
                new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    public void save() {
        EntityManager em = ResourceUtils.getEntityManager();
        Experiment_Metadata existingExpMetaData = em.find(Experiment_Metadata.class, expID);
        em.close();

        em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        Experiment_Metadata experimentMetadata = new Experiment_Metadata();
        experimentMetadata.setExperiment_ID(expID);
        byte[] contentBytes = metadata.getBytes();
        experimentMetadata.setMetadata(contentBytes);

        if (existingExpMetaData != null) {
            existingExpMetaData.setMetadata(contentBytes);
            existingExpMetaData.setExperiment_ID(expID);
            experimentMetadata = em.merge(existingExpMetaData);
        } else {
            em.persist(experimentMetadata);
        }
        em.getTransaction().commit();
        em.close();

    }
}
