/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Experiment_Metadata;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentMetadataResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ExperimentMetadataResource.class);
    private String expID;
    private String metadata;

    public String getExpID() {
        return this.expID;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setExpID(String expID) {
        this.expID = expID;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    @Override
    public Resource create(ResourceType type) {
        logger.error("Unsupported operation for experiment metadata resource since there are no child resources generated by experiment metadata resource.. ", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) {
        logger.error("Unsupported operation for experiment metadata resource since there are no child resources generated by experiment metadata resource.. ", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) {
        logger.error("Unsupported operation for experiment metadata resource since there are no child resources generated by experiment metadata resource.. ", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Resource> get(ResourceType type) {
        logger.error("Unsupported operation for experiment metadata resource since there are no child resources generated by experiment metadata resource.. ", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() {
        EntityManager em = ResourceUtils.getEntityManager();
        Experiment_Metadata existingExpMetaData = (Experiment_Metadata)em.find(Experiment_Metadata.class, (Object)this.expID);
        em.close();
        em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        Experiment_Metadata experimentMetadata = new Experiment_Metadata();
        experimentMetadata.setExperiment_ID(this.expID);
        byte[] contentBytes = this.metadata.getBytes();
        experimentMetadata.setMetadata(contentBytes);
        if (existingExpMetaData != null) {
            existingExpMetaData.setMetadata(contentBytes);
            existingExpMetaData.setExperiment_ID(this.expID);
            experimentMetadata = (Experiment_Metadata)em.merge((Object)existingExpMetaData);
        } else {
            em.persist((Object)experimentMetadata);
        }
        em.getTransaction().commit();
        em.close();
    }
}

