/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Experiment;
import org.apache.airavata.persistance.registry.jpa.model.Experiment_Data;
import org.apache.airavata.persistance.registry.jpa.model.Gateway;
import org.apache.airavata.persistance.registry.jpa.model.Project;
import org.apache.airavata.persistance.registry.jpa.model.Users;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentDataResource;
import org.apache.airavata.persistance.registry.jpa.resources.GatewayResource;
import org.apache.airavata.persistance.registry.jpa.resources.ProjectResource;
import org.apache.airavata.persistance.registry.jpa.resources.Utils;
import org.apache.airavata.persistance.registry.jpa.resources.WorkerResource;
import org.apache.airavata.persistance.registry.jpa.utils.QueryGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ExperimentResource.class);
    private WorkerResource worker;
    private String expID;
    private Timestamp submittedDate;
    private GatewayResource gateway;
    private ProjectResource project;

    public String getExpID() {
        return this.expID;
    }

    public Timestamp getSubmittedDate() {
        return this.submittedDate;
    }

    public void setSubmittedDate(Timestamp submittedDate) {
        this.submittedDate = submittedDate;
    }

    @Override
    public Resource create(ResourceType type) {
        switch (type) {
            case EXPERIMENT_DATA: {
                ExperimentDataResource expDataResource = new ExperimentDataResource();
                expDataResource.setUserName(this.getWorker().getUser());
                expDataResource.setExperimentID(this.getExpID());
                return expDataResource;
            }
        }
        logger.error("Unsupported resource type for experiment resource.", (Throwable)new IllegalArgumentException());
        throw new IllegalArgumentException("Unsupported resource type for experiment resource.");
    }

    @Override
    public void remove(ResourceType type, Object name) {
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        switch (type) {
            case EXPERIMENT_DATA: {
                QueryGenerator generator = new QueryGenerator("Experiment_Data", new Object[0][]);
                generator.setParameter("experiment_ID", name);
                Query q = generator.deleteQuery(em);
                q.executeUpdate();
            }
        }
        em.getTransaction().commit();
        em.close();
    }

    @Override
    public Resource get(ResourceType type, Object name) {
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        switch (type) {
            case EXPERIMENT_DATA: {
                QueryGenerator generator = new QueryGenerator("Experiment_Data", new Object[0][]);
                generator.setParameter("experiment_ID", name);
                Query q = generator.selectQuery(em);
                Experiment_Data experimentData = (Experiment_Data)q.getSingleResult();
                ExperimentDataResource experimentDataResource = (ExperimentDataResource)Utils.getResource(ResourceType.EXPERIMENT_DATA, experimentData);
                em.getTransaction().commit();
                em.close();
                return experimentDataResource;
            }
        }
        em.getTransaction().commit();
        em.close();
        logger.error("Unsupported resource type for experiment resource.", (Throwable)new IllegalArgumentException());
        throw new IllegalArgumentException("Unsupported resource type for experiment data resource.");
    }

    public List<Resource> populate(Object[] keys) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        QueryGenerator queryGenerator = new QueryGenerator("Experiment", new Object[0][]);
        queryGenerator.setParameter("experiment_ID", keys[0]);
        Query q = queryGenerator.selectQuery(em);
        Experiment experiment = (Experiment)q.getSingleResult();
        ExperimentResource experimentResource = (ExperimentResource)Utils.getResource(ResourceType.EXPERIMENT, experiment);
        em.getTransaction().commit();
        em.close();
        list.add(experimentResource);
        return list;
    }

    @Override
    public List<Resource> get(ResourceType type) {
        logger.error("Unsupported resource type for experiment resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() {
        EntityManager em = ResourceUtils.getEntityManager();
        Experiment existingExp = (Experiment)em.find(Experiment.class, (Object)this.expID);
        em.close();
        em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        Experiment experiment = new Experiment();
        Project projectmodel = (Project)em.find(Project.class, (Object)this.project.getName());
        experiment.setProject(projectmodel);
        Users user = (Users)em.find(Users.class, (Object)this.getWorker().getUser());
        Gateway gateway = (Gateway)em.find(Gateway.class, (Object)this.getGateway().getGatewayName());
        experiment.setProject(projectmodel);
        experiment.setExperiment_ID(this.getExpID());
        experiment.setUser(user);
        experiment.setGateway(gateway);
        experiment.setSubmitted_date(this.submittedDate);
        if (existingExp != null) {
            existingExp.setGateway(gateway);
            existingExp.setProject(projectmodel);
            existingExp.setUser(user);
            existingExp.setSubmitted_date(this.submittedDate);
            experiment = (Experiment)em.merge((Object)existingExp);
        } else {
            em.merge((Object)experiment);
        }
        em.getTransaction().commit();
        em.close();
    }

    public void setExpID(String expID) {
        this.expID = expID;
    }

    public GatewayResource getGateway() {
        return this.gateway;
    }

    public void setGateway(GatewayResource gateway) {
        this.gateway = gateway;
    }

    public WorkerResource getWorker() {
        return this.worker;
    }

    public void setWorker(WorkerResource worker) {
        this.worker = worker;
    }

    public ProjectResource getProject() {
        return this.project;
    }

    public void setProject(ProjectResource project) {
        this.project = project;
    }

    public ExperimentDataResource getData() {
        if (this.isExists(ResourceType.EXPERIMENT_DATA, this.getExpID())) {
            return (ExperimentDataResource)this.get(ResourceType.EXPERIMENT_DATA, this.getExpID());
        }
        ExperimentDataResource data = (ExperimentDataResource)this.create(ResourceType.EXPERIMENT_DATA);
        data.save();
        return data;
    }
}

