/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Gram_Data;
import org.apache.airavata.persistance.registry.jpa.model.Gram_DataPK;
import org.apache.airavata.persistance.registry.jpa.model.Workflow_Data;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.WorkflowDataResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GramDataResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(GramDataResource.class);
    private WorkflowDataResource workflowDataResource;
    private String nodeID;
    private String rsl;
    private String invokedHost;
    private String localJobID;

    public String getNodeID() {
        return this.nodeID;
    }

    public String getRsl() {
        return this.rsl;
    }

    public String getInvokedHost() {
        return this.invokedHost;
    }

    public String getLocalJobID() {
        return this.localJobID;
    }

    public WorkflowDataResource getWorkflowDataResource() {
        return this.workflowDataResource;
    }

    public void setWorkflowDataResource(WorkflowDataResource workflowDataResource) {
        this.workflowDataResource = workflowDataResource;
    }

    public void setNodeID(String nodeID) {
        this.nodeID = nodeID;
    }

    public void setRsl(String rsl) {
        this.rsl = rsl;
    }

    public void setInvokedHost(String invokedHost) {
        this.invokedHost = invokedHost;
    }

    public void setLocalJobID(String localJobID) {
        this.localJobID = localJobID;
    }

    @Override
    public Resource create(ResourceType type) {
        logger.error("Unsupported resource type for Gram data resource", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) {
        logger.error("Unsupported resource type for Gram data resource", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) {
        logger.error("Unsupported resource type for Gram data resource", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Resource> get(ResourceType type) {
        logger.error("Unsupported resource type for Gram data resource", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() {
        EntityManager em = ResourceUtils.getEntityManager();
        Gram_Data existingGramData = (Gram_Data)em.find(Gram_Data.class, (Object)new Gram_DataPK(this.workflowDataResource.getWorkflowInstanceID(), this.nodeID));
        em.close();
        em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        Gram_Data gramData = new Gram_Data();
        gramData.setNode_id(this.nodeID);
        Workflow_Data workflow_data = (Workflow_Data)em.find(Workflow_Data.class, (Object)this.workflowDataResource.getWorkflowInstanceID());
        gramData.setWorkflow_Data(workflow_data);
        gramData.setNode_id(this.nodeID);
        gramData.setInvoked_host(this.invokedHost);
        gramData.setLocal_Job_ID(this.localJobID);
        byte[] bytes = this.rsl.getBytes();
        gramData.setRsl(bytes);
        if (existingGramData != null) {
            existingGramData.setInvoked_host(this.invokedHost);
            existingGramData.setLocal_Job_ID(this.localJobID);
            existingGramData.setRsl(bytes);
            gramData = (Gram_Data)em.merge((Object)existingGramData);
        } else {
            em.persist((Object)gramData);
        }
        em.getTransaction().commit();
        em.close();
    }
}

