/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.net.URI;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.model.Application_Descriptor;
import org.apache.airavata.persistance.registry.jpa.model.Configuration;
import org.apache.airavata.persistance.registry.jpa.model.Execution_Error;
import org.apache.airavata.persistance.registry.jpa.model.Experiment;
import org.apache.airavata.persistance.registry.jpa.model.Experiment_Data;
import org.apache.airavata.persistance.registry.jpa.model.Experiment_Metadata;
import org.apache.airavata.persistance.registry.jpa.model.GFac_Job_Data;
import org.apache.airavata.persistance.registry.jpa.model.GFac_Job_Status;
import org.apache.airavata.persistance.registry.jpa.model.Gateway;
import org.apache.airavata.persistance.registry.jpa.model.Gateway_Worker;
import org.apache.airavata.persistance.registry.jpa.model.Gram_Data;
import org.apache.airavata.persistance.registry.jpa.model.Host_Descriptor;
import org.apache.airavata.persistance.registry.jpa.model.Node_Data;
import org.apache.airavata.persistance.registry.jpa.model.Project;
import org.apache.airavata.persistance.registry.jpa.model.Published_Workflow;
import org.apache.airavata.persistance.registry.jpa.model.Service_Descriptor;
import org.apache.airavata.persistance.registry.jpa.model.User_Workflow;
import org.apache.airavata.persistance.registry.jpa.model.Users;
import org.apache.airavata.persistance.registry.jpa.model.Workflow_Data;
import org.apache.airavata.persistance.registry.jpa.resources.AiravataRegistryConnectionDataProviderImpl;
import org.apache.airavata.persistance.registry.jpa.resources.ApplicationDescriptorResource;
import org.apache.airavata.persistance.registry.jpa.resources.ConfigurationResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExecutionErrorResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentDataResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentMetadataResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentResource;
import org.apache.airavata.persistance.registry.jpa.resources.GFacJobDataResource;
import org.apache.airavata.persistance.registry.jpa.resources.GFacJobStatusResource;
import org.apache.airavata.persistance.registry.jpa.resources.GatewayResource;
import org.apache.airavata.persistance.registry.jpa.resources.GramDataResource;
import org.apache.airavata.persistance.registry.jpa.resources.HostDescriptorResource;
import org.apache.airavata.persistance.registry.jpa.resources.NodeDataResource;
import org.apache.airavata.persistance.registry.jpa.resources.ProjectResource;
import org.apache.airavata.persistance.registry.jpa.resources.PublishWorkflowResource;
import org.apache.airavata.persistance.registry.jpa.resources.ServiceDescriptorResource;
import org.apache.airavata.persistance.registry.jpa.resources.UserResource;
import org.apache.airavata.persistance.registry.jpa.resources.UserWorkflowResource;
import org.apache.airavata.persistance.registry.jpa.resources.WorkerResource;
import org.apache.airavata.persistance.registry.jpa.resources.WorkflowDataResource;
import org.apache.airavata.registry.api.AiravataRegistryConnectionDataProvider;
import org.apache.airavata.registry.api.AiravataRegistryFactory;
import org.apache.airavata.registry.api.exception.RegistrySettingsException;
import org.apache.airavata.registry.api.util.RegistrySettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static String getJDBCFullURL() {
        String jdbcUrl = Utils.getJDBCURL();
        String jdbcUser = Utils.getJDBCUser();
        String jdbcPassword = Utils.getJDBCPassword();
        jdbcUrl = jdbcUrl + "?" + "user=" + jdbcUser + "&" + "password=" + jdbcPassword;
        return jdbcUrl;
    }

    public static String getJDBCURL() {
        try {
            return Utils.getProvider().getValue("registry.jdbc.url").toString();
        }
        catch (RegistrySettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getHost() {
        try {
            String jdbcURL = Utils.getJDBCURL();
            String cleanURI = jdbcURL.substring(5);
            URI uri = URI.create(cleanURI);
            return uri.getHost();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static int getPort() {
        try {
            String jdbcURL = Utils.getJDBCURL();
            String cleanURI = jdbcURL.substring(5);
            URI uri = URI.create(cleanURI);
            return uri.getPort();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    public static String getDBType() {
        try {
            String jdbcURL = Utils.getJDBCURL();
            String cleanURI = jdbcURL.substring(5);
            URI uri = URI.create(cleanURI);
            return uri.getScheme();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean isDerbyStartEnabled() {
        try {
            String s = Utils.getProvider().getValue("start.derby.server.mode").toString();
            if ("true".equals(s)) {
                return true;
            }
        }
        catch (RegistrySettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return false;
    }

    private static AiravataRegistryConnectionDataProvider getProvider() {
        return AiravataRegistryFactory.getRegistryConnectionDataProvider();
    }

    public static String getJDBCUser() {
        try {
            if (Utils.getProvider() != null) {
                return Utils.getProvider().getValue("registry.jdbc.user").toString();
            }
            return RegistrySettings.getSetting((String)"registry.jdbc.user");
        }
        catch (RegistrySettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getValidationQuery() {
        try {
            if (Utils.getProvider() != null) {
                if (Utils.getProvider().getValue("validationQuery") != null) {
                    return Utils.getProvider().getValue("validationQuery").toString();
                }
            } else if (Utils.getProvider().getValue("validationQuery") != null) {
                return RegistrySettings.getSetting((String)"validationQuery");
            }
            return "";
        }
        catch (RegistrySettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getJPAConnectionProperties() {
        try {
            if (Utils.getProvider() != null) {
                if (Utils.getProvider().getValue("jpa.connection.properties") != null) {
                    return Utils.getProvider().getValue("jpa.connection.properties").toString();
                }
            } else if (Utils.getProvider().getValue("jpa.connection.properties") != null) {
                return RegistrySettings.getSetting((String)"jpa.connection.properties");
            }
            return "";
        }
        catch (RegistrySettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getJDBCPassword() {
        try {
            if (Utils.getProvider() != null) {
                return Utils.getProvider().getValue("registry.jdbc.password").toString();
            }
            return RegistrySettings.getSetting((String)"registry.jdbc.password");
        }
        catch (RegistrySettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getJDBCDriver() {
        try {
            if (Utils.getProvider() != null) {
                return Utils.getProvider().getValue("registry.jdbc.driver").toString();
            }
            return RegistrySettings.getSetting((String)"registry.jdbc.driver");
        }
        catch (RegistrySettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Resource getResource(ResourceType type, Object o) {
        switch (type) {
            case GATEWAY: {
                if (o instanceof Gateway) {
                    return Utils.createGateway((Gateway)o);
                }
                logger.error("Object should be a Gateway.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Gateway.");
            }
            case PROJECT: {
                if (o instanceof Project) {
                    return Utils.createProject((Project)o);
                }
                logger.error("Object should be a Project.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Project.");
            }
            case CONFIGURATION: {
                if (o instanceof Configuration) {
                    return Utils.createConfiguration((Configuration)o);
                }
                logger.error("Object should be a Configuration.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Configuration.");
            }
            case APPLICATION_DESCRIPTOR: {
                if (o instanceof Application_Descriptor) {
                    return Utils.createApplicationDescriptor((Application_Descriptor)o);
                }
                logger.error("Object should be a Application Descriptor.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Application Descriptor.");
            }
            case EXPERIMENT: {
                if (o instanceof Experiment) {
                    return Utils.createExperiment((Experiment)o);
                }
                logger.error("Object should be a Experiment.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Experiment.");
            }
            case USER: {
                if (o instanceof Users) {
                    return Utils.createUser((Users)o);
                }
                logger.error("Object should be a User.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a User.");
            }
            case HOST_DESCRIPTOR: {
                if (o instanceof Host_Descriptor) {
                    return Utils.createHostDescriptor((Host_Descriptor)o);
                }
                logger.error("Object should be a Host Descriptor.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Host Descriptor.");
            }
            case SERVICE_DESCRIPTOR: {
                if (o instanceof Service_Descriptor) {
                    return Utils.createServiceDescriptor((Service_Descriptor)o);
                }
                logger.error("Object should be a Service Descriptor.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Service Descriptor.");
            }
            case PUBLISHED_WORKFLOW: {
                if (o instanceof Published_Workflow) {
                    return Utils.createPublishWorkflow((Published_Workflow)o);
                }
                logger.error("Object should be a Publish Workflow.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Publish Workflow.");
            }
            case USER_WORKFLOW: {
                if (o instanceof User_Workflow) {
                    return Utils.createUserWorkflow((User_Workflow)o);
                }
                logger.error("Object should be a User Workflow.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a User Workflow.");
            }
            case GATEWAY_WORKER: {
                if (o instanceof Gateway_Worker) {
                    return Utils.createGatewayWorker((Gateway_Worker)o);
                }
                logger.error("Object should be a Gateway Worker.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Gateway Worker.");
            }
            case EXPERIMENT_DATA: {
                if (o instanceof Experiment_Data) {
                    return Utils.createExperimentData((Experiment_Data)o);
                }
                logger.error("Object should be a Experiment Data.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Experiment Data.");
            }
            case EXPERIMENT_METADATA: {
                if (o instanceof Experiment_Metadata) {
                    return Utils.createExperimentMetadata((Experiment_Metadata)o);
                }
                logger.error("Object should be a Experiment Metadata.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Experiment Metadata.");
            }
            case WORKFLOW_DATA: {
                if (o instanceof Workflow_Data) {
                    return Utils.createWorkflowData((Workflow_Data)o);
                }
                logger.error("Object should be a Workflow Data.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Workflow Data.");
            }
            case NODE_DATA: {
                if (o instanceof Node_Data) {
                    return Utils.createNodeData((Node_Data)o);
                }
                logger.error("Object should be a Node Data.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Node Data.");
            }
            case GRAM_DATA: {
                if (o instanceof Gram_Data) {
                    return Utils.createGramData((Gram_Data)o);
                }
                logger.error("Object should be a Gram Data.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Gram Data.");
            }
            case EXECUTION_ERROR: {
                if (o instanceof Execution_Error) {
                    return Utils.createExecutionError((Execution_Error)o);
                }
                logger.error("Object should be a Node Error type.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Node Error.");
            }
            case GFAC_JOB_DATA: {
                if (o instanceof GFac_Job_Data) {
                    return Utils.createGfacJobData((GFac_Job_Data)o);
                }
                logger.error("Object should be a GFac Job Data type.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a GFac Job Data.");
            }
            case GFAC_JOB_STATUS: {
                if (o instanceof GFac_Job_Status) {
                    return Utils.createGfacJobStatus((GFac_Job_Status)o);
                }
                logger.error("Object should be a GFac Job Status type.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a GFac Job Status.");
            }
        }
        return null;
    }

    private static Resource createGateway(Gateway o) {
        GatewayResource gatewayResource = new GatewayResource();
        gatewayResource.setGatewayName(o.getGateway_name());
        return gatewayResource;
    }

    private static Resource createProject(Project o) {
        ProjectResource projectResource = new ProjectResource();
        projectResource.setName(o.getProject_name());
        GatewayResource gatewayResource = (GatewayResource)Utils.createGateway(o.getGateway());
        projectResource.setGateway(gatewayResource);
        Gateway_Worker gateway_worker = new Gateway_Worker();
        gateway_worker.setGateway(o.getGateway());
        gateway_worker.setUser(o.getUsers());
        WorkerResource workerResource = (WorkerResource)Utils.createGatewayWorker(gateway_worker);
        projectResource.setWorker(workerResource);
        return projectResource;
    }

    private static Resource createConfiguration(Configuration o) {
        ConfigurationResource configurationResource = new ConfigurationResource();
        configurationResource.setConfigKey(o.getConfig_key());
        configurationResource.setConfigVal(o.getConfig_val());
        configurationResource.setExpireDate(o.getExpire_date());
        configurationResource.setCategoryID(o.getCategory_id());
        return configurationResource;
    }

    private static Resource createApplicationDescriptor(Application_Descriptor o) {
        ApplicationDescriptorResource applicationDescriptorResource = new ApplicationDescriptorResource();
        applicationDescriptorResource.setName(o.getApplication_descriptor_ID());
        applicationDescriptorResource.setHostDescName(o.getHost_descriptor_ID());
        applicationDescriptorResource.setServiceDescName(o.getService_descriptor_ID());
        applicationDescriptorResource.setContent(new String(o.getApplication_descriptor_xml()));
        applicationDescriptorResource.setUpdatedUser(o.getUser().getUser_name());
        applicationDescriptorResource.setGatewayName(o.getGateway().getGateway_name());
        return applicationDescriptorResource;
    }

    private static Resource createExperiment(Experiment o) {
        ExperimentResource experimentResource = new ExperimentResource();
        GatewayResource gatewayResource = (GatewayResource)Utils.createGateway(o.getGateway());
        experimentResource.setGateway(gatewayResource);
        Gateway_Worker gateway_worker = new Gateway_Worker();
        gateway_worker.setGateway(o.getGateway());
        gateway_worker.setUser(o.getUser());
        WorkerResource workerResource = (WorkerResource)Utils.createGatewayWorker(gateway_worker);
        experimentResource.setWorker(workerResource);
        ProjectResource projectResource = (ProjectResource)Utils.createProject(o.getProject());
        experimentResource.setProject(projectResource);
        experimentResource.setExpID(o.getExperiment_ID());
        experimentResource.setSubmittedDate(o.getSubmitted_date());
        return experimentResource;
    }

    private static Resource createGatewayWorker(Gateway_Worker o) {
        GatewayResource gatewayResource = new GatewayResource(o.getGateway().getGateway_name());
        gatewayResource.setOwner(o.getGateway().getOwner());
        WorkerResource workerResource = new WorkerResource(o.getUser().getUser_name(), gatewayResource);
        return workerResource;
    }

    private static Resource createHostDescriptor(Host_Descriptor o) {
        try {
            HostDescriptorResource hostDescriptorResource = new HostDescriptorResource();
            hostDescriptorResource.setGatewayName(o.getGateway().getGateway_name());
            hostDescriptorResource.setUserName(o.getUser().getUser_name());
            hostDescriptorResource.setHostDescName(o.getHost_descriptor_ID());
            byte[] bytes = o.getHost_descriptor_xml();
            hostDescriptorResource.setContent(new String(bytes));
            return hostDescriptorResource;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Resource createPublishWorkflow(Published_Workflow o) {
        PublishWorkflowResource publishWorkflowResource = new PublishWorkflowResource();
        GatewayResource gatewayResource = (GatewayResource)Utils.createGateway(o.getGateway());
        publishWorkflowResource.setGateway(gatewayResource);
        publishWorkflowResource.setCreatedUser(o.getUser().getUser_name());
        publishWorkflowResource.setName(o.getPublish_workflow_name());
        publishWorkflowResource.setContent(new String(o.getWorkflow_content()));
        publishWorkflowResource.setPublishedDate(o.getPublished_date());
        publishWorkflowResource.setVersion(o.getVersion());
        publishWorkflowResource.setPath(o.getPath());
        return publishWorkflowResource;
    }

    private static Resource createServiceDescriptor(Service_Descriptor o) {
        ServiceDescriptorResource serviceDescriptorResource = new ServiceDescriptorResource();
        serviceDescriptorResource.setGatewayName(o.getGateway().getGateway_name());
        serviceDescriptorResource.setUserName(o.getUser().getUser_name());
        serviceDescriptorResource.setServiceDescName(o.getService_descriptor_ID());
        serviceDescriptorResource.setContent(new String(o.getService_descriptor_xml()));
        return serviceDescriptorResource;
    }

    private static Resource createUserWorkflow(User_Workflow o) {
        UserWorkflowResource userWorkflowResource = new UserWorkflowResource();
        userWorkflowResource.setName(o.getTemplate_name());
        GatewayResource gatewayResource = (GatewayResource)Utils.createGateway(o.getGateway());
        userWorkflowResource.setGateway(gatewayResource);
        Gateway_Worker gateway_worker = new Gateway_Worker();
        gateway_worker.setGateway(o.getGateway());
        gateway_worker.setUser(o.getUser());
        WorkerResource workerResource = (WorkerResource)Utils.createGatewayWorker(gateway_worker);
        userWorkflowResource.setWorker(workerResource);
        userWorkflowResource.setLastUpdateDate(o.getLast_updated_date());
        userWorkflowResource.setContent(new String(o.getWorkflow_graph()));
        userWorkflowResource.setPath(o.getPath());
        return userWorkflowResource;
    }

    private static Resource createUser(Users o) {
        UserResource userResource = new UserResource();
        userResource.setUserName(o.getUser_name());
        userResource.setPassword(o.getPassword());
        return userResource;
    }

    private static Resource createExperimentData(Experiment_Data o) {
        ExperimentDataResource experimentDataResource = new ExperimentDataResource();
        experimentDataResource.setExperimentID(o.getExperiment_ID());
        experimentDataResource.setExpName(o.getName());
        experimentDataResource.setUserName(o.getUsername());
        return experimentDataResource;
    }

    private static Resource createExperimentMetadata(Experiment_Metadata o) {
        ExperimentMetadataResource experimentMetadataResource = new ExperimentMetadataResource();
        experimentMetadataResource.setExpID(o.getExperiment_ID());
        experimentMetadataResource.setMetadata(new String(o.getMetadata()));
        return experimentMetadataResource;
    }

    private static Resource createWorkflowData(Workflow_Data o) {
        WorkflowDataResource workflowDataResource = new WorkflowDataResource();
        workflowDataResource.setExperimentID(o.getExperiment_data().getExperiment_ID());
        workflowDataResource.setWorkflowInstanceID(o.getWorkflow_instanceID());
        workflowDataResource.setTemplateName(o.getTemplate_name());
        workflowDataResource.setStatus(o.getStatus());
        workflowDataResource.setStartTime(o.getStart_time());
        workflowDataResource.setLastUpdatedTime(o.getLast_update_time());
        return workflowDataResource;
    }

    private static Resource createNodeData(Node_Data o) {
        NodeDataResource nodeDataResource = new NodeDataResource();
        WorkflowDataResource workflowDataResource = (WorkflowDataResource)Utils.createWorkflowData(o.getWorkflow_Data());
        nodeDataResource.setWorkflowDataResource(workflowDataResource);
        nodeDataResource.setNodeID(o.getNode_id());
        nodeDataResource.setNodeType(o.getNode_type());
        if (o.getInputs() != null) {
            nodeDataResource.setInputs(new String(o.getInputs()));
        }
        if (o.getOutputs() != null) {
            nodeDataResource.setOutputs(new String(o.getOutputs()));
        }
        nodeDataResource.setStatus(o.getStatus());
        nodeDataResource.setStartTime(o.getStart_time());
        nodeDataResource.setLastUpdateTime(o.getLast_update_time());
        nodeDataResource.setExecutionIndex(o.getExecution_index());
        return nodeDataResource;
    }

    private static Resource createGramData(Gram_Data o) {
        GramDataResource gramDataResource = new GramDataResource();
        WorkflowDataResource workflowDataResource = (WorkflowDataResource)Utils.createWorkflowData(o.getWorkflow_Data());
        gramDataResource.setWorkflowDataResource(workflowDataResource);
        gramDataResource.setNodeID(o.getNode_id());
        gramDataResource.setRsl(new String(o.getRsl()));
        gramDataResource.setInvokedHost(o.getInvoked_host());
        gramDataResource.setLocalJobID(o.getLocal_Job_ID());
        return gramDataResource;
    }

    private static Resource createExecutionError(Execution_Error o) {
        ExecutionErrorResource executionErrorResource = new ExecutionErrorResource();
        ExperimentDataResource experimentDataResource = (ExperimentDataResource)Utils.createExperimentData(o.getExperiment_Data());
        executionErrorResource.setExperimentDataResource(experimentDataResource);
        WorkflowDataResource workflowDataResource = (WorkflowDataResource)Utils.createWorkflowData(o.getWorkflow_Data());
        executionErrorResource.setWorkflowDataResource(workflowDataResource);
        executionErrorResource.setNodeID(o.getNode_id());
        executionErrorResource.setErrorID(o.getError_id());
        executionErrorResource.setGfacJobID(o.getGfacJobID());
        executionErrorResource.setSourceType(o.getSource_type());
        executionErrorResource.setErrorTime(o.getError_date());
        executionErrorResource.setErrorMsg(o.getError_msg());
        executionErrorResource.setErrorDes(o.getError_des());
        executionErrorResource.setErrorCode(o.getError_code());
        executionErrorResource.setErrorReporter(o.getError_reporter());
        executionErrorResource.setErrorLocation(o.getError_location());
        executionErrorResource.setActionTaken(o.getAction_taken());
        executionErrorResource.setErrorReference(o.getError_reference());
        return executionErrorResource;
    }

    private static Resource createGfacJobData(GFac_Job_Data o) {
        GFacJobDataResource gFacJobDataResource = new GFacJobDataResource();
        ExperimentDataResource experimentDataResource = (ExperimentDataResource)Utils.createExperimentData(o.getExperiment_data());
        WorkflowDataResource workflowDataResource = (WorkflowDataResource)Utils.createWorkflowData(o.getWorkflow_Data());
        gFacJobDataResource.setExperimentDataResource(experimentDataResource);
        gFacJobDataResource.setWorkflowDataResource(workflowDataResource);
        gFacJobDataResource.setNodeID(o.getNode_id());
        gFacJobDataResource.setApplicationDescID(o.getApplication_descriptor_ID());
        gFacJobDataResource.setServiceDescID(o.getService_descriptor_ID());
        gFacJobDataResource.setHostDescID(o.getHost_descriptor_ID());
        gFacJobDataResource.setJobData(o.getJob_data());
        gFacJobDataResource.setLocalJobID(o.getLocal_Job_ID());
        gFacJobDataResource.setSubmittedTime(o.getSubmitted_time());
        gFacJobDataResource.setStatusUpdateTime(o.getStatus_update_time());
        gFacJobDataResource.setStatus(o.getStatus());
        gFacJobDataResource.setMetadata(o.getMetadata());
        return gFacJobDataResource;
    }

    private static Resource createGfacJobStatus(GFac_Job_Status o) {
        GFacJobStatusResource gFacJobStatusResource = new GFacJobStatusResource();
        gFacJobStatusResource.setLocalJobID(o.getLocal_Job_ID());
        gFacJobStatusResource.setStatus(o.getStatus());
        gFacJobStatusResource.setStatusUpdateTime(o.getStatus_update_time());
        GFacJobDataResource gFacJobDataResource = (GFacJobDataResource)Utils.createGfacJobData(o.getgFac_job_data());
        gFacJobStatusResource.setgFacJobDataResource(gFacJobDataResource);
        return gFacJobStatusResource;
    }

    static {
        if (AiravataRegistryFactory.getRegistryConnectionDataProvider() == null) {
            AiravataRegistryFactory.registerRegistryConnectionDataProvider((AiravataRegistryConnectionDataProvider)new AiravataRegistryConnectionDataProviderImpl());
        }
    }
}

