/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.model.workspace.experiment.ActionableGroup;
import org.apache.airavata.model.workspace.experiment.AdvancedInputDataHandling;
import org.apache.airavata.model.workspace.experiment.AdvancedOutputDataHandling;
import org.apache.airavata.model.workspace.experiment.ApplicationStatus;
import org.apache.airavata.model.workspace.experiment.ComputationalResourceScheduling;
import org.apache.airavata.model.workspace.experiment.CorrectiveAction;
import org.apache.airavata.model.workspace.experiment.DataObjectType;
import org.apache.airavata.model.workspace.experiment.DataTransferDetails;
import org.apache.airavata.model.workspace.experiment.ErrorDetails;
import org.apache.airavata.model.workspace.experiment.Experiment;
import org.apache.airavata.model.workspace.experiment.ExperimentState;
import org.apache.airavata.model.workspace.experiment.ExperimentStatus;
import org.apache.airavata.model.workspace.experiment.ExperimentSummary;
import org.apache.airavata.model.workspace.experiment.JobDetails;
import org.apache.airavata.model.workspace.experiment.JobState;
import org.apache.airavata.model.workspace.experiment.JobStatus;
import org.apache.airavata.model.workspace.experiment.QualityOfServiceParams;
import org.apache.airavata.model.workspace.experiment.TaskDetails;
import org.apache.airavata.model.workspace.experiment.TaskState;
import org.apache.airavata.model.workspace.experiment.TaskStatus;
import org.apache.airavata.model.workspace.experiment.TransferState;
import org.apache.airavata.model.workspace.experiment.TransferStatus;
import org.apache.airavata.model.workspace.experiment.UserConfigurationData;
import org.apache.airavata.model.workspace.experiment.WorkflowNodeDetails;
import org.apache.airavata.model.workspace.experiment.WorkflowNodeState;
import org.apache.airavata.model.workspace.experiment.WorkflowNodeStatus;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.resources.AdvanceInputDataHandlingResource;
import org.apache.airavata.persistance.registry.jpa.resources.AdvancedOutputDataHandlingResource;
import org.apache.airavata.persistance.registry.jpa.resources.ApplicationInputResource;
import org.apache.airavata.persistance.registry.jpa.resources.ApplicationOutputResource;
import org.apache.airavata.persistance.registry.jpa.resources.ComputationSchedulingResource;
import org.apache.airavata.persistance.registry.jpa.resources.ConfigDataResource;
import org.apache.airavata.persistance.registry.jpa.resources.DataTransferDetailResource;
import org.apache.airavata.persistance.registry.jpa.resources.ErrorDetailResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentInputResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentOutputResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentResource;
import org.apache.airavata.persistance.registry.jpa.resources.GatewayResource;
import org.apache.airavata.persistance.registry.jpa.resources.JobDetailResource;
import org.apache.airavata.persistance.registry.jpa.resources.NodeInputResource;
import org.apache.airavata.persistance.registry.jpa.resources.NodeOutputResource;
import org.apache.airavata.persistance.registry.jpa.resources.ProjectResource;
import org.apache.airavata.persistance.registry.jpa.resources.QosParamResource;
import org.apache.airavata.persistance.registry.jpa.resources.StatusResource;
import org.apache.airavata.persistance.registry.jpa.resources.TaskDetailResource;
import org.apache.airavata.persistance.registry.jpa.resources.UserResource;
import org.apache.airavata.persistance.registry.jpa.resources.WorkerResource;
import org.apache.airavata.persistance.registry.jpa.resources.WorkflowNodeDetailResource;
import org.apache.airavata.persistance.registry.jpa.utils.ThriftDataModelConversion;
import org.apache.airavata.registry.cpi.CompositeIdentifier;
import org.apache.airavata.registry.cpi.RegistryException;
import org.apache.airavata.registry.cpi.RegistryModelType;
import org.apache.airavata.registry.cpi.utils.StatusType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentRegistry {
    private GatewayResource gatewayResource;
    private WorkerResource workerResource;
    private static final Logger logger = LoggerFactory.getLogger(ExperimentRegistry.class);

    public ExperimentRegistry(GatewayResource gateway, UserResource user) throws RegistryException {
        this.gatewayResource = gateway;
        this.workerResource = !this.gatewayResource.isExists(ResourceType.GATEWAY_WORKER, user.getUserName()) ? ResourceUtils.addGatewayWorker(gateway, user) : (WorkerResource)ResourceUtils.getWorker(gateway.getGatewayName(), user.getUserName());
    }

    public String addExperiment(Experiment experiment) throws RegistryException {
        String experimentID;
        try {
            List errors;
            List experimentOutputs;
            UserConfigurationData userConfigurationData;
            if (!ResourceUtils.isUserExist(experiment.getUserName())) {
                ResourceUtils.addUser(experiment.getUserName(), null);
            }
            experimentID = this.getExperimentID(experiment.getName());
            experiment.setExperimentID(experimentID);
            ExperimentResource experimentResource = new ExperimentResource();
            experimentResource.setExpID(experimentID);
            experimentResource.setExpName(experiment.getName());
            experimentResource.setExecutionUser(experiment.getUserName());
            experimentResource.setGateway(this.gatewayResource);
            if (!this.workerResource.isProjectExists(experiment.getProjectID())) {
                logger.error("Project does not exist in the system..");
                throw new Exception("Project does not exist in the system, Please create the project first...");
            }
            ProjectResource project = this.workerResource.getProject(experiment.getProjectID());
            experimentResource.setProject(project);
            experimentResource.setCreationTime(AiravataUtils.getTime((long)experiment.getCreationTime()));
            experimentResource.setDescription(experiment.getDescription());
            experimentResource.setApplicationId(experiment.getApplicationId());
            experimentResource.setApplicationVersion(experiment.getApplicationVersion());
            experimentResource.setWorkflowTemplateId(experiment.getWorkflowTemplateId());
            experimentResource.setWorkflowTemplateVersion(experiment.getWorkflowTemplateVersion());
            experimentResource.setWorkflowExecutionId(experiment.getWorkflowExecutionInstanceId());
            experimentResource.save();
            List experimentInputs = experiment.getExperimentInputs();
            if (experimentInputs != null) {
                this.addExpInputs(experimentInputs, experimentResource);
            }
            if ((userConfigurationData = experiment.getUserConfigurationData()) != null) {
                this.addUserConfigData(userConfigurationData, experimentID);
            }
            if ((experimentOutputs = experiment.getExperimentOutputs()) != null && !experimentOutputs.isEmpty()) {
                for (DataObjectType output : experimentOutputs) {
                    output.setValue("");
                }
                this.addExpOutputs(experimentOutputs, experimentID);
            }
            ExperimentStatus experimentStatus = new ExperimentStatus();
            experimentStatus.setExperimentState(ExperimentState.CREATED);
            this.updateExperimentStatus(experimentStatus, experimentID);
            List workflowNodeDetailsList = experiment.getWorkflowNodeDetailsList();
            if (workflowNodeDetailsList != null && !workflowNodeDetailsList.isEmpty()) {
                for (WorkflowNodeDetails wf : workflowNodeDetailsList) {
                    this.addWorkflowNodeDetails(wf, experimentID);
                }
            }
            if ((errors = experiment.getErrors()) != null && !errors.isEmpty()) {
                for (ErrorDetails errror : errors) {
                    this.addErrorDetails(errror, experimentID);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while saving experiment to registry", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return experimentID;
    }

    public String addUserConfigData(UserConfigurationData configurationData, String experimentID) throws RegistryException {
        try {
            QualityOfServiceParams qosParams;
            AdvancedOutputDataHandling outputDataHandling;
            AdvancedInputDataHandling inputDataHandling;
            ExperimentResource experiment = this.gatewayResource.getExperiment(experimentID);
            ConfigDataResource configData = (ConfigDataResource)experiment.create(ResourceType.CONFIG_DATA);
            configData.setExperimentResource(experiment);
            configData.setAiravataAutoSchedule(configurationData.isAiravataAutoSchedule());
            configData.setOverrideManualParams(configurationData.isOverrideManualScheduledParams());
            configData.setShareExp(configurationData.isShareExperimentPublicly());
            configData.save();
            ComputationalResourceScheduling resourceScheduling = configurationData.getComputationalResourceScheduling();
            if (resourceScheduling != null) {
                this.addComputationScheduling(resourceScheduling, experiment);
            }
            if ((inputDataHandling = configurationData.getAdvanceInputDataHandling()) != null) {
                this.addInputDataHandling(inputDataHandling, experiment);
            }
            if ((outputDataHandling = configurationData.getAdvanceOutputDataHandling()) != null) {
                this.addOutputDataHandling(outputDataHandling, experiment);
            }
            if ((qosParams = configurationData.getQosParams()) != null) {
                this.addQosParams(qosParams, experiment);
            }
        }
        catch (Exception e) {
            logger.error("Unable to save user config data", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return experimentID;
    }

    public void addQosParams(QualityOfServiceParams qosParams, Resource resource) throws RegistryException {
        try {
            QosParamResource qosr = new QosParamResource();
            if (resource instanceof ExperimentResource) {
                ExperimentResource experiment = (ExperimentResource)resource;
                qosr.setExperimentResource(experiment);
            }
            if (resource instanceof TaskDetailResource) {
                TaskDetailResource taskDetailResource = (TaskDetailResource)resource;
                qosr.setTaskDetailResource(taskDetailResource);
                qosr.setExperimentResource(taskDetailResource.getWorkflowNodeDetailResource().getExperimentResource());
            }
            qosr.setStartExecutionAt(qosParams.getStartExecutionAt());
            qosr.setExecuteBefore(qosParams.getExecuteBefore());
            qosr.setNoOfRetries(qosParams.getNumberofRetries());
            qosr.save();
        }
        catch (Exception e) {
            logger.error("Unable to save QOS params", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void addOutputDataHandling(AdvancedOutputDataHandling outputDataHandling, Resource resource) throws RegistryException {
        AdvancedOutputDataHandlingResource adodh = new AdvancedOutputDataHandlingResource();
        try {
            if (resource instanceof ExperimentResource) {
                ExperimentResource experiment = (ExperimentResource)resource;
                adodh.setExperimentResource(experiment);
            }
            if (resource instanceof TaskDetailResource) {
                TaskDetailResource taskDetailResource = (TaskDetailResource)resource;
                adodh.setTaskDetailResource(taskDetailResource);
                adodh.setExperimentResource(taskDetailResource.getWorkflowNodeDetailResource().getExperimentResource());
            }
            adodh.setOutputDataDir(outputDataHandling.getOutputDataDir());
            adodh.setDataRegUrl(outputDataHandling.getDataRegistryURL());
            adodh.setPersistOutputData(outputDataHandling.isPersistOutputData());
            adodh.save();
        }
        catch (Exception e) {
            logger.error("Unable to save output data handling data", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void addInputDataHandling(AdvancedInputDataHandling inputDataHandling, Resource resource) throws RegistryException {
        AdvanceInputDataHandlingResource adidh = new AdvanceInputDataHandlingResource();
        try {
            if (resource instanceof ExperimentResource) {
                ExperimentResource experiment = (ExperimentResource)resource;
                adidh.setExperimentResource(experiment);
            }
            if (resource instanceof TaskDetailResource) {
                TaskDetailResource taskDetailResource = (TaskDetailResource)resource;
                adidh.setTaskDetailResource(taskDetailResource);
                adidh.setExperimentResource(taskDetailResource.getWorkflowNodeDetailResource().getExperimentResource());
            }
            adidh.setWorkingDir(inputDataHandling.getUniqueWorkingDirectory());
            adidh.setWorkingDirParent(inputDataHandling.getParentWorkingDirectory());
            adidh.setStageInputFiles(inputDataHandling.isSetStageInputFilesToWorkingDir());
            adidh.setCleanAfterJob(inputDataHandling.isCleanUpWorkingDirAfterJob());
            adidh.save();
        }
        catch (Exception e) {
            logger.error("Unable to save input data handling data", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void addComputationScheduling(ComputationalResourceScheduling resourceScheduling, Resource resource) throws RegistryException {
        ComputationSchedulingResource cmsr = new ComputationSchedulingResource();
        try {
            if (resource instanceof ExperimentResource) {
                ExperimentResource experiment = (ExperimentResource)resource;
                cmsr.setExperimentResource(experiment);
            }
            if (resource instanceof TaskDetailResource) {
                TaskDetailResource taskDetailResource = (TaskDetailResource)resource;
                cmsr.setTaskDetailResource(taskDetailResource);
                cmsr.setExperimentResource(taskDetailResource.getWorkflowNodeDetailResource().getExperimentResource());
            }
            cmsr.setResourceHostId(resourceScheduling.getResourceHostId());
            cmsr.setCpuCount(resourceScheduling.getTotalCPUCount());
            cmsr.setNodeCount(resourceScheduling.getNodeCount());
            cmsr.setNumberOfThreads(resourceScheduling.getNumberOfThreads());
            cmsr.setQueueName(resourceScheduling.getQueueName());
            cmsr.setWalltimeLimit(resourceScheduling.getWallTimeLimit());
            cmsr.setJobStartTime(AiravataUtils.getTime((long)resourceScheduling.getJobStartTime()));
            cmsr.setPhysicalMemory(resourceScheduling.getTotalPhysicalMemory());
            cmsr.setProjectName(resourceScheduling.getComputationalProjectAccount());
            cmsr.save();
        }
        catch (Exception e) {
            logger.error("Unable to save computational scheduling data", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void addExpInputs(List<DataObjectType> exInputs, ExperimentResource experimentResource) throws RegistryException {
        try {
            for (DataObjectType input : exInputs) {
                ExperimentInputResource resource = (ExperimentInputResource)experimentResource.create(ResourceType.EXPERIMENT_INPUT);
                resource.setExperimentResource(experimentResource);
                resource.setExperimentKey(input.getKey());
                resource.setValue(input.getValue());
                resource.setInputType(input.getType().toString());
                resource.setMetadata(input.getMetaData());
                resource.save();
            }
        }
        catch (Exception e) {
            logger.error("Unable to save experiment inputs", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void updateExpInputs(List<DataObjectType> exInputs, ExperimentResource experimentResource) throws RegistryException {
        try {
            List<ExperimentInputResource> experimentInputs = experimentResource.getExperimentInputs();
            for (DataObjectType input : exInputs) {
                for (ExperimentInputResource exinput : experimentInputs) {
                    if (!exinput.getExperimentKey().equals(input.getKey())) continue;
                    exinput.setValue(input.getValue());
                    exinput.setInputType(input.getType().toString());
                    exinput.setMetadata(input.getMetaData());
                    exinput.save();
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to update experiment inputs", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public String addExpOutputs(List<DataObjectType> exOutput, String expId) throws RegistryException {
        try {
            ExperimentResource experiment = this.gatewayResource.getExperiment(expId);
            for (DataObjectType output : exOutput) {
                ExperimentOutputResource resource = (ExperimentOutputResource)experiment.create(ResourceType.EXPERIMENT_OUTPUT);
                resource.setExperimentResource(experiment);
                resource.setExperimentKey(output.getKey());
                resource.setValue(output.getValue());
                resource.setOutputType(output.getType().toString());
                resource.setMetadata(output.getMetaData());
                resource.save();
            }
        }
        catch (Exception e) {
            logger.error("Error while adding experiment outputs...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return expId;
    }

    public void updateExpOutputs(List<DataObjectType> exOutput, String expId) throws RegistryException {
        try {
            ExperimentResource experiment = this.gatewayResource.getExperiment(expId);
            List<ExperimentOutputResource> existingExpOutputs = experiment.getExperimentOutputs();
            for (DataObjectType output : exOutput) {
                for (ExperimentOutputResource resource : existingExpOutputs) {
                    if (!resource.getExperimentKey().equals(output.getKey())) continue;
                    resource.setExperimentResource(experiment);
                    resource.setExperimentKey(output.getKey());
                    resource.setValue(output.getValue());
                    resource.setOutputType(output.getType().toString());
                    resource.setMetadata(output.getMetaData());
                    resource.save();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while updating experiment outputs", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public String addNodeOutputs(List<DataObjectType> wfOutputs, CompositeIdentifier ids) throws RegistryException {
        try {
            ExperimentResource experiment = this.gatewayResource.getExperiment((String)ids.getTopLevelIdentifier());
            WorkflowNodeDetailResource workflowNode = experiment.getWorkflowNode((String)ids.getSecondLevelIdentifier());
            for (DataObjectType output : wfOutputs) {
                NodeOutputResource resource = (NodeOutputResource)workflowNode.create(ResourceType.NODE_OUTPUT);
                resource.setNodeDetailResource(workflowNode);
                resource.setOutputKey(output.getKey());
                resource.setValue(output.getValue());
                resource.setOutputType(output.getType().toString());
                resource.setMetadata(output.getMetaData());
                resource.save();
            }
        }
        catch (Exception e) {
            logger.error("Error while adding node outputs...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return (String)ids.getSecondLevelIdentifier();
    }

    public void updateNodeOutputs(List<DataObjectType> wfOutputs, String nodeId) throws RegistryException {
        try {
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = experiment.getWorkflowNode(nodeId);
            List<NodeOutputResource> nodeOutputs = workflowNode.getNodeOutputs();
            for (DataObjectType output : wfOutputs) {
                for (NodeOutputResource resource : nodeOutputs) {
                    resource.setNodeDetailResource(workflowNode);
                    resource.setOutputKey(output.getKey());
                    resource.setValue(output.getValue());
                    resource.setOutputType(output.getType().toString());
                    resource.setMetadata(output.getMetaData());
                    resource.save();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while updating node outputs...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public String addApplicationOutputs(List<DataObjectType> appOutputs, CompositeIdentifier ids) throws RegistryException {
        try {
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = experiment.getWorkflowNode((String)ids.getTopLevelIdentifier());
            TaskDetailResource taskDetail = workflowNode.getTaskDetail((String)ids.getSecondLevelIdentifier());
            for (DataObjectType output : appOutputs) {
                ApplicationOutputResource resource = (ApplicationOutputResource)taskDetail.create(ResourceType.APPLICATION_OUTPUT);
                resource.setTaskDetailResource(taskDetail);
                resource.setOutputKey(output.getKey());
                resource.setValue(output.getValue());
                resource.setOutputType(output.getType().toString());
                resource.setMetadata(output.getMetaData());
                resource.save();
            }
        }
        catch (Exception e) {
            logger.error("Error while adding application outputs...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return (String)ids.getSecondLevelIdentifier();
    }

    public String updateExperimentStatus(ExperimentStatus experimentStatus, String expId) throws RegistryException {
        try {
            ExperimentResource experiment = this.gatewayResource.getExperiment(expId);
            StatusResource status = experiment.getExperimentStatus();
            if (status == null) {
                status = (StatusResource)experiment.create(ResourceType.STATUS);
            }
            status.setExperimentResource(experiment);
            status.setStatusUpdateTime(AiravataUtils.getTime((long)experimentStatus.getTimeOfStateChange()));
            if (experimentStatus.getExperimentState() == null) {
                status.setState(ExperimentState.UNKNOWN.toString());
            } else {
                status.setState(experimentStatus.getExperimentState().toString());
            }
            status.setStatusType(StatusType.EXPERIMENT.toString());
            status.save();
        }
        catch (Exception e) {
            logger.error("Error while updating experiment status...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return expId;
    }

    public String addWorkflowNodeStatus(WorkflowNodeStatus status, CompositeIdentifier ids) throws RegistryException {
        try {
            ExperimentResource experiment = this.gatewayResource.getExperiment((String)ids.getTopLevelIdentifier());
            WorkflowNodeDetailResource workflowNode = experiment.getWorkflowNode((String)ids.getSecondLevelIdentifier());
            StatusResource statusResource = (StatusResource)experiment.create(ResourceType.STATUS);
            statusResource.setExperimentResource(experiment);
            statusResource.setWorkflowNodeDetail(workflowNode);
            statusResource.setStatusType(StatusType.WORKFLOW_NODE.toString());
            statusResource.setStatusUpdateTime(AiravataUtils.getTime((long)status.getTimeOfStateChange()));
            if (status.getWorkflowNodeState() == null) {
                statusResource.setState(WorkflowNodeState.UNKNOWN.toString());
            } else {
                statusResource.setState(status.getWorkflowNodeState().toString());
            }
            statusResource.save();
            return String.valueOf(statusResource.getStatusId());
        }
        catch (Exception e) {
            logger.error("Error while adding workflow node status...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public String updateWorkflowNodeStatus(WorkflowNodeStatus status, String nodeId) throws RegistryException {
        try {
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = experiment.getWorkflowNode(nodeId);
            StatusResource statusResource = workflowNode.getWorkflowNodeStatus();
            if (statusResource == null) {
                statusResource = (StatusResource)workflowNode.create(ResourceType.STATUS);
            }
            statusResource.setExperimentResource(workflowNode.getExperimentResource());
            statusResource.setWorkflowNodeDetail(workflowNode);
            statusResource.setStatusType(StatusType.WORKFLOW_NODE.toString());
            statusResource.setStatusUpdateTime(AiravataUtils.getTime((long)status.getTimeOfStateChange()));
            statusResource.setState(status.getWorkflowNodeState().toString());
            statusResource.save();
            return String.valueOf(statusResource.getStatusId());
        }
        catch (Exception e) {
            logger.error("Error whilw updating workflow node status...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public String addTaskStatus(TaskStatus status, CompositeIdentifier ids) throws RegistryException {
        try {
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = experiment.getWorkflowNode((String)ids.getTopLevelIdentifier());
            TaskDetailResource taskDetail = workflowNode.getTaskDetail((String)ids.getSecondLevelIdentifier());
            StatusResource statusResource = (StatusResource)workflowNode.create(ResourceType.STATUS);
            statusResource.setExperimentResource(workflowNode.getExperimentResource());
            statusResource.setWorkflowNodeDetail(workflowNode);
            statusResource.setTaskDetailResource(taskDetail);
            statusResource.setStatusType(StatusType.TASK.toString());
            statusResource.setStatusUpdateTime(AiravataUtils.getTime((long)status.getTimeOfStateChange()));
            if (status.getExecutionState() == null) {
                statusResource.setState(TaskState.UNKNOWN.toString());
            } else {
                statusResource.setState(status.getExecutionState().toString());
            }
            statusResource.save();
            return String.valueOf(statusResource.getStatusId());
        }
        catch (Exception e) {
            logger.error("Error while adding task status...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void updateTaskStatus(TaskStatus status, String taskId) throws RegistryException {
        try {
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
            TaskDetailResource taskDetail = workflowNode.getTaskDetail(taskId);
            StatusResource statusResource = taskDetail.isTaskStatusExist(taskId) ? workflowNode.getTaskStatus(taskId) : (StatusResource)taskDetail.create(ResourceType.STATUS);
            statusResource.setExperimentResource(taskDetail.getWorkflowNodeDetailResource().getExperimentResource());
            statusResource.setWorkflowNodeDetail(taskDetail.getWorkflowNodeDetailResource());
            statusResource.setTaskDetailResource(taskDetail);
            statusResource.setStatusType(StatusType.TASK.toString());
            statusResource.setStatusUpdateTime(AiravataUtils.getTime((long)status.getTimeOfStateChange()));
            statusResource.setState(status.getExecutionState().toString());
            statusResource.save();
        }
        catch (Exception e) {
            logger.error("Error while updating task status...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public String addJobStatus(JobStatus status, CompositeIdentifier ids) throws RegistryException {
        try {
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
            TaskDetailResource taskDetail = workflowNode.getTaskDetail((String)ids.getTopLevelIdentifier());
            JobDetailResource jobDetail = taskDetail.getJobDetail((String)ids.getSecondLevelIdentifier());
            StatusResource statusResource = (StatusResource)jobDetail.create(ResourceType.STATUS);
            statusResource.setExperimentResource(taskDetail.getWorkflowNodeDetailResource().getExperimentResource());
            statusResource.setWorkflowNodeDetail(taskDetail.getWorkflowNodeDetailResource());
            statusResource.setTaskDetailResource(taskDetail);
            statusResource.setStatusType(StatusType.JOB.toString());
            statusResource.setStatusUpdateTime(AiravataUtils.getTime((long)status.getTimeOfStateChange()));
            if (status.getJobState() == null) {
                statusResource.setState(JobState.UNKNOWN.toString());
            } else {
                statusResource.setState(status.getJobState().toString());
            }
            statusResource.save();
            return String.valueOf(statusResource.getStatusId());
        }
        catch (Exception e) {
            logger.error("Error while adding job status...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public String updateJobStatus(JobStatus status, CompositeIdentifier ids) throws RegistryException {
        try {
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
            TaskDetailResource taskDetail = workflowNode.getTaskDetail((String)ids.getTopLevelIdentifier());
            JobDetailResource jobDetail = taskDetail.getJobDetail((String)ids.getSecondLevelIdentifier());
            StatusResource statusResource = jobDetail.getJobStatus();
            workflowNode = taskDetail.getWorkflowNodeDetailResource();
            experiment = workflowNode.getExperimentResource();
            statusResource.setExperimentResource(experiment);
            statusResource.setWorkflowNodeDetail(workflowNode);
            statusResource.setTaskDetailResource(taskDetail);
            statusResource.setStatusType(StatusType.JOB.toString());
            statusResource.setStatusUpdateTime(AiravataUtils.getTime((long)status.getTimeOfStateChange()));
            statusResource.setState(status.getJobState().toString());
            statusResource.save();
            return String.valueOf(statusResource.getStatusId());
        }
        catch (Exception e) {
            logger.error("Error while updating job status...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public String addApplicationStatus(ApplicationStatus status, CompositeIdentifier ids) throws RegistryException {
        try {
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
            TaskDetailResource taskDetail = workflowNode.getTaskDetail((String)ids.getTopLevelIdentifier());
            JobDetailResource jobDetail = taskDetail.getJobDetail((String)ids.getSecondLevelIdentifier());
            StatusResource statusResource = (StatusResource)jobDetail.create(ResourceType.STATUS);
            statusResource.setExperimentResource(taskDetail.getWorkflowNodeDetailResource().getExperimentResource());
            statusResource.setWorkflowNodeDetail(taskDetail.getWorkflowNodeDetailResource());
            statusResource.setTaskDetailResource(taskDetail);
            statusResource.setStatusType(StatusType.APPLICATION.toString());
            statusResource.setStatusUpdateTime(AiravataUtils.getTime((long)status.getTimeOfStateChange()));
            if (status.getApplicationState() == null) {
                statusResource.setState("UNKNOWN");
            } else {
                statusResource.setState(status.getApplicationState());
            }
            statusResource.save();
            return String.valueOf(statusResource.getStatusId());
        }
        catch (Exception e) {
            logger.error("Unable to read airavata-server properties", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void updateApplicationStatus(ApplicationStatus status, String jobId) throws RegistryException {
        try {
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
            TaskDetailResource taskDetail = (TaskDetailResource)workflowNode.create(ResourceType.TASK_DETAIL);
            JobDetailResource jobDetail = taskDetail.getJobDetail(jobId);
            StatusResource statusResource = jobDetail.getApplicationStatus();
            statusResource.setExperimentResource(jobDetail.getTaskDetailResource().getWorkflowNodeDetailResource().getExperimentResource());
            statusResource.setWorkflowNodeDetail(jobDetail.getTaskDetailResource().getWorkflowNodeDetailResource());
            statusResource.setTaskDetailResource(jobDetail.getTaskDetailResource());
            statusResource.setStatusType(StatusType.APPLICATION.toString());
            statusResource.setStatusUpdateTime(AiravataUtils.getTime((long)status.getTimeOfStateChange()));
            statusResource.setState(status.getApplicationState());
            statusResource.save();
        }
        catch (Exception e) {
            logger.error("Error while updating application status...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public String addTransferStatus(TransferStatus status, CompositeIdentifier ids) throws RegistryException {
        try {
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
            TaskDetailResource taskDetail = workflowNode.getTaskDetail((String)ids.getTopLevelIdentifier());
            DataTransferDetailResource dataTransferDetail = taskDetail.getDataTransferDetail((String)ids.getSecondLevelIdentifier());
            StatusResource statusResource = (StatusResource)dataTransferDetail.create(ResourceType.STATUS);
            statusResource.setExperimentResource(taskDetail.getWorkflowNodeDetailResource().getExperimentResource());
            statusResource.setWorkflowNodeDetail(taskDetail.getWorkflowNodeDetailResource());
            statusResource.setTaskDetailResource(taskDetail);
            statusResource.setDataTransferDetail(dataTransferDetail);
            statusResource.setStatusType(StatusType.DATA_TRANSFER.toString());
            statusResource.setStatusUpdateTime(AiravataUtils.getTime((long)status.getTimeOfStateChange()));
            if (status.getTransferState() == null) {
                statusResource.setState(TransferState.UNKNOWN.toString());
            } else {
                statusResource.setState(status.getTransferState().toString());
            }
            statusResource.save();
            return String.valueOf(statusResource.getStatusId());
        }
        catch (Exception e) {
            logger.error("Error while adding transfer status...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void updateTransferStatus(TransferStatus status, String transferId) throws RegistryException {
        try {
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
            TaskDetailResource taskDetail = (TaskDetailResource)workflowNode.create(ResourceType.TASK_DETAIL);
            DataTransferDetailResource dataTransferDetail = taskDetail.getDataTransferDetail(transferId);
            StatusResource statusResource = dataTransferDetail.getDataTransferStatus();
            WorkflowNodeDetailResource workflowNodeDetailResource = dataTransferDetail.getTaskDetailResource().getWorkflowNodeDetailResource();
            if (workflowNodeDetailResource != null) {
                statusResource.setExperimentResource(workflowNodeDetailResource.getExperimentResource());
                statusResource.setWorkflowNodeDetail(workflowNodeDetailResource);
            }
            statusResource.setTaskDetailResource(dataTransferDetail.getTaskDetailResource());
            statusResource.setDataTransferDetail(dataTransferDetail);
            statusResource.setStatusType(StatusType.DATA_TRANSFER.toString());
            statusResource.setStatusUpdateTime(AiravataUtils.getTime((long)status.getTimeOfStateChange()));
            statusResource.setState(status.getTransferState().toString());
            statusResource.save();
        }
        catch (Exception e) {
            logger.error("Error while updating transfer status...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public String addWorkflowNodeDetails(WorkflowNodeDetails nodeDetails, String expId) throws RegistryException {
        try {
            List errors;
            List nodeOutputs;
            ExperimentResource experiment = this.gatewayResource.getExperiment(expId);
            WorkflowNodeDetailResource resource = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
            resource.setExperimentResource(experiment);
            resource.setNodeName(nodeDetails.getNodeName());
            resource.setCreationTime(AiravataUtils.getTime((long)nodeDetails.getCreationTime()));
            resource.setNodeInstanceId(this.getNodeInstanceID(nodeDetails.getNodeName()));
            resource.save();
            String nodeId = resource.getNodeInstanceId();
            List nodeInputs = nodeDetails.getNodeInputs();
            if (nodeInputs != null) {
                this.addWorkflowInputs(nodeDetails.getNodeInputs(), resource);
            }
            if ((nodeOutputs = nodeDetails.getNodeOutputs()) != null && !nodeOutputs.isEmpty()) {
                CompositeIdentifier ids = new CompositeIdentifier((Object)expId, (Object)nodeId);
                this.addNodeOutputs(nodeOutputs, ids);
            }
            WorkflowNodeStatus workflowNodeStatus = nodeDetails.getWorkflowNodeStatus();
            CompositeIdentifier ids = new CompositeIdentifier((Object)expId, (Object)nodeId);
            if (workflowNodeStatus == null) {
                workflowNodeStatus = new WorkflowNodeStatus();
            }
            workflowNodeStatus.setWorkflowNodeState(WorkflowNodeState.UNKNOWN);
            this.addWorkflowNodeStatus(workflowNodeStatus, ids);
            List taskDetails = nodeDetails.getTaskDetailsList();
            if (taskDetails != null && !taskDetails.isEmpty()) {
                for (TaskDetails task : taskDetails) {
                    this.addTaskDetails(task, nodeId);
                }
            }
            if ((errors = nodeDetails.getErrors()) != null && !errors.isEmpty()) {
                for (ErrorDetails error : errors) {
                    this.addErrorDetails(error, nodeId);
                }
            }
            return nodeId;
        }
        catch (Exception e) {
            logger.error("Error while adding workflow node details...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void updateWorkflowNodeDetails(WorkflowNodeDetails nodeDetails, String nodeId) throws RegistryException {
        try {
            List errors;
            List taskDetails;
            WorkflowNodeStatus workflowNodeStatus;
            List nodeOutputs;
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = experiment.getWorkflowNode(nodeId);
            workflowNode.setNodeName(nodeDetails.getNodeName());
            workflowNode.setCreationTime(AiravataUtils.getTime((long)nodeDetails.getCreationTime()));
            workflowNode.setNodeInstanceId(nodeId);
            workflowNode.save();
            String expID = workflowNode.getExperimentResource().getExpID();
            List nodeInputs = nodeDetails.getNodeInputs();
            if (nodeInputs != null) {
                this.updateWorkflowInputs(nodeDetails.getNodeInputs(), workflowNode);
            }
            if ((nodeOutputs = nodeDetails.getNodeOutputs()) != null && !nodeOutputs.isEmpty()) {
                this.updateNodeOutputs(nodeOutputs, nodeId);
            }
            if ((workflowNodeStatus = nodeDetails.getWorkflowNodeStatus()) != null) {
                if (this.isWFNodeExist(nodeId)) {
                    this.updateWorkflowNodeStatus(workflowNodeStatus, nodeId);
                } else {
                    CompositeIdentifier ids = new CompositeIdentifier((Object)expID, (Object)nodeId);
                    this.addWorkflowNodeStatus(workflowNodeStatus, ids);
                }
            }
            if ((taskDetails = nodeDetails.getTaskDetailsList()) != null && !taskDetails.isEmpty()) {
                for (TaskDetails task : taskDetails) {
                    String taskID = task.getTaskID();
                    if (this.isTaskDetailExist(taskID)) {
                        this.updateTaskDetails(task, taskID);
                        continue;
                    }
                    this.addTaskDetails(task, nodeId);
                }
            }
            if ((errors = nodeDetails.getErrors()) != null && !errors.isEmpty()) {
                for (ErrorDetails error : errors) {
                    this.addErrorDetails(error, nodeId);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while updating workflow node details...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void addWorkflowInputs(List<DataObjectType> wfInputs, WorkflowNodeDetailResource nodeDetailResource) throws RegistryException {
        try {
            for (DataObjectType input : wfInputs) {
                NodeInputResource resource = (NodeInputResource)nodeDetailResource.create(ResourceType.NODE_INPUT);
                resource.setNodeDetailResource(nodeDetailResource);
                resource.setInputKey(input.getKey());
                resource.setValue(input.getValue());
                resource.setInputType(input.getType().toString());
                resource.setMetadata(input.getMetaData());
                resource.save();
            }
        }
        catch (Exception e) {
            logger.error("Error while adding workflow inputs...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void updateWorkflowInputs(List<DataObjectType> wfInputs, WorkflowNodeDetailResource nodeDetailResource) throws RegistryException {
        try {
            List<NodeInputResource> nodeInputs = nodeDetailResource.getNodeInputs();
            for (DataObjectType input : wfInputs) {
                for (NodeInputResource resource : nodeInputs) {
                    resource.setNodeDetailResource(nodeDetailResource);
                    resource.setInputKey(input.getKey());
                    resource.setValue(input.getValue());
                    resource.setInputType(input.getType().toString());
                    resource.setMetadata(input.getMetaData());
                    resource.save();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while updating workflow inputs...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public String addTaskDetails(TaskDetails taskDetails, String nodeId) throws RegistryException {
        try {
            List errors;
            List dataTransferDetailsList;
            List jobDetailsList;
            AdvancedOutputDataHandling outputDataHandling;
            AdvancedInputDataHandling inputDataHandling;
            ComputationalResourceScheduling taskScheduling;
            List applicationOutput;
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = experiment.getWorkflowNode(nodeId);
            TaskDetailResource taskDetail = (TaskDetailResource)workflowNode.create(ResourceType.TASK_DETAIL);
            taskDetail.setWorkflowNodeDetailResource(workflowNode);
            taskDetail.setTaskId(this.getTaskID(workflowNode.getNodeName()));
            taskDetail.setApplicationId(taskDetails.getApplicationId());
            taskDetail.setApplicationVersion(taskDetails.getApplicationVersion());
            taskDetail.setCreationTime(AiravataUtils.getTime((long)taskDetails.getCreationTime()));
            taskDetail.save();
            List applicationInputs = taskDetails.getApplicationInputs();
            if (applicationInputs != null) {
                this.addAppInputs(applicationInputs, taskDetail);
            }
            if ((applicationOutput = taskDetails.getApplicationOutputs()) != null) {
                this.addAppOutputs(applicationOutput, taskDetail);
            }
            if ((taskScheduling = taskDetails.getTaskScheduling()) != null) {
                this.addComputationScheduling(taskScheduling, taskDetail);
            }
            if ((inputDataHandling = taskDetails.getAdvancedInputDataHandling()) != null) {
                this.addInputDataHandling(inputDataHandling, taskDetail);
            }
            if ((outputDataHandling = taskDetails.getAdvancedOutputDataHandling()) != null) {
                this.addOutputDataHandling(outputDataHandling, taskDetail);
            }
            if ((jobDetailsList = taskDetails.getJobDetailsList()) != null && !jobDetailsList.isEmpty()) {
                for (JobDetails job : jobDetailsList) {
                    CompositeIdentifier ids = new CompositeIdentifier((Object)taskDetail.getTaskId(), (Object)job.getJobID());
                    this.addJobDetails(job, ids);
                }
            }
            if ((dataTransferDetailsList = taskDetails.getDataTransferDetailsList()) != null && !dataTransferDetailsList.isEmpty()) {
                for (DataTransferDetails transferDetails : dataTransferDetailsList) {
                    this.addDataTransferDetails(transferDetails, taskDetail.getTaskId());
                }
            }
            if ((errors = taskDetails.getErrors()) != null && !errors.isEmpty()) {
                for (ErrorDetails error : errors) {
                    this.addErrorDetails(error, taskDetail.getTaskId());
                }
            }
            TaskStatus taskStatus = taskDetails.getTaskStatus();
            CompositeIdentifier ids = new CompositeIdentifier((Object)nodeId, (Object)taskDetail.getTaskId());
            if (taskStatus != null) {
                if (taskStatus.getExecutionState() != null) {
                    this.addTaskStatus(taskStatus, ids);
                } else {
                    taskStatus.setExecutionState(TaskState.UNKNOWN);
                    this.addTaskStatus(taskStatus, ids);
                }
            } else {
                TaskStatus status = new TaskStatus();
                status.setExecutionState(TaskState.UNKNOWN);
                this.addTaskStatus(status, ids);
            }
            return taskDetail.getTaskId();
        }
        catch (Exception e) {
            logger.error("Error while adding task details...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public String updateTaskDetails(TaskDetails taskDetails, String taskId) throws RegistryException {
        try {
            TaskStatus taskStatus;
            List errors;
            List dataTransferDetailsList;
            List jobDetailsList;
            AdvancedOutputDataHandling outputDataHandling;
            AdvancedInputDataHandling inputDataHandling;
            ComputationalResourceScheduling taskScheduling;
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
            TaskDetailResource taskDetail = workflowNode.getTaskDetail(taskId);
            taskDetail.setApplicationId(taskDetails.getApplicationId());
            taskDetail.setApplicationVersion(taskDetails.getApplicationVersion());
            taskDetail.setCreationTime(AiravataUtils.getTime((long)taskDetails.getCreationTime()));
            taskDetail.save();
            List applicationInputs = taskDetails.getApplicationInputs();
            if (applicationInputs != null) {
                this.updateAppInputs(applicationInputs, taskDetail);
            }
            if ((taskScheduling = taskDetails.getTaskScheduling()) != null) {
                this.updateSchedulingData(taskScheduling, taskDetail);
            }
            if ((inputDataHandling = taskDetails.getAdvancedInputDataHandling()) != null) {
                this.updateInputDataHandling(inputDataHandling, taskDetail);
            }
            if ((outputDataHandling = taskDetails.getAdvancedOutputDataHandling()) != null) {
                this.updateOutputDataHandling(outputDataHandling, taskDetail);
            }
            if ((jobDetailsList = taskDetails.getJobDetailsList()) != null && !jobDetailsList.isEmpty()) {
                for (JobDetails job : jobDetailsList) {
                    CompositeIdentifier ids = new CompositeIdentifier((Object)taskId, (Object)job.getJobID());
                    this.updateJobDetails(job, ids);
                }
            }
            if ((dataTransferDetailsList = taskDetails.getDataTransferDetailsList()) != null && !dataTransferDetailsList.isEmpty()) {
                for (DataTransferDetails transferDetails : dataTransferDetailsList) {
                    this.updateDataTransferDetails(transferDetails, transferDetails.getTransferID());
                }
            }
            if ((errors = taskDetails.getErrors()) != null && !errors.isEmpty()) {
                for (ErrorDetails error : errors) {
                    this.addErrorDetails(error, taskDetail.getTaskId());
                }
            }
            if ((taskStatus = taskDetails.getTaskStatus()) != null) {
                this.updateTaskStatus(taskStatus, taskId);
            }
            return taskDetail.getTaskId();
        }
        catch (Exception e) {
            logger.error("Error while updating task details...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void addAppInputs(List<DataObjectType> appInputs, TaskDetailResource taskDetailResource) throws RegistryException {
        try {
            for (DataObjectType input : appInputs) {
                ApplicationInputResource resource = (ApplicationInputResource)taskDetailResource.create(ResourceType.APPLICATION_INPUT);
                resource.setTaskDetailResource(taskDetailResource);
                resource.setInputKey(input.getKey());
                resource.setValue(input.getValue());
                resource.setInputType(input.getType().toString());
                resource.setMetadata(input.getMetaData());
                resource.save();
            }
        }
        catch (Exception e) {
            logger.error("Error while adding application inputs...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void addAppOutputs(List<DataObjectType> appInputs, TaskDetailResource taskDetailResource) throws RegistryException {
        try {
            for (DataObjectType input : appInputs) {
                ApplicationOutputResource resource = (ApplicationOutputResource)taskDetailResource.create(ResourceType.APPLICATION_OUTPUT);
                resource.setTaskDetailResource(taskDetailResource);
                resource.setOutputKey(input.getKey());
                resource.setValue(input.getValue());
                resource.setOutputType(input.getType().toString());
                resource.setMetadata(input.getMetaData());
                resource.save();
            }
        }
        catch (Exception e) {
            logger.error("Error while adding application outputs...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void updateAppOutputs(List<DataObjectType> appOutputs, String taskId) throws RegistryException {
        try {
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
            TaskDetailResource taskDetail = workflowNode.getTaskDetail(taskId);
            List<ApplicationOutputResource> outputs = taskDetail.getApplicationOutputs();
            for (DataObjectType output : appOutputs) {
                for (ApplicationOutputResource resource : outputs) {
                    resource.setTaskDetailResource(taskDetail);
                    resource.setOutputKey(output.getKey());
                    resource.setValue(output.getValue());
                    resource.setOutputType(output.getType().toString());
                    resource.setMetadata(output.getMetaData());
                    resource.save();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while updating application outputs...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void updateAppInputs(List<DataObjectType> appInputs, TaskDetailResource taskDetailResource) throws RegistryException {
        try {
            List<ApplicationInputResource> inputs = taskDetailResource.getApplicationInputs();
            for (DataObjectType input : appInputs) {
                for (ApplicationInputResource resource : inputs) {
                    resource.setTaskDetailResource(taskDetailResource);
                    resource.setInputKey(input.getKey());
                    resource.setValue(input.getValue());
                    resource.setInputType(input.getType().toString());
                    resource.setMetadata(input.getMetaData());
                    resource.save();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while updating application inputs...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public String addJobDetails(JobDetails jobDetails, CompositeIdentifier ids) throws RegistryException {
        try {
            List errors;
            ApplicationStatus applicationStatus;
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
            TaskDetailResource taskDetail = workflowNode.getTaskDetail((String)ids.getTopLevelIdentifier());
            JobDetailResource jobDetail = taskDetail.createJobDetail((String)ids.getSecondLevelIdentifier());
            jobDetail.setTaskDetailResource(taskDetail);
            jobDetail.setJobDescription(jobDetails.getJobDescription());
            jobDetail.setCreationTime(AiravataUtils.getTime((long)jobDetails.getCreationTime()));
            jobDetail.setComputeResourceConsumed(jobDetails.getComputeResourceConsumed());
            jobDetail.save();
            JobStatus jobStatus = jobDetails.getJobStatus();
            if (jobStatus != null) {
                JobStatus status = this.getJobStatus(ids);
                if (status != null) {
                    this.updateJobStatus(jobStatus, ids);
                } else {
                    this.addJobStatus(jobStatus, ids);
                }
            }
            if ((applicationStatus = jobDetails.getApplicationStatus()) != null) {
                ApplicationStatus appStatus = this.getApplicationStatus(ids);
                if (appStatus != null) {
                    this.updateApplicationStatus(applicationStatus, (String)ids.getSecondLevelIdentifier());
                } else {
                    this.addApplicationStatus(applicationStatus, ids);
                }
            }
            if ((errors = jobDetails.getErrors()) != null && !errors.isEmpty()) {
                for (ErrorDetails error : errors) {
                    this.addErrorDetails(error, ids.getSecondLevelIdentifier());
                }
            }
            return jobDetail.getJobId();
        }
        catch (Exception e) {
            logger.error("Error while adding job details...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void updateJobDetails(JobDetails jobDetails, CompositeIdentifier ids) throws RegistryException {
        try {
            List errors;
            ApplicationStatus applicationStatus;
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
            String taskId = (String)ids.getTopLevelIdentifier();
            TaskDetailResource taskDetail = workflowNode.getTaskDetail(taskId);
            String jobId = (String)ids.getSecondLevelIdentifier();
            JobDetailResource jobDetail = taskDetail.getJobDetail(jobId);
            jobDetail.setTaskDetailResource(taskDetail);
            jobDetail.setJobDescription(jobDetails.getJobDescription());
            jobDetail.setCreationTime(AiravataUtils.getTime((long)jobDetails.getCreationTime()));
            jobDetail.setComputeResourceConsumed(jobDetails.getComputeResourceConsumed());
            jobDetail.save();
            JobStatus jobStatus = jobDetails.getJobStatus();
            if (jobStatus != null) {
                JobStatus status = this.getJobStatus(ids);
                if (status != null) {
                    this.updateJobStatus(jobStatus, ids);
                } else {
                    this.addJobStatus(jobStatus, ids);
                }
            }
            if ((applicationStatus = jobDetails.getApplicationStatus()) != null) {
                ApplicationStatus appStatus = this.getApplicationStatus(ids);
                if (appStatus != null) {
                    this.updateApplicationStatus(applicationStatus, jobId);
                } else {
                    this.addApplicationStatus(applicationStatus, ids);
                }
            }
            if ((errors = jobDetails.getErrors()) != null && !errors.isEmpty()) {
                for (ErrorDetails error : errors) {
                    this.addErrorDetails(error, jobId);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while updating job details...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public String addDataTransferDetails(DataTransferDetails transferDetails, String taskId) throws RegistryException {
        try {
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
            TaskDetailResource taskDetail = workflowNode.getTaskDetail(taskId);
            DataTransferDetailResource resource = (DataTransferDetailResource)taskDetail.create(ResourceType.DATA_TRANSFER_DETAIL);
            resource.setTaskDetailResource(taskDetail);
            resource.setTransferId(this.getDataTransferID(taskId));
            resource.setTransferDescription(transferDetails.getTransferDescription());
            resource.setCreationTime(AiravataUtils.getTime((long)transferDetails.getCreationTime()));
            resource.save();
            String transferId = resource.getTransferId();
            TransferStatus transferStatus = transferDetails.getTransferStatus();
            if (transferStatus != null) {
                TransferStatus status = this.getDataTransferStatus(transferId);
                if (status != null) {
                    this.updateTransferStatus(transferStatus, transferId);
                } else {
                    CompositeIdentifier ids = new CompositeIdentifier((Object)taskId, (Object)transferId);
                    this.addTransferStatus(transferStatus, ids);
                }
            }
            return resource.getTransferId();
        }
        catch (Exception e) {
            logger.error("Error while adding transfer details...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public String updateDataTransferDetails(DataTransferDetails transferDetails, String transferId) throws RegistryException {
        try {
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
            TaskDetailResource taskDetail = (TaskDetailResource)workflowNode.create(ResourceType.TASK_DETAIL);
            DataTransferDetailResource resource = taskDetail.getDataTransferDetail(transferId);
            resource.setTaskDetailResource(taskDetail);
            resource.setTransferDescription(transferDetails.getTransferDescription());
            resource.setCreationTime(AiravataUtils.getTime((long)transferDetails.getCreationTime()));
            resource.save();
            String taskId = resource.getTaskDetailResource().getTaskId();
            TransferStatus transferStatus = transferDetails.getTransferStatus();
            if (transferStatus != null) {
                TransferStatus status = this.getDataTransferStatus(transferId);
                if (status != null) {
                    this.updateTransferStatus(transferStatus, transferId);
                } else {
                    CompositeIdentifier ids = new CompositeIdentifier((Object)taskId, (Object)transferId);
                    this.addTransferStatus(transferStatus, ids);
                }
            }
            return resource.getTransferId();
        }
        catch (Exception e) {
            logger.error("Error while updating transfer details...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public String addComputationalResourceScheduling(ComputationalResourceScheduling scheduling, CompositeIdentifier ids) throws RegistryException {
        try {
            ExperimentResource experiment = this.gatewayResource.getExperiment((String)ids.getTopLevelIdentifier());
            ComputationSchedulingResource schedulingResource = (ComputationSchedulingResource)experiment.create(ResourceType.COMPUTATIONAL_RESOURCE_SCHEDULING);
            if (ids.getSecondLevelIdentifier() != null) {
                WorkflowNodeDetailResource nodeDetailResource = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
                TaskDetailResource taskDetail = nodeDetailResource.getTaskDetail((String)ids.getSecondLevelIdentifier());
                schedulingResource.setTaskDetailResource(taskDetail);
            }
            schedulingResource.setExperimentResource(experiment);
            schedulingResource.setResourceHostId(scheduling.getResourceHostId());
            schedulingResource.setCpuCount(scheduling.getTotalCPUCount());
            schedulingResource.setNodeCount(scheduling.getNodeCount());
            schedulingResource.setNumberOfThreads(scheduling.getNumberOfThreads());
            schedulingResource.setQueueName(scheduling.getQueueName());
            schedulingResource.setWalltimeLimit(scheduling.getWallTimeLimit());
            schedulingResource.setJobStartTime(AiravataUtils.getTime((long)scheduling.getJobStartTime()));
            schedulingResource.setPhysicalMemory(scheduling.getTotalPhysicalMemory());
            schedulingResource.setProjectName(scheduling.getComputationalProjectAccount());
            schedulingResource.save();
            return String.valueOf(schedulingResource.getSchedulingId());
        }
        catch (Exception e) {
            logger.error("Error while adding scheduling parameters...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public String addInputDataHandling(AdvancedInputDataHandling dataHandling, CompositeIdentifier ids) throws RegistryException {
        try {
            ExperimentResource experiment = this.gatewayResource.getExperiment((String)ids.getTopLevelIdentifier());
            AdvanceInputDataHandlingResource dataHandlingResource = (AdvanceInputDataHandlingResource)experiment.create(ResourceType.ADVANCE_INPUT_DATA_HANDLING);
            if (ids.getSecondLevelIdentifier() != null) {
                WorkflowNodeDetailResource nodeDetailResource = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
                TaskDetailResource taskDetail = nodeDetailResource.getTaskDetail((String)ids.getSecondLevelIdentifier());
                dataHandlingResource.setTaskDetailResource(taskDetail);
            }
            dataHandlingResource.setExperimentResource(experiment);
            dataHandlingResource.setWorkingDir(dataHandling.getUniqueWorkingDirectory());
            dataHandlingResource.setWorkingDirParent(dataHandling.getParentWorkingDirectory());
            dataHandlingResource.setStageInputFiles(dataHandling.isStageInputFilesToWorkingDir());
            dataHandlingResource.setCleanAfterJob(dataHandling.isCleanUpWorkingDirAfterJob());
            dataHandlingResource.save();
            return String.valueOf(dataHandlingResource.getDataHandlingId());
        }
        catch (Exception e) {
            logger.error("Error while adding input data handling...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public String addOutputDataHandling(AdvancedOutputDataHandling dataHandling, CompositeIdentifier ids) throws RegistryException {
        try {
            ExperimentResource experiment = this.gatewayResource.getExperiment((String)ids.getTopLevelIdentifier());
            AdvancedOutputDataHandlingResource dataHandlingResource = (AdvancedOutputDataHandlingResource)experiment.create(ResourceType.ADVANCE_OUTPUT_DATA_HANDLING);
            if (ids.getSecondLevelIdentifier() != null) {
                WorkflowNodeDetailResource nodeDetailResource = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
                TaskDetailResource taskDetail = nodeDetailResource.getTaskDetail((String)ids.getSecondLevelIdentifier());
                dataHandlingResource.setTaskDetailResource(taskDetail);
            }
            dataHandlingResource.setExperimentResource(experiment);
            dataHandlingResource.setOutputDataDir(dataHandling.getOutputDataDir());
            dataHandlingResource.setDataRegUrl(dataHandling.getDataRegistryURL());
            dataHandlingResource.setPersistOutputData(dataHandling.isPersistOutputData());
            dataHandlingResource.save();
            return String.valueOf(dataHandlingResource.getOutputDataHandlingId());
        }
        catch (Exception e) {
            logger.error("Error while adding output data handling...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public String addQosParams(QualityOfServiceParams qosParams, CompositeIdentifier ids) throws RegistryException {
        try {
            ExperimentResource experiment = this.gatewayResource.getExperiment((String)ids.getTopLevelIdentifier());
            QosParamResource qosParamResource = (QosParamResource)experiment.create(ResourceType.QOS_PARAM);
            if (ids.getSecondLevelIdentifier() != null) {
                WorkflowNodeDetailResource nodeDetailResource = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
                TaskDetailResource taskDetail = nodeDetailResource.getTaskDetail((String)ids.getSecondLevelIdentifier());
                qosParamResource.setTaskDetailResource(taskDetail);
            }
            qosParamResource.setExperimentResource(experiment);
            qosParamResource.setStartExecutionAt(qosParams.getStartExecutionAt());
            qosParamResource.setExecuteBefore(qosParams.getExecuteBefore());
            qosParamResource.setNoOfRetries(qosParams.getNumberofRetries());
            qosParamResource.save();
            return String.valueOf(qosParamResource.getQosId());
        }
        catch (Exception e) {
            logger.error("Error while adding QOS params...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public String addErrorDetails(ErrorDetails error, Object id) throws RegistryException {
        try {
            ErrorDetailResource errorResource = null;
            if (id instanceof String) {
                if (this.isTaskDetailExist((String)id)) {
                    ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
                    WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
                    TaskDetailResource taskDetail = workflowNode.getTaskDetail((String)id);
                    errorResource = (ErrorDetailResource)taskDetail.create(ResourceType.ERROR_DETAIL);
                    errorResource.setTaskDetailResource(taskDetail);
                    errorResource.setNodeDetail(taskDetail.getWorkflowNodeDetailResource());
                    errorResource.setExperimentResource(taskDetail.getWorkflowNodeDetailResource().getExperimentResource());
                } else {
                    logger.error("The id provided is not an experiment id or a workflow id or a task id..");
                }
            } else if (id instanceof CompositeIdentifier) {
                CompositeIdentifier cid = (CompositeIdentifier)id;
                if (this.isJobDetailExist(cid)) {
                    ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
                    WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
                    TaskDetailResource taskDetail = workflowNode.getTaskDetail((String)cid.getTopLevelIdentifier());
                    JobDetailResource jobDetail = taskDetail.getJobDetail((String)cid.getSecondLevelIdentifier());
                    errorResource = (ErrorDetailResource)jobDetail.create(ResourceType.ERROR_DETAIL);
                    errorResource.setTaskDetailResource(taskDetail);
                    errorResource.setNodeDetail(taskDetail.getWorkflowNodeDetailResource());
                    errorResource.setExperimentResource(taskDetail.getWorkflowNodeDetailResource().getExperimentResource());
                } else {
                    logger.error("The id provided is not a job in the system..");
                }
            } else {
                logger.error("The id provided is not an experiment id or a workflow id or a task id or a composite identifier for job..");
            }
            if (errorResource != null) {
                errorResource.setCreationTime(AiravataUtils.getTime((long)error.getCreationTime()));
                errorResource.setActualErrorMsg(error.getActualErrorMessage());
                errorResource.setUserFriendlyErrorMsg(error.getUserFriendlyMessage());
                if (error.getErrorCategory() != null) {
                    errorResource.setErrorCategory(error.getErrorCategory().toString());
                }
                errorResource.setTransientPersistent(error.isTransientOrPersistent());
                if (error.getCorrectiveAction() != null) {
                    errorResource.setCorrectiveAction(error.getCorrectiveAction().toString());
                } else {
                    errorResource.setCorrectiveAction(CorrectiveAction.CONTACT_SUPPORT.toString());
                }
                if (error.getActionableGroup() != null) {
                    errorResource.setActionableGroup(error.getActionableGroup().toString());
                } else {
                    errorResource.setActionableGroup(ActionableGroup.GATEWAYS_ADMINS.toString());
                }
                errorResource.save();
                return String.valueOf(errorResource.getErrorId());
            }
        }
        catch (Exception e) {
            logger.error("Unable to add error details...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return null;
    }

    public String getNodeInstanceID(String nodeName) {
        String node = nodeName.replaceAll("\\s", "");
        return node + "_" + UUID.randomUUID();
    }

    public String getExperimentID(String experimentName) {
        String exp = experimentName.replaceAll("\\s", "");
        return exp + "_" + UUID.randomUUID();
    }

    public String getTaskID(String nodeName) {
        String node = nodeName.replaceAll("\\s", "");
        return node + "_" + UUID.randomUUID();
    }

    public String getDataTransferID(String taskId) {
        String task = taskId.replaceAll("\\s", "");
        return task + "_" + UUID.randomUUID();
    }

    public void updateExperimentField(String expID, String fieldName, Object value) throws RegistryException {
        try {
            ExperimentResource experiment = this.gatewayResource.getExperiment(expID);
            if (fieldName.equals("experimentName")) {
                experiment.setExpName((String)value);
                experiment.save();
            } else if (fieldName.equals("userName")) {
                experiment.setExecutionUser((String)value);
                experiment.save();
            } else if (fieldName.equals("experimentDescription")) {
                experiment.setDescription((String)value);
                experiment.save();
            } else if (fieldName.equals("applicationId")) {
                experiment.setApplicationId((String)value);
                experiment.save();
            } else if (fieldName.equals("applicationVersion")) {
                experiment.setApplicationVersion((String)value);
                experiment.save();
            } else if (fieldName.equals("workflowTemplateId")) {
                experiment.setWorkflowTemplateId((String)value);
                experiment.save();
            } else if (fieldName.equals("worklfowTemplateVersion")) {
                experiment.setWorkflowTemplateVersion((String)value);
                experiment.save();
            } else {
                logger.error("Unsupported field type for Experiment");
            }
        }
        catch (Exception e) {
            logger.error("Error while updating fields in experiment...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void updateExpConfigDataField(String expID, String fieldName, Object value) throws RegistryException {
        try {
            ExperimentResource experiment = this.gatewayResource.getExperiment(expID);
            ConfigDataResource exConfigData = (ConfigDataResource)experiment.get(ResourceType.CONFIG_DATA, expID);
            if (fieldName.equals("airavataAutoSchedule")) {
                exConfigData.setAiravataAutoSchedule((Boolean)value);
                exConfigData.save();
            } else if (fieldName.equals("overrideManualScheduledParams")) {
                exConfigData.setOverrideManualParams((Boolean)value);
                exConfigData.save();
            } else if (fieldName.equals("shareExperimentPublicly")) {
                exConfigData.setShareExp((Boolean)value);
                exConfigData.save();
            } else if (fieldName.equals("computationalResourceScheduling")) {
                this.updateSchedulingData((ComputationalResourceScheduling)value, experiment);
            } else if (fieldName.equals("advanceInputDataHandling")) {
                this.updateInputDataHandling((AdvancedInputDataHandling)value, experiment);
            } else if (fieldName.equals("advanceOutputDataHandling")) {
                this.updateOutputDataHandling((AdvancedOutputDataHandling)value, experiment);
            } else if (fieldName.equals("qosParams")) {
                this.updateQosParams((QualityOfServiceParams)value, experiment);
            } else {
                logger.error("Unsupported field type for Experiment config data");
            }
        }
        catch (Exception e) {
            logger.error("Error while updating fields in experiment config...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void updateExperiment(Experiment experiment, String expId) throws RegistryException {
        try {
            List errors;
            List workflowNodeDetailsList;
            ExperimentStatus experimentStatus;
            List experimentOutputs;
            UserConfigurationData userConfigurationData;
            ExperimentResource existingExperiment = this.gatewayResource.getExperiment(expId);
            existingExperiment.setExpName(experiment.getName());
            existingExperiment.setExecutionUser(experiment.getUserName());
            existingExperiment.setGateway(this.gatewayResource);
            if (!this.workerResource.isProjectExists(experiment.getProjectID())) {
                logger.error("Project does not exist in the system..");
                throw new Exception("Project does not exist in the system, Please create the project first...");
            }
            ProjectResource project = this.workerResource.getProject(experiment.getProjectID());
            existingExperiment.setProject(project);
            existingExperiment.setCreationTime(AiravataUtils.getTime((long)experiment.getCreationTime()));
            existingExperiment.setDescription(experiment.getDescription());
            existingExperiment.setApplicationId(experiment.getApplicationId());
            existingExperiment.setApplicationVersion(experiment.getApplicationVersion());
            existingExperiment.setWorkflowTemplateId(experiment.getWorkflowTemplateId());
            existingExperiment.setWorkflowTemplateVersion(experiment.getWorkflowTemplateVersion());
            existingExperiment.setWorkflowExecutionId(experiment.getWorkflowExecutionInstanceId());
            existingExperiment.save();
            List experimentInputs = experiment.getExperimentInputs();
            if (experimentInputs != null && !experimentInputs.isEmpty()) {
                this.updateExpInputs(experimentInputs, existingExperiment);
            }
            if ((userConfigurationData = experiment.getUserConfigurationData()) != null) {
                this.updateUserConfigData(userConfigurationData, expId);
            }
            if ((experimentOutputs = experiment.getExperimentOutputs()) != null && !experimentOutputs.isEmpty()) {
                this.updateExpOutputs(experimentOutputs, expId);
            }
            if ((experimentStatus = experiment.getExperimentStatus()) != null) {
                this.updateExperimentStatus(experimentStatus, expId);
            }
            if ((workflowNodeDetailsList = experiment.getWorkflowNodeDetailsList()) != null && !workflowNodeDetailsList.isEmpty()) {
                for (WorkflowNodeDetails wf : workflowNodeDetailsList) {
                    this.updateWorkflowNodeDetails(wf, wf.getNodeInstanceId());
                }
            }
            if ((errors = experiment.getErrors()) != null && !errors.isEmpty()) {
                for (ErrorDetails errror : errors) {
                    this.addErrorDetails(errror, expId);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while updating experiment...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void updateUserConfigData(UserConfigurationData configData, String expId) throws RegistryException {
        try {
            QualityOfServiceParams qosParams;
            AdvancedOutputDataHandling outputDataHandling;
            AdvancedInputDataHandling inputDataHandling;
            ExperimentResource experiment = this.gatewayResource.getExperiment(expId);
            ConfigDataResource resource = (ConfigDataResource)experiment.get(ResourceType.CONFIG_DATA, expId);
            resource.setExperimentResource(experiment);
            resource.setAiravataAutoSchedule(configData.isAiravataAutoSchedule());
            resource.setOverrideManualParams(configData.isOverrideManualScheduledParams());
            resource.setShareExp(configData.isShareExperimentPublicly());
            resource.save();
            ComputationalResourceScheduling resourceScheduling = configData.getComputationalResourceScheduling();
            if (resourceScheduling != null) {
                this.updateSchedulingData(resourceScheduling, experiment);
            }
            if ((inputDataHandling = configData.getAdvanceInputDataHandling()) != null) {
                this.updateInputDataHandling(inputDataHandling, experiment);
            }
            if ((outputDataHandling = configData.getAdvanceOutputDataHandling()) != null) {
                this.updateOutputDataHandling(outputDataHandling, experiment);
            }
            if ((qosParams = configData.getQosParams()) != null) {
                this.updateQosParams(qosParams, experiment);
            }
        }
        catch (Exception e) {
            logger.error("Error while updating user config data...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void updateQosParams(QualityOfServiceParams qosParams, Resource resource) throws RegistryException {
        try {
            if (resource instanceof ExperimentResource) {
                ExperimentResource expResource = (ExperimentResource)resource;
                QosParamResource qosr = expResource.getQOSparams(expResource.getExpID());
                qosr.setExperimentResource(expResource);
                qosr.setStartExecutionAt(qosParams.getStartExecutionAt());
                qosr.setExecuteBefore(qosParams.getExecuteBefore());
                qosr.setNoOfRetries(qosParams.getNumberofRetries());
                qosr.save();
            }
        }
        catch (Exception e) {
            logger.error("Error while updating QOS data...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void updateOutputDataHandling(AdvancedOutputDataHandling outputDataHandling, Resource resource) throws RegistryException {
        try {
            AdvancedOutputDataHandlingResource adodh;
            if (resource instanceof ExperimentResource) {
                ExperimentResource expResource = (ExperimentResource)resource;
                adodh = expResource.getOutputDataHandling(expResource.getExpID());
                adodh.setExperimentResource(expResource);
            } else {
                TaskDetailResource taskDetailResource = (TaskDetailResource)resource;
                adodh = taskDetailResource.getOutputDataHandling(taskDetailResource.getTaskId());
                adodh.setTaskDetailResource(taskDetailResource);
                adodh.setExperimentResource(taskDetailResource.getWorkflowNodeDetailResource().getExperimentResource());
            }
            adodh.setOutputDataDir(outputDataHandling.getOutputDataDir());
            adodh.setDataRegUrl(outputDataHandling.getDataRegistryURL());
            adodh.setPersistOutputData(outputDataHandling.isPersistOutputData());
            adodh.save();
        }
        catch (Exception e) {
            logger.error("Error while updating output data handling...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void updateInputDataHandling(AdvancedInputDataHandling inputDataHandling, Resource resource) throws RegistryException {
        try {
            AdvanceInputDataHandlingResource adidh;
            if (resource instanceof ExperimentResource) {
                ExperimentResource expResource = (ExperimentResource)resource;
                adidh = expResource.getInputDataHandling(expResource.getExpID());
                adidh.setExperimentResource(expResource);
            } else {
                TaskDetailResource taskDetailResource = (TaskDetailResource)resource;
                adidh = taskDetailResource.getInputDataHandling(taskDetailResource.getTaskId());
                adidh.setTaskDetailResource(taskDetailResource);
                adidh.setExperimentResource(taskDetailResource.getWorkflowNodeDetailResource().getExperimentResource());
            }
            adidh.setWorkingDir(inputDataHandling.getUniqueWorkingDirectory());
            adidh.setWorkingDirParent(inputDataHandling.getParentWorkingDirectory());
            adidh.setStageInputFiles(inputDataHandling.isSetStageInputFilesToWorkingDir());
            adidh.setCleanAfterJob(inputDataHandling.isCleanUpWorkingDirAfterJob());
            adidh.save();
        }
        catch (Exception e) {
            logger.error("Error while updating input data handling...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void updateSchedulingData(ComputationalResourceScheduling resourceScheduling, Resource resource) throws RegistryException {
        try {
            ComputationSchedulingResource cmsr;
            if (resource instanceof ExperimentResource) {
                ExperimentResource expResource = (ExperimentResource)resource;
                cmsr = expResource.getComputationScheduling(expResource.getExpID());
                cmsr.setExperimentResource(expResource);
            } else {
                TaskDetailResource taskDetailResource = (TaskDetailResource)resource;
                cmsr = taskDetailResource.getComputationScheduling(taskDetailResource.getTaskId());
                cmsr.setTaskDetailResource(taskDetailResource);
                cmsr.setExperimentResource(taskDetailResource.getWorkflowNodeDetailResource().getExperimentResource());
            }
            cmsr.setResourceHostId(resourceScheduling.getResourceHostId());
            cmsr.setCpuCount(resourceScheduling.getTotalCPUCount());
            cmsr.setNodeCount(resourceScheduling.getNodeCount());
            cmsr.setNumberOfThreads(resourceScheduling.getNumberOfThreads());
            cmsr.setQueueName(resourceScheduling.getQueueName());
            cmsr.setWalltimeLimit(resourceScheduling.getWallTimeLimit());
            cmsr.setJobStartTime(AiravataUtils.getTime((long)resourceScheduling.getJobStartTime()));
            cmsr.setPhysicalMemory(resourceScheduling.getTotalPhysicalMemory());
            cmsr.setProjectName(resourceScheduling.getComputationalProjectAccount());
            cmsr.save();
        }
        catch (Exception e) {
            logger.error("Error while updating scheduling data...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public List<Experiment> getExperimentList(String fieldName, Object value) throws RegistryException {
        ArrayList<Experiment> experiments = new ArrayList<Experiment>();
        try {
            if (fieldName.equals("userName")) {
                WorkerResource resource = (WorkerResource)this.gatewayResource.create(ResourceType.GATEWAY_WORKER);
                resource.setUser((String)value);
                List<ExperimentResource> resources = resource.getExperiments();
                for (ExperimentResource experimentResource : resources) {
                    Experiment experiment = ThriftDataModelConversion.getExperiment(experimentResource);
                    experiments.add(experiment);
                }
                return experiments;
            }
            if (fieldName.equals("projectId")) {
                ProjectResource project = this.workerResource.getProject((String)value);
                List<ExperimentResource> resources = project.getExperiments();
                for (ExperimentResource resource : resources) {
                    Experiment experiment = ThriftDataModelConversion.getExperiment(resource);
                    experiments.add(experiment);
                }
                return experiments;
            }
            if (fieldName.equals("gateway")) {
                List<ExperimentResource> resources = this.gatewayResource.getExperiments();
                for (ExperimentResource resource : resources) {
                    Experiment experiment = ThriftDataModelConversion.getExperiment(resource);
                    experiments.add(experiment);
                }
                return experiments;
            }
            logger.error("Unsupported field name to retrieve experiment list...");
        }
        catch (Exception e) {
            logger.error("Error while getting experiment list...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return experiments;
    }

    public List<WorkflowNodeDetails> getWFNodeDetails(String fieldName, Object value) throws RegistryException {
        try {
            if (fieldName.equals("experimentId")) {
                ExperimentResource experiment = this.gatewayResource.getExperiment((String)value);
                List<WorkflowNodeDetailResource> workflowNodeDetails = experiment.getWorkflowNodeDetails();
                return ThriftDataModelConversion.getWfNodeList(workflowNodeDetails);
            }
            logger.error("Unsupported field name to retrieve workflow detail list...");
        }
        catch (Exception e) {
            logger.error("Error while getting workfkow details...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return null;
    }

    public List<WorkflowNodeStatus> getWFNodeStatusList(String fieldName, Object value) throws RegistryException {
        try {
            if (fieldName.equals("experimentId")) {
                ExperimentResource experiment = this.gatewayResource.getExperiment((String)value);
                List<StatusResource> workflowNodeStatuses = experiment.getWorkflowNodeStatuses();
                return ThriftDataModelConversion.getWorkflowNodeStatusList(workflowNodeStatuses);
            }
            logger.error("Unsupported field name to retrieve workflow status list...");
        }
        catch (Exception e) {
            logger.error("Error while getting workflow status...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return null;
    }

    public List<TaskDetails> getTaskDetails(String fieldName, Object value) throws RegistryException {
        try {
            if (fieldName.equals("nodeId")) {
                ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
                WorkflowNodeDetailResource workflowNode = experiment.getWorkflowNode((String)value);
                List<TaskDetailResource> taskDetails = workflowNode.getTaskDetails();
                return ThriftDataModelConversion.getTaskDetailsList(taskDetails);
            }
            logger.error("Unsupported field name to retrieve task detail list...");
        }
        catch (Exception e) {
            logger.error("Error while getting task details...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return null;
    }

    public List<JobDetails> getJobDetails(String fieldName, Object value) throws RegistryException {
        try {
            if (fieldName.equals("taskId")) {
                ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
                WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
                TaskDetailResource taskDetail = workflowNode.getTaskDetail((String)value);
                List<JobDetailResource> jobDetailList = taskDetail.getJobDetailList();
                return ThriftDataModelConversion.getJobDetailsList(jobDetailList);
            }
            logger.error("Unsupported field name to retrieve job details list...");
        }
        catch (Exception e) {
            logger.error("Error while job details...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return null;
    }

    public List<DataTransferDetails> getDataTransferDetails(String fieldName, Object value) throws RegistryException {
        try {
            if (fieldName.equals("taskId")) {
                ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
                WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
                TaskDetailResource taskDetail = workflowNode.getTaskDetail((String)value);
                List<DataTransferDetailResource> dataTransferDetailList = taskDetail.getDataTransferDetailList();
                return ThriftDataModelConversion.getDataTransferlList(dataTransferDetailList);
            }
            logger.error("Unsupported field name to retrieve job details list...");
        }
        catch (Exception e) {
            logger.error("Error while getting data transfer details...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return null;
    }

    public List<ErrorDetails> getErrorDetails(String fieldName, Object value) throws RegistryException {
        try {
            if (fieldName.equals("experimentId")) {
                ExperimentResource experiment = this.gatewayResource.getExperiment((String)value);
                List<ErrorDetailResource> errorDetails = experiment.getErrorDetails();
                return ThriftDataModelConversion.getErrorDetailList(errorDetails);
            }
            if (fieldName.equals("nodeId")) {
                ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
                WorkflowNodeDetailResource workflowNode = experiment.getWorkflowNode((String)value);
                List<ErrorDetailResource> errorDetails = workflowNode.getErrorDetails();
                return ThriftDataModelConversion.getErrorDetailList(errorDetails);
            }
            if (fieldName.equals("taskId")) {
                ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
                WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
                TaskDetailResource taskDetail = workflowNode.getTaskDetail((String)value);
                List<ErrorDetailResource> errorDetailList = taskDetail.getErrorDetailList();
                return ThriftDataModelConversion.getErrorDetailList(errorDetailList);
            }
            if (fieldName.equals("jobId")) {
                CompositeIdentifier cid = (CompositeIdentifier)value;
                ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
                WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
                TaskDetailResource taskDetail = workflowNode.getTaskDetail((String)cid.getTopLevelIdentifier());
                JobDetailResource jobDetail = taskDetail.getJobDetail((String)cid.getSecondLevelIdentifier());
                List<ErrorDetailResource> errorDetails = jobDetail.getErrorDetails();
                return ThriftDataModelConversion.getErrorDetailList(errorDetails);
            }
            logger.error("Unsupported field name to retrieve job details list...");
        }
        catch (Exception e) {
            logger.error("Unable to get error details...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return null;
    }

    public Object getExperiment(String expId, String fieldName) throws RegistryException {
        try {
            ExperimentResource resource = this.gatewayResource.getExperiment(expId);
            if (fieldName == null) {
                return ThriftDataModelConversion.getExperiment(resource);
            }
            if (fieldName.equals("userName")) {
                return resource.getExecutionUser();
            }
            if (fieldName.equals("experimentName")) {
                return resource.getExpName();
            }
            if (fieldName.equals("experimentDescription")) {
                return resource.getDescription();
            }
            if (fieldName.equals("applicationId")) {
                return resource.getApplicationId();
            }
            if (fieldName.equals("projectId")) {
                return resource.getProject().getId();
            }
            if (fieldName.equals("applicationVersion")) {
                return resource.getApplicationVersion();
            }
            if (fieldName.equals("workflowTemplateId")) {
                return resource.getWorkflowTemplateId();
            }
            if (fieldName.equals("worklfowTemplateVersion")) {
                return resource.getWorkflowTemplateId();
            }
            if (fieldName.equals("experimentInputs")) {
                return ThriftDataModelConversion.getExpInputs(resource.getExperimentInputs());
            }
            if (fieldName.equals("experimentOutputs")) {
                return ThriftDataModelConversion.getExpOutputs(resource.getExperimentOutputs());
            }
            if (fieldName.equals("experimentStatus")) {
                return ThriftDataModelConversion.getExperimentStatus(resource.getExperimentStatus());
            }
            if (fieldName.equals("userConfigurationData")) {
                return ThriftDataModelConversion.getUserConfigData(resource.getUserConfigData(expId));
            }
            if (fieldName.equals("workflowExecutionInstanceId")) {
                return resource.getWorkflowExecutionId();
            }
            if (fieldName.equals("stateChangeList")) {
                return ThriftDataModelConversion.getWorkflowNodeStatusList(resource.getWorkflowNodeStatuses());
            }
            if (fieldName.equals("workflowNodeDetailsList")) {
                return ThriftDataModelConversion.getWfNodeList(resource.getWorkflowNodeDetails());
            }
            if (fieldName.equals("errors")) {
                return ThriftDataModelConversion.getErrorDetailList(resource.getErrorDetails());
            }
            logger.error("Unsupported field name for experiment basic data..");
        }
        catch (Exception e) {
            logger.error("Error while getting experiment info...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return null;
    }

    public Object getConfigData(String expId, String fieldName) throws RegistryException {
        try {
            ExperimentResource resource = this.gatewayResource.getExperiment(expId);
            ConfigDataResource userConfigData = resource.getUserConfigData(expId);
            if (fieldName == null) {
                return ThriftDataModelConversion.getUserConfigData(userConfigData);
            }
            if (fieldName.equals("airavataAutoSchedule")) {
                return userConfigData.isAiravataAutoSchedule();
            }
            if (fieldName.equals("overrideManualScheduledParams")) {
                return userConfigData.isOverrideManualParams();
            }
            if (fieldName.equals("shareExperimentPublicly")) {
                return userConfigData.isShareExp();
            }
            if (fieldName.equals("computationalResourceScheduling")) {
                return ThriftDataModelConversion.getComputationalResourceScheduling(resource.getComputationScheduling(expId));
            }
            if (fieldName.equals("advanceInputDataHandling")) {
                return ThriftDataModelConversion.getAdvanceInputDataHandling(resource.getInputDataHandling(expId));
            }
            if (fieldName.equals("advanceOutputDataHandling")) {
                return ThriftDataModelConversion.getAdvanceOutputDataHandling(resource.getOutputDataHandling(expId));
            }
            if (fieldName.equals("qosParams")) {
                return ThriftDataModelConversion.getQOSParams(resource.getQOSparams(expId));
            }
            logger.error("Unsupported field name for experiment configuration data..");
        }
        catch (Exception e) {
            logger.error("Error while getting config data..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return null;
    }

    public List<DataObjectType> getExperimentOutputs(String expId) throws RegistryException {
        try {
            ExperimentResource resource = this.gatewayResource.getExperiment(expId);
            List<ExperimentOutputResource> experimentOutputs = resource.getExperimentOutputs();
            return ThriftDataModelConversion.getExpOutputs(experimentOutputs);
        }
        catch (Exception e) {
            logger.error("Error while getting experiment outputs...", (Throwable)e);
            return null;
        }
    }

    public ExperimentStatus getExperimentStatus(String expId) throws RegistryException {
        try {
            ExperimentResource resource = this.gatewayResource.getExperiment(expId);
            StatusResource experimentStatus = resource.getExperimentStatus();
            return ThriftDataModelConversion.getExperimentStatus(experimentStatus);
        }
        catch (Exception e) {
            logger.error("Error while getting experiment status...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public ComputationalResourceScheduling getComputationalScheduling(RegistryModelType type, String id) throws RegistryException {
        try {
            ComputationSchedulingResource computationScheduling = null;
            switch (type) {
                case EXPERIMENT: {
                    ExperimentResource resource = this.gatewayResource.getExperiment(id);
                    computationScheduling = resource.getComputationScheduling(id);
                    break;
                }
                case TASK_DETAIL: {
                    ExperimentResource exp = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
                    WorkflowNodeDetailResource wf = (WorkflowNodeDetailResource)exp.create(ResourceType.WORKFLOW_NODE_DETAIL);
                    TaskDetailResource taskDetail = wf.getTaskDetail(id);
                    computationScheduling = taskDetail.getComputationScheduling(id);
                }
            }
            if (computationScheduling != null) {
                return ThriftDataModelConversion.getComputationalResourceScheduling(computationScheduling);
            }
        }
        catch (Exception e) {
            logger.error("Error while getting scheduling data..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return null;
    }

    public AdvancedInputDataHandling getInputDataHandling(RegistryModelType type, String id) throws RegistryException {
        try {
            AdvanceInputDataHandlingResource dataHandlingResource = null;
            switch (type) {
                case EXPERIMENT: {
                    ExperimentResource resource = this.gatewayResource.getExperiment(id);
                    dataHandlingResource = resource.getInputDataHandling(id);
                    break;
                }
                case TASK_DETAIL: {
                    ExperimentResource exp = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
                    WorkflowNodeDetailResource wf = (WorkflowNodeDetailResource)exp.create(ResourceType.WORKFLOW_NODE_DETAIL);
                    TaskDetailResource taskDetail = wf.getTaskDetail(id);
                    dataHandlingResource = taskDetail.getInputDataHandling(id);
                }
            }
            if (dataHandlingResource != null) {
                return ThriftDataModelConversion.getAdvanceInputDataHandling(dataHandlingResource);
            }
        }
        catch (Exception e) {
            logger.error("Error while getting input data handling..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return null;
    }

    public AdvancedOutputDataHandling getOutputDataHandling(RegistryModelType type, String id) throws RegistryException {
        try {
            AdvancedOutputDataHandlingResource dataHandlingResource = null;
            switch (type) {
                case EXPERIMENT: {
                    ExperimentResource resource = this.gatewayResource.getExperiment(id);
                    dataHandlingResource = resource.getOutputDataHandling(id);
                    break;
                }
                case TASK_DETAIL: {
                    ExperimentResource exp = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
                    WorkflowNodeDetailResource wf = (WorkflowNodeDetailResource)exp.create(ResourceType.WORKFLOW_NODE_DETAIL);
                    TaskDetailResource taskDetail = wf.getTaskDetail(id);
                    dataHandlingResource = taskDetail.getOutputDataHandling(id);
                }
            }
            if (dataHandlingResource != null) {
                return ThriftDataModelConversion.getAdvanceOutputDataHandling(dataHandlingResource);
            }
        }
        catch (Exception e) {
            logger.error("Error while getting output data handling...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return null;
    }

    public QualityOfServiceParams getQosParams(RegistryModelType type, String id) throws RegistryException {
        try {
            QosParamResource qosParamResource = null;
            switch (type) {
                case EXPERIMENT: {
                    ExperimentResource resource = this.gatewayResource.getExperiment(id);
                    qosParamResource = resource.getQOSparams(id);
                }
            }
            if (qosParamResource != null) {
                return ThriftDataModelConversion.getQOSParams(qosParamResource);
            }
        }
        catch (Exception e) {
            logger.error("Error while getting qos params..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return null;
    }

    public WorkflowNodeDetails getWorkflowNodeDetails(String nodeId) throws RegistryException {
        try {
            ExperimentResource resource = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = resource.getWorkflowNode(nodeId);
            return ThriftDataModelConversion.getWorkflowNodeDetails(workflowNode);
        }
        catch (Exception e) {
            logger.error("Error while getting workflow node details...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public WorkflowNodeStatus getWorkflowNodeStatus(String nodeId) throws RegistryException {
        try {
            ExperimentResource resource = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = resource.getWorkflowNode(nodeId);
            StatusResource workflowNodeStatus = workflowNode.getWorkflowNodeStatus();
            return ThriftDataModelConversion.getWorkflowNodeStatus(workflowNodeStatus);
        }
        catch (Exception e) {
            logger.error("Error while getting workflow node status..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public List<DataObjectType> getNodeOutputs(String nodeId) throws RegistryException {
        try {
            ExperimentResource resource = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = resource.getWorkflowNode(nodeId);
            List<NodeOutputResource> nodeOutputs = workflowNode.getNodeOutputs();
            return ThriftDataModelConversion.getNodeOutputs(nodeOutputs);
        }
        catch (Exception e) {
            logger.error("Error while getting node outputs..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public TaskDetails getTaskDetails(String taskId) throws RegistryException {
        try {
            ExperimentResource resource = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)resource.create(ResourceType.WORKFLOW_NODE_DETAIL);
            TaskDetailResource taskDetail = workflowNode.getTaskDetail(taskId);
            return ThriftDataModelConversion.getTaskDetail(taskDetail);
        }
        catch (Exception e) {
            logger.error("Error while getting task details..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public List<DataObjectType> getApplicationOutputs(String taskId) throws RegistryException {
        try {
            ExperimentResource resource = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)resource.create(ResourceType.WORKFLOW_NODE_DETAIL);
            TaskDetailResource taskDetail = workflowNode.getTaskDetail(taskId);
            List<ApplicationOutputResource> applicationOutputs = taskDetail.getApplicationOutputs();
            return ThriftDataModelConversion.getApplicationOutputs(applicationOutputs);
        }
        catch (Exception e) {
            logger.error("Error while getting application outputs..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public TaskStatus getTaskStatus(String taskId) throws RegistryException {
        try {
            ExperimentResource resource = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)resource.create(ResourceType.WORKFLOW_NODE_DETAIL);
            TaskDetailResource taskDetail = workflowNode.getTaskDetail(taskId);
            StatusResource taskStatus = taskDetail.getTaskStatus();
            return ThriftDataModelConversion.getTaskStatus(taskStatus);
        }
        catch (Exception e) {
            logger.error("Error while getting experiment outputs..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public JobDetails getJobDetails(CompositeIdentifier ids) throws RegistryException {
        try {
            ExperimentResource resource = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)resource.create(ResourceType.WORKFLOW_NODE_DETAIL);
            TaskDetailResource taskDetail = workflowNode.getTaskDetail((String)ids.getTopLevelIdentifier());
            JobDetailResource jobDetail = taskDetail.getJobDetail((String)ids.getSecondLevelIdentifier());
            return ThriftDataModelConversion.getJobDetail(jobDetail);
        }
        catch (Exception e) {
            logger.error("Error while getting job details..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public JobStatus getJobStatus(CompositeIdentifier ids) throws RegistryException {
        try {
            ExperimentResource resource = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)resource.create(ResourceType.WORKFLOW_NODE_DETAIL);
            TaskDetailResource taskDetail = workflowNode.getTaskDetail((String)ids.getTopLevelIdentifier());
            JobDetailResource jobDetail = taskDetail.getJobDetail((String)ids.getSecondLevelIdentifier());
            StatusResource jobStatus = jobDetail.getJobStatus();
            return ThriftDataModelConversion.getJobStatus(jobStatus);
        }
        catch (Exception e) {
            logger.error("Error while getting job status..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public ApplicationStatus getApplicationStatus(CompositeIdentifier ids) throws RegistryException {
        try {
            ExperimentResource resource = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)resource.create(ResourceType.WORKFLOW_NODE_DETAIL);
            TaskDetailResource taskDetail = workflowNode.getTaskDetail((String)ids.getTopLevelIdentifier());
            JobDetailResource jobDetail = taskDetail.getJobDetail((String)ids.getSecondLevelIdentifier());
            StatusResource applicationStatus = jobDetail.getApplicationStatus();
            return ThriftDataModelConversion.getApplicationStatus(applicationStatus);
        }
        catch (Exception e) {
            logger.error("Error while getting application status..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public DataTransferDetails getDataTransferDetails(String transferId) throws RegistryException {
        try {
            ExperimentResource resource = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)resource.create(ResourceType.WORKFLOW_NODE_DETAIL);
            TaskDetailResource taskDetail = (TaskDetailResource)workflowNode.create(ResourceType.TASK_DETAIL);
            DataTransferDetailResource dataTransferDetail = taskDetail.getDataTransferDetail(transferId);
            return ThriftDataModelConversion.getDataTransferDetail(dataTransferDetail);
        }
        catch (Exception e) {
            logger.error("Error while getting data transfer details..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public TransferStatus getDataTransferStatus(String transferId) throws RegistryException {
        try {
            ExperimentResource resource = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)resource.create(ResourceType.WORKFLOW_NODE_DETAIL);
            TaskDetailResource taskDetail = (TaskDetailResource)workflowNode.create(ResourceType.TASK_DETAIL);
            DataTransferDetailResource dataTransferDetail = taskDetail.getDataTransferDetail(transferId);
            StatusResource dataTransferStatus = dataTransferDetail.getDataTransferStatus();
            return ThriftDataModelConversion.getTransferStatus(dataTransferStatus);
        }
        catch (Exception e) {
            logger.error("Error while getting data transfer status..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public List<String> getExperimentIDs(String fieldName, Object value) throws RegistryException {
        ArrayList<String> expIDs = new ArrayList<String>();
        try {
            if (fieldName.equals("gateway")) {
                if (this.gatewayResource == null) {
                    logger.error("You should use an existing gateway in order to retrieve experiments..");
                    return null;
                }
                List<ExperimentResource> resources = this.gatewayResource.getExperiments();
                for (ExperimentResource resource : resources) {
                    String expID = resource.getExpID();
                    expIDs.add(expID);
                }
            } else if (fieldName.equals("userName")) {
                List<ExperimentResource> resources = this.workerResource.getExperiments();
                for (ExperimentResource resource : resources) {
                    expIDs.add(resource.getExpID());
                }
            } else if (fieldName.equals("projectId")) {
                List<ExperimentResource> resources = this.workerResource.getExperiments();
                for (ExperimentResource resource : resources) {
                    expIDs.add(resource.getExpID());
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving experiment ids..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return expIDs;
    }

    public List<String> getWorkflowNodeIds(String fieldName, Object value) throws RegistryException {
        ArrayList<String> wfIds = new ArrayList<String>();
        List<WorkflowNodeDetails> wfNodeDetails = this.getWFNodeDetails(fieldName, value);
        for (WorkflowNodeDetails wf : wfNodeDetails) {
            wfIds.add(wf.getNodeInstanceId());
        }
        return wfIds;
    }

    public List<String> getTaskDetailIds(String fieldName, Object value) throws RegistryException {
        ArrayList<String> taskDetailIds = new ArrayList<String>();
        List<TaskDetails> taskDetails = this.getTaskDetails(fieldName, value);
        for (TaskDetails td : taskDetails) {
            taskDetailIds.add(td.getTaskID());
        }
        return taskDetailIds;
    }

    public List<String> getJobDetailIds(String fieldName, Object value) throws RegistryException {
        ArrayList<String> jobIds = new ArrayList<String>();
        List<JobDetails> jobDetails = this.getJobDetails(fieldName, value);
        for (JobDetails jd : jobDetails) {
            jobIds.add(jd.getJobID());
        }
        return jobIds;
    }

    public List<String> getTransferDetailIds(String fieldName, Object value) throws RegistryException {
        ArrayList<String> transferIds = new ArrayList<String>();
        List<DataTransferDetails> dataTransferDetails = this.getDataTransferDetails(fieldName, value);
        for (DataTransferDetails dtd : dataTransferDetails) {
            transferIds.add(dtd.getTransferID());
        }
        return transferIds;
    }

    public void removeExperiment(String experimentId) throws RegistryException {
        try {
            this.gatewayResource.remove(ResourceType.EXPERIMENT, experimentId);
        }
        catch (Exception e) {
            logger.error("Error while removing experiment..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void removeExperimentConfigData(String experimentId) throws RegistryException {
        try {
            ExperimentResource experiment = this.gatewayResource.getExperiment(experimentId);
            experiment.remove(ResourceType.CONFIG_DATA, experimentId);
        }
        catch (Exception e) {
            logger.error("Error while removing experiment config..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void removeWorkflowNode(String nodeId) throws RegistryException {
        try {
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            experiment.remove(ResourceType.WORKFLOW_NODE_DETAIL, nodeId);
        }
        catch (Exception e) {
            logger.error("Error while removing workflow node..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void removeTaskDetails(String taskId) throws RegistryException {
        try {
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource nodeDetailResource = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
            nodeDetailResource.remove(ResourceType.TASK_DETAIL, taskId);
        }
        catch (Exception e) {
            logger.error("Error while removing task details..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void removeJobDetails(CompositeIdentifier ids) throws RegistryException {
        try {
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource nodeDetailResource = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
            TaskDetailResource taskDetailResource = nodeDetailResource.getTaskDetail((String)ids.getTopLevelIdentifier());
            taskDetailResource.remove(ResourceType.JOB_DETAIL, (String)ids.getSecondLevelIdentifier());
        }
        catch (Exception e) {
            logger.error("Error while removing job details..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void removeDataTransferDetails(String transferId) throws RegistryException {
        try {
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource nodeDetailResource = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
            TaskDetailResource taskDetail = (TaskDetailResource)nodeDetailResource.create(ResourceType.TASK_DETAIL);
            taskDetail.remove(ResourceType.DATA_TRANSFER_DETAIL, transferId);
        }
        catch (Exception e) {
            logger.error("Error while removing transfer details..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void removeComputationalScheduling(RegistryModelType dataType, String id) throws RegistryException {
        try {
            switch (dataType) {
                case EXPERIMENT: {
                    ExperimentResource experiment = this.gatewayResource.getExperiment(id);
                    experiment.remove(ResourceType.COMPUTATIONAL_RESOURCE_SCHEDULING, id);
                    break;
                }
                case TASK_DETAIL: {
                    ExperimentResource resource = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
                    WorkflowNodeDetailResource wf = (WorkflowNodeDetailResource)resource.create(ResourceType.WORKFLOW_NODE_DETAIL);
                    TaskDetailResource taskDetail = wf.getTaskDetail(id);
                    taskDetail.remove(ResourceType.COMPUTATIONAL_RESOURCE_SCHEDULING, id);
                    break;
                }
                default: {
                    logger.error("Unsupported data type...");
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while removing scheduling data..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void removeInputDataHandling(RegistryModelType dataType, String id) throws RegistryException {
        try {
            switch (dataType) {
                case EXPERIMENT: {
                    ExperimentResource experiment = this.gatewayResource.getExperiment(id);
                    experiment.remove(ResourceType.ADVANCE_INPUT_DATA_HANDLING, id);
                    break;
                }
                case TASK_DETAIL: {
                    ExperimentResource resource = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
                    WorkflowNodeDetailResource wf = (WorkflowNodeDetailResource)resource.create(ResourceType.WORKFLOW_NODE_DETAIL);
                    TaskDetailResource taskDetail = wf.getTaskDetail(id);
                    taskDetail.remove(ResourceType.ADVANCE_INPUT_DATA_HANDLING, id);
                    break;
                }
                default: {
                    logger.error("Unsupported data type...");
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while removing input data handling..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void removeOutputDataHandling(RegistryModelType dataType, String id) throws RegistryException {
        try {
            switch (dataType) {
                case EXPERIMENT: {
                    ExperimentResource experiment = this.gatewayResource.getExperiment(id);
                    experiment.remove(ResourceType.ADVANCE_OUTPUT_DATA_HANDLING, id);
                    break;
                }
                case TASK_DETAIL: {
                    ExperimentResource resource = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
                    WorkflowNodeDetailResource wf = (WorkflowNodeDetailResource)resource.create(ResourceType.WORKFLOW_NODE_DETAIL);
                    TaskDetailResource taskDetail = wf.getTaskDetail(id);
                    taskDetail.remove(ResourceType.ADVANCE_OUTPUT_DATA_HANDLING, id);
                    break;
                }
                default: {
                    logger.error("Unsupported data type...");
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while removing output data handling..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void removeQOSParams(RegistryModelType dataType, String id) throws RegistryException {
        try {
            switch (dataType) {
                case EXPERIMENT: {
                    ExperimentResource experiment = this.gatewayResource.getExperiment(id);
                    experiment.remove(ResourceType.QOS_PARAM, id);
                    break;
                }
                default: {
                    logger.error("Unsupported data type...");
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while removing QOS params", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public boolean isExperimentExist(String expID) throws RegistryException {
        try {
            return this.gatewayResource.isExists(ResourceType.EXPERIMENT, expID);
        }
        catch (Exception e) {
            logger.error("Error while retrieving experiment...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public boolean isExperimentConfigDataExist(String expID) throws RegistryException {
        try {
            ExperimentResource experiment = this.gatewayResource.getExperiment(expID);
            experiment.isExists(ResourceType.CONFIG_DATA, expID);
            return true;
        }
        catch (Exception e) {
            logger.error("Error while retrieving experiment...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public boolean isWFNodeExist(String nodeId) throws RegistryException {
        try {
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            return experiment.isExists(ResourceType.WORKFLOW_NODE_DETAIL, nodeId);
        }
        catch (Exception e) {
            logger.error("Error while retrieving workflow...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public boolean isTaskDetailExist(String taskId) throws RegistryException {
        try {
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource wf = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
            return wf.isExists(ResourceType.TASK_DETAIL, taskId);
        }
        catch (Exception e) {
            logger.error("Error while retrieving task.....", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public boolean isJobDetailExist(CompositeIdentifier ids) throws RegistryException {
        try {
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource wf = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
            TaskDetailResource taskDetail = wf.getTaskDetail((String)ids.getTopLevelIdentifier());
            return taskDetail.isExists(ResourceType.JOB_DETAIL, (String)ids.getSecondLevelIdentifier());
        }
        catch (Exception e) {
            logger.error("Error while retrieving job details.....", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public boolean isTransferDetailExist(String transferId) throws RegistryException {
        try {
            ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
            WorkflowNodeDetailResource wf = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
            TaskDetailResource taskDetail = (TaskDetailResource)wf.create(ResourceType.TASK_DETAIL);
            return taskDetail.isExists(ResourceType.DATA_TRANSFER_DETAIL, transferId);
        }
        catch (Exception e) {
            logger.error("Error while retrieving transfer details.....", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public boolean isComputationalSchedulingExist(RegistryModelType dataType, String id) throws RegistryException {
        try {
            switch (dataType) {
                case EXPERIMENT: {
                    ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
                    return experiment.isExists(ResourceType.COMPUTATIONAL_RESOURCE_SCHEDULING, id);
                }
                case TASK_DETAIL: {
                    ExperimentResource exp = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
                    WorkflowNodeDetailResource wf = (WorkflowNodeDetailResource)exp.create(ResourceType.WORKFLOW_NODE_DETAIL);
                    TaskDetailResource taskDetail = wf.getTaskDetail(id);
                    return taskDetail.isExists(ResourceType.COMPUTATIONAL_RESOURCE_SCHEDULING, id);
                }
            }
            logger.error("Unsupported data type...");
        }
        catch (Exception e) {
            logger.error("Error while retrieving scheduling data.....", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return false;
    }

    public boolean isInputDataHandlingExist(RegistryModelType dataType, String id) throws RegistryException {
        try {
            switch (dataType) {
                case EXPERIMENT: {
                    ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
                    return experiment.isExists(ResourceType.ADVANCE_INPUT_DATA_HANDLING, id);
                }
                case TASK_DETAIL: {
                    ExperimentResource exp = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
                    WorkflowNodeDetailResource wf = (WorkflowNodeDetailResource)exp.create(ResourceType.WORKFLOW_NODE_DETAIL);
                    TaskDetailResource taskDetail = wf.getTaskDetail(id);
                    return taskDetail.isExists(ResourceType.ADVANCE_INPUT_DATA_HANDLING, id);
                }
            }
            logger.error("Unsupported data type...");
        }
        catch (Exception e) {
            logger.error("Error while retrieving input data handling.....", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return false;
    }

    public boolean isOutputDataHandlingExist(RegistryModelType dataType, String id) throws RegistryException {
        try {
            switch (dataType) {
                case EXPERIMENT: {
                    ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
                    return experiment.isExists(ResourceType.ADVANCE_OUTPUT_DATA_HANDLING, id);
                }
                case TASK_DETAIL: {
                    ExperimentResource exp = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
                    WorkflowNodeDetailResource wf = (WorkflowNodeDetailResource)exp.create(ResourceType.WORKFLOW_NODE_DETAIL);
                    TaskDetailResource taskDetail = wf.getTaskDetail(id);
                    return taskDetail.isExists(ResourceType.ADVANCE_OUTPUT_DATA_HANDLING, id);
                }
            }
            logger.error("Unsupported data type...");
        }
        catch (Exception e) {
            logger.error("Error while retrieving output data handling..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return false;
    }

    public boolean isQOSParamsExist(RegistryModelType dataType, String id) throws RegistryException {
        try {
            switch (dataType) {
                case EXPERIMENT: {
                    ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
                    return experiment.isExists(ResourceType.QOS_PARAM, id);
                }
            }
            logger.error("Unsupported data type...");
        }
        catch (Exception e) {
            logger.error("Error while retrieving qos params..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return false;
    }

    public void updateScheduling(ComputationalResourceScheduling scheduling, String id, String type) throws RegistryException {
        try {
            if (type.equals(RegistryModelType.EXPERIMENT.toString())) {
                ExperimentResource experiment = this.gatewayResource.getExperiment(id);
                this.updateSchedulingData(scheduling, experiment);
            } else if (type.equals(RegistryModelType.TASK_DETAIL.toString())) {
                ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
                WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
                TaskDetailResource taskDetail = workflowNode.getTaskDetail(id);
                this.updateSchedulingData(scheduling, taskDetail);
            }
        }
        catch (Exception e) {
            logger.error("Error while updating scheduling..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void updateInputDataHandling(AdvancedInputDataHandling dataHandling, String id, String type) throws RegistryException {
        try {
            if (type.equals(RegistryModelType.EXPERIMENT.toString())) {
                ExperimentResource experiment = this.gatewayResource.getExperiment(id);
                this.updateInputDataHandling(dataHandling, experiment);
            } else if (type.equals(RegistryModelType.TASK_DETAIL.toString())) {
                ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
                WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
                TaskDetailResource taskDetail = workflowNode.getTaskDetail(id);
                this.updateInputDataHandling(dataHandling, taskDetail);
            }
        }
        catch (Exception e) {
            logger.error("Error while updating input data handling..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void updateOutputDataHandling(AdvancedOutputDataHandling dataHandling, String id, String type) throws RegistryException {
        try {
            if (type.equals(RegistryModelType.EXPERIMENT.toString())) {
                ExperimentResource experiment = this.gatewayResource.getExperiment(id);
                this.updateOutputDataHandling(dataHandling, experiment);
            } else if (type.equals(RegistryModelType.TASK_DETAIL.toString())) {
                ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
                WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
                TaskDetailResource taskDetail = workflowNode.getTaskDetail(id);
                this.updateOutputDataHandling(dataHandling, taskDetail);
            }
        }
        catch (Exception e) {
            logger.error("Error while updating output data handling", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public void updateQOSParams(QualityOfServiceParams params, String id, String type) throws RegistryException {
        try {
            if (type.equals(RegistryModelType.EXPERIMENT.toString())) {
                ExperimentResource experiment = this.gatewayResource.getExperiment(id);
                this.updateQosParams(params, experiment);
            } else if (type.equals(RegistryModelType.TASK_DETAIL.toString())) {
                ExperimentResource experiment = (ExperimentResource)this.gatewayResource.create(ResourceType.EXPERIMENT);
                WorkflowNodeDetailResource workflowNode = (WorkflowNodeDetailResource)experiment.create(ResourceType.WORKFLOW_NODE_DETAIL);
                TaskDetailResource taskDetail = workflowNode.getTaskDetail(id);
                this.updateQosParams(params, taskDetail);
            }
        }
        catch (Exception e) {
            logger.error("Error while updating QOS data..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public List<ExperimentSummary> searchExperiments(Map<String, String> filters) throws RegistryException {
        HashMap<String, String> fil = new HashMap<String, String>();
        if (filters != null && filters.size() != 0) {
            ArrayList<ExperimentSummary> experimentSummaries = new ArrayList<ExperimentSummary>();
            try {
                for (String field : filters.keySet()) {
                    if (field.equals("experimentName")) {
                        fil.put("expName", filters.get(field));
                        continue;
                    }
                    if (field.equals("userName")) {
                        fil.put("executionUser", filters.get(field));
                        continue;
                    }
                    if (field.equals("experimentDescription")) {
                        fil.put("expDesc", filters.get(field));
                        continue;
                    }
                    if (!field.equals("applicationId")) continue;
                    fil.put("applicationId", filters.get(field));
                }
                List<ExperimentResource> experimentResources = this.workerResource.searchExperiments(fil);
                if (experimentResources != null && !experimentResources.isEmpty()) {
                    for (ExperimentResource ex : experimentResources) {
                        experimentSummaries.add(ThriftDataModelConversion.getExperimentSummary(ex));
                    }
                }
                return experimentSummaries;
            }
            catch (Exception e) {
                logger.error("Error while retrieving experiment summary from registry", (Throwable)e);
                throw new RegistryException((Throwable)e);
            }
        }
        return null;
    }
}

