/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.model.workspace.Project;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.resources.GatewayResource;
import org.apache.airavata.persistance.registry.jpa.resources.ProjectResource;
import org.apache.airavata.persistance.registry.jpa.resources.ProjectUserResource;
import org.apache.airavata.persistance.registry.jpa.resources.UserResource;
import org.apache.airavata.persistance.registry.jpa.resources.WorkerResource;
import org.apache.airavata.persistance.registry.jpa.utils.ThriftDataModelConversion;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectRegistry {
    private GatewayResource gatewayResource;
    private WorkerResource workerResource;
    private static final Logger logger = LoggerFactory.getLogger(ProjectRegistry.class);

    public ProjectRegistry(GatewayResource gatewayResource, UserResource user) throws RegistryException {
        this.gatewayResource = !ResourceUtils.isGatewayExist(gatewayResource.getGatewayName()) ? gatewayResource : (GatewayResource)ResourceUtils.getGateway(gatewayResource.getGatewayName());
        this.workerResource = !gatewayResource.isExists(ResourceType.GATEWAY_WORKER, user.getUserName()) ? ResourceUtils.addGatewayWorker(gatewayResource, user) : (WorkerResource)ResourceUtils.getWorker(gatewayResource.getGatewayName(), user.getUserName());
    }

    public String addProject(Project project) throws RegistryException {
        String projectId;
        try {
            List sharedUsers;
            if (!ResourceUtils.isUserExist(project.getOwner())) {
                ResourceUtils.addUser(project.getOwner(), null);
            }
            ProjectResource projectResource = new ProjectResource();
            projectId = this.getProjectId(project.getName());
            projectResource.setId(projectId);
            project.setProjectID(projectId);
            projectResource.setName(project.getName());
            projectResource.setDescription(project.getDescription());
            projectResource.setCreationTime(AiravataUtils.getTime((long)project.getCreationTime()));
            projectResource.setGateway(this.workerResource.getGateway());
            WorkerResource worker = new WorkerResource(project.getOwner(), this.workerResource.getGateway());
            projectResource.setWorker(worker);
            projectResource.save();
            ProjectUserResource resource = (ProjectUserResource)projectResource.create(ResourceType.PROJECT_USER);
            resource.setProjectId(project.getProjectID());
            resource.setUserName(project.getOwner());
            resource.save();
            List sharedGroups = project.getSharedGroups();
            if (sharedGroups != null && !sharedGroups.isEmpty()) {
                for (String group : sharedGroups) {
                    logger.info("Groups are not supported at the moment...");
                }
            }
            if ((sharedUsers = project.getSharedUsers()) != null && !sharedUsers.isEmpty()) {
                for (String username : sharedUsers) {
                    ProjectUserResource pr = (ProjectUserResource)projectResource.create(ResourceType.PROJECT_USER);
                    pr.setUserName(username);
                    pr.save();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while saving project to registry", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return projectId;
    }

    private String getProjectId(String projectName) {
        String pro = projectName.replaceAll("\\s", "");
        return pro + "_" + UUID.randomUUID();
    }

    public void updateProject(Project project, String projectId) throws RegistryException {
        try {
            List sharedUsers;
            ProjectResource existingProject = this.workerResource.getProject(projectId);
            existingProject.setDescription(project.getDescription());
            existingProject.setCreationTime(AiravataUtils.getTime((long)project.getCreationTime()));
            existingProject.setGateway(this.gatewayResource);
            UserResource user = (UserResource)ResourceUtils.getUser(project.getOwner());
            this.workerResource = !this.gatewayResource.isExists(ResourceType.GATEWAY_WORKER, user.getUserName()) ? ResourceUtils.addGatewayWorker(this.gatewayResource, user) : (WorkerResource)ResourceUtils.getWorker(this.gatewayResource.getGatewayName(), user.getUserName());
            WorkerResource worker = new WorkerResource(project.getOwner(), this.gatewayResource);
            existingProject.setWorker(worker);
            existingProject.save();
            ProjectUserResource resource = (ProjectUserResource)existingProject.create(ResourceType.PROJECT_USER);
            resource.setProjectId(projectId);
            resource.setUserName(project.getOwner());
            resource.save();
            List sharedGroups = project.getSharedGroups();
            if (sharedGroups != null && !sharedGroups.isEmpty()) {
                for (String group : sharedGroups) {
                    logger.info("Groups are not supported at the moment...");
                }
            }
            if ((sharedUsers = project.getSharedUsers()) != null && !sharedUsers.isEmpty()) {
                for (String username : sharedUsers) {
                    ProjectUserResource pr = (ProjectUserResource)existingProject.create(ResourceType.PROJECT_USER);
                    pr.setUserName(username);
                    pr.save();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while saving project to registry", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public Project getProject(String projectId) throws RegistryException {
        try {
            ProjectResource project = this.workerResource.getProject(projectId);
            if (project != null) {
                return ThriftDataModelConversion.getProject(project);
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving project from registry", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return null;
    }

    public List<Project> getProjectList(String fieldName, Object value) throws RegistryException {
        ArrayList<Project> projects = new ArrayList<Project>();
        try {
            if (fieldName.equals("owner")) {
                this.workerResource.setUser((String)value);
                List<ProjectResource> projectList = this.workerResource.getProjects();
                if (projectList != null && !projectList.isEmpty()) {
                    for (ProjectResource pr : projectList) {
                        projects.add(ThriftDataModelConversion.getProject(pr));
                    }
                }
                return projects;
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving project from registry", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return projects;
    }

    public List<Project> searchProjects(Map<String, String> filters) throws RegistryException {
        HashMap<String, String> fil = new HashMap<String, String>();
        if (filters != null && filters.size() != 0) {
            ArrayList<Project> projects = new ArrayList<Project>();
            try {
                for (String field : filters.keySet()) {
                    if (field.equals("name")) {
                        fil.put("project_name", filters.get(field));
                        continue;
                    }
                    if (field.equals("owner")) {
                        fil.put("user_name", filters.get(field));
                        continue;
                    }
                    if (!field.equals("description")) continue;
                    fil.put("description", filters.get(field));
                }
                List<ProjectResource> projectResources = this.workerResource.searchProjects(fil);
                if (projectResources != null && !projectResources.isEmpty()) {
                    for (ProjectResource pr : projectResources) {
                        projects.add(ThriftDataModelConversion.getProject(pr));
                    }
                }
                return projects;
            }
            catch (Exception e) {
                logger.error("Error while retrieving project from registry", (Throwable)e);
                throw new RegistryException((Throwable)e);
            }
        }
        return null;
    }

    public List<String> getProjectIDs(String fieldName, Object value) throws RegistryException {
        ArrayList<String> projectIds = new ArrayList<String>();
        try {
            if (fieldName.equals("owner")) {
                this.workerResource.setUser((String)value);
                List<ProjectResource> projectList = this.workerResource.getProjects();
                if (projectList != null && !projectList.isEmpty()) {
                    for (ProjectResource pr : projectList) {
                        projectIds.add(pr.getName());
                    }
                }
                return projectIds;
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving projects from registry", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return projectIds;
    }

    public void removeProject(String projectId) throws RegistryException {
        try {
            this.workerResource.removeProject(projectId);
        }
        catch (Exception e) {
            logger.error("Error while removing the project..", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }

    public boolean isProjectExist(String projectId) throws RegistryException {
        try {
            return this.workerResource.isProjectExists(projectId);
        }
        catch (Exception e) {
            logger.error("Error while retrieving project...", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
    }
}

