/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Application_Descriptor;
import org.apache.airavata.persistance.registry.jpa.model.Application_Descriptor_PK;
import org.apache.airavata.persistance.registry.jpa.model.Gateway;
import org.apache.airavata.persistance.registry.jpa.model.Users;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationDescriptorResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationDescriptorResource.class);
    private String name;
    private String gatewayName;
    private String updatedUser;
    private String content;
    private String hostDescName;
    private String serviceDescName;

    public ApplicationDescriptorResource(String name, String gatewayName) {
        this.setName(name);
        this.gatewayName = gatewayName;
    }

    public ApplicationDescriptorResource() {
    }

    public String getGatewayName() {
        return this.gatewayName;
    }

    public void setGatewayName(String gatewayName) {
        this.gatewayName = gatewayName;
    }

    public void setUpdatedUser(String updatedUser) {
        this.updatedUser = updatedUser;
    }

    public String getName() {
        return this.name;
    }

    public String getContent() {
        return this.content;
    }

    public String getHostDescName() {
        return this.hostDescName;
    }

    public String getServiceDescName() {
        return this.serviceDescName;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setHostDescName(String hostDescName) {
        this.hostDescName = hostDescName;
    }

    public void setServiceDescName(String serviceDescName) {
        this.serviceDescName = serviceDescName;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported operation for application descriptor resource since application descriptors could not create child resources.. ", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported operation for application descriptor resource since application descriptors could not remove child resources.. ", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported operation for application descriptor resource since there are no child resources generated by application descriptors.. ", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported operation for application descriptor resource since there are no child resources generated by application descriptors.. ", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            Application_Descriptor existingAppDesc = (Application_Descriptor)em.find(Application_Descriptor.class, (Object)new Application_Descriptor_PK(this.gatewayName, this.name));
            em.close();
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Application_Descriptor applicationDescriptor = new Application_Descriptor();
            applicationDescriptor.setApplication_descriptor_ID(this.getName());
            Gateway gateway = (Gateway)em.find(Gateway.class, (Object)this.gatewayName);
            Users user = (Users)em.find(Users.class, (Object)this.updatedUser);
            applicationDescriptor.setGateway(gateway);
            applicationDescriptor.setGateway_name(gateway.getGateway_name());
            applicationDescriptor.setUser(user);
            byte[] contentBytes = this.content.getBytes();
            applicationDescriptor.setApplication_descriptor_xml(contentBytes);
            applicationDescriptor.setService_descriptor_ID(this.serviceDescName);
            applicationDescriptor.setHost_descriptor_ID(this.hostDescName);
            if (existingAppDesc != null) {
                existingAppDesc.setUser(user);
                existingAppDesc.setGateway(gateway);
                existingAppDesc.setGateway_name(gateway.getGateway_name());
                existingAppDesc.setApplication_descriptor_xml(contentBytes);
                existingAppDesc.setHost_descriptor_ID(this.hostDescName);
                existingAppDesc.setService_descriptor_ID(this.serviceDescName);
                applicationDescriptor = (Application_Descriptor)em.merge((Object)existingAppDesc);
            } else {
                em.persist((Object)applicationDescriptor);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported operation for application descriptor resource since there are no child resources generated by application descriptors.. ", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    public void setName(String name) {
        this.name = name;
    }
}

