/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.ApplicationOutput;
import org.apache.airavata.persistance.registry.jpa.model.ApplicationOutput_PK;
import org.apache.airavata.persistance.registry.jpa.model.TaskDetail;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.TaskDetailResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationOutputResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationOutputResource.class);
    private TaskDetailResource taskDetailResource;
    private String outputKey;
    private String outputType;
    private String metadata;
    private String value;

    public String getOutputKey() {
        return this.outputKey;
    }

    public void setOutputKey(String outputKey) {
        this.outputKey = outputKey;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public TaskDetailResource getTaskDetailResource() {
        return this.taskDetailResource;
    }

    public void setTaskDetailResource(TaskDetailResource taskDetailResource) {
        this.taskDetailResource = taskDetailResource;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for application output data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for application output data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for application output data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for application output data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            ApplicationOutput existingOutput = (ApplicationOutput)em.find(ApplicationOutput.class, (Object)new ApplicationOutput_PK(this.outputKey, this.taskDetailResource.getTaskId()));
            em.close();
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            ApplicationOutput applicationOutput = new ApplicationOutput();
            TaskDetail taskDetail = (TaskDetail)em.find(TaskDetail.class, (Object)this.taskDetailResource.getTaskId());
            applicationOutput.setTask(taskDetail);
            applicationOutput.setTaskId(taskDetail.getTaskId());
            applicationOutput.setOutputKey(this.outputKey);
            applicationOutput.setOutputKeyType(this.outputType);
            applicationOutput.setValue(this.value);
            applicationOutput.setMetadata(this.metadata);
            if (existingOutput != null) {
                existingOutput.setTask(taskDetail);
                existingOutput.setTaskId(taskDetail.getTaskId());
                existingOutput.setOutputKey(this.outputKey);
                existingOutput.setOutputKeyType(this.outputType);
                existingOutput.setValue(this.value);
                existingOutput.setMetadata(this.metadata);
                applicationOutput = (ApplicationOutput)em.merge((Object)existingOutput);
            } else {
                em.persist((Object)applicationOutput);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException(e.getMessage());
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

