/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.sql.Timestamp;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Computational_Resource_Scheduling;
import org.apache.airavata.persistance.registry.jpa.model.Experiment;
import org.apache.airavata.persistance.registry.jpa.model.TaskDetail;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentResource;
import org.apache.airavata.persistance.registry.jpa.resources.TaskDetailResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputationSchedulingResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ComputationSchedulingResource.class);
    private int schedulingId = 0;
    private ExperimentResource experimentResource;
    private TaskDetailResource taskDetailResource;
    private String resourceHostId;
    private int cpuCount;
    private int nodeCount;
    private int numberOfThreads;
    private String queueName;
    private int walltimeLimit;
    private Timestamp jobStartTime;
    private int physicalMemory;
    private String projectName;

    public int getSchedulingId() {
        return this.schedulingId;
    }

    public void setSchedulingId(int schedulingId) {
        this.schedulingId = schedulingId;
    }

    public ExperimentResource getExperimentResource() {
        return this.experimentResource;
    }

    public void setExperimentResource(ExperimentResource experimentResource) {
        this.experimentResource = experimentResource;
    }

    public TaskDetailResource getTaskDetailResource() {
        return this.taskDetailResource;
    }

    public void setTaskDetailResource(TaskDetailResource taskDetailResource) {
        this.taskDetailResource = taskDetailResource;
    }

    public String getResourceHostId() {
        return this.resourceHostId;
    }

    public void setResourceHostId(String resourceHostId) {
        this.resourceHostId = resourceHostId;
    }

    public int getCpuCount() {
        return this.cpuCount;
    }

    public void setCpuCount(int cpuCount) {
        this.cpuCount = cpuCount;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public void setNodeCount(int nodeCount) {
        this.nodeCount = nodeCount;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setNumberOfThreads(int numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public int getWalltimeLimit() {
        return this.walltimeLimit;
    }

    public void setWalltimeLimit(int walltimeLimit) {
        this.walltimeLimit = walltimeLimit;
    }

    public Timestamp getJobStartTime() {
        return this.jobStartTime;
    }

    public void setJobStartTime(Timestamp jobStartTime) {
        this.jobStartTime = jobStartTime;
    }

    public int getPhysicalMemory() {
        return this.physicalMemory;
    }

    public void setPhysicalMemory(int physicalMemory) {
        this.physicalMemory = physicalMemory;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for computational scheduling resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for computational scheduling resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for computational scheduling resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for computational scheduling resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            Computational_Resource_Scheduling scheduling;
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            if (this.schedulingId != 0) {
                scheduling = (Computational_Resource_Scheduling)em.find(Computational_Resource_Scheduling.class, (Object)this.schedulingId);
                scheduling.setSchedulingId(this.schedulingId);
            } else {
                scheduling = new Computational_Resource_Scheduling();
            }
            Experiment experiment = (Experiment)em.find(Experiment.class, (Object)this.experimentResource.getExpID());
            if (this.taskDetailResource != null) {
                TaskDetail taskDetail = (TaskDetail)em.find(TaskDetail.class, (Object)this.taskDetailResource.getTaskId());
                scheduling.setTask(taskDetail);
                scheduling.setTaskId(this.taskDetailResource.getTaskId());
            }
            scheduling.setExpId(this.experimentResource.getExpID());
            scheduling.setExperiment(experiment);
            scheduling.setResourceHostId(this.resourceHostId);
            scheduling.setCpuCount(this.cpuCount);
            scheduling.setNodeCount(this.nodeCount);
            scheduling.setNumberOfThreads(this.numberOfThreads);
            scheduling.setQueueName(this.queueName);
            scheduling.setWallTimeLimit(this.walltimeLimit);
            scheduling.setJobStartTime(this.jobStartTime);
            scheduling.setTotalPhysicalmemory(this.physicalMemory);
            scheduling.setProjectName(this.projectName);
            em.persist((Object)scheduling);
            this.schedulingId = scheduling.getSchedulingId();
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

