/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.airavata.persistance.registry.jpa.resources.Utils;
import org.apache.airavata.registry.api.exception.worker.ExperimentLazyLoadedException;
import org.apache.airavata.registry.api.impl.ExperimentDataImpl;
import org.apache.airavata.registry.api.impl.WorkflowExecutionDataImpl;
import org.apache.airavata.registry.api.workflow.ExperimentData;
import org.apache.airavata.registry.api.workflow.NodeExecutionData;
import org.apache.airavata.registry.api.workflow.WorkflowExecution;
import org.apache.airavata.registry.api.workflow.WorkflowExecutionStatus;
import org.apache.airavata.registry.api.workflow.WorkflowInstanceNode;
import org.apache.airavata.registry.api.workflow.WorkflowNodeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentDataRetriever {
    private static final Logger logger = LoggerFactory.getLogger(ExperimentDataRetriever.class);

    public ExperimentData getExperiment(String experimentId) {
        String connectionURL = Utils.getJDBCURL();
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<WorkflowExecution> experimentWorkflowInstances = new ArrayList<WorkflowExecution>();
        ExperimentDataImpl experimentData = null;
        try {
            Class.forName(Utils.getJDBCDriver()).newInstance();
            connection = DriverManager.getConnection(connectionURL, Utils.getJDBCUser(), Utils.getJDBCPassword());
            Statement statement = connection.createStatement();
            String queryString = "SELECT e.EXPERIMENT_ID, e.EXPERIMENT_NAME, e.EXECUTION_USER, e.DESCRIPTION, wd.WORKFLOW_INSTANCE_ID, wd.TEMPLATE_NAME, wd.STATUS, wd.START_TIME,wd.LAST_UPDATE_TIME, nd.NODE_ID, nd.INPUTS, nd.OUTPUTS, e.PROJECT_NAME, e.SUBMITTED_DATE, nd.NODE_TYPE, nd.STATUS,nd.START_TIME, nd.LAST_UPDATE_TIME FROM EXPERIMENT_METADATA e LEFT JOIN WORKFLOW_DATA wd ON e.EXPERIMENT_ID = wd.EXPERIMENT_ID LEFT JOIN NODE_DATA nd ON wd.WORKFLOW_INSTANCE_ID = nd.WORKFLOW_INSTANCE_ID WHERE e.EXPERIMENT_ID ='" + experimentId + "'";
            rs = statement.executeQuery(queryString);
            if (rs != null) {
                while (rs.next()) {
                    if (experimentData == null) {
                        experimentData = new ExperimentDataImpl();
                        experimentData.setExperimentId(rs.getString(1));
                        experimentData.setExperimentName(rs.getString(2));
                        experimentData.setUser(rs.getString(3));
                        experimentData.setTopic(rs.getString(1));
                    }
                    this.fillWorkflowInstanceData((ExperimentData)experimentData, rs, experimentWorkflowInstances);
                }
            }
            if (rs != null) {
                rs.close();
            }
            statement.close();
            connection.close();
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ExperimentLazyLoadedException e) {
            logger.error(e.getMessage());
        }
        return experimentData;
    }

    private void fillWorkflowInstanceData(ExperimentData experimentData, ResultSet rs, List<WorkflowExecution> workflowInstances) throws SQLException, ExperimentLazyLoadedException, ParseException {
        WorkflowExecutionDataImpl workflowInstanceData = (WorkflowExecutionDataImpl)experimentData.getWorkflowExecutionData(rs.getString(5));
        if (workflowInstanceData == null) {
            WorkflowExecution workflowInstance = new WorkflowExecution(experimentData.getExperimentId(), rs.getString(5));
            workflowInstance.setTemplateName(rs.getString(6));
            workflowInstance.setExperimentId(rs.getString(1));
            workflowInstance.setWorkflowExecutionId(rs.getString(5));
            workflowInstances.add(workflowInstance);
            Date lastUpdateDate = this.getTime(rs.getString(9));
            String wdStatus = rs.getString(7);
            WorkflowExecutionStatus workflowExecutionStatus = new WorkflowExecutionStatus(workflowInstance, this.createExecutionStatus(wdStatus), lastUpdateDate);
            workflowInstanceData = new WorkflowExecutionDataImpl(null, workflowInstance, workflowExecutionStatus, null);
            ExperimentDataImpl expData = (ExperimentDataImpl)experimentData;
            workflowInstanceData.setExperimentData(expData);
            if (expData.getExecutionStatus() != null) {
                if (expData.getExecutionStatus().getStatusUpdateTime().compareTo(workflowExecutionStatus.getStatusUpdateTime()) < 0) {
                    expData.setExecutionStatus(workflowExecutionStatus);
                }
            } else {
                expData.setExecutionStatus(workflowExecutionStatus);
            }
            experimentData.getWorkflowExecutionDataList().add(workflowInstanceData);
        }
        WorkflowInstanceNode workflowInstanceNode = new WorkflowInstanceNode(workflowInstanceData.getWorkflowExecution(), rs.getString(10));
        NodeExecutionData workflowInstanceNodeData = new NodeExecutionData(workflowInstanceNode);
        String inputData = this.getStringValue(11, rs);
        String outputData = this.getStringValue(12, rs);
        workflowInstanceNodeData.setInput(inputData);
        workflowInstanceNodeData.setOutput(outputData);
        workflowInstanceNodeData.setStatus(this.createExecutionStatus(rs.getString(16)), this.getTime(rs.getString(18)));
        workflowInstanceNodeData.setType(WorkflowNodeType.getType((String)rs.getString(15)).getNodeType());
        workflowInstanceData.getNodeDataList().add(workflowInstanceNodeData);
    }

    private WorkflowExecutionStatus.State createExecutionStatus(String status) {
        return status == null ? WorkflowExecutionStatus.State.UNKNOWN : WorkflowExecutionStatus.State.valueOf((String)status);
    }

    private String getStringValue(int parameterNumber, ResultSet rs) throws SQLException {
        Blob input = rs.getBlob(parameterNumber);
        if (input != null) {
            byte[] inputBytes = input.getBytes(1L, (int)input.length());
            String inputData = new String(inputBytes);
            return inputData;
        }
        return null;
    }

    private Date getTime(String date) throws ParseException {
        if (date != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return dateFormat.parse(date);
        }
        return null;
    }

    public List<String> getExperimentIdByUser(String user) {
        ArrayList<String> result = new ArrayList<String>();
        String connectionURL = Utils.getJDBCURL();
        Connection connection = null;
        ResultSet rs = null;
        Statement statement = null;
        try {
            String jdbcDriver = Utils.getJDBCDriver();
            Class.forName(jdbcDriver).newInstance();
            connection = DriverManager.getConnection(connectionURL, Utils.getJDBCUser(), Utils.getJDBCPassword());
            statement = connection.createStatement();
            String queryString = "SELECT e.EXPERIMENT_ID FROM EXPERIMENT_METADATA e WHERE e.EXECUTION_USER ='" + user + "'";
            rs = statement.executeQuery(queryString);
            if (rs != null) {
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
            if (rs != null) {
                rs.close();
            }
            statement.close();
            connection.close();
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public String getExperimentName(String experimentId) {
        String connectionURL = Utils.getJDBCURL();
        try {
            Class.forName(Utils.getJDBCDriver()).newInstance();
            Connection connection = DriverManager.getConnection(connectionURL, Utils.getJDBCUser(), Utils.getJDBCPassword());
            Statement statement = connection.createStatement();
            String queryString = "SELECT e.name FROM EXPERIMENT_METADATA e WHERE e.EXPERIMENT_ID='" + experimentId + "'";
            ResultSet rs = statement.executeQuery(queryString);
            if (rs != null && rs.next()) {
                return rs.getString(1);
            }
            if (rs != null) {
                rs.close();
            }
            statement.close();
            connection.close();
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public List<ExperimentData> getExperiments(String user) {
        String connectionURL = Utils.getJDBCURL();
        Connection connection = null;
        ResultSet rs = null;
        HashMap<String, ExperimentDataImpl> experimentDataMap = new HashMap<String, ExperimentDataImpl>();
        ArrayList<ExperimentData> experimentDataList = new ArrayList<ExperimentData>();
        ArrayList<WorkflowExecution> experimentWorkflowInstances = new ArrayList<WorkflowExecution>();
        try {
            Class.forName(Utils.getJDBCDriver()).newInstance();
            connection = DriverManager.getConnection(connectionURL, Utils.getJDBCUser(), Utils.getJDBCPassword());
            Statement statement = connection.createStatement();
            String queryString = "SELECT e.EXPERIMENT_ID, e.EXPERIMENT_NAME, e.EXECUTION_USER, e.DESCRIPTION, wd.WORKFLOW_INSTANCE_ID, wd.TEMPLATE_NAME, wd.STATUS, wd.START_TIME,wd.LAST_UPDATE_TIME, nd.NODE_ID, nd.INPUTS, nd.OUTPUTS, e.PROJECT_NAME, e.SUBMITTED_DATE, nd.NODE_TYPE, nd.STATUS, nd.START_TIME, nd.LAST_UPDATE_TIME FROM EXPERIMENT_METADATA e LEFT JOIN WORKFLOW_DATA wd ON e.EXPERIMENT_ID = wd.EXPERIMENT_ID LEFT JOIN NODE_DATA nd ON wd.WORKFLOW_INSTANCE_ID = nd.WORKFLOW_INSTANCE_ID WHERE e.EXECUTION_USER='" + user + "'";
            rs = statement.executeQuery(queryString);
            if (rs != null) {
                while (rs.next()) {
                    ExperimentDataImpl experimentData = null;
                    if (experimentDataMap.containsKey(rs.getString(1))) {
                        experimentData = (ExperimentData)experimentDataMap.get(rs.getString(1));
                    } else {
                        experimentData = new ExperimentDataImpl();
                        experimentData.setExperimentId(rs.getString(1));
                        experimentData.setExperimentName(rs.getString(2));
                        experimentData.setUser(rs.getString(3));
                        experimentData.setTopic(rs.getString(1));
                        experimentDataMap.put(experimentData.getExperimentId(), experimentData);
                        experimentDataList.add((ExperimentData)experimentData);
                    }
                    this.fillWorkflowInstanceData((ExperimentData)experimentData, rs, experimentWorkflowInstances);
                }
            }
            if (rs != null) {
                rs.close();
            }
            statement.close();
            connection.close();
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ExperimentLazyLoadedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return experimentDataList;
    }

    public List<ExperimentData> getExperiments(HashMap<String, String> params) {
        String connectionURL = Utils.getJDBCURL();
        Connection connection = null;
        ResultSet rs = null;
        HashMap<String, ExperimentDataImpl> experimentDataMap = new HashMap<String, ExperimentDataImpl>();
        ArrayList<ExperimentData> experimentDataList = new ArrayList<ExperimentData>();
        ArrayList<WorkflowExecution> experimentWorkflowInstances = new ArrayList<WorkflowExecution>();
        try {
            Class.forName(Utils.getJDBCDriver()).newInstance();
            connection = DriverManager.getConnection(connectionURL, Utils.getJDBCUser(), Utils.getJDBCPassword());
            Statement statement = connection.createStatement();
            String queryString = "SELECT e.EXPERIMENT_ID, e.EXPERIMENT_NAME, e.EXECUTION_USER, e.DESCRIPTION, wd.WORKFLOW_INSTANCE_ID, wd.TEMPLATE_NAME, wd.STATUS, wd.START_TIME,wd.LAST_UPDATE_TIME, nd.NODE_ID, nd.INPUTS, nd.OUTPUTS, e.PROJECT_NAME, e.SUBMITTED_DATE, nd.NODE_TYPE, nd.STATUS, nd.START_TIME, nd.LAST_UPDATE_TIME FROM EXPERIMENT_METADATA e LEFT JOIN WORKFLOW_DATA wd ON e.EXPERIMENT_ID = wd.EXPERIMENT_ID LEFT JOIN NODE_DATA nd ON wd.WORKFLOW_INSTANCE_ID = nd.WORKFLOW_INSTANCE_ID ";
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (params.keySet().size() > 0) {
                queryString = queryString + "WHERE ";
                String username = params.get("username");
                String from = params.get("fromDate");
                String to = params.get("toDate");
                if (username != null && !username.isEmpty()) {
                    queryString = queryString + "ed.username='" + username + "'";
                    if (from != null && !from.isEmpty() || to != null && !to.isEmpty()) {
                        queryString = queryString + " AND ";
                    }
                }
                if (from != null && !from.isEmpty()) {
                    Date fromDate = dateFormat.parse(from);
                    Timestamp fromTime = new Timestamp(fromDate.getTime());
                    queryString = queryString + "e.submitted_date>='" + fromTime + "'";
                    if (to != null && !to.equals("")) {
                        queryString = queryString + " AND ";
                    }
                }
                if (to != null && !to.isEmpty()) {
                    Date toDate = dateFormat.parse(to);
                    Timestamp toTime = new Timestamp(toDate.getTime());
                    queryString = queryString + "e.submitted_date<='" + toTime + "'";
                }
            }
            if ((rs = statement.executeQuery(queryString)) != null) {
                while (rs.next()) {
                    ExperimentDataImpl experimentData = null;
                    if (experimentDataMap.containsKey(rs.getString(1))) {
                        experimentData = (ExperimentData)experimentDataMap.get(rs.getString(1));
                    } else {
                        experimentData = new ExperimentDataImpl();
                        experimentData.setExperimentId(rs.getString(1));
                        experimentData.setExperimentName(rs.getString(2));
                        experimentData.setUser(rs.getString(3));
                        experimentData.setTopic(rs.getString(1));
                        experimentDataMap.put(experimentData.getExperimentId(), experimentData);
                        experimentDataList.add((ExperimentData)experimentData);
                    }
                    this.fillWorkflowInstanceData((ExperimentData)experimentData, rs, experimentWorkflowInstances);
                }
            }
            if (rs != null) {
                rs.close();
            }
            statement.close();
            connection.close();
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ExperimentLazyLoadedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return experimentDataList;
    }

    public ExperimentData getExperimentMetaInformation(String experimentId) {
        String connectionURL = Utils.getJDBCURL();
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<WorkflowExecution> experimentWorkflowInstances = new ArrayList<WorkflowExecution>();
        ExperimentDataImpl experimentData = null;
        try {
            Class.forName(Utils.getJDBCDriver()).newInstance();
            connection = DriverManager.getConnection(connectionURL, Utils.getJDBCUser(), Utils.getJDBCPassword());
            Statement statement = connection.createStatement();
            String queryString = "SELECT e.EXPERIMENT_ID, e.EXPERIMENT_NAME, e.EXECUTION_USER, e.PROJECT_NAME, e.SUBMITTED_DATE, wd.WORKFLOW_INSTANCE_ID FROM EXPERIMENT_METADATA e LEFT JOIN WORKFLOW_DATA wd ON e.EXPERIMENT_ID = wd.EXPERIMENT_ID WHERE e.EXPERIMENT_ID ='" + experimentId + "'";
            rs = statement.executeQuery(queryString);
            if (rs != null) {
                while (rs.next()) {
                    experimentData = new ExperimentDataImpl(true);
                    experimentData.setExperimentId(rs.getString(1));
                    experimentData.setExperimentName(rs.getString(2));
                    experimentData.setUser(rs.getString(3));
                    experimentData.setTopic(rs.getString(1));
                    WorkflowExecution workflowInstance = new WorkflowExecution(experimentId, rs.getString(6));
                    workflowInstance.setTemplateName(rs.getString(6));
                    workflowInstance.setExperimentId(rs.getString(1));
                    workflowInstance.setWorkflowExecutionId(rs.getString(6));
                    experimentWorkflowInstances.add(workflowInstance);
                }
            }
            if (rs != null) {
                rs.close();
            }
            statement.close();
            connection.close();
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return experimentData;
    }

    public boolean isExperimentNameExist(String experimentName) {
        String connectionURL = Utils.getJDBCURL();
        Connection connection = null;
        ResultSet rs = null;
        try {
            Class.forName(Utils.getJDBCDriver()).newInstance();
            connection = DriverManager.getConnection(connectionURL, Utils.getJDBCUser(), Utils.getJDBCPassword());
            Statement statement = connection.createStatement();
            String queryString = "SELECT EXPERIMENT_NAME FROM EXPERIMENT_METADATA WHERE EXPERIMENT_NAME='" + experimentName + "'";
            rs = statement.executeQuery(queryString);
            if (rs != null && rs.next()) {
                return true;
            }
            if (rs != null) {
                rs.close();
            }
            statement.close();
            connection.close();
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public List<ExperimentData> getAllExperimentMetaInformation(String user) {
        String connectionURL = Utils.getJDBCURL();
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<ExperimentData> experimentDataList = new ArrayList<ExperimentData>();
        ArrayList<WorkflowExecution> experimentWorkflowInstances = new ArrayList<WorkflowExecution>();
        ExperimentDataImpl experimentData = null;
        try {
            Class.forName(Utils.getJDBCDriver()).newInstance();
            connection = DriverManager.getConnection(connectionURL, Utils.getJDBCUser(), Utils.getJDBCPassword());
            Statement statement = connection.createStatement();
            String queryString = "SELECT e.EXPERIMENT_ID, e.EXPERIMENT_NAME, e.EXECUTION_USER,  e.PROJECT_NAME, e.SUBMITTED_DATE FROM EXPERIMENT_METADATA e WHERE e.EXECUTION_USER ='" + user + "'" + " ORDER BY e.SUBMITTED_DATE ASC";
            rs = statement.executeQuery(queryString);
            if (rs != null) {
                while (rs.next()) {
                    experimentData = new ExperimentDataImpl(true);
                    experimentData.setExperimentId(rs.getString(1));
                    experimentData.setExperimentName(rs.getString(2));
                    experimentData.setUser(rs.getString(3));
                    experimentData.setTopic(rs.getString(1));
                    WorkflowExecution workflowInstance = new WorkflowExecution(rs.getString(1), rs.getString(5));
                    workflowInstance.setTemplateName(rs.getString(6));
                    workflowInstance.setExperimentId(rs.getString(1));
                    workflowInstance.setWorkflowExecutionId(rs.getString(5));
                    experimentWorkflowInstances.add(workflowInstance);
                    experimentDataList.add((ExperimentData)experimentData);
                }
            }
            if (rs != null) {
                rs.close();
            }
            statement.close();
            connection.close();
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return experimentDataList;
    }
}

