/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Experiment;
import org.apache.airavata.persistance.registry.jpa.model.Experiment_Output;
import org.apache.airavata.persistance.registry.jpa.model.Experiment_Output_PK;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentOutputResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ExperimentOutputResource.class);
    private ExperimentResource experimentResource;
    private String experimentKey;
    private String value;
    private String outputType;
    private String metadata;

    public String getExperimentKey() {
        return this.experimentKey;
    }

    public void setExperimentKey(String experimentKey) {
        this.experimentKey = experimentKey;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ExperimentResource getExperimentResource() {
        return this.experimentResource;
    }

    public void setExperimentResource(ExperimentResource experimentResource) {
        this.experimentResource = experimentResource;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for experiment output data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for experiment output data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for experiment output data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for experiment output data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            Experiment_Output existingOutput = (Experiment_Output)em.find(Experiment_Output.class, (Object)new Experiment_Output_PK(this.experimentResource.getExpID(), this.experimentKey));
            em.close();
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Experiment_Output exOutput = new Experiment_Output();
            exOutput.setEx_key(this.experimentKey);
            Experiment experiment = (Experiment)em.find(Experiment.class, (Object)this.experimentResource.getExpID());
            exOutput.setExperiment(experiment);
            exOutput.setExperiment_id(experiment.getExpId());
            exOutput.setValue(this.value);
            exOutput.setOutputKeyType(this.outputType);
            exOutput.setMetadata(this.metadata);
            if (existingOutput != null) {
                existingOutput.setEx_key(this.experimentKey);
                existingOutput.setExperiment(experiment);
                existingOutput.setValue(this.value);
                existingOutput.setExperiment_id(experiment.getExpId());
                existingOutput.setOutputKeyType(this.outputType);
                existingOutput.setMetadata(this.metadata);
                exOutput = (Experiment_Output)em.merge((Object)existingOutput);
            } else {
                em.persist((Object)exOutput);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

