/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.NodeInput;
import org.apache.airavata.persistance.registry.jpa.model.NodeInput_PK;
import org.apache.airavata.persistance.registry.jpa.model.WorkflowNodeDetail;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.WorkflowNodeDetailResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeInputResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(NodeInputResource.class);
    private WorkflowNodeDetailResource nodeDetailResource;
    private String inputKey;
    private String inputType;
    private String metadata;
    private String value;

    public WorkflowNodeDetailResource getNodeDetailResource() {
        return this.nodeDetailResource;
    }

    public void setNodeDetailResource(WorkflowNodeDetailResource nodeDetailResource) {
        this.nodeDetailResource = nodeDetailResource;
    }

    public String getInputKey() {
        return this.inputKey;
    }

    public void setInputKey(String inputKey) {
        this.inputKey = inputKey;
    }

    public String getInputType() {
        return this.inputType;
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for node input data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for node input data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for node input data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for node input data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            NodeInput existingInput = (NodeInput)em.find(NodeInput.class, (Object)new NodeInput_PK(this.inputKey, this.nodeDetailResource.getNodeInstanceId()));
            em.close();
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            NodeInput nodeInput = new NodeInput();
            WorkflowNodeDetail nodeDetail = (WorkflowNodeDetail)em.find(WorkflowNodeDetail.class, (Object)this.nodeDetailResource.getNodeInstanceId());
            nodeInput.setNodeDetails(nodeDetail);
            nodeInput.setNodeId(nodeDetail.getNodeId());
            nodeInput.setInputKey(this.inputKey);
            nodeInput.setInputKeyType(this.inputType);
            nodeInput.setValue(this.value);
            nodeInput.setMetadata(this.metadata);
            if (existingInput != null) {
                existingInput.setNodeDetails(nodeDetail);
                existingInput.setNodeId(nodeDetail.getNodeId());
                existingInput.setInputKey(this.inputKey);
                existingInput.setInputKeyType(this.inputType);
                existingInput.setValue(this.value);
                existingInput.setMetadata(this.metadata);
                nodeInput = (NodeInput)em.merge((Object)existingInput);
            } else {
                em.persist((Object)nodeInput);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

