/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.airavata.common.exception.AiravataConfigurationException;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.AiravataJobState;
import org.apache.airavata.common.utils.DBUtil;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.common.utils.Version;
import org.apache.airavata.commons.gfac.type.ApplicationDescription;
import org.apache.airavata.commons.gfac.type.HostDescription;
import org.apache.airavata.commons.gfac.type.ServiceDescription;
import org.apache.airavata.credential.store.credential.Credential;
import org.apache.airavata.credential.store.credential.impl.ssh.SSHCredential;
import org.apache.airavata.credential.store.credential.impl.ssh.SSHCredentialGenerator;
import org.apache.airavata.credential.store.store.CredentialReader;
import org.apache.airavata.credential.store.store.CredentialStoreException;
import org.apache.airavata.credential.store.store.CredentialWriter;
import org.apache.airavata.credential.store.store.impl.CredentialReaderImpl;
import org.apache.airavata.credential.store.store.impl.SSHCredentialWriter;
import org.apache.airavata.persistance.registry.jpa.JPAResourceAccessor;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.resources.ApplicationDescriptorResource;
import org.apache.airavata.persistance.registry.jpa.resources.ConfigurationResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentDataRetriever;
import org.apache.airavata.persistance.registry.jpa.resources.GatewayResource;
import org.apache.airavata.persistance.registry.jpa.resources.HostDescriptorResource;
import org.apache.airavata.persistance.registry.jpa.resources.PublishWorkflowResource;
import org.apache.airavata.persistance.registry.jpa.resources.ServiceDescriptorResource;
import org.apache.airavata.persistance.registry.jpa.resources.UserResource;
import org.apache.airavata.persistance.registry.jpa.resources.UserWorkflowResource;
import org.apache.airavata.persistance.registry.jpa.resources.WorkerResource;
import org.apache.airavata.registry.api.AiravataExperiment;
import org.apache.airavata.registry.api.AiravataRegistry2;
import org.apache.airavata.registry.api.AiravataRegistryFactory;
import org.apache.airavata.registry.api.AiravataSubRegistry;
import org.apache.airavata.registry.api.AiravataUser;
import org.apache.airavata.registry.api.ConfigurationRegistry;
import org.apache.airavata.registry.api.DescriptorRegistry;
import org.apache.airavata.registry.api.ExecutionErrors;
import org.apache.airavata.registry.api.PasswordCallback;
import org.apache.airavata.registry.api.ProjectsRegistry;
import org.apache.airavata.registry.api.ProvenanceRegistry;
import org.apache.airavata.registry.api.PublishedWorkflowRegistry;
import org.apache.airavata.registry.api.ResourceMetadata;
import org.apache.airavata.registry.api.UserRegistry;
import org.apache.airavata.registry.api.UserWorkflowRegistry;
import org.apache.airavata.registry.api.WorkspaceProject;
import org.apache.airavata.registry.api.exception.AiravataRegUninitializedException;
import org.apache.airavata.registry.api.exception.GatewayNotRegisteredException;
import org.apache.airavata.registry.api.exception.RegAPIVersionIncompatibleException;
import org.apache.airavata.registry.api.exception.RegAccessorInstantiateException;
import org.apache.airavata.registry.api.exception.RegAccessorNotFoundException;
import org.apache.airavata.registry.api.exception.RegAccessorUndefinedException;
import org.apache.airavata.registry.api.exception.RegException;
import org.apache.airavata.registry.api.exception.RegistrySettingsException;
import org.apache.airavata.registry.api.exception.UnimplementedRegOperationException;
import org.apache.airavata.registry.api.exception.gateway.DescriptorAlreadyExistsException;
import org.apache.airavata.registry.api.exception.gateway.DescriptorDoesNotExistsException;
import org.apache.airavata.registry.api.exception.gateway.InsufficientDataException;
import org.apache.airavata.registry.api.exception.gateway.MalformedDescriptorException;
import org.apache.airavata.registry.api.exception.gateway.PublishedWorkflowAlreadyExistsException;
import org.apache.airavata.registry.api.exception.gateway.PublishedWorkflowDoesNotExistsException;
import org.apache.airavata.registry.api.exception.worker.ApplicationJobAlreadyExistsException;
import org.apache.airavata.registry.api.exception.worker.ExperimentDoesNotExistsException;
import org.apache.airavata.registry.api.exception.worker.InvalidApplicationJobIDException;
import org.apache.airavata.registry.api.exception.worker.UserWorkflowAlreadyExistsException;
import org.apache.airavata.registry.api.exception.worker.WorkflowInstanceAlreadyExistsException;
import org.apache.airavata.registry.api.exception.worker.WorkflowInstanceDoesNotExistsException;
import org.apache.airavata.registry.api.exception.worker.WorkflowInstanceNodeAlreadyExistsException;
import org.apache.airavata.registry.api.exception.worker.WorkflowInstanceNodeDoesNotExistsException;
import org.apache.airavata.registry.api.workflow.ApplicationJob;
import org.apache.airavata.registry.api.workflow.ApplicationJobExecutionError;
import org.apache.airavata.registry.api.workflow.ApplicationJobStatusData;
import org.apache.airavata.registry.api.workflow.ExecutionError;
import org.apache.airavata.registry.api.workflow.ExperimentData;
import org.apache.airavata.registry.api.workflow.ExperimentExecutionError;
import org.apache.airavata.registry.api.workflow.NodeExecutionData;
import org.apache.airavata.registry.api.workflow.NodeExecutionError;
import org.apache.airavata.registry.api.workflow.NodeExecutionStatus;
import org.apache.airavata.registry.api.workflow.WorkflowExecution;
import org.apache.airavata.registry.api.workflow.WorkflowExecutionData;
import org.apache.airavata.registry.api.workflow.WorkflowExecutionError;
import org.apache.airavata.registry.api.workflow.WorkflowExecutionStatus;
import org.apache.airavata.registry.api.workflow.WorkflowIOData;
import org.apache.airavata.registry.api.workflow.WorkflowInstanceNode;
import org.apache.airavata.registry.api.workflow.WorkflowNodeGramData;
import org.apache.airavata.registry.api.workflow.WorkflowNodeIOData;
import org.apache.airavata.registry.api.workflow.WorkflowNodeType;
import org.apache.airavata.registry.cpi.RegistryException;
import org.apache.xmlbeans.XmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiravataJPARegistry
extends AiravataRegistry2 {
    private static final Logger logger = LoggerFactory.getLogger(AiravataJPARegistry.class);
    private static Map<String, String[]> compatibleVersionMap;
    private static int CONNECT_FAIL_WAIT_TIME;
    private static int MAX_TRIES;
    private static final String DEFAULT_PROJECT_NAME = "default";
    private static final Version API_VERSION;
    private JPAResourceAccessor jpa;
    private boolean active = false;
    private URI registryConnectionURI;
    private ConfigurationRegistry configurationRegistry;
    private DescriptorRegistry descriptorRegistry;
    private ProjectsRegistry projectsRegistry;
    private ProvenanceRegistry provenanceRegistry;
    private UserWorkflowRegistry userWorkflowRegistry;
    private PublishedWorkflowRegistry publishedWorkflowRegistry;
    private UserRegistry userRegistry;
    private PasswordCallback callback;
    private CredentialReader credentialReader;
    private CredentialWriter credentialWriter;
    private SSHCredentialGenerator credentialGenerator;
    private static final String GFAC_URL = "gfac.url";
    private static final String INTERPRETER_URL = "interpreter.url";
    private static final String MESSAGE_BOX_URL = "messagebox.url";
    private static final String EVENTING_URL = "eventing.url";

    protected void initialize() throws RegException {
        String[] list;
        this.jpa = new JPAResourceAccessor(this);
        this.active = true;
        this.initializeCustomRegistries();
        String apiVersion = this.getVersion().toString();
        String registryVersion = null;
        int tries = 0;
        while (!ServerSettings.isStopAllThreads()) {
            try {
                ++tries;
                registryVersion = this.getConfiguration("registry.version").toString();
                if (System.getProperty("registry.initialize.state") == null) {
                    Thread.sleep(CONNECT_FAIL_WAIT_TIME * 5);
                    break;
                }
                while (System.getProperty("registry.initialize.state").equals("0")) {
                    Thread.sleep(CONNECT_FAIL_WAIT_TIME);
                }
                break;
            }
            catch (Exception e) {
                ResourceUtils.reset();
                if (tries < MAX_TRIES) {
                    try {
                        Thread.sleep(CONNECT_FAIL_WAIT_TIME);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                throw new AiravataRegUninitializedException("Airavata Registry has not yet initialized properly!!!", (Throwable)e);
            }
        }
        if ((list = compatibleVersionMap.get(apiVersion)) == null || !Arrays.asList(list).contains(registryVersion)) {
            throw new RegAPIVersionIncompatibleException("Incompatible registry versions. Please check whether you updated the API and Registry versions.");
        }
        try {
            if (!ResourceUtils.isGatewayExist(this.getGateway().getGatewayName())) {
                throw new GatewayNotRegisteredException(this.getGateway().getGatewayName());
            }
        }
        catch (RegistryException e) {
            e.printStackTrace();
        }
    }

    private void initializeCustomRegistries() throws RegException {
        try {
            this.configurationRegistry = (ConfigurationRegistry)this.getClassInstance(ConfigurationRegistry.class, "class.configuration.registry.accessor");
            this.descriptorRegistry = (DescriptorRegistry)this.getClassInstance(ConfigurationRegistry.class, "class.descriptor.registry.accessor");
            this.projectsRegistry = (ProjectsRegistry)this.getClassInstance(ConfigurationRegistry.class, "class.project.registry.accessor");
            this.provenanceRegistry = (ProvenanceRegistry)this.getClassInstance(ConfigurationRegistry.class, "class.provenance.registry.accessor");
            this.userWorkflowRegistry = (UserWorkflowRegistry)this.getClassInstance(ConfigurationRegistry.class, "class.user.workflow.registry.accessor");
            this.publishedWorkflowRegistry = (PublishedWorkflowRegistry)this.getClassInstance(ConfigurationRegistry.class, "class.published.workflow.registry.accessor");
            this.userRegistry = (UserRegistry)this.getClassInstance(ConfigurationRegistry.class, "class.user.registry.accessor");
        }
        catch (AiravataConfigurationException e) {
            throw new RegException("An error occured when attempting to determine any custom implementations of the registries!!!", (Throwable)e);
        }
    }

    private <T extends AiravataSubRegistry> Object getClassInstance(Class<T> c, String registryAccessorKey) throws AiravataConfigurationException {
        try {
            AiravataSubRegistry registryClass = (AiravataSubRegistry)c.cast(AiravataRegistryFactory.getRegistryClass((String)registryAccessorKey));
            registryClass.setAiravataRegistry((AiravataRegistry2)this);
            return registryClass;
        }
        catch (ClassCastException e) {
            logger.error("The class defined for accessor type " + registryAccessorKey + " MUST be an extention of the interface " + c.getName(), (Throwable)e);
        }
        catch (RegAccessorNotFoundException e) {
            logger.error("Error in loading class for registry accessor " + registryAccessorKey, (Throwable)e);
        }
        catch (RegAccessorUndefinedException e) {
        }
        catch (RegAccessorInstantiateException e) {
            logger.error("Error in instantiating instance from class for registry accessor " + registryAccessorKey, (Throwable)e);
        }
        return null;
    }

    public boolean isActive() {
        return this.active;
    }

    public Object getConfiguration(String key) throws RegException {
        ConfigurationResource configuration = ResourceUtils.getConfiguration(key);
        return configuration == null ? null : configuration.getConfigVal();
    }

    public List<Object> getConfigurationList(String key) throws RegException {
        if (this.configurationRegistry != null) {
            return this.configurationRegistry.getConfigurationList(key);
        }
        ArrayList<Object> values = new ArrayList<Object>();
        List<ConfigurationResource> configurations = ResourceUtils.getConfigurations(key);
        for (ConfigurationResource configurationResource : configurations) {
            values.add(configurationResource.getConfigVal());
        }
        return values;
    }

    public void setConfiguration(String key, String value, Date expire) throws RegException {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.setConfiguration(key, value, expire);
        } else {
            try {
                ConfigurationResource config = ResourceUtils.isConfigurationExist(key) ? ResourceUtils.getConfiguration(key) : ResourceUtils.createConfiguration(key);
                config.setConfigVal(value);
                config.setExpireDate(new Timestamp(expire.getTime()));
                config.save();
            }
            catch (RegistryException e) {
                e.printStackTrace();
            }
        }
    }

    public void addConfiguration(String key, String value, Date expire) throws RegException {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.addConfiguration(key, value, expire);
        } else {
            try {
                ConfigurationResource config = ResourceUtils.createConfiguration(key);
                config.setConfigVal(value);
                config.setExpireDate(new Timestamp(expire.getTime()));
                config.save();
            }
            catch (RegistryException e) {
                e.printStackTrace();
            }
        }
    }

    public void removeAllConfiguration(String key) throws RegException {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.removeAllConfiguration(key);
        } else {
            try {
                ResourceUtils.removeConfiguration(key);
            }
            catch (RegistryException e) {
                e.printStackTrace();
            }
        }
    }

    public void removeConfiguration(String key, String value) throws RegException {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.removeConfiguration(key, value);
        } else {
            try {
                ResourceUtils.removeConfiguration(key, value);
            }
            catch (RegistryException e) {
                e.printStackTrace();
            }
        }
    }

    public List<URI> getGFacURIs() throws RegException {
        if (this.configurationRegistry != null) {
            return this.configurationRegistry.getGFacURIs();
        }
        return this.retrieveURIsFromConfiguration(GFAC_URL);
    }

    private List<URI> retrieveURIsFromConfiguration(String urlType) throws RegException {
        ArrayList<URI> urls = new ArrayList<URI>();
        List<Object> configurationList = this.getConfigurationList(urlType);
        for (Object o : configurationList) {
            try {
                urls.add(new URI(o.toString()));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return urls;
    }

    public List<URI> getWorkflowInterpreterURIs() throws RegException {
        if (this.configurationRegistry != null) {
            return this.configurationRegistry.getWorkflowInterpreterURIs();
        }
        return this.retrieveURIsFromConfiguration(INTERPRETER_URL);
    }

    public URI getEventingServiceURI() throws RegException {
        if (this.configurationRegistry != null) {
            return this.configurationRegistry.getEventingServiceURI();
        }
        List<URI> eventingURLs = this.retrieveURIsFromConfiguration(EVENTING_URL);
        return eventingURLs.size() == 0 ? null : eventingURLs.get(0);
    }

    public URI getMessageBoxURI() throws RegException {
        if (this.configurationRegistry != null) {
            return this.configurationRegistry.getMessageBoxURI();
        }
        List<URI> messageboxURLs = this.retrieveURIsFromConfiguration(MESSAGE_BOX_URL);
        return messageboxURLs.size() == 0 ? null : messageboxURLs.get(0);
    }

    public void addGFacURI(URI uri) throws RegException {
        if (this.configurationRegistry != null) {
            this.addGFacURI(uri);
        } else {
            this.addConfigurationURL(GFAC_URL, uri);
        }
    }

    private void addConfigurationURL(String urlType, URI uri) throws RegException {
        Calendar instance = Calendar.getInstance();
        instance.add(12, 180);
        Date expire = instance.getTime();
        this.addConfigurationURL(urlType, uri, expire);
    }

    private void addConfigurationURL(String urlType, URI uri, Date expire) throws RegException {
        this.addConfiguration(urlType, uri.toString(), expire);
    }

    public void addWorkflowInterpreterURI(URI uri) throws RegException {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.addWorkflowInterpreterURI(uri);
        } else {
            this.addConfigurationURL(INTERPRETER_URL, uri);
        }
    }

    public void setEventingURI(URI uri) throws RegException {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.setEventingURI(uri);
        } else {
            this.addConfigurationURL(EVENTING_URL, uri);
        }
    }

    public void setMessageBoxURI(URI uri) throws RegException {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.setMessageBoxURI(uri);
        } else {
            this.addConfigurationURL(MESSAGE_BOX_URL, uri);
        }
    }

    public void addGFacURI(URI uri, Date expire) throws RegException {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.addGFacURI(uri, expire);
        } else {
            this.addConfigurationURL(GFAC_URL, uri, expire);
        }
    }

    public void addWorkflowInterpreterURI(URI uri, Date expire) throws RegException {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.addWorkflowInterpreterURI(uri, expire);
        } else {
            this.addConfigurationURL(INTERPRETER_URL, uri, expire);
        }
    }

    public void setEventingURI(URI uri, Date expire) throws RegException {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.setEventingURI(uri, expire);
        } else {
            this.addConfigurationURL(EVENTING_URL, uri, expire);
        }
    }

    public void setMessageBoxURI(URI uri, Date expire) throws RegException {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.setMessageBoxURI(uri, expire);
        } else {
            this.addConfigurationURL(MESSAGE_BOX_URL, uri, expire);
        }
    }

    public void removeGFacURI(URI uri) throws RegException {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.removeGFacURI(uri);
        } else {
            this.removeConfiguration(GFAC_URL, uri.toString());
        }
    }

    public void removeWorkflowInterpreterURI(URI uri) throws RegException {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.removeWorkflowInterpreterURI(uri);
        } else {
            this.removeConfiguration(INTERPRETER_URL, uri.toString());
        }
    }

    public void removeAllGFacURI() throws RegException {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.removeAllGFacURI();
        } else {
            this.removeAllConfiguration(GFAC_URL);
        }
    }

    public void removeAllWorkflowInterpreterURI() throws RegException {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.removeAllWorkflowInterpreterURI();
        } else {
            this.removeAllConfiguration(INTERPRETER_URL);
        }
    }

    public void unsetEventingURI() throws RegException {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.unsetEventingURI();
        } else {
            this.removeAllConfiguration(EVENTING_URL);
        }
    }

    public void unsetMessageBoxURI() throws RegException {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.unsetMessageBoxURI();
        } else {
            this.removeAllConfiguration(MESSAGE_BOX_URL);
        }
    }

    public boolean isHostDescriptorExists(String descriptorName) throws RegException {
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.isHostDescriptorExists(descriptorName);
        }
        try {
            return this.jpa.getGateway().isHostDescriptorExists(descriptorName);
        }
        catch (RegistryException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void addHostDescriptor(HostDescription descriptor) throws RegException {
        if (this.descriptorRegistry != null) {
            this.descriptorRegistry.addHostDescriptor(descriptor);
        } else {
            try {
                GatewayResource gateway = this.jpa.getGateway();
                WorkerResource workerResource = this.jpa.getWorker();
                String hostName = descriptor.getType().getHostName();
                if (this.isHostDescriptorExists(hostName)) {
                    throw new DescriptorAlreadyExistsException(hostName);
                }
                HostDescriptorResource hostDescriptorResource = gateway.createHostDescriptorResource(hostName);
                hostDescriptorResource.setUserName(workerResource.getUser());
                hostDescriptorResource.setContent(descriptor.toXML());
                hostDescriptorResource.save();
            }
            catch (RegistryException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateHostDescriptor(HostDescription descriptor) throws RegException {
        if (this.descriptorRegistry != null) {
            this.descriptorRegistry.updateHostDescriptor(descriptor);
        } else {
            try {
                GatewayResource gateway = this.jpa.getGateway();
                String hostName = descriptor.getType().getHostName();
                if (!this.isHostDescriptorExists(hostName)) {
                    throw new DescriptorDoesNotExistsException(hostName);
                }
                HostDescriptorResource hostDescriptorResource = gateway.getHostDescriptorResource(hostName);
                hostDescriptorResource.setContent(descriptor.toXML());
                hostDescriptorResource.save();
            }
            catch (RegistryException e) {
                e.printStackTrace();
            }
        }
    }

    public HostDescription getHostDescriptor(String hostName) throws RegException {
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.getHostDescriptor(hostName);
        }
        try {
            GatewayResource gateway = this.jpa.getGateway();
            if (!this.isHostDescriptorExists(hostName)) {
                return null;
            }
            HostDescriptorResource hostDescriptorResource = gateway.getHostDescriptorResource(hostName);
            return this.createHostDescriptor(hostDescriptorResource);
        }
        catch (RegistryException e) {
            e.printStackTrace();
            return null;
        }
    }

    private HostDescription createHostDescriptor(HostDescriptorResource hostDescriptorResource) throws MalformedDescriptorException {
        try {
            return HostDescription.fromXML((String)hostDescriptorResource.getContent());
        }
        catch (XmlException e) {
            throw new MalformedDescriptorException(hostDescriptorResource.getHostDescName(), (Throwable)e);
        }
    }

    public void removeHostDescriptor(String hostName) throws RegException {
        if (this.descriptorRegistry != null) {
            this.descriptorRegistry.removeHostDescriptor(hostName);
        } else {
            try {
                GatewayResource gateway = this.jpa.getGateway();
                if (!this.isHostDescriptorExists(hostName)) {
                    throw new DescriptorDoesNotExistsException(hostName);
                }
                gateway.removeHostDescriptor(hostName);
                Map<String, ApplicationDescription> applicationDescriptors = this.getApplicationDescriptorsFromHostName(hostName);
                for (String serviceName : applicationDescriptors.keySet()) {
                    this.removeApplicationDescriptor(serviceName, hostName, applicationDescriptors.get(serviceName).getType().getApplicationName().getStringValue());
                }
            }
            catch (RegistryException e) {
                logger.error("Error while removing application descriptors bound to host " + hostName, (Throwable)e);
            }
        }
    }

    public List<HostDescription> getHostDescriptors() throws MalformedDescriptorException, RegException {
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.getHostDescriptors();
        }
        try {
            GatewayResource gateway = this.jpa.getGateway();
            ArrayList<HostDescription> list = new ArrayList<HostDescription>();
            List<HostDescriptorResource> hostDescriptorResources = gateway.getHostDescriptorResources();
            for (HostDescriptorResource resource : hostDescriptorResources) {
                list.add(this.createHostDescriptor(resource));
            }
            return list;
        }
        catch (RegistryException e) {
            logger.error("Error while getting host descriptors ", (Throwable)e);
            return null;
        }
    }

    public ResourceMetadata getHostDescriptorMetadata(String hostName) throws RegException {
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.getHostDescriptorMetadata(hostName);
        }
        throw new UnimplementedRegOperationException();
    }

    public boolean isServiceDescriptorExists(String descriptorName) throws RegException {
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.isServiceDescriptorExists(descriptorName);
        }
        try {
            return this.jpa.getGateway().isServiceDescriptorExists(descriptorName);
        }
        catch (RegistryException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void addServiceDescriptor(ServiceDescription descriptor) throws RegException {
        if (this.descriptorRegistry != null) {
            this.descriptorRegistry.addServiceDescriptor(descriptor);
        } else {
            try {
                GatewayResource gateway = this.jpa.getGateway();
                WorkerResource workerResource = this.jpa.getWorker();
                String serviceName = descriptor.getType().getName();
                if (this.isServiceDescriptorExists(serviceName)) {
                    throw new DescriptorAlreadyExistsException(serviceName);
                }
                ServiceDescriptorResource serviceDescriptorResource = gateway.createServiceDescriptorResource(serviceName);
                serviceDescriptorResource.setUserName(workerResource.getUser());
                serviceDescriptorResource.setContent(descriptor.toXML());
                serviceDescriptorResource.save();
            }
            catch (RegistryException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateServiceDescriptor(ServiceDescription descriptor) throws RegException {
        if (this.descriptorRegistry != null) {
            this.descriptorRegistry.updateServiceDescriptor(descriptor);
        } else {
            try {
                GatewayResource gateway = this.jpa.getGateway();
                String serviceName = descriptor.getType().getName();
                if (!this.isServiceDescriptorExists(serviceName)) {
                    throw new DescriptorDoesNotExistsException(serviceName);
                }
                ServiceDescriptorResource serviceDescriptorResource = gateway.getServiceDescriptorResource(serviceName);
                serviceDescriptorResource.setContent(descriptor.toXML());
                serviceDescriptorResource.save();
            }
            catch (RegistryException e) {
                e.printStackTrace();
            }
        }
    }

    public ServiceDescription getServiceDescriptor(String serviceName) throws RegException, MalformedDescriptorException {
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.getServiceDescriptor(serviceName);
        }
        try {
            GatewayResource gateway = this.jpa.getGateway();
            if (!gateway.isServiceDescriptorExists(serviceName)) {
                return null;
            }
            ServiceDescriptorResource serviceDescriptorResource = gateway.getServiceDescriptorResource(serviceName);
            return this.createServiceDescriptor(serviceDescriptorResource);
        }
        catch (RegistryException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ServiceDescription createServiceDescriptor(ServiceDescriptorResource serviceDescriptorResource) throws MalformedDescriptorException {
        try {
            return ServiceDescription.fromXML((String)serviceDescriptorResource.getContent());
        }
        catch (XmlException e) {
            throw new MalformedDescriptorException(serviceDescriptorResource.getServiceDescName(), (Throwable)e);
        }
    }

    public void removeServiceDescriptor(String serviceName) throws RegException {
        if (this.descriptorRegistry != null) {
            this.descriptorRegistry.removeServiceDescriptor(serviceName);
        } else {
            try {
                GatewayResource gateway = this.jpa.getGateway();
                if (!this.isServiceDescriptorExists(serviceName)) {
                    throw new DescriptorDoesNotExistsException(serviceName);
                }
                gateway.removeServiceDescriptor(serviceName);
                Map<String, ApplicationDescription> applicationDescriptors = this.getApplicationDescriptors(serviceName);
                for (String hostName : applicationDescriptors.keySet()) {
                    this.removeApplicationDescriptor(serviceName, hostName, applicationDescriptors.get(hostName).getType().getApplicationName().getStringValue());
                }
            }
            catch (Exception e) {
                logger.error("Error while removing application descriptors bound to service " + serviceName, (Throwable)e);
            }
        }
    }

    public List<ServiceDescription> getServiceDescriptors() throws MalformedDescriptorException, RegException {
        ArrayList<ServiceDescription> list = new ArrayList<ServiceDescription>();
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.getServiceDescriptors();
        }
        try {
            GatewayResource gateway = this.jpa.getGateway();
            List<ServiceDescriptorResource> serviceDescriptorResources = gateway.getServiceDescriptorResources();
            for (ServiceDescriptorResource resource : serviceDescriptorResources) {
                list.add(this.createServiceDescriptor(resource));
            }
            return list;
        }
        catch (RegistryException e) {
            e.printStackTrace();
            return list;
        }
    }

    public ResourceMetadata getServiceDescriptorMetadata(String serviceName) throws RegException {
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.getServiceDescriptorMetadata(serviceName);
        }
        throw new UnimplementedRegOperationException();
    }

    private String createAppName(String serviceName, String hostName, String applicationName) {
        return serviceName + "/" + hostName + "/" + applicationName;
    }

    public boolean isApplicationDescriptorExists(String serviceName, String hostName, String descriptorName) throws RegException {
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.isApplicationDescriptorExists(serviceName, hostName, descriptorName);
        }
        try {
            return this.jpa.getGateway().isApplicationDescriptorExists(this.createAppName(serviceName, hostName, descriptorName));
        }
        catch (RegistryException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void addApplicationDescriptor(ServiceDescription serviceDescription, HostDescription hostDescriptor, ApplicationDescription descriptor) throws RegException {
        if (this.descriptorRegistry != null) {
            this.descriptorRegistry.addApplicationDescriptor(serviceDescription, hostDescriptor, descriptor);
        } else {
            this.addApplicationDescriptor(serviceDescription.getType().getName(), hostDescriptor.getType().getHostName(), descriptor);
        }
    }

    public void addApplicationDescriptor(String serviceName, String hostName, ApplicationDescription descriptor) throws RegException {
        if (this.descriptorRegistry != null) {
            this.descriptorRegistry.addApplicationDescriptor(serviceName, hostName, descriptor);
        } else {
            if (serviceName == null || hostName == null) {
                throw new InsufficientDataException("Service name or Host name cannot be null");
            }
            try {
                GatewayResource gateway = this.jpa.getGateway();
                WorkerResource workerResource = this.jpa.getWorker();
                String applicationName = descriptor.getType().getApplicationName().getStringValue();
                applicationName = this.createAppName(serviceName, hostName, applicationName);
                if (this.isApplicationDescriptorExists(serviceName, hostName, descriptor.getType().getApplicationName().getStringValue())) {
                    throw new DescriptorAlreadyExistsException(applicationName);
                }
                ApplicationDescriptorResource applicationDescriptorResource = gateway.createApplicationDescriptorResource(applicationName);
                applicationDescriptorResource.setUpdatedUser(workerResource.getUser());
                applicationDescriptorResource.setServiceDescName(serviceName);
                applicationDescriptorResource.setHostDescName(hostName);
                applicationDescriptorResource.setContent(descriptor.toXML());
                applicationDescriptorResource.save();
            }
            catch (RegistryException e) {
                e.printStackTrace();
            }
        }
    }

    public void udpateApplicationDescriptor(ServiceDescription serviceDescription, HostDescription hostDescriptor, ApplicationDescription descriptor) throws RegException {
        if (this.descriptorRegistry != null) {
            this.descriptorRegistry.udpateApplicationDescriptor(serviceDescription, hostDescriptor, descriptor);
        } else {
            this.updateApplicationDescriptor(serviceDescription.getType().getName(), hostDescriptor.getType().getHostName(), descriptor);
        }
    }

    public void updateApplicationDescriptor(String serviceName, String hostName, ApplicationDescription descriptor) throws RegException {
        if (this.descriptorRegistry != null) {
            this.descriptorRegistry.updateApplicationDescriptor(serviceName, hostName, descriptor);
        } else {
            if (serviceName == null || hostName == null) {
                throw new InsufficientDataException("Service name or Host name cannot be null");
            }
            try {
                GatewayResource gateway = this.jpa.getGateway();
                String applicationName = descriptor.getType().getApplicationName().getStringValue();
                applicationName = this.createAppName(serviceName, hostName, applicationName);
                if (!this.isApplicationDescriptorExists(serviceName, hostName, descriptor.getType().getApplicationName().getStringValue())) {
                    throw new DescriptorDoesNotExistsException(applicationName);
                }
                ApplicationDescriptorResource serviceDescriptorResource = gateway.getApplicationDescriptorResource(applicationName);
                serviceDescriptorResource.setContent(descriptor.toXML());
                serviceDescriptorResource.save();
            }
            catch (RegistryException e) {
                e.printStackTrace();
            }
        }
    }

    private ApplicationDescription createApplicationDescriptor(ApplicationDescriptorResource applicationDescriptorResource) throws MalformedDescriptorException {
        try {
            return ApplicationDescription.fromXML((String)applicationDescriptorResource.getContent());
        }
        catch (XmlException e) {
            throw new MalformedDescriptorException(applicationDescriptorResource.getName(), (Throwable)e);
        }
    }

    public ApplicationDescription getApplicationDescriptor(String serviceName, String hostname, String applicationName) throws DescriptorDoesNotExistsException, MalformedDescriptorException, RegException {
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.getApplicationDescriptor(serviceName, hostname, applicationName);
        }
        if (serviceName == null || hostname == null) {
            throw new InsufficientDataException("Service name or Host name cannot be null");
        }
        GatewayResource gateway = this.jpa.getGateway();
        if (!this.isApplicationDescriptorExists(serviceName, hostname, applicationName)) {
            throw new DescriptorDoesNotExistsException(this.createAppName(serviceName, hostname, applicationName));
        }
        try {
            return this.createApplicationDescriptor(gateway.getApplicationDescriptorResource(this.createAppName(serviceName, hostname, applicationName)));
        }
        catch (RegistryException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ApplicationDescription getApplicationDescriptors(String serviceName, String hostname) throws RegException {
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.getApplicationDescriptors(serviceName, hostname);
        }
        try {
            GatewayResource gateway = this.jpa.getGateway();
            List<ApplicationDescriptorResource> applicationDescriptorResources = gateway.getApplicationDescriptorResources(serviceName, hostname);
            if (applicationDescriptorResources.size() > 0) {
                return this.createApplicationDescriptor(applicationDescriptorResources.get(0));
            }
        }
        catch (RegistryException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Map<String, ApplicationDescription> getApplicationDescriptors(String serviceName) throws RegException {
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.getApplicationDescriptors(serviceName);
        }
        HashMap<String, ApplicationDescription> map = new HashMap<String, ApplicationDescription>();
        try {
            GatewayResource gateway = this.jpa.getGateway();
            List<ApplicationDescriptorResource> applicationDescriptorResources = gateway.getApplicationDescriptorResources(serviceName, null);
            for (ApplicationDescriptorResource resource : applicationDescriptorResources) {
                map.put(resource.getHostDescName(), this.createApplicationDescriptor(resource));
            }
        }
        catch (RegistryException e) {
            e.printStackTrace();
        }
        return map;
    }

    private Map<String, ApplicationDescription> getApplicationDescriptorsFromHostName(String hostName) throws RegException {
        HashMap<String, ApplicationDescription> map = new HashMap<String, ApplicationDescription>();
        try {
            GatewayResource gateway = this.jpa.getGateway();
            List<ApplicationDescriptorResource> applicationDescriptorResources = gateway.getApplicationDescriptorResources(null, hostName);
            for (ApplicationDescriptorResource resource : applicationDescriptorResources) {
                map.put(resource.getServiceDescName(), this.createApplicationDescriptor(resource));
            }
        }
        catch (RegistryException e) {
            e.printStackTrace();
        }
        return map;
    }

    public Map<String[], ApplicationDescription> getApplicationDescriptors() throws MalformedDescriptorException, RegException {
        HashMap<String[], ApplicationDescription> map = new HashMap<String[], ApplicationDescription>();
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.getApplicationDescriptors();
        }
        try {
            GatewayResource gateway = this.jpa.getGateway();
            List<ApplicationDescriptorResource> applicationDescriptorResources = gateway.getApplicationDescriptorResources();
            for (ApplicationDescriptorResource resource : applicationDescriptorResources) {
                map.put(new String[]{resource.getServiceDescName(), resource.getHostDescName()}, this.createApplicationDescriptor(resource));
            }
            return map;
        }
        catch (RegistryException e) {
            e.printStackTrace();
            return map;
        }
    }

    public void removeApplicationDescriptor(String serviceName, String hostName, String applicationName) throws RegException {
        if (this.descriptorRegistry != null) {
            this.descriptorRegistry.removeApplicationDescriptor(serviceName, hostName, applicationName);
        } else {
            try {
                GatewayResource gateway = this.jpa.getGateway();
                String appName = this.createAppName(serviceName, hostName, applicationName);
                if (!this.isApplicationDescriptorExists(serviceName, hostName, applicationName)) {
                    throw new DescriptorDoesNotExistsException(appName);
                }
                gateway.removeApplicationDescriptor(appName);
            }
            catch (RegistryException e) {
                e.printStackTrace();
            }
        }
    }

    public ResourceMetadata getApplicationDescriptorMetadata(String serviceName, String hostName, String applicationName) throws RegException {
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.getApplicationDescriptorMetadata(serviceName, hostName, applicationName);
        }
        throw new UnimplementedRegOperationException();
    }

    private String createProjName(String projectName) {
        return this.createProjName(this.getGateway().getGatewayName(), this.getUser().getUserName(), projectName);
    }

    private String createProjName(String gatewayName, String userName, String projectName) {
        return gatewayName + "\n" + userName + "\n" + projectName;
    }

    private String getProjName(String projectLongName) {
        String[] s = projectLongName.split("\n");
        return s[s.length - 1];
    }

    public boolean isWorkspaceProjectExists(String projectName) throws RegException {
        if (this.projectsRegistry != null) {
            return this.projectsRegistry.isWorkspaceProjectExists(projectName);
        }
        return this.isWorkspaceProjectExists(projectName, false);
    }

    public boolean isWorkspaceProjectExists(String projectName, boolean createIfNotExists) throws RegException {
        if (this.projectsRegistry != null) {
            return this.projectsRegistry.isWorkspaceProjectExists(projectName, createIfNotExists);
        }
        try {
            if (this.jpa.getWorker().isProjectExists(this.createProjName(projectName))) {
                return true;
            }
            if (createIfNotExists) {
                this.addWorkspaceProject(new WorkspaceProject(projectName, (ProjectsRegistry)this));
                return this.isWorkspaceProjectExists(projectName);
            }
            return false;
        }
        catch (RegistryException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void addWorkspaceProject(WorkspaceProject project) throws RegException {
    }

    public void updateWorkspaceProject(WorkspaceProject project) throws RegException {
    }

    public void deleteWorkspaceProject(String projectName) throws RegException {
    }

    public WorkspaceProject getWorkspaceProject(String projectName) throws RegException {
        return null;
    }

    public List<WorkspaceProject> getWorkspaceProjects() throws RegException {
        return null;
    }

    public void addExperiment(String projectName, AiravataExperiment experiment) throws RegException {
    }

    public void removeExperiment(String experimentId) throws ExperimentDoesNotExistsException {
    }

    public List<AiravataExperiment> getExperiments() throws RegException {
        return null;
    }

    public List<AiravataExperiment> getExperiments(String projectName) throws RegException {
        return null;
    }

    public List<AiravataExperiment> getExperiments(Date from, Date to) throws RegException {
        return null;
    }

    public List<AiravataExperiment> getExperiments(String projectName, Date from, Date to) throws RegException {
        return null;
    }

    public boolean isPublishedWorkflowExists(String workflowName) throws RegException {
        if (this.publishedWorkflowRegistry != null) {
            return this.publishedWorkflowRegistry.isPublishedWorkflowExists(workflowName);
        }
        try {
            return this.jpa.getGateway().isPublishedWorkflowExists(workflowName);
        }
        catch (RegistryException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void publishWorkflow(String workflowName, String publishWorkflowName) throws RegException {
        if (this.publishedWorkflowRegistry != null) {
            this.publishedWorkflowRegistry.publishWorkflow(workflowName, publishWorkflowName);
        } else {
            try {
                GatewayResource gateway = this.jpa.getGateway();
                String workflowGraphXML = this.getWorkflowGraphXML(workflowName);
                if (gateway.isPublishedWorkflowExists(publishWorkflowName)) {
                    throw new PublishedWorkflowAlreadyExistsException(publishWorkflowName);
                }
                PublishWorkflowResource publishedWorkflow = gateway.createPublishedWorkflow(publishWorkflowName);
                publishedWorkflow.setCreatedUser(this.getUser().getUserName());
                publishedWorkflow.setContent(workflowGraphXML);
                publishedWorkflow.setPublishedDate(new Timestamp(Calendar.getInstance().getTime().getTime()));
                publishedWorkflow.save();
            }
            catch (RegistryException e) {
                e.printStackTrace();
            }
        }
    }

    public void publishWorkflow(String workflowName) throws RegException {
        if (this.publishedWorkflowRegistry != null) {
            this.publishedWorkflowRegistry.publishWorkflow(workflowName);
        } else {
            this.publishWorkflow(workflowName, workflowName);
        }
    }

    public String getPublishedWorkflowGraphXML(String workflowName) throws RegException {
        if (this.publishedWorkflowRegistry != null) {
            return this.publishedWorkflowRegistry.getPublishedWorkflowGraphXML(workflowName);
        }
        GatewayResource gateway = this.jpa.getGateway();
        if (!this.isPublishedWorkflowExists(workflowName)) {
            throw new PublishedWorkflowDoesNotExistsException(workflowName);
        }
        try {
            return gateway.getPublishedWorkflow(workflowName).getContent();
        }
        catch (RegistryException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<String> getPublishedWorkflowNames() throws RegException {
        ArrayList<String> result = new ArrayList<String>();
        if (this.publishedWorkflowRegistry != null) {
            return this.publishedWorkflowRegistry.getPublishedWorkflowNames();
        }
        GatewayResource gateway = this.jpa.getGateway();
        try {
            List<PublishWorkflowResource> publishedWorkflows = gateway.getPublishedWorkflows();
            for (PublishWorkflowResource resource : publishedWorkflows) {
                result.add(resource.getName());
            }
        }
        catch (RegistryException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Map<String, String> getPublishedWorkflows() throws RegException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.publishedWorkflowRegistry != null) {
            return this.publishedWorkflowRegistry.getPublishedWorkflows();
        }
        try {
            GatewayResource gateway = this.jpa.getGateway();
            List<PublishWorkflowResource> publishedWorkflows = gateway.getPublishedWorkflows();
            for (PublishWorkflowResource resource : publishedWorkflows) {
                result.put(resource.getName(), resource.getContent());
            }
        }
        catch (RegistryException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void removePublishedWorkflow(String workflowName) throws RegException {
        if (this.publishedWorkflowRegistry != null) {
            this.publishedWorkflowRegistry.removePublishedWorkflow(workflowName);
        } else {
            try {
                GatewayResource gateway = this.jpa.getGateway();
                if (!this.isPublishedWorkflowExists(workflowName)) {
                    throw new PublishedWorkflowDoesNotExistsException(workflowName);
                }
                gateway.removePublishedWorkflow(workflowName);
            }
            catch (RegistryException e) {
                e.printStackTrace();
            }
        }
    }

    public ResourceMetadata getPublishedWorkflowMetadata(String workflowName) throws RegException {
        if (this.publishedWorkflowRegistry != null) {
            return this.publishedWorkflowRegistry.getPublishedWorkflowMetadata(workflowName);
        }
        throw new UnimplementedRegOperationException();
    }

    public boolean isWorkflowExists(String workflowName) throws RegException {
        if (this.userWorkflowRegistry != null) {
            return this.userWorkflowRegistry.isWorkflowExists(workflowName);
        }
        try {
            return this.jpa.getWorker().isWorkflowTemplateExists(workflowName);
        }
        catch (RegistryException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void addWorkflow(String workflowName, String workflowGraphXml) throws RegException {
        if (this.userWorkflowRegistry != null) {
            this.userWorkflowRegistry.addWorkflow(workflowName, workflowGraphXml);
        } else {
            WorkerResource worker = this.jpa.getWorker();
            if (this.isWorkflowExists(workflowName)) {
                throw new UserWorkflowAlreadyExistsException(workflowName);
            }
            try {
                UserWorkflowResource workflowResource = worker.createWorkflowTemplate(workflowName);
                workflowResource.setContent(workflowGraphXml);
                workflowResource.save();
            }
            catch (RegistryException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateWorkflow(String workflowName, String workflowGraphXml) throws RegException {
    }

    public String getWorkflowGraphXML(String workflowName) throws RegException {
        return null;
    }

    public Map<String, String> getWorkflows() throws RegException {
        return null;
    }

    public void removeWorkflow(String workflowName) throws RegException {
    }

    public ResourceMetadata getWorkflowMetadata(String workflowName) throws RegException {
        if (this.userWorkflowRegistry != null) {
            return this.userWorkflowRegistry.getWorkflowMetadata(workflowName);
        }
        throw new UnimplementedRegOperationException();
    }

    public void setAiravataRegistry(AiravataRegistry2 registry) {
    }

    public void setAiravataUser(AiravataUser user) {
        this.setUser(user);
    }

    public AiravataUser getAiravataUser() {
        return this.getUser();
    }

    public boolean isExperimentExists(String experimentId, boolean createIfNotPresent) throws RegException {
        return false;
    }

    public boolean isExperimentExists(String experimentId) throws RegException {
        return false;
    }

    public void updateExperimentExecutionUser(String experimentId, String user) throws RegException {
    }

    public String getExperimentExecutionUser(String experimentId) throws RegException {
        return null;
    }

    public boolean isExperimentNameExist(String experimentName) throws RegException {
        return false;
    }

    public String getExperimentName(String experimentId) throws RegException {
        return null;
    }

    public void updateExperimentName(String experimentId, String experimentName) throws RegException {
    }

    public String getExperimentMetadata(String experimentId) throws RegException {
        return null;
    }

    public void updateExperimentMetadata(String experimentId, String metadata) throws RegException {
    }

    public String getWorkflowExecutionTemplateName(String workflowInstanceId) throws RegException {
        return null;
    }

    public void setWorkflowInstanceTemplateName(String workflowInstanceId, String templateName) throws RegException {
    }

    public List<WorkflowExecution> getExperimentWorkflowInstances(String experimentId) throws RegException {
        return null;
    }

    public boolean isWorkflowInstanceExists(String instanceId, boolean createIfNotPresent) throws RegException {
        return false;
    }

    public boolean isWorkflowInstanceExists(String instanceId) throws RegException {
        return false;
    }

    public void updateWorkflowInstanceStatus(String instanceId, WorkflowExecutionStatus.State status) throws RegException {
    }

    public void updateWorkflowInstanceStatus(WorkflowExecutionStatus status) throws RegException {
    }

    public WorkflowExecutionStatus getWorkflowInstanceStatus(String instanceId) throws RegException {
        return null;
    }

    public void updateWorkflowNodeInput(WorkflowInstanceNode node, String data) throws RegException {
    }

    public void updateWorkflowNodeOutput(WorkflowInstanceNode node, String data) throws RegException {
    }

    public List<WorkflowNodeIOData> searchWorkflowInstanceNodeInput(String experimentIdRegEx, String workflowNameRegEx, String nodeNameRegEx) throws RegException {
        return null;
    }

    public List<WorkflowNodeIOData> searchWorkflowInstanceNodeOutput(String experimentIdRegEx, String workflowNameRegEx, String nodeNameRegEx) throws RegException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.searchWorkflowInstanceNodeOutput(experimentIdRegEx, workflowNameRegEx, nodeNameRegEx);
        }
        return null;
    }

    public List<WorkflowNodeIOData> getWorkflowInstanceNodeInput(String workflowInstanceId, String nodeType) throws RegException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getWorkflowInstanceNodeInput(workflowInstanceId, nodeType);
        }
        return null;
    }

    public List<WorkflowNodeIOData> getWorkflowInstanceNodeOutput(String workflowInstanceId, String nodeType) throws RegException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getWorkflowInstanceNodeOutput(workflowInstanceId, nodeType);
        }
        return null;
    }

    @Deprecated
    public void saveWorkflowExecutionOutput(String experimentId, String outputNodeName, String output) throws RegException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.saveWorkflowExecutionOutput(experimentId, outputNodeName, output);
        }
    }

    @Deprecated
    public void saveWorkflowExecutionOutput(String experimentId, WorkflowIOData data) throws RegException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.saveWorkflowExecutionOutput(experimentId, data);
        }
    }

    @Deprecated
    public WorkflowIOData getWorkflowExecutionOutput(String experimentId, String outputNodeName) throws RegException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getWorkflowExecutionOutput(experimentId, outputNodeName);
        }
        return null;
    }

    @Deprecated
    public List<WorkflowIOData> getWorkflowExecutionOutput(String experimentId) throws RegException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getWorkflowExecutionOutput(experimentId);
        }
        return null;
    }

    @Deprecated
    public String[] getWorkflowExecutionOutputNames(String exeperimentId) throws RegException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getWorkflowExecutionOutputNames(exeperimentId);
        }
        return null;
    }

    public ExperimentData getExperiment(String experimentId) throws RegException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getExperiment(experimentId);
        }
        if (!this.isExperimentExists(experimentId)) {
            throw new ExperimentDoesNotExistsException(experimentId);
        }
        return new ExperimentDataRetriever().getExperiment(experimentId);
    }

    public List<String> getExperimentIdByUser(String user) throws RegException {
        return null;
    }

    public List<ExperimentData> getExperimentByUser(String user) throws RegException {
        return null;
    }

    public List<ExperimentData> getExperiments(HashMap<String, String> params) throws RegException {
        return null;
    }

    public List<ExperimentData> getExperimentByUser(String user, int pageSize, int pageNo) throws RegException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getExperimentByUser(user, pageSize, pageNo);
        }
        return null;
    }

    public void updateWorkflowNodeStatus(NodeExecutionStatus workflowStatusNode) throws RegException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.updateWorkflowNodeStatus(workflowStatusNode);
        } else {
            WorkflowExecution workflowInstance = workflowStatusNode.getWorkflowInstanceNode().getWorkflowInstance();
            String nodeId = workflowStatusNode.getWorkflowInstanceNode().getNodeId();
            if (!this.isWorkflowInstanceNodePresent(workflowInstance.getWorkflowExecutionId(), nodeId, true)) {
                throw new WorkflowInstanceNodeDoesNotExistsException(workflowInstance.getWorkflowExecutionId(), nodeId);
            }
        }
    }

    public void updateWorkflowNodeStatus(String workflowInstanceId, String nodeId, WorkflowExecutionStatus.State status) throws RegException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.updateWorkflowNodeStatus(workflowInstanceId, nodeId, status);
        } else {
            this.updateWorkflowNodeStatus(new WorkflowInstanceNode(new WorkflowExecution(workflowInstanceId, workflowInstanceId), nodeId), status);
        }
    }

    public void updateWorkflowNodeStatus(WorkflowInstanceNode workflowNode, WorkflowExecutionStatus.State status) throws RegException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.updateWorkflowNodeStatus(workflowNode, status);
        } else {
            this.updateWorkflowNodeStatus(new NodeExecutionStatus(workflowNode, status, Calendar.getInstance().getTime()));
        }
    }

    public NodeExecutionStatus getWorkflowNodeStatus(WorkflowInstanceNode workflowNode) throws RegException {
        String nodeId;
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getWorkflowNodeStatus(workflowNode);
        }
        String id = workflowNode.getWorkflowInstance().getWorkflowExecutionId();
        if (!this.isWorkflowInstanceNodePresent(id, nodeId = workflowNode.getNodeId())) {
            throw new WorkflowInstanceNodeDoesNotExistsException(id, nodeId);
        }
        return null;
    }

    public Date getWorkflowNodeStartTime(WorkflowInstanceNode workflowNode) throws RegException {
        String nodeId;
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getWorkflowNodeStartTime(workflowNode);
        }
        String id = workflowNode.getWorkflowInstance().getWorkflowExecutionId();
        if (!this.isWorkflowInstanceNodePresent(id, nodeId = workflowNode.getNodeId())) {
            throw new WorkflowInstanceNodeDoesNotExistsException(id, nodeId);
        }
        return null;
    }

    public Date getWorkflowStartTime(WorkflowExecution workflowInstance) throws RegException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getWorkflowStartTime(workflowInstance);
        }
        if (!this.isWorkflowInstanceExists(workflowInstance.getWorkflowExecutionId(), true)) {
            throw new WorkflowInstanceDoesNotExistsException(workflowInstance.getWorkflowExecutionId());
        }
        return null;
    }

    public void updateWorkflowNodeGramData(WorkflowNodeGramData workflowNodeGramData) throws RegException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.updateWorkflowNodeGramData(workflowNodeGramData);
        } else {
            ApplicationJob job = new ApplicationJob();
            job.setJobId(workflowNodeGramData.getGramJobID());
            job.setHostDescriptionId(workflowNodeGramData.getInvokedHost());
            job.setExperimentId(workflowNodeGramData.getWorkflowInstanceId());
            job.setWorkflowExecutionId(workflowNodeGramData.getWorkflowInstanceId());
            job.setNodeId(workflowNodeGramData.getNodeID());
            job.setJobData(workflowNodeGramData.getRsl());
            if (this.isApplicationJobExists(job.getJobId())) {
                this.updateApplicationJob(job);
            } else {
                this.addApplicationJob(job);
            }
        }
    }

    public WorkflowExecutionData getWorkflowInstanceData(String workflowInstanceId) throws RegException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getWorkflowInstanceData(workflowInstanceId);
        }
        if (!this.isWorkflowInstanceExists(workflowInstanceId, true)) {
            throw new WorkflowInstanceDoesNotExistsException(workflowInstanceId);
        }
        return null;
    }

    public NodeExecutionData getWorkflowInstanceNodeData(String workflowInstanceId, String nodeId) throws RegException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getWorkflowInstanceNodeData(workflowInstanceId, nodeId);
        }
        if (!this.isWorkflowInstanceNodePresent(workflowInstanceId, nodeId)) {
            throw new WorkflowInstanceNodeDoesNotExistsException(workflowInstanceId, nodeId);
        }
        return null;
    }

    public boolean isWorkflowInstanceNodePresent(String workflowInstanceId, String nodeId) throws RegException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.isWorkflowInstanceNodePresent(workflowInstanceId, nodeId);
        }
        return this.isWorkflowInstanceNodePresent(workflowInstanceId, nodeId, false);
    }

    public boolean isWorkflowInstanceNodePresent(String workflowInstanceId, String nodeId, boolean createIfNotPresent) throws RegException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.isWorkflowInstanceNodePresent(workflowInstanceId, nodeId, createIfNotPresent);
        }
        if (!this.isWorkflowInstanceExists(workflowInstanceId, true)) {
            throw new WorkflowInstanceDoesNotExistsException(workflowInstanceId);
        }
        return false;
    }

    public void addWorkflowInstance(String experimentId, String workflowInstanceId, String templateName) throws RegException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.addWorkflowInstance(experimentId, workflowInstanceId, templateName);
        } else {
            if (!this.isExperimentExists(experimentId, true)) {
                throw new ExperimentDoesNotExistsException(experimentId);
            }
            if (this.isWorkflowInstanceExists(workflowInstanceId)) {
                throw new WorkflowInstanceAlreadyExistsException(workflowInstanceId);
            }
        }
    }

    public void updateWorkflowNodeType(WorkflowInstanceNode node, WorkflowNodeType type) throws RegException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.updateWorkflowNodeType(node, type);
        } else {
            try {
                if (!this.isWorkflowInstanceNodePresent(node.getWorkflowInstance().getWorkflowExecutionId(), node.getNodeId(), true)) {
                    throw new WorkflowInstanceNodeDoesNotExistsException(node.getWorkflowInstance().getWorkflowExecutionId(), node.getNodeId());
                }
            }
            catch (RegException e) {
                e.printStackTrace();
                throw e;
            }
        }
    }

    public void addWorkflowInstanceNode(String workflowInstanceId, String nodeId) throws RegException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.addWorkflowInstanceNode(workflowInstanceId, nodeId);
        } else if (this.isWorkflowInstanceNodePresent(workflowInstanceId, nodeId)) {
            throw new WorkflowInstanceNodeAlreadyExistsException(workflowInstanceId, nodeId);
        }
    }

    public ExperimentData getExperimentMetaInformation(String experimentId) throws RegException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getExperimentMetaInformation(experimentId);
        }
        if (!this.isExperimentExists(experimentId)) {
            throw new ExperimentDoesNotExistsException(experimentId);
        }
        ExperimentDataRetriever experimentDataRetriever = new ExperimentDataRetriever();
        return experimentDataRetriever.getExperimentMetaInformation(experimentId);
    }

    public List<ExperimentData> getAllExperimentMetaInformation(String user) throws RegException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getAllExperimentMetaInformation(user);
        }
        ExperimentDataRetriever experimentDataRetriever = new ExperimentDataRetriever();
        return experimentDataRetriever.getAllExperimentMetaInformation(user);
    }

    public List<ExperimentData> searchExperiments(String user, String experimentNameRegex) throws RegException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.searchExperiments(user, experimentNameRegex);
        }
        Pattern pattern = Pattern.compile(experimentNameRegex);
        ArrayList<ExperimentData> filteredExperiments = new ArrayList<ExperimentData>();
        List<ExperimentData> allExperimentMetaInformation = this.getAllExperimentMetaInformation(user);
        for (ExperimentData experimentData : allExperimentMetaInformation) {
            if (experimentData.getExperimentName() == null || !pattern.matcher(experimentData.getExperimentName()).find()) continue;
            filteredExperiments.add(experimentData);
        }
        return filteredExperiments;
    }

    public Version getVersion() {
        return API_VERSION;
    }

    public void setConnectionURI(URI connectionURI) {
        this.registryConnectionURI = connectionURI;
    }

    public URI getConnectionURI() {
        return this.registryConnectionURI;
    }

    public void setCallback(PasswordCallback callback) {
        this.callback = callback;
    }

    public PasswordCallback getCallback() {
        return this.callback;
    }

    public List<ExperimentExecutionError> getExperimentExecutionErrors(String experimentId) throws RegException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getExperimentExecutionErrors(experimentId);
        }
        ArrayList result = new ArrayList();
        return null;
    }

    public List<WorkflowExecutionError> getWorkflowExecutionErrors(String experimentId, String workflowInstanceId) throws RegException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getWorkflowExecutionErrors(experimentId, workflowInstanceId);
        }
        ArrayList result = new ArrayList();
        return null;
    }

    public List<NodeExecutionError> getNodeExecutionErrors(String experimentId, String workflowInstanceId, String nodeId) throws RegException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getNodeExecutionErrors(experimentId, workflowInstanceId, nodeId);
        }
        ArrayList result = new ArrayList();
        return null;
    }

    public List<ApplicationJobExecutionError> getApplicationJobErrors(String experimentId, String workflowInstanceId, String nodeId, String gfacJobId) throws RegException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getApplicationJobErrors(experimentId, workflowInstanceId, nodeId, gfacJobId);
        }
        ArrayList result = new ArrayList();
        return null;
    }

    public List<ApplicationJobExecutionError> getApplicationJobErrors(String gfacJobId) throws RegException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getApplicationJobErrors(gfacJobId);
        }
        return this.getApplicationJobErrors(null, null, null, gfacJobId);
    }

    public List<ExecutionError> getExecutionErrors(String experimentId, String workflowInstanceId, String nodeId, String gfacJobId, ExecutionErrors.Source ... filterBy) throws RegException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getExecutionErrors(experimentId, workflowInstanceId, nodeId, gfacJobId, filterBy);
        }
        ArrayList<ExecutionError> errors = new ArrayList<ExecutionError>();
        for (ExecutionErrors.Source sourceType : filterBy) {
            if (sourceType == ExecutionErrors.Source.ALL) {
                errors.addAll(this.getExperimentExecutionErrors(experimentId));
                errors.addAll(this.getWorkflowExecutionErrors(experimentId, workflowInstanceId));
                errors.addAll(this.getNodeExecutionErrors(experimentId, workflowInstanceId, nodeId));
                errors.addAll(this.getApplicationJobErrors(experimentId, workflowInstanceId, nodeId, gfacJobId));
                break;
            }
            if (sourceType == ExecutionErrors.Source.EXPERIMENT) {
                errors.addAll(this.getExperimentExecutionErrors(experimentId));
                continue;
            }
            if (sourceType == ExecutionErrors.Source.WORKFLOW) {
                errors.addAll(this.getWorkflowExecutionErrors(experimentId, workflowInstanceId));
                continue;
            }
            if (sourceType == ExecutionErrors.Source.NODE) {
                errors.addAll(this.getNodeExecutionErrors(experimentId, workflowInstanceId, nodeId));
                continue;
            }
            if (sourceType != ExecutionErrors.Source.APPLICATION) continue;
            errors.addAll(this.getApplicationJobErrors(experimentId, workflowInstanceId, nodeId, gfacJobId));
        }
        return errors;
    }

    public int addExperimentError(ExperimentExecutionError error) throws RegException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.addExperimentError(error);
        }
        return 0;
    }

    public int addWorkflowExecutionError(WorkflowExecutionError error) throws RegException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.addWorkflowExecutionError(error);
        }
        return 0;
    }

    public int addNodeExecutionError(NodeExecutionError error) throws RegException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.addNodeExecutionError(error);
        }
        return 0;
    }

    public int addApplicationJobExecutionError(ApplicationJobExecutionError error) throws RegException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.addApplicationJobExecutionError(error);
        }
        return 0;
    }

    public void addApplicationJob(ApplicationJob job) throws RegException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.addApplicationJob(job);
        }
        if (job.getJobId() == null || job.getJobId().equals("")) {
            throw new InvalidApplicationJobIDException();
        }
        if (this.isApplicationJobExists(job.getJobId())) {
            throw new ApplicationJobAlreadyExistsException(job.getJobId());
        }
    }

    public void updateApplicationJob(ApplicationJob job) throws RegException {
    }

    public void updateApplicationJobStatus(String gfacJobId, ApplicationJob.ApplicationJobStatus status, Date statusUpdateTime) throws RegException {
    }

    public void updateApplicationJobData(String gfacJobId, String jobdata) throws RegException {
    }

    public void updateApplicationJobSubmittedTime(String gfacJobId, Date submitted) throws RegException {
    }

    public void updateApplicationJobStatusUpdateTime(String gfacJobId, Date completed) throws RegException {
    }

    public void updateApplicationJobMetadata(String gfacJobId, String metadata) throws RegException {
    }

    public ApplicationJob getApplicationJob(String gfacJobId) throws RegException {
        return null;
    }

    public List<ApplicationJob> getApplicationJobsForDescriptors(String serviceDescriptionId, String hostDescriptionId, String applicationDescriptionId) throws RegException {
        ArrayList jobs = new ArrayList();
        return null;
    }

    public List<ApplicationJob> getApplicationJobs(String experimentId, String workflowExecutionId, String nodeId) throws RegException {
        ArrayList jobs = new ArrayList();
        if (workflowExecutionId == null) {
            if (!this.isExperimentExists(experimentId)) {
                throw new ExperimentDoesNotExistsException(experimentId);
            }
        } else if (nodeId == null) {
            if (!this.isWorkflowInstanceExists(workflowExecutionId)) {
                throw new WorkflowInstanceDoesNotExistsException(workflowExecutionId);
            }
        } else if (!this.isWorkflowInstanceNodePresent(workflowExecutionId, nodeId)) {
            throw new WorkflowInstanceNodeDoesNotExistsException(workflowExecutionId, nodeId);
        }
        return null;
    }

    public boolean isApplicationJobExists(String gfacJobId) throws RegException {
        return false;
    }

    public List<ApplicationJobStatusData> getApplicationJobStatusHistory(String jobId) throws RegException {
        ArrayList statusData = new ArrayList();
        return null;
    }

    public List<AiravataUser> getUsers() throws RegException {
        if (this.userRegistry != null) {
            return this.userRegistry.getUsers();
        }
        ArrayList<AiravataUser> result = new ArrayList<AiravataUser>();
        List<Resource> users = null;
        try {
            users = this.jpa.getGateway().get(ResourceType.USER);
            for (Resource resource : users) {
                UserResource userRes = (UserResource)resource;
                AiravataUser user = new AiravataUser(userRes.getUserName());
                result.add(user);
            }
        }
        catch (RegistryException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean isCredentialExist(String gatewayId, String tokenId) throws RegException {
        try {
            this.credentialReader = new CredentialReaderImpl(AiravataJPARegistry.getDBConnector());
            SSHCredential credential = (SSHCredential)this.credentialReader.getCredential(gatewayId, tokenId);
            if (credential != null) {
                return true;
            }
        }
        catch (ApplicationSettingsException e1) {
            return false;
        }
        catch (CredentialStoreException e) {
            return false;
        }
        return false;
    }

    public String getCredentialPublicKey(String gatewayId, String tokenId) throws RegException {
        try {
            this.credentialReader = new CredentialReaderImpl(AiravataJPARegistry.getDBConnector());
            SSHCredential credential = (SSHCredential)this.credentialReader.getCredential(gatewayId, tokenId);
            if (credential != null) {
                return new String(credential.getPublicKey());
            }
        }
        catch (ApplicationSettingsException e1) {
            return null;
        }
        catch (CredentialStoreException e) {
            return null;
        }
        return null;
    }

    public String createCredential(String gatewayId, String tokenId) throws RegException {
        return this.createCredential(gatewayId, tokenId, null);
    }

    public String createCredential(String gatewayId, String tokenId, String username) throws RegException {
        try {
            this.credentialWriter = new SSHCredentialWriter(AiravataJPARegistry.getDBConnector());
            this.credentialGenerator = new SSHCredentialGenerator();
            SSHCredential credential = this.credentialGenerator.generateCredential(tokenId);
            if (credential != null) {
                credential.setGateway(gatewayId);
                credential.setToken(tokenId);
                credential.setPortalUserName(username);
                this.credentialWriter.writeCredentials((Credential)credential);
                return new String(credential.getPublicKey());
            }
        }
        catch (ApplicationSettingsException e1) {
            return null;
        }
        catch (CredentialStoreException e) {
            return null;
        }
        return null;
    }

    private static DBUtil getDBConnector() throws RegException {
        try {
            String jdbcUrl = ServerSettings.getCredentialStoreDBURL();
            String jdbcUsr = ServerSettings.getCredentialStoreDBUser();
            String jdbcPass = ServerSettings.getCredentialStoreDBPassword();
            String driver = ServerSettings.getCredentialStoreDBDriver();
            return new DBUtil(jdbcUrl, jdbcUsr, jdbcPass, driver);
        }
        catch (InstantiationException e) {
            logger.error("Error while accesing registrty settings ", (Throwable)e);
            throw new RegException("Error while accesing registrty settings ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error("Error while reading registrty settings ", (Throwable)e);
            throw new RegException("Error while accesing registrty settings ", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error("Error while reading registrty settings ", (Throwable)e);
            throw new RegException("Error while accesing registrty settings ", (Throwable)e);
        }
        catch (RegistrySettingsException e) {
            logger.error("Error while reading registrty settings ", (Throwable)e);
            throw new RegException("Error while accesing registrty settings ", (Throwable)e);
        }
        catch (ApplicationSettingsException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<URI> getLiveGFacURIs() throws RegException {
        return null;
    }

    public Map<String, Integer> getGFACNodeList() throws RegException {
        return null;
    }

    public boolean addGFACNode(String uri, int nodeID) throws RegException {
        return false;
    }

    public boolean changeStatus(String experimentID, AiravataJobState.State state) throws RegException {
        GatewayResource gateway = this.jpa.getGateway();
        return true;
    }

    public boolean changeStatus(String experimentID, AiravataJobState.State state, String gfacEPR) throws RegException {
        GatewayResource gateway = this.jpa.getGateway();
        return true;
    }

    public AiravataJobState getState(String experimentID) throws RegException {
        GatewayResource gateway = this.jpa.getGateway();
        return null;
    }

    public List<String> getAllJobsWithState(AiravataJobState state) throws RuntimeException {
        ArrayList<String> jobsWithStatus = new ArrayList<String>();
        return jobsWithStatus;
    }

    public List<String> getAllAcceptedJobs() throws RegException {
        ArrayList<String> acceptedJobIds = new ArrayList<String>();
        return acceptedJobIds;
    }

    public List<String> getAllHangedJobs() throws RegException {
        ArrayList<String> hangedJobIds = new ArrayList<String>();
        return hangedJobIds;
    }

    public int getHangedJobCount() throws RegException {
        return 0;
    }

    public boolean resetHangedJob(String experimentID) throws RegException {
        try {
            GatewayResource gatewayResource = this.jpa.getGateway();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        CONNECT_FAIL_WAIT_TIME = 1000;
        MAX_TRIES = 15;
        API_VERSION = new Version("Airavata Registry API", Integer.valueOf(0), Integer.valueOf(12), null, null, null);
        compatibleVersionMap = new HashMap<String, String[]>();
        compatibleVersionMap.put("0.6", new String[]{"0.6"});
        compatibleVersionMap.put("0.7", new String[]{"0.6", "0.7"});
        compatibleVersionMap.put("0.8", new String[]{"0.8"});
        compatibleVersionMap.put("0.9", new String[]{"0.9", "0.8"});
        compatibleVersionMap.put("0.10", new String[]{"0.10", "0.9", "0.8"});
        compatibleVersionMap.put("0.11", new String[]{"0.11", "0.10", "0.9", "0.8"});
        compatibleVersionMap.put("0.12", new String[]{"0.12"});
    }
}

