/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.AdvancedInputDataHandling;
import org.apache.airavata.persistance.registry.jpa.model.AdvancedOutputDataHandling;
import org.apache.airavata.persistance.registry.jpa.model.Computational_Resource_Scheduling;
import org.apache.airavata.persistance.registry.jpa.model.ErrorDetail;
import org.apache.airavata.persistance.registry.jpa.model.Experiment;
import org.apache.airavata.persistance.registry.jpa.model.ExperimentConfigData;
import org.apache.airavata.persistance.registry.jpa.model.Experiment_Input;
import org.apache.airavata.persistance.registry.jpa.model.Experiment_Output;
import org.apache.airavata.persistance.registry.jpa.model.Gateway;
import org.apache.airavata.persistance.registry.jpa.model.Project;
import org.apache.airavata.persistance.registry.jpa.model.QosParam;
import org.apache.airavata.persistance.registry.jpa.model.Status;
import org.apache.airavata.persistance.registry.jpa.model.Users;
import org.apache.airavata.persistance.registry.jpa.model.WorkflowNodeDetail;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.AdvanceInputDataHandlingResource;
import org.apache.airavata.persistance.registry.jpa.resources.AdvancedOutputDataHandlingResource;
import org.apache.airavata.persistance.registry.jpa.resources.ComputationSchedulingResource;
import org.apache.airavata.persistance.registry.jpa.resources.ConfigDataResource;
import org.apache.airavata.persistance.registry.jpa.resources.ErrorDetailResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentInputResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentOutputResource;
import org.apache.airavata.persistance.registry.jpa.resources.GatewayResource;
import org.apache.airavata.persistance.registry.jpa.resources.ProjectResource;
import org.apache.airavata.persistance.registry.jpa.resources.QosParamResource;
import org.apache.airavata.persistance.registry.jpa.resources.StatusResource;
import org.apache.airavata.persistance.registry.jpa.resources.Utils;
import org.apache.airavata.persistance.registry.jpa.resources.WorkflowNodeDetailResource;
import org.apache.airavata.persistance.registry.jpa.utils.QueryGenerator;
import org.apache.airavata.registry.cpi.RegistryException;
import org.apache.airavata.registry.cpi.utils.StatusType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ExperimentResource.class);
    private String executionUser;
    private String expID;
    private Timestamp creationTime;
    private GatewayResource gateway;
    private ProjectResource project;
    private String expName;
    private String description;
    private String applicationId;
    private String applicationVersion;
    private String workflowTemplateId;
    private String workflowTemplateVersion;
    private String workflowExecutionId;

    public String getExpID() {
        return this.expID;
    }

    public Timestamp getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Timestamp creationTime) {
        this.creationTime = creationTime;
    }

    public String getExpName() {
        return this.expName;
    }

    public void setExpName(String expName) {
        this.expName = expName;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public String getWorkflowTemplateId() {
        return this.workflowTemplateId;
    }

    public void setWorkflowTemplateId(String workflowTemplateId) {
        this.workflowTemplateId = workflowTemplateId;
    }

    public String getWorkflowTemplateVersion() {
        return this.workflowTemplateVersion;
    }

    public void setWorkflowTemplateVersion(String workflowTemplateVersion) {
        this.workflowTemplateVersion = workflowTemplateVersion;
    }

    public String getWorkflowExecutionId() {
        return this.workflowExecutionId;
    }

    public void setWorkflowExecutionId(String workflowExecutionId) {
        this.workflowExecutionId = workflowExecutionId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        switch (type) {
            case EXPERIMENT_INPUT: {
                ExperimentInputResource inputResource = new ExperimentInputResource();
                inputResource.setExperimentResource(this);
                return inputResource;
            }
            case EXPERIMENT_OUTPUT: {
                ExperimentOutputResource experimentOutputResource = new ExperimentOutputResource();
                experimentOutputResource.setExperimentResource(this);
                return experimentOutputResource;
            }
            case WORKFLOW_NODE_DETAIL: {
                WorkflowNodeDetailResource nodeDetailResource = new WorkflowNodeDetailResource();
                nodeDetailResource.setExperimentResource(this);
                return nodeDetailResource;
            }
            case ERROR_DETAIL: {
                ErrorDetailResource errorDetailResource = new ErrorDetailResource();
                errorDetailResource.setExperimentResource(this);
                return errorDetailResource;
            }
            case STATUS: {
                StatusResource statusResource = new StatusResource();
                statusResource.setExperimentResource(this);
                return statusResource;
            }
            case CONFIG_DATA: {
                ConfigDataResource configDataResource = new ConfigDataResource();
                configDataResource.setExperimentResource(this);
                return configDataResource;
            }
            case COMPUTATIONAL_RESOURCE_SCHEDULING: {
                ComputationSchedulingResource schedulingResource = new ComputationSchedulingResource();
                schedulingResource.setExperimentResource(this);
                return schedulingResource;
            }
            case ADVANCE_INPUT_DATA_HANDLING: {
                AdvanceInputDataHandlingResource dataHandlingResource = new AdvanceInputDataHandlingResource();
                dataHandlingResource.setExperimentResource(this);
                return dataHandlingResource;
            }
            case ADVANCE_OUTPUT_DATA_HANDLING: {
                AdvancedOutputDataHandlingResource outputDataHandlingResource = new AdvancedOutputDataHandlingResource();
                outputDataHandlingResource.setExperimentResource(this);
                return outputDataHandlingResource;
            }
            case QOS_PARAM: {
                QosParamResource qosParamResource = new QosParamResource();
                qosParamResource.setExperimentResource(this);
                return qosParamResource;
            }
        }
        logger.error("Unsupported resource type for experiment resource.", (Throwable)new IllegalArgumentException());
        throw new IllegalArgumentException("Unsupported resource type for experiment resource.");
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case EXPERIMENT_INPUT: {
                    QueryGenerator generator = new QueryGenerator("Experiment_Input", new Object[0][]);
                    generator.setParameter("experiment_id", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case EXPERIMENT_OUTPUT: {
                    QueryGenerator generator = new QueryGenerator("Experiment_Output", new Object[0][]);
                    generator.setParameter("experiment_id", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case WORKFLOW_NODE_DETAIL: {
                    QueryGenerator generator = new QueryGenerator("WorkflowNodeDetail", new Object[0][]);
                    generator.setParameter("nodeId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case ERROR_DETAIL: {
                    QueryGenerator generator = new QueryGenerator("ErrorDetail", new Object[0][]);
                    generator.setParameter("expId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case STATUS: {
                    QueryGenerator generator = new QueryGenerator("Status", new Object[0][]);
                    generator.setParameter("expId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case CONFIG_DATA: {
                    QueryGenerator generator = new QueryGenerator("ExperimentConfigData", new Object[0][]);
                    generator.setParameter("expId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case COMPUTATIONAL_RESOURCE_SCHEDULING: {
                    QueryGenerator generator = new QueryGenerator("Computational_Resource_Scheduling", new Object[0][]);
                    generator.setParameter("expId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case ADVANCE_INPUT_DATA_HANDLING: {
                    QueryGenerator generator = new QueryGenerator("AdvancedInputDataHandling", new Object[0][]);
                    generator.setParameter("expId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case ADVANCE_OUTPUT_DATA_HANDLING: {
                    QueryGenerator generator = new QueryGenerator("AdvancedOutputDataHandling", new Object[0][]);
                    generator.setParameter("expId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case QOS_PARAM: {
                    QueryGenerator generator = new QueryGenerator("QosParam", new Object[0][]);
                    generator.setParameter("expId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                default: {
                    logger.error("Unsupported resource type for experiment resource.", (Throwable)new IllegalArgumentException());
                }
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case EXPERIMENT_INPUT: {
                    QueryGenerator generator = new QueryGenerator("Experiment_Input", new Object[0][]);
                    generator.setParameter("experiment_id", name);
                    Query q = generator.selectQuery(em);
                    Experiment_Input experimentInput = (Experiment_Input)q.getSingleResult();
                    ExperimentInputResource inputResource = (ExperimentInputResource)Utils.getResource(ResourceType.EXPERIMENT_INPUT, experimentInput);
                    em.getTransaction().commit();
                    em.close();
                    ExperimentInputResource experimentInputResource = inputResource;
                    return experimentInputResource;
                }
                case EXPERIMENT_OUTPUT: {
                    QueryGenerator generator = new QueryGenerator("Experiment_Output", new Object[0][]);
                    generator.setParameter("experiment_id", name);
                    Query q = generator.selectQuery(em);
                    Experiment_Output experimentOutput = (Experiment_Output)q.getSingleResult();
                    ExperimentOutputResource outputResource = (ExperimentOutputResource)Utils.getResource(ResourceType.EXPERIMENT_OUTPUT, experimentOutput);
                    em.getTransaction().commit();
                    em.close();
                    ExperimentOutputResource experimentOutputResource = outputResource;
                    return experimentOutputResource;
                }
                case WORKFLOW_NODE_DETAIL: {
                    QueryGenerator generator = new QueryGenerator("WorkflowNodeDetail", new Object[0][]);
                    generator.setParameter("nodeId", name);
                    Query q = generator.selectQuery(em);
                    WorkflowNodeDetail workflowNodeDetail = (WorkflowNodeDetail)q.getSingleResult();
                    WorkflowNodeDetailResource nodeDetailResource = (WorkflowNodeDetailResource)Utils.getResource(ResourceType.WORKFLOW_NODE_DETAIL, workflowNodeDetail);
                    em.getTransaction().commit();
                    em.close();
                    WorkflowNodeDetailResource workflowNodeDetailResource = nodeDetailResource;
                    return workflowNodeDetailResource;
                }
                case ERROR_DETAIL: {
                    QueryGenerator generator = new QueryGenerator("ErrorDetail", new Object[0][]);
                    generator.setParameter("expId", name);
                    Query q = generator.selectQuery(em);
                    ErrorDetail errorDetail = (ErrorDetail)q.getSingleResult();
                    ErrorDetailResource errorDetailResource = (ErrorDetailResource)Utils.getResource(ResourceType.ERROR_DETAIL, errorDetail);
                    em.getTransaction().commit();
                    em.close();
                    ErrorDetailResource errorDetailResource2 = errorDetailResource;
                    return errorDetailResource2;
                }
                case STATUS: {
                    QueryGenerator generator = new QueryGenerator("Status", new Object[0][]);
                    generator.setParameter("expId", name);
                    Query q = generator.selectQuery(em);
                    Status status = (Status)q.getSingleResult();
                    StatusResource statusResource = (StatusResource)Utils.getResource(ResourceType.STATUS, status);
                    em.getTransaction().commit();
                    em.close();
                    StatusResource statusResource2 = statusResource;
                    return statusResource2;
                }
                case CONFIG_DATA: {
                    QueryGenerator generator = new QueryGenerator("ExperimentConfigData", new Object[0][]);
                    generator.setParameter("expId", name);
                    Query q = generator.selectQuery(em);
                    ExperimentConfigData configData = (ExperimentConfigData)q.getSingleResult();
                    ConfigDataResource configDataResource = (ConfigDataResource)Utils.getResource(ResourceType.CONFIG_DATA, configData);
                    em.getTransaction().commit();
                    em.close();
                    ConfigDataResource configDataResource2 = configDataResource;
                    return configDataResource2;
                }
                case COMPUTATIONAL_RESOURCE_SCHEDULING: {
                    QueryGenerator generator = new QueryGenerator("Computational_Resource_Scheduling", new Object[0][]);
                    generator.setParameter("expId", name);
                    generator.setParameter("taskId", null);
                    Query q = generator.selectQuery(em);
                    Computational_Resource_Scheduling scheduling = (Computational_Resource_Scheduling)q.getSingleResult();
                    ComputationSchedulingResource schedulingResource = (ComputationSchedulingResource)Utils.getResource(ResourceType.COMPUTATIONAL_RESOURCE_SCHEDULING, scheduling);
                    em.getTransaction().commit();
                    em.close();
                    ComputationSchedulingResource computationSchedulingResource = schedulingResource;
                    return computationSchedulingResource;
                }
                case ADVANCE_INPUT_DATA_HANDLING: {
                    QueryGenerator generator = new QueryGenerator("AdvancedInputDataHandling", new Object[0][]);
                    generator.setParameter("expId", name);
                    generator.setParameter("taskId", null);
                    Query q = generator.selectQuery(em);
                    AdvancedInputDataHandling inputDataHandling = (AdvancedInputDataHandling)q.getSingleResult();
                    AdvanceInputDataHandlingResource dataHandlingResource = (AdvanceInputDataHandlingResource)Utils.getResource(ResourceType.ADVANCE_INPUT_DATA_HANDLING, inputDataHandling);
                    em.getTransaction().commit();
                    em.close();
                    AdvanceInputDataHandlingResource advanceInputDataHandlingResource = dataHandlingResource;
                    return advanceInputDataHandlingResource;
                }
                case ADVANCE_OUTPUT_DATA_HANDLING: {
                    QueryGenerator generator = new QueryGenerator("AdvancedOutputDataHandling", new Object[0][]);
                    generator.setParameter("expId", name);
                    generator.setParameter("taskId", null);
                    Query q = generator.selectQuery(em);
                    AdvancedOutputDataHandling outputDataHandling = (AdvancedOutputDataHandling)q.getSingleResult();
                    AdvancedOutputDataHandlingResource outputDataHandlingResource = (AdvancedOutputDataHandlingResource)Utils.getResource(ResourceType.ADVANCE_OUTPUT_DATA_HANDLING, outputDataHandling);
                    em.getTransaction().commit();
                    em.close();
                    AdvancedOutputDataHandlingResource advancedOutputDataHandlingResource = outputDataHandlingResource;
                    return advancedOutputDataHandlingResource;
                }
                case QOS_PARAM: {
                    QueryGenerator generator = new QueryGenerator("QosParam", new Object[0][]);
                    generator.setParameter("expId", name);
                    generator.setParameter("taskId", null);
                    Query q = generator.selectQuery(em);
                    QosParam qosParam = (QosParam)q.getSingleResult();
                    QosParamResource qosParamResource = (QosParamResource)Utils.getResource(ResourceType.QOS_PARAM, qosParam);
                    em.getTransaction().commit();
                    em.close();
                    QosParamResource qosParamResource2 = qosParamResource;
                    return qosParamResource2;
                }
            }
            try {
                em.getTransaction().commit();
                em.close();
                logger.error("Unsupported resource type for experiment resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for experiment data resource.");
            }
            catch (Exception e) {
                throw new RegistryException((Throwable)e);
            }
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case EXPERIMENT_INPUT: {
                    QueryGenerator generator = new QueryGenerator("Experiment_Input", new Object[0][]);
                    generator.setParameter("experiment_id", this.expID);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        Experiment_Input exInput = (Experiment_Input)result;
                        ExperimentInputResource inputResource = (ExperimentInputResource)Utils.getResource(ResourceType.EXPERIMENT_INPUT, exInput);
                        resourceList.add(inputResource);
                    }
                    break;
                }
                case EXPERIMENT_OUTPUT: {
                    QueryGenerator generator = new QueryGenerator("Experiment_Output", new Object[0][]);
                    generator.setParameter("experiment_id", this.expID);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        Experiment_Output output = (Experiment_Output)result;
                        ExperimentOutputResource outputResource = (ExperimentOutputResource)Utils.getResource(ResourceType.EXPERIMENT_OUTPUT, output);
                        resourceList.add(outputResource);
                    }
                    break;
                }
                case WORKFLOW_NODE_DETAIL: {
                    QueryGenerator generator = new QueryGenerator("WorkflowNodeDetail", new Object[0][]);
                    generator.setParameter("expId", this.expID);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        WorkflowNodeDetail nodeDetail = (WorkflowNodeDetail)result;
                        WorkflowNodeDetailResource nodeDetailResource = (WorkflowNodeDetailResource)Utils.getResource(ResourceType.WORKFLOW_NODE_DETAIL, nodeDetail);
                        resourceList.add(nodeDetailResource);
                    }
                    break;
                }
                case ERROR_DETAIL: {
                    QueryGenerator generator = new QueryGenerator("ErrorDetail", new Object[0][]);
                    generator.setParameter("expId", this.expID);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        ErrorDetail errorDetail = (ErrorDetail)result;
                        ErrorDetailResource errorDetailResource = (ErrorDetailResource)Utils.getResource(ResourceType.ERROR_DETAIL, errorDetail);
                        resourceList.add(errorDetailResource);
                    }
                    break;
                }
                case STATUS: {
                    QueryGenerator generator = new QueryGenerator("Status", new Object[0][]);
                    generator.setParameter("expId", this.expID);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        Status status = (Status)result;
                        StatusResource statusResource = (StatusResource)Utils.getResource(ResourceType.STATUS, status);
                        resourceList.add(statusResource);
                    }
                    break;
                }
                default: {
                    em.getTransaction().commit();
                    em.close();
                    logger.error("Unsupported resource type for experiment resource.", (Throwable)new UnsupportedOperationException());
                    throw new UnsupportedOperationException();
                }
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return resourceList;
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            Experiment existingExp = (Experiment)em.find(Experiment.class, (Object)this.expID);
            em.close();
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Experiment experiment = new Experiment();
            Project projectmodel = (Project)em.find(Project.class, (Object)this.project.getId());
            experiment.setProject(projectmodel);
            experiment.setProjectId(projectmodel.getProject_id());
            Gateway gateway = (Gateway)em.find(Gateway.class, (Object)this.getGateway().getGatewayName());
            experiment.setExpId(this.expID);
            experiment.setExecutionUser(this.executionUser);
            Users userModel = (Users)em.find(Users.class, (Object)this.executionUser);
            experiment.setUser(userModel);
            experiment.setExecutionUser(userModel.getUser_name());
            experiment.setGateway(gateway);
            experiment.setGatewayName(gateway.getGateway_name());
            experiment.setCreationTime(this.creationTime);
            experiment.setExpName(this.expName);
            experiment.setExpDesc(this.description);
            experiment.setApplicationId(this.applicationId);
            experiment.setAppVersion(this.applicationVersion);
            experiment.setWorkflowExecutionId(this.workflowExecutionId);
            experiment.setWorkflowTemplateVersion(this.workflowTemplateVersion);
            experiment.setWorkflowExecutionId(this.workflowExecutionId);
            if (existingExp != null) {
                existingExp.setGateway(gateway);
                existingExp.setGatewayName(gateway.getGateway_name());
                existingExp.setProject(projectmodel);
                existingExp.setExecutionUser(this.executionUser);
                existingExp.setUser(userModel);
                existingExp.setProjectId(projectmodel.getProject_id());
                existingExp.setCreationTime(this.creationTime);
                existingExp.setExpName(this.expName);
                existingExp.setExpDesc(this.description);
                existingExp.setApplicationId(this.applicationId);
                existingExp.setAppVersion(this.applicationVersion);
                existingExp.setWorkflowExecutionId(this.workflowExecutionId);
                existingExp.setWorkflowTemplateVersion(this.workflowTemplateVersion);
                existingExp.setWorkflowExecutionId(this.workflowExecutionId);
                experiment = (Experiment)em.merge((Object)existingExp);
            } else {
                em.persist((Object)experiment);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public void setExpID(String expID) {
        this.expID = expID;
    }

    public GatewayResource getGateway() {
        return this.gateway;
    }

    public void setGateway(GatewayResource gateway) {
        this.gateway = gateway;
    }

    public String getExecutionUser() {
        return this.executionUser;
    }

    public void setExecutionUser(String executionUser) {
        this.executionUser = executionUser;
    }

    public ProjectResource getProject() {
        return this.project;
    }

    public void setProject(ProjectResource project) {
        this.project = project;
    }

    public List<ExperimentInputResource> getExperimentInputs() throws RegistryException {
        ArrayList<ExperimentInputResource> expInputs = new ArrayList<ExperimentInputResource>();
        List<Resource> resources = this.get(ResourceType.EXPERIMENT_INPUT);
        for (Resource resource : resources) {
            expInputs.add((ExperimentInputResource)resource);
        }
        return expInputs;
    }

    public List<ExperimentOutputResource> getExperimentOutputs() throws RegistryException {
        ArrayList<ExperimentOutputResource> expOutputs = new ArrayList<ExperimentOutputResource>();
        List<Resource> resources = this.get(ResourceType.EXPERIMENT_OUTPUT);
        for (Resource resource : resources) {
            expOutputs.add((ExperimentOutputResource)resource);
        }
        return expOutputs;
    }

    public StatusResource getExperimentStatus() throws RegistryException {
        List<Resource> resources = this.get(ResourceType.STATUS);
        for (Resource resource : resources) {
            StatusResource expStatus = (StatusResource)resource;
            if (!expStatus.getStatusType().equals(StatusType.EXPERIMENT.toString())) continue;
            if (expStatus.getState() == null || expStatus.getState().equals("")) {
                expStatus.setState("UNKNOWN");
            }
            return expStatus;
        }
        return null;
    }

    public List<StatusResource> getWorkflowNodeStatuses() throws RegistryException {
        ArrayList<StatusResource> statuses = new ArrayList<StatusResource>();
        List<Resource> resources = this.get(ResourceType.STATUS);
        for (Resource resource : resources) {
            StatusResource workflowNodeStatus = (StatusResource)resource;
            if (!workflowNodeStatus.getStatusType().equals(StatusType.WORKFLOW_NODE.toString())) continue;
            if (workflowNodeStatus.getState() == null || workflowNodeStatus.getState().equals("")) {
                workflowNodeStatus.setState("UNKNOWN");
            }
            statuses.add(workflowNodeStatus);
        }
        return statuses;
    }

    public List<WorkflowNodeDetailResource> getWorkflowNodeDetails() throws RegistryException {
        ArrayList<WorkflowNodeDetailResource> workflowNodeDetailResourceList = new ArrayList<WorkflowNodeDetailResource>();
        List<Resource> resources = this.get(ResourceType.WORKFLOW_NODE_DETAIL);
        for (Resource resource : resources) {
            WorkflowNodeDetailResource nodeDetailResource = (WorkflowNodeDetailResource)resource;
            workflowNodeDetailResourceList.add(nodeDetailResource);
        }
        return workflowNodeDetailResourceList;
    }

    public List<ErrorDetailResource> getErrorDetails() throws RegistryException {
        ArrayList<ErrorDetailResource> errorDetailResources = new ArrayList<ErrorDetailResource>();
        List<Resource> resources = this.get(ResourceType.ERROR_DETAIL);
        for (Resource resource : resources) {
            ErrorDetailResource errorDetailResource = (ErrorDetailResource)resource;
            errorDetailResources.add(errorDetailResource);
        }
        return errorDetailResources;
    }

    public ComputationSchedulingResource getComputationScheduling(String expId) throws RegistryException {
        return (ComputationSchedulingResource)this.get(ResourceType.COMPUTATIONAL_RESOURCE_SCHEDULING, expId);
    }

    public AdvanceInputDataHandlingResource getInputDataHandling(String expId) throws RegistryException {
        return (AdvanceInputDataHandlingResource)this.get(ResourceType.ADVANCE_INPUT_DATA_HANDLING, expId);
    }

    public AdvancedOutputDataHandlingResource getOutputDataHandling(String expId) throws RegistryException {
        return (AdvancedOutputDataHandlingResource)this.get(ResourceType.ADVANCE_OUTPUT_DATA_HANDLING, expId);
    }

    public QosParamResource getQOSparams(String expId) throws RegistryException {
        return (QosParamResource)this.get(ResourceType.QOS_PARAM, expId);
    }

    public ConfigDataResource getUserConfigData(String expID) throws RegistryException {
        return (ConfigDataResource)this.get(ResourceType.CONFIG_DATA, expID);
    }

    public WorkflowNodeDetailResource getWorkflowNode(String nodeId) throws RegistryException {
        return (WorkflowNodeDetailResource)this.get(ResourceType.WORKFLOW_NODE_DETAIL, nodeId);
    }
}

