/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Experiment;
import org.apache.airavata.persistance.registry.jpa.model.Gateway;
import org.apache.airavata.persistance.registry.jpa.model.Project;
import org.apache.airavata.persistance.registry.jpa.model.ProjectUser;
import org.apache.airavata.persistance.registry.jpa.model.Users;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentResource;
import org.apache.airavata.persistance.registry.jpa.resources.GatewayResource;
import org.apache.airavata.persistance.registry.jpa.resources.ProjectUserResource;
import org.apache.airavata.persistance.registry.jpa.resources.Utils;
import org.apache.airavata.persistance.registry.jpa.resources.WorkerResource;
import org.apache.airavata.persistance.registry.jpa.utils.QueryGenerator;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ProjectResource.class);
    private String name;
    private String id;
    private GatewayResource gateway;
    private WorkerResource worker;
    private String description;
    private Timestamp creationTime;

    public ProjectResource() {
    }

    public ProjectResource(WorkerResource worker, GatewayResource gateway, String projectId) {
        this.setWorker(worker);
        this.setGateway(gateway);
        this.id = projectId;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        if (type == ResourceType.EXPERIMENT) {
            ExperimentResource experimentResource = new ExperimentResource();
            experimentResource.setGateway(this.getGateway());
            experimentResource.setExecutionUser(this.worker.getUser());
            experimentResource.setProject(this);
            return experimentResource;
        }
        if (type == ResourceType.PROJECT_USER) {
            ProjectUserResource pr = new ProjectUserResource();
            pr.setProjectId(this.id);
            pr.setUserName(this.worker.getUser());
            return pr;
        }
        logger.error("Unsupported resource type for project resource.", (Throwable)new IllegalArgumentException());
        throw new IllegalArgumentException("Unsupported resource type for project resource.");
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            if (type == ResourceType.EXPERIMENT) {
                QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
                generator.setParameter("expId", name);
                Query q = generator.deleteQuery(em);
                q.executeUpdate();
            } else if (type == ResourceType.PROJECT_USER) {
                QueryGenerator generator = new QueryGenerator("ProjectUser", new Object[0][]);
                generator.setParameter("userName", name);
                generator.setParameter("projectID", this.id);
                Query q = generator.deleteQuery(em);
                q.executeUpdate();
            } else {
                logger.error("Unsupported resource type for project resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for project resource.");
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            if (type == ResourceType.EXPERIMENT) {
                em = ResourceUtils.getEntityManager();
                em.getTransaction().begin();
                QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
                generator.setParameter("expId", name);
                Query q = generator.selectQuery(em);
                Experiment experiment = (Experiment)q.getSingleResult();
                ExperimentResource experimentResource = (ExperimentResource)Utils.getResource(ResourceType.EXPERIMENT, experiment);
                em.getTransaction().commit();
                em.close();
                ExperimentResource experimentResource2 = experimentResource;
                return experimentResource2;
            }
            if (type == ResourceType.PROJECT_USER) {
                em = ResourceUtils.getEntityManager();
                em.getTransaction().begin();
                QueryGenerator generator = new QueryGenerator("ProjectUser", new Object[0][]);
                generator.setParameter("userName", name);
                generator.setParameter("projectID", this.id);
                Query q = generator.selectQuery(em);
                ProjectUser prUser = (ProjectUser)q.getSingleResult();
                ExperimentResource experimentResource = (ExperimentResource)Utils.getResource(ResourceType.PROJECT_USER, prUser);
                em.getTransaction().commit();
                em.close();
                ExperimentResource experimentResource3 = experimentResource;
                return experimentResource3;
            }
            try {
                logger.error("Unsupported resource type for project resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for project resource.");
            }
            catch (Exception e) {
                throw new RegistryException((Throwable)e);
            }
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        ArrayList<Resource> resourceList;
        block13: {
            resourceList = new ArrayList<Resource>();
            EntityManager em = null;
            try {
                if (type == ResourceType.EXPERIMENT) {
                    em = ResourceUtils.getEntityManager();
                    em.getTransaction().begin();
                    QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
                    generator.setParameter("projectID", this.id);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() != 0) {
                        for (Object result : results) {
                            Experiment experiment = (Experiment)result;
                            ExperimentResource experimentResource = (ExperimentResource)Utils.getResource(ResourceType.EXPERIMENT, experiment);
                            resourceList.add(experimentResource);
                        }
                    }
                    em.getTransaction().commit();
                    em.close();
                    break block13;
                }
                if (type == ResourceType.PROJECT_USER) {
                    em = ResourceUtils.getEntityManager();
                    em.getTransaction().begin();
                    QueryGenerator generator = new QueryGenerator("ProjectUser", new Object[0][]);
                    generator.setParameter("projectID", this.id);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() != 0) {
                        for (Object result : results) {
                            ProjectUser projectUser = (ProjectUser)result;
                            ProjectUserResource pr = (ProjectUserResource)Utils.getResource(ResourceType.PROJECT_USER, projectUser);
                            resourceList.add(pr);
                        }
                    }
                    em.getTransaction().commit();
                    em.close();
                    break block13;
                }
                logger.error("Unsupported resource type for project resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for project resource.");
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RegistryException((Throwable)e);
            }
            finally {
                if (em != null && em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
            }
        }
        return resourceList;
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            Project existingProject = (Project)em.find(Project.class, (Object)this.id);
            em.close();
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Project project = new Project();
            project.setProject_id(this.id);
            project.setProject_name(this.name);
            Gateway modelGateway = (Gateway)em.find(Gateway.class, (Object)this.gateway.getGatewayName());
            project.setGateway(modelGateway);
            Users user = (Users)em.find(Users.class, (Object)this.worker.getUser());
            project.setUsers(user);
            project.setUser_name(user.getUser_name());
            project.setDescription(this.description);
            project.setCreationTime(this.creationTime);
            if (existingProject != null) {
                existingProject.setProject_name(this.name);
                existingProject.setGateway(modelGateway);
                existingProject.setUsers(user);
                existingProject.setUser_name(user.getUser_name());
                existingProject.setDescription(this.description);
                existingProject.setCreationTime(this.creationTime);
                project = (Project)em.merge((Object)existingProject);
            } else {
                em.persist((Object)project);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkerResource getWorker() {
        return this.worker;
    }

    public void setWorker(WorkerResource worker) {
        this.worker = worker;
    }

    public GatewayResource getGateway() {
        return this.gateway;
    }

    public void setGateway(GatewayResource gateway) {
        this.gateway = gateway;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Timestamp getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Timestamp creationTime) {
        this.creationTime = creationTime;
    }

    public boolean isExperimentExists(String experimentId) throws RegistryException {
        return this.isExists(ResourceType.EXPERIMENT, experimentId);
    }

    public ExperimentResource createExperiment(String experimentId) throws RegistryException {
        ExperimentResource experimentResource = (ExperimentResource)this.create(ResourceType.EXPERIMENT);
        experimentResource.setExpID(experimentId);
        return experimentResource;
    }

    public ExperimentResource getExperiment(String experimentId) throws RegistryException {
        return (ExperimentResource)this.get(ResourceType.EXPERIMENT, experimentId);
    }

    public List<ExperimentResource> getExperiments() throws RegistryException {
        List<Resource> list = this.get(ResourceType.EXPERIMENT);
        ArrayList<ExperimentResource> result = new ArrayList<ExperimentResource>();
        for (Resource resource : list) {
            result.add((ExperimentResource)resource);
        }
        return result;
    }

    public void removeExperiment(String experimentId) throws RegistryException {
        this.remove(ResourceType.EXPERIMENT, experimentId);
    }

    public List<ProjectUserResource> getProjectUserList() throws RegistryException {
        List<Resource> resources = this.get(ResourceType.PROJECT_USER);
        ArrayList<ProjectUserResource> projectUserResources = new ArrayList<ProjectUserResource>();
        if (resources != null && !resources.isEmpty()) {
            for (Resource r : resources) {
                projectUserResources.add((ProjectUserResource)r);
            }
        }
        return projectUserResources;
    }
}

