/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Application_Descriptor;
import org.apache.airavata.persistance.registry.jpa.model.Gateway;
import org.apache.airavata.persistance.registry.jpa.model.Service_Descriptor;
import org.apache.airavata.persistance.registry.jpa.model.Service_Descriptor_PK;
import org.apache.airavata.persistance.registry.jpa.model.Users;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.ApplicationDescriptorResource;
import org.apache.airavata.persistance.registry.jpa.resources.Utils;
import org.apache.airavata.persistance.registry.jpa.utils.QueryGenerator;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDescriptorResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ServiceDescriptorResource.class);
    private String serviceDescName;
    private String gatewayName;
    private String userName;
    private String content;

    public String getGatewayName() {
        return this.gatewayName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setGatewayName(String gatewayName) {
        this.gatewayName = gatewayName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getServiceDescName() {
        return this.serviceDescName;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        if (type == ResourceType.APPLICATION_DESCRIPTOR) {
            ApplicationDescriptorResource applicationDescriptorResource = new ApplicationDescriptorResource();
            applicationDescriptorResource.setGatewayName(this.gatewayName);
            applicationDescriptorResource.setHostDescName(this.getServiceDescName());
            return applicationDescriptorResource;
        }
        logger.error("Unsupported resource type for service descriptor resource.", (Throwable)new IllegalArgumentException());
        throw new IllegalArgumentException("Unsupported resource type for service descriptor resource.");
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for service descriptor resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for service descriptor resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        EntityManager em = null;
        try {
            if (type == ResourceType.APPLICATION_DESCRIPTOR) {
                em = ResourceUtils.getEntityManager();
                em.getTransaction().begin();
                QueryGenerator queryGenerator = new QueryGenerator("Application_Descriptor", new Object[0][]);
                queryGenerator.setParameter("gateway_name", this.gatewayName);
                queryGenerator.setParameter("service_descriptor_ID", this.serviceDescName);
                Query q = queryGenerator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        Application_Descriptor applicationDescriptor = (Application_Descriptor)result;
                        ApplicationDescriptorResource applicationDescriptorResource = (ApplicationDescriptorResource)Utils.getResource(ResourceType.APPLICATION_DESCRIPTOR, applicationDescriptor);
                        resourceList.add(applicationDescriptorResource);
                    }
                }
                em.getTransaction().commit();
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return resourceList;
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            Service_Descriptor existingServiceDesc = (Service_Descriptor)em.find(Service_Descriptor.class, (Object)new Service_Descriptor_PK(this.gatewayName, this.serviceDescName));
            em.close();
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Service_Descriptor serviceDescriptor = new Service_Descriptor();
            serviceDescriptor.setService_descriptor_ID(this.getServiceDescName());
            Gateway gateway = (Gateway)em.find(Gateway.class, (Object)this.gatewayName);
            serviceDescriptor.setGateway(gateway);
            serviceDescriptor.setGateway_name(gateway.getGateway_name());
            byte[] bytes = this.content.getBytes();
            serviceDescriptor.setService_descriptor_xml(bytes);
            Users user = (Users)em.find(Users.class, (Object)this.userName);
            serviceDescriptor.setUser(user);
            if (existingServiceDesc != null) {
                existingServiceDesc.setUser(user);
                existingServiceDesc.setService_descriptor_xml(bytes);
                existingServiceDesc.setGateway(gateway);
                existingServiceDesc.setGateway_name(gateway.getGateway_name());
                serviceDescriptor = (Service_Descriptor)em.merge((Object)existingServiceDesc);
            } else {
                em.persist((Object)serviceDescriptor);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for service descriptor resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    public void setServiceDescName(String serviceDescName) {
        this.serviceDescName = serviceDescName;
    }
}

