/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.sql.Timestamp;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.DataTransferDetail;
import org.apache.airavata.persistance.registry.jpa.model.Experiment;
import org.apache.airavata.persistance.registry.jpa.model.Status;
import org.apache.airavata.persistance.registry.jpa.model.TaskDetail;
import org.apache.airavata.persistance.registry.jpa.model.WorkflowNodeDetail;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.DataTransferDetailResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentResource;
import org.apache.airavata.persistance.registry.jpa.resources.TaskDetailResource;
import org.apache.airavata.persistance.registry.jpa.resources.WorkflowNodeDetailResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(StatusResource.class);
    private int statusId = 0;
    private ExperimentResource experimentResource;
    private WorkflowNodeDetailResource workflowNodeDetail;
    private DataTransferDetailResource dataTransferDetail;
    private TaskDetailResource taskDetailResource;
    private String jobId;
    private String state;
    private Timestamp statusUpdateTime;
    private String statusType;

    public int getStatusId() {
        return this.statusId;
    }

    public void setStatusId(int statusId) {
        this.statusId = statusId;
    }

    public ExperimentResource getExperimentResource() {
        return this.experimentResource;
    }

    public void setExperimentResource(ExperimentResource experimentResource) {
        this.experimentResource = experimentResource;
    }

    public WorkflowNodeDetailResource getWorkflowNodeDetail() {
        return this.workflowNodeDetail;
    }

    public void setWorkflowNodeDetail(WorkflowNodeDetailResource workflowNodeDetail) {
        this.workflowNodeDetail = workflowNodeDetail;
    }

    public DataTransferDetailResource getDataTransferDetail() {
        return this.dataTransferDetail;
    }

    public void setDataTransferDetail(DataTransferDetailResource dataTransferDetail) {
        this.dataTransferDetail = dataTransferDetail;
    }

    public TaskDetailResource getTaskDetailResource() {
        return this.taskDetailResource;
    }

    public void setTaskDetailResource(TaskDetailResource taskDetailResource) {
        this.taskDetailResource = taskDetailResource;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Timestamp getStatusUpdateTime() {
        return this.statusUpdateTime;
    }

    public void setStatusUpdateTime(Timestamp statusUpdateTime) {
        this.statusUpdateTime = statusUpdateTime;
    }

    public String getStatusType() {
        return this.statusType;
    }

    public void setStatusType(String statusType) {
        this.statusType = statusType;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for status resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for status resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for status resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for status resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            Status status;
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            if (this.statusId != 0) {
                status = (Status)em.find(Status.class, (Object)this.statusId);
                status.setStatusId(this.statusId);
            } else {
                status = new Status();
            }
            Experiment experiment = (Experiment)em.find(Experiment.class, (Object)this.experimentResource.getExpID());
            if (this.taskDetailResource != null) {
                TaskDetail taskDetail = (TaskDetail)em.find(TaskDetail.class, (Object)this.taskDetailResource.getTaskId());
                status.setTask(taskDetail);
                status.setTaskId(this.taskDetailResource.getTaskId());
            }
            if (this.workflowNodeDetail != null) {
                WorkflowNodeDetail nodeDetail = (WorkflowNodeDetail)em.find(WorkflowNodeDetail.class, (Object)this.workflowNodeDetail.getNodeInstanceId());
                status.setNode(nodeDetail);
                status.setNodeId(this.workflowNodeDetail.getNodeInstanceId());
            }
            if (this.dataTransferDetail != null) {
                DataTransferDetail transferDetail = (DataTransferDetail)em.find(DataTransferDetail.class, (Object)this.dataTransferDetail.getTransferId());
                status.setTransferDetail(transferDetail);
                status.setTransferId(this.dataTransferDetail.getTransferId());
            }
            status.setExperiment(experiment);
            status.setJobId(this.jobId);
            status.setExpId(this.experimentResource.getExpID());
            status.setState(this.state);
            status.setStatusUpdateTime(this.statusUpdateTime);
            status.setStatusType(this.statusType);
            em.persist((Object)status);
            this.statusId = status.getStatusId();
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

