/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.net.URI;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.model.AdvancedInputDataHandling;
import org.apache.airavata.persistance.registry.jpa.model.AdvancedOutputDataHandling;
import org.apache.airavata.persistance.registry.jpa.model.ApplicationInput;
import org.apache.airavata.persistance.registry.jpa.model.ApplicationOutput;
import org.apache.airavata.persistance.registry.jpa.model.Computational_Resource_Scheduling;
import org.apache.airavata.persistance.registry.jpa.model.Configuration;
import org.apache.airavata.persistance.registry.jpa.model.DataTransferDetail;
import org.apache.airavata.persistance.registry.jpa.model.ErrorDetail;
import org.apache.airavata.persistance.registry.jpa.model.Experiment;
import org.apache.airavata.persistance.registry.jpa.model.ExperimentConfigData;
import org.apache.airavata.persistance.registry.jpa.model.Experiment_Input;
import org.apache.airavata.persistance.registry.jpa.model.Experiment_Output;
import org.apache.airavata.persistance.registry.jpa.model.Gateway;
import org.apache.airavata.persistance.registry.jpa.model.Gateway_Worker;
import org.apache.airavata.persistance.registry.jpa.model.JobDetail;
import org.apache.airavata.persistance.registry.jpa.model.NodeInput;
import org.apache.airavata.persistance.registry.jpa.model.NodeOutput;
import org.apache.airavata.persistance.registry.jpa.model.Project;
import org.apache.airavata.persistance.registry.jpa.model.ProjectUser;
import org.apache.airavata.persistance.registry.jpa.model.Published_Workflow;
import org.apache.airavata.persistance.registry.jpa.model.QosParam;
import org.apache.airavata.persistance.registry.jpa.model.Status;
import org.apache.airavata.persistance.registry.jpa.model.TaskDetail;
import org.apache.airavata.persistance.registry.jpa.model.User_Workflow;
import org.apache.airavata.persistance.registry.jpa.model.Users;
import org.apache.airavata.persistance.registry.jpa.model.WorkflowNodeDetail;
import org.apache.airavata.persistance.registry.jpa.resources.AdvanceInputDataHandlingResource;
import org.apache.airavata.persistance.registry.jpa.resources.AdvancedOutputDataHandlingResource;
import org.apache.airavata.persistance.registry.jpa.resources.ApplicationInputResource;
import org.apache.airavata.persistance.registry.jpa.resources.ApplicationOutputResource;
import org.apache.airavata.persistance.registry.jpa.resources.ComputationSchedulingResource;
import org.apache.airavata.persistance.registry.jpa.resources.ConfigDataResource;
import org.apache.airavata.persistance.registry.jpa.resources.ConfigurationResource;
import org.apache.airavata.persistance.registry.jpa.resources.DataTransferDetailResource;
import org.apache.airavata.persistance.registry.jpa.resources.ErrorDetailResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentInputResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentOutputResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentResource;
import org.apache.airavata.persistance.registry.jpa.resources.GatewayResource;
import org.apache.airavata.persistance.registry.jpa.resources.JobDetailResource;
import org.apache.airavata.persistance.registry.jpa.resources.NodeInputResource;
import org.apache.airavata.persistance.registry.jpa.resources.NodeOutputResource;
import org.apache.airavata.persistance.registry.jpa.resources.ProjectResource;
import org.apache.airavata.persistance.registry.jpa.resources.ProjectUserResource;
import org.apache.airavata.persistance.registry.jpa.resources.PublishWorkflowResource;
import org.apache.airavata.persistance.registry.jpa.resources.QosParamResource;
import org.apache.airavata.persistance.registry.jpa.resources.StatusResource;
import org.apache.airavata.persistance.registry.jpa.resources.TaskDetailResource;
import org.apache.airavata.persistance.registry.jpa.resources.UserResource;
import org.apache.airavata.persistance.registry.jpa.resources.UserWorkflowResource;
import org.apache.airavata.persistance.registry.jpa.resources.WorkerResource;
import org.apache.airavata.persistance.registry.jpa.resources.WorkflowNodeDetailResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static String getJDBCFullURL() {
        String jdbcUrl = Utils.getJDBCURL();
        String jdbcUser = Utils.getJDBCUser();
        String jdbcPassword = Utils.getJDBCPassword();
        jdbcUrl = jdbcUrl + "?" + "user=" + jdbcUser + "&" + "password=" + jdbcPassword;
        return jdbcUrl;
    }

    public static String getJDBCURL() {
        try {
            return ServerSettings.getSetting((String)"registry.jdbc.url");
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getHost() {
        try {
            String jdbcURL = Utils.getJDBCURL();
            String cleanURI = jdbcURL.substring(5);
            URI uri = URI.create(cleanURI);
            return uri.getHost();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static int getPort() {
        try {
            String jdbcURL = Utils.getJDBCURL();
            String cleanURI = jdbcURL.substring(5);
            URI uri = URI.create(cleanURI);
            return uri.getPort();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    public static int getJPACacheSize() {
        try {
            String cache = ServerSettings.getSetting((String)"jpa.cache.size", (String)"5000");
            return Integer.parseInt(cache);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    public static String getDBType() {
        try {
            String jdbcURL = Utils.getJDBCURL();
            String cleanURI = jdbcURL.substring(5);
            URI uri = URI.create(cleanURI);
            return uri.getScheme();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean isDerbyStartEnabled() {
        try {
            String s = ServerSettings.getSetting((String)"start.derby.server.mode");
            if ("true".equals(s)) {
                return true;
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return false;
    }

    public static String getJDBCUser() {
        try {
            return ServerSettings.getSetting((String)"registry.jdbc.user");
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getValidationQuery() {
        try {
            return ServerSettings.getSetting((String)"validationQuery");
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getJDBCPassword() {
        try {
            return ServerSettings.getSetting((String)"registry.jdbc.password");
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getJDBCDriver() {
        try {
            return ServerSettings.getSetting((String)"registry.jdbc.driver");
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Resource getResource(ResourceType type, Object o) {
        switch (type) {
            case GATEWAY: {
                if (o instanceof Gateway) {
                    return Utils.createGateway((Gateway)o);
                }
                logger.error("Object should be a Gateway.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Gateway.");
            }
            case PROJECT: {
                if (o instanceof Project) {
                    return Utils.createProject((Project)o);
                }
                logger.error("Object should be a Project.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Project.");
            }
            case PROJECT_USER: {
                if (o instanceof ProjectUser) {
                    return Utils.createProjectUser((ProjectUser)o);
                }
                logger.error("Object should be a ProjectUser.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a ProjectUser.");
            }
            case CONFIGURATION: {
                if (o instanceof Configuration) {
                    return Utils.createConfiguration((Configuration)o);
                }
                logger.error("Object should be a Configuration.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Configuration.");
            }
            case USER: {
                if (o instanceof Users) {
                    return Utils.createUser((Users)o);
                }
                logger.error("Object should be a User.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a User.");
            }
            case PUBLISHED_WORKFLOW: {
                if (o instanceof Published_Workflow) {
                    return Utils.createPublishWorkflow((Published_Workflow)o);
                }
                logger.error("Object should be a Publish Workflow.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Publish Workflow.");
            }
            case USER_WORKFLOW: {
                if (o instanceof User_Workflow) {
                    return Utils.createUserWorkflow((User_Workflow)o);
                }
                logger.error("Object should be a User Workflow.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a User Workflow.");
            }
            case GATEWAY_WORKER: {
                if (o instanceof Gateway_Worker) {
                    return Utils.createGatewayWorker((Gateway_Worker)o);
                }
                logger.error("Object should be a Gateway Worker.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Gateway Worker.");
            }
            case EXPERIMENT: {
                if (o instanceof Experiment) {
                    return Utils.createExperiment((Experiment)o);
                }
                logger.error("Object should be a Experiment.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Experiment.");
            }
            case EXPERIMENT_INPUT: {
                if (o instanceof Experiment_Input) {
                    return Utils.createExperimentInput((Experiment_Input)o);
                }
                logger.error("Object should be a Experiment input data.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Experiment input data.");
            }
            case EXPERIMENT_OUTPUT: {
                if (o instanceof Experiment_Output) {
                    return Utils.createExperimentOutput((Experiment_Output)o);
                }
                logger.error("Object should be a Experiment output data.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Experiment output data.");
            }
            case WORKFLOW_NODE_DETAIL: {
                if (o instanceof WorkflowNodeDetail) {
                    return Utils.createWorkflowNodeDetail((WorkflowNodeDetail)o);
                }
                logger.error("Object should be a Workflow node data.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a Workflow node data.");
            }
            case TASK_DETAIL: {
                if (o instanceof TaskDetail) {
                    return Utils.createTaskDetail((TaskDetail)o);
                }
                logger.error("Object should be a task detail data.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a task detail data.");
            }
            case ERROR_DETAIL: {
                if (o instanceof ErrorDetail) {
                    return Utils.createErrorDetail((ErrorDetail)o);
                }
                logger.error("Object should be a error detail data.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a error detail data.");
            }
            case APPLICATION_INPUT: {
                if (o instanceof ApplicationInput) {
                    return Utils.createApplicationInput((ApplicationInput)o);
                }
                logger.error("Object should be a application input data.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a application input data.");
            }
            case APPLICATION_OUTPUT: {
                if (o instanceof ApplicationOutput) {
                    return Utils.createApplicationOutput((ApplicationOutput)o);
                }
                logger.error("Object should be a application output data.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a application output data.");
            }
            case NODE_INPUT: {
                if (o instanceof NodeInput) {
                    return Utils.createNodeInput((NodeInput)o);
                }
                logger.error("Object should be a node input data.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a node input data.");
            }
            case NODE_OUTPUT: {
                if (o instanceof NodeOutput) {
                    return Utils.createNodeOutput((NodeOutput)o);
                }
                logger.error("Object should be a node output data.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a node output data.");
            }
            case JOB_DETAIL: {
                if (o instanceof JobDetail) {
                    return Utils.createJobDetail((JobDetail)o);
                }
                logger.error("Object should be a job detail data.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a job detail data.");
            }
            case DATA_TRANSFER_DETAIL: {
                if (o instanceof DataTransferDetail) {
                    return Utils.createDataTransferResource((DataTransferDetail)o);
                }
                logger.error("Object should be a data transfer detail data.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a data transfer detail data.");
            }
            case STATUS: {
                if (o instanceof Status) {
                    return Utils.createStatusResource((Status)o);
                }
                logger.error("Object should be a status data.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be a status data.");
            }
            case CONFIG_DATA: {
                if (o instanceof ExperimentConfigData) {
                    return Utils.createExConfigDataResource((ExperimentConfigData)o);
                }
                logger.error("Object should be a experiment config data.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be experiment config data.");
            }
            case COMPUTATIONAL_RESOURCE_SCHEDULING: {
                if (o instanceof Computational_Resource_Scheduling) {
                    return Utils.createComputationalScheduling((Computational_Resource_Scheduling)o);
                }
                logger.error("Object should be a scheduling resource data.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be scheduling resource data.");
            }
            case ADVANCE_INPUT_DATA_HANDLING: {
                if (o instanceof AdvancedInputDataHandling) {
                    return Utils.createAdvancedInputDataResource((AdvancedInputDataHandling)o);
                }
                logger.error("Object should be a advanced input data handling data.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be advanced input data handling data.");
            }
            case ADVANCE_OUTPUT_DATA_HANDLING: {
                if (o instanceof AdvancedOutputDataHandling) {
                    return Utils.createAdvancedOutputDataResource((AdvancedOutputDataHandling)o);
                }
                logger.error("Object should be a advanced output data handling data.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be advanced output data handling data.");
            }
            case QOS_PARAM: {
                if (o instanceof QosParam) {
                    return Utils.createQosParamResource((QosParam)o);
                }
                logger.error("Object should be a QOSparam data.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Object should be QOSparam data.");
            }
        }
        logger.error("Illegal data type..", (Throwable)new IllegalArgumentException());
        throw new IllegalArgumentException("Illegal data type..");
    }

    private static Resource createGateway(Gateway o) {
        GatewayResource gatewayResource = new GatewayResource();
        gatewayResource.setGatewayName(o.getGateway_name());
        return gatewayResource;
    }

    private static Resource createProject(Project o) {
        ProjectResource projectResource = new ProjectResource();
        if (o != null) {
            projectResource.setId(o.getProject_id());
            projectResource.setName(o.getProject_name());
            GatewayResource gatewayResource = (GatewayResource)Utils.createGateway(o.getGateway());
            projectResource.setGateway(gatewayResource);
            Gateway_Worker gateway_worker = new Gateway_Worker();
            gateway_worker.setGateway(o.getGateway());
            gateway_worker.setUser(o.getUsers());
            gateway_worker.setUser_name(o.getUsers().getUser_name());
            WorkerResource workerResource = (WorkerResource)Utils.createGatewayWorker(gateway_worker);
            projectResource.setWorker(workerResource);
            projectResource.setDescription(o.getDescription());
            projectResource.setCreationTime(o.getCreationTime());
        }
        return projectResource;
    }

    private static Resource createProjectUser(ProjectUser o) {
        ProjectUserResource projectUserResource = new ProjectUserResource();
        if (o != null) {
            projectUserResource.setUserName(o.getUser().getUser_name());
            projectUserResource.setProjectId(o.getProjectID());
        }
        return projectUserResource;
    }

    private static Resource createConfiguration(Configuration o) {
        ConfigurationResource configurationResource = new ConfigurationResource();
        if (o != null) {
            configurationResource.setConfigKey(o.getConfig_key());
            configurationResource.setConfigVal(o.getConfig_val());
            configurationResource.setExpireDate(o.getExpire_date());
            configurationResource.setCategoryID(o.getCategory_id());
        }
        return configurationResource;
    }

    private static Resource createGatewayWorker(Gateway_Worker o) {
        if (o != null) {
            GatewayResource gatewayResource = new GatewayResource(o.getGateway().getGateway_name());
            gatewayResource.setOwner(o.getGateway().getOwner());
            return new WorkerResource(o.getUser_name(), gatewayResource);
        }
        return null;
    }

    private static Resource createPublishWorkflow(Published_Workflow o) {
        PublishWorkflowResource publishWorkflowResource = new PublishWorkflowResource();
        if (o != null) {
            GatewayResource gatewayResource = (GatewayResource)Utils.createGateway(o.getGateway());
            publishWorkflowResource.setGateway(gatewayResource);
            publishWorkflowResource.setCreatedUser(o.getUser().getUser_name());
            publishWorkflowResource.setName(o.getPublish_workflow_name());
            publishWorkflowResource.setContent(new String(o.getWorkflow_content()));
            publishWorkflowResource.setPublishedDate(o.getPublished_date());
            publishWorkflowResource.setVersion(o.getVersion());
            publishWorkflowResource.setPath(o.getPath());
        }
        return publishWorkflowResource;
    }

    private static Resource createUserWorkflow(User_Workflow o) {
        UserWorkflowResource userWorkflowResource = new UserWorkflowResource();
        if (o != null) {
            userWorkflowResource.setName(o.getTemplate_name());
            GatewayResource gatewayResource = (GatewayResource)Utils.createGateway(o.getGateway());
            userWorkflowResource.setGateway(gatewayResource);
            Gateway_Worker gateway_worker = new Gateway_Worker();
            gateway_worker.setGateway(o.getGateway());
            gateway_worker.setUser(o.getUser());
            WorkerResource workerResource = (WorkerResource)Utils.createGatewayWorker(gateway_worker);
            userWorkflowResource.setWorker(workerResource);
            userWorkflowResource.setLastUpdateDate(o.getLast_updated_date());
            userWorkflowResource.setContent(new String(o.getWorkflow_graph()));
            userWorkflowResource.setPath(o.getPath());
        }
        return userWorkflowResource;
    }

    private static Resource createUser(Users o) {
        UserResource userResource = new UserResource();
        if (o != null) {
            userResource.setUserName(o.getUser_name());
            userResource.setPassword(o.getPassword());
        }
        return userResource;
    }

    private static Resource createExperiment(Experiment o) {
        ExperimentResource experimentResource = new ExperimentResource();
        if (o != null) {
            GatewayResource gatewayResource = (GatewayResource)Utils.createGateway(o.getGateway());
            experimentResource.setGateway(gatewayResource);
            experimentResource.setExecutionUser(o.getExecutionUser());
            if (o.getProject() != null) {
                ProjectResource projectResource = (ProjectResource)Utils.createProject(o.getProject());
                experimentResource.setProject(projectResource);
            }
            experimentResource.setExpID(o.getExpId());
            experimentResource.setExpName(o.getExpName());
            experimentResource.setCreationTime(o.getCreationTime());
            experimentResource.setDescription(o.getExpDesc());
            experimentResource.setApplicationId(o.getApplicationId());
            experimentResource.setApplicationVersion(o.getAppVersion());
            experimentResource.setWorkflowTemplateId(o.getWorkflowTemplateId());
            experimentResource.setWorkflowTemplateVersion(o.getWorkflowTemplateVersion());
            experimentResource.setWorkflowExecutionId(o.getWorkflowExecutionId());
        }
        return experimentResource;
    }

    private static Resource createExperimentInput(Experiment_Input o) {
        ExperimentInputResource eInputResource = new ExperimentInputResource();
        if (o != null) {
            ExperimentResource experimentResource = (ExperimentResource)Utils.createExperiment(o.getExperiment());
            eInputResource.setExperimentResource(experimentResource);
            eInputResource.setInputType(o.getInputType());
            eInputResource.setMetadata(o.getMetadata());
            eInputResource.setExperimentKey(o.getEx_key());
            if (o.getValue() != null) {
                eInputResource.setValue(new String(o.getValue()));
            }
        }
        return eInputResource;
    }

    private static Resource createExperimentOutput(Experiment_Output o) {
        ExperimentOutputResource eOutputResource = new ExperimentOutputResource();
        if (o != null) {
            ExperimentResource experimentResource = (ExperimentResource)Utils.createExperiment(o.getExperiment());
            eOutputResource.setExperimentResource(experimentResource);
            eOutputResource.setExperimentKey(o.getEx_key());
            if (o.getValue() != null) {
                eOutputResource.setValue(new String(o.getValue()));
            }
            eOutputResource.setOutputType(o.getOutputKeyType());
            eOutputResource.setMetadata(o.getMetadata());
        }
        return eOutputResource;
    }

    private static Resource createWorkflowNodeDetail(WorkflowNodeDetail o) {
        WorkflowNodeDetailResource nodeDetailResource = new WorkflowNodeDetailResource();
        if (o != null) {
            ExperimentResource experimentResource = (ExperimentResource)Utils.createExperiment(o.getExperiment());
            nodeDetailResource.setExperimentResource(experimentResource);
            nodeDetailResource.setCreationTime(o.getCreationTime());
            nodeDetailResource.setNodeInstanceId(o.getNodeId());
            nodeDetailResource.setNodeName(o.getNodeName());
            nodeDetailResource.setExecutionUnit(o.getExecutionUnit());
            nodeDetailResource.setExecutionUnitData(o.getExecutionUnitData());
        }
        return nodeDetailResource;
    }

    private static Resource createTaskDetail(TaskDetail o) {
        TaskDetailResource taskDetailResource = new TaskDetailResource();
        if (o != null) {
            WorkflowNodeDetailResource nodeDetailResource = (WorkflowNodeDetailResource)Utils.createWorkflowNodeDetail(o.getNodeDetail());
            taskDetailResource.setWorkflowNodeDetailResource(nodeDetailResource);
            taskDetailResource.setCreationTime(o.getCreationTime());
            taskDetailResource.setTaskId(o.getTaskId());
            taskDetailResource.setApplicationId(o.getAppId());
            taskDetailResource.setApplicationVersion(o.getAppVersion());
            taskDetailResource.setApplicationDeploymentId(o.getApplicationDeploymentId());
        }
        return taskDetailResource;
    }

    private static Resource createErrorDetail(ErrorDetail o) {
        ErrorDetailResource errorDetailResource = new ErrorDetailResource();
        if (o != null) {
            ExperimentResource experimentResource = (ExperimentResource)Utils.createExperiment(o.getExperiment());
            errorDetailResource.setExperimentResource(experimentResource);
            if (o.getTask() != null) {
                TaskDetailResource taskDetailResource = (TaskDetailResource)Utils.createTaskDetail(o.getTask());
                errorDetailResource.setTaskDetailResource(taskDetailResource);
            }
            if (o.getNodeDetails() != null) {
                WorkflowNodeDetailResource nodeDetailResource = (WorkflowNodeDetailResource)Utils.createWorkflowNodeDetail(o.getNodeDetails());
                errorDetailResource.setNodeDetail(nodeDetailResource);
            }
            errorDetailResource.setErrorId(o.getErrorID());
            errorDetailResource.setJobId(o.getJobId());
            errorDetailResource.setCreationTime(o.getCreationTime());
            errorDetailResource.setActualErrorMsg(new String(o.getActualErrorMsg()));
            errorDetailResource.setUserFriendlyErrorMsg(o.getUserFriendlyErrorMsg());
            errorDetailResource.setTransientPersistent(o.isTransientPersistent());
            errorDetailResource.setErrorCategory(o.getErrorCategory());
            errorDetailResource.setCorrectiveAction(o.getCorrectiveAction());
            errorDetailResource.setActionableGroup(o.getActionableGroup());
        }
        return errorDetailResource;
    }

    private static Resource createApplicationInput(ApplicationInput o) {
        ApplicationInputResource inputResource = new ApplicationInputResource();
        if (o != null) {
            TaskDetailResource taskDetailResource = (TaskDetailResource)Utils.createTaskDetail(o.getTask());
            inputResource.setTaskDetailResource(taskDetailResource);
            inputResource.setInputKey(o.getInputKey());
            inputResource.setInputType(o.getInputKeyType());
            if (o.getValue() != null) {
                inputResource.setValue(new String(o.getValue()));
            }
            inputResource.setMetadata(o.getMetadata());
        }
        return inputResource;
    }

    private static Resource createApplicationOutput(ApplicationOutput o) {
        ApplicationOutputResource outputResource = new ApplicationOutputResource();
        if (o != null) {
            TaskDetailResource taskDetailResource = (TaskDetailResource)Utils.createTaskDetail(o.getTask());
            outputResource.setTaskDetailResource(taskDetailResource);
            outputResource.setOutputType(o.getOutputKeyType());
            outputResource.setOutputKey(o.getOutputKey());
            if (o.getValue() != null) {
                outputResource.setValue(new String(o.getValue()));
            }
            outputResource.setMetadata(o.getMetadata());
        }
        return outputResource;
    }

    private static Resource createNodeInput(NodeInput o) {
        NodeInputResource inputResource = new NodeInputResource();
        if (o != null) {
            WorkflowNodeDetailResource nodeDetailResource = (WorkflowNodeDetailResource)Utils.createWorkflowNodeDetail(o.getNodeDetails());
            inputResource.setNodeDetailResource(nodeDetailResource);
            inputResource.setInputKey(o.getInputKey());
            inputResource.setInputType(o.getInputKeyType());
            inputResource.setValue(o.getValue());
            inputResource.setMetadata(o.getMetadata());
        }
        return inputResource;
    }

    private static Resource createNodeOutput(NodeOutput o) {
        NodeOutputResource outputResource = new NodeOutputResource();
        if (o != null) {
            WorkflowNodeDetailResource nodeDetailResource = (WorkflowNodeDetailResource)Utils.createWorkflowNodeDetail(o.getNode());
            outputResource.setNodeDetailResource(nodeDetailResource);
            outputResource.setOutputType(o.getOutputKeyType());
            outputResource.setOutputKey(o.getOutputKey());
            outputResource.setValue(o.getValue());
            outputResource.setMetadata(o.getMetadata());
        }
        return outputResource;
    }

    private static Resource createJobDetail(JobDetail o) {
        JobDetailResource jobDetailResource = new JobDetailResource();
        if (o != null) {
            TaskDetailResource taskDetailResource = (TaskDetailResource)Utils.createTaskDetail(o.getTask());
            jobDetailResource.setTaskDetailResource(taskDetailResource);
            if (o.getJobDescription() != null) {
                jobDetailResource.setJobDescription(new String(o.getJobDescription()));
            }
            jobDetailResource.setJobId(o.getJobId());
            jobDetailResource.setCreationTime(o.getCreationTime());
            jobDetailResource.setComputeResourceConsumed(o.getComputeResourceConsumed());
        }
        return jobDetailResource;
    }

    private static Resource createDataTransferResource(DataTransferDetail o) {
        DataTransferDetailResource transferDetailResource = new DataTransferDetailResource();
        if (o != null) {
            TaskDetailResource taskDetailResource = (TaskDetailResource)Utils.createTaskDetail(o.getTask());
            transferDetailResource.setTaskDetailResource(taskDetailResource);
            transferDetailResource.setTransferId(o.getTransferId());
            transferDetailResource.setCreationTime(o.getCreationTime());
            if (o.getTransferDesc() != null) {
                transferDetailResource.setTransferDescription(new String(o.getTransferDesc()));
            }
        }
        return transferDetailResource;
    }

    private static Resource createStatusResource(Status o) {
        StatusResource statusResource = new StatusResource();
        if (o != null) {
            ExperimentResource experimentResource = (ExperimentResource)Utils.createExperiment(o.getExperiment());
            statusResource.setExperimentResource(experimentResource);
            if (o.getTask() != null) {
                TaskDetailResource taskDetailResource = (TaskDetailResource)Utils.createTaskDetail(o.getTask());
                statusResource.setTaskDetailResource(taskDetailResource);
            }
            if (o.getNode() != null) {
                WorkflowNodeDetailResource nodeDetailResource = (WorkflowNodeDetailResource)Utils.createWorkflowNodeDetail(o.getNode());
                statusResource.setWorkflowNodeDetail(nodeDetailResource);
            }
            if (o.getTransferDetail() != null) {
                DataTransferDetailResource transferDetailResource = (DataTransferDetailResource)Utils.createDataTransferResource(o.getTransferDetail());
                statusResource.setDataTransferDetail(transferDetailResource);
            }
            statusResource.setStatusId(o.getStatusId());
            statusResource.setJobId(o.getJobId());
            statusResource.setState(o.getState());
            statusResource.setStatusUpdateTime(o.getStatusUpdateTime());
            statusResource.setStatusType(o.getStatusType());
        }
        return statusResource;
    }

    private static Resource createExConfigDataResource(ExperimentConfigData o) {
        ConfigDataResource configDataResource = new ConfigDataResource();
        if (o != null) {
            ExperimentResource experimentResource = (ExperimentResource)Utils.createExperiment(o.getExperiment());
            configDataResource.setExperimentResource(experimentResource);
            configDataResource.setAiravataAutoSchedule(o.isAiravataAutoSchedule());
            configDataResource.setOverrideManualParams(o.isOverrideManualParams());
            configDataResource.setShareExp(o.isShareExp());
        }
        return configDataResource;
    }

    private static Resource createComputationalScheduling(Computational_Resource_Scheduling o) {
        ComputationSchedulingResource schedulingResource = new ComputationSchedulingResource();
        if (o != null) {
            ExperimentResource experimentResource = (ExperimentResource)Utils.createExperiment(o.getExperiment());
            schedulingResource.setExperimentResource(experimentResource);
            if (o.getTask() != null) {
                TaskDetailResource taskDetailResource = (TaskDetailResource)Utils.createTaskDetail(o.getTask());
                schedulingResource.setTaskDetailResource(taskDetailResource);
            }
            schedulingResource.setSchedulingId(o.getSchedulingId());
            schedulingResource.setResourceHostId(o.getResourceHostId());
            schedulingResource.setCpuCount(o.getCpuCount());
            schedulingResource.setNodeCount(o.getNodeCount());
            schedulingResource.setNumberOfThreads(o.getNumberOfThreads());
            schedulingResource.setQueueName(o.getQueueName());
            schedulingResource.setWalltimeLimit(o.getWallTimeLimit());
            schedulingResource.setJobStartTime(o.getJobStartTime());
            schedulingResource.setPhysicalMemory(o.getTotalPhysicalmemory());
            schedulingResource.setProjectName(o.getProjectName());
        }
        return schedulingResource;
    }

    private static Resource createAdvancedInputDataResource(AdvancedInputDataHandling o) {
        AdvanceInputDataHandlingResource dataHandlingResource = new AdvanceInputDataHandlingResource();
        if (o != null) {
            ExperimentResource experimentResource = (ExperimentResource)Utils.createExperiment(o.getExperiment());
            dataHandlingResource.setExperimentResource(experimentResource);
            if (o.getTask() != null) {
                TaskDetailResource taskDetailResource = (TaskDetailResource)Utils.createTaskDetail(o.getTask());
                dataHandlingResource.setTaskDetailResource(taskDetailResource);
            }
            dataHandlingResource.setDataHandlingId(o.getDataHandlingId());
            dataHandlingResource.setWorkingDirParent(o.getParentWorkingDir());
            dataHandlingResource.setWorkingDir(o.getWorkingDir());
            dataHandlingResource.setStageInputFiles(o.isStageInputsToWorkingDir());
            dataHandlingResource.setCleanAfterJob(o.isCleanAfterJob());
        }
        return dataHandlingResource;
    }

    private static Resource createAdvancedOutputDataResource(AdvancedOutputDataHandling o) {
        AdvancedOutputDataHandlingResource dataHandlingResource = new AdvancedOutputDataHandlingResource();
        if (o != null) {
            ExperimentResource experimentResource = (ExperimentResource)Utils.createExperiment(o.getExperiment());
            dataHandlingResource.setExperimentResource(experimentResource);
            if (o.getTask() != null) {
                TaskDetailResource taskDetailResource = (TaskDetailResource)Utils.createTaskDetail(o.getTask());
                dataHandlingResource.setTaskDetailResource(taskDetailResource);
            }
            dataHandlingResource.setOutputDataHandlingId(o.getOutputDataHandlingId());
            dataHandlingResource.setOutputDataDir(o.getOutputDataDir());
            dataHandlingResource.setDataRegUrl(o.getDataRegUrl());
            dataHandlingResource.setPersistOutputData(o.isPersistOutputData());
        }
        return dataHandlingResource;
    }

    private static Resource createQosParamResource(QosParam o) {
        QosParamResource qosParamResource = new QosParamResource();
        if (o != null) {
            ExperimentResource experimentResource = (ExperimentResource)Utils.createExperiment(o.getExperiment());
            qosParamResource.setExperimentResource(experimentResource);
            if (o.getTask() != null) {
                TaskDetailResource taskDetailResource = (TaskDetailResource)Utils.createTaskDetail(o.getTask());
                qosParamResource.setTaskDetailResource(taskDetailResource);
            }
            qosParamResource.setQosId(o.getQosId());
            qosParamResource.setExecuteBefore(o.getExecuteBefore());
            qosParamResource.setStartExecutionAt(o.getStartExecutionAt());
            qosParamResource.setNoOfRetries(o.getNoOfRetries());
        }
        return qosParamResource;
    }
}

