/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.util.ArrayList;
import java.util.List;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;

public abstract class AbstractResource
implements Resource {
    public static final String GATEWAY = "Gateway";
    public static final String CONFIGURATION = "Configuration";
    public static final String USERS = "Users";
    public static final String GATEWAY_WORKER = "Gateway_Worker";
    public static final String PROJECT = "Project";
    public static final String PUBLISHED_WORKFLOW = "Published_Workflow";
    public static final String USER_WORKFLOW = "User_Workflow";
    public static final String HOST_DESCRIPTOR = "Host_Descriptor";
    public static final String SERVICE_DESCRIPTOR = "Service_Descriptor";
    public static final String APPLICATION_DESCRIPTOR = "Application_Descriptor";
    public static final String EXPERIMENT = "Experiment";
    public static final String EXPERIMENT_DATA = "Experiment_Data";
    public static final String WORKFLOW_DATA = "Workflow_Data";
    public static final String EXPERIMENT_METADATA = "Experiment_Metadata";

    protected AbstractResource() {
    }

    @Override
    public boolean isExists(ResourceType type, Object name) {
        try {
            return this.get(type, name) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static <T> List<T> getResourceList(List<Resource> resources, Class<?> T) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        for (Resource o : resources) {
            list.add(o);
        }
        return list;
    }

    public final class GramDataConstants {
        public static final String WORKFLOW_INSTANCE_ID = "workflow_instanceID";
        public static final String NODE_ID = "node_id";
        public static final String RSL = "rsl";
        public static final String INVOKED_HOST = "invoked_host";
        public static final String LOCAL_JOB_ID = "local_Job_ID";
    }

    public final class NodeDataConstants {
        public static final String WORKFLOW_INSTANCE_ID = "workflow_instanceID";
        public static final String NODE_ID = "node_id";
        public static final String NODE_TYPE = "node_type";
        public static final String INPUTS = "inputs";
        public static final String OUTPUTS = "outputs";
        public static final String STATUS = "status";
        public static final String START_TIME = "start_time";
        public static final String LAST_UPDATE_TIME = "last_update_time";
    }

    public final class WorkflowDataConstants {
        public static final String EXPERIMENT_ID = "experiment_ID";
        public static final String WORKFLOW_INSTANCE_ID = "workflow_instanceID";
        public static final String TEMPLATE_NAME = "template_name";
        public static final String STATUS = "status";
        public static final String START_TIME = "start_time";
        public static final String LAST_UPDATE_TIME = "last_update_time";
    }

    public final class ExperimentDataConstants {
        public static final String EXPERIMENT_ID = "experiment_ID";
        public static final String NAME = "name";
        public static final String USERNAME = "username";
        public static final String METADATA = "metadata";
    }

    public final class ExperimentConstants {
        public static final String PROJECT_NAME = "project_name";
        public static final String USERNAME = "user_name";
        public static final String GATEWAY_NAME = "gateway_name";
        public static final String EXPERIMENT_ID = "experiment_ID";
        public static final String SUBMITTED_DATE = "submitted_date";
    }

    public final class ApplicationDescriptorConstants {
        public static final String GATEWAY_NAME = "gateway_name";
        public static final String UPDATED_USER = "updated_user";
        public static final String APPLICATION_DESC_ID = "application_descriptor_ID";
        public static final String HOST_DESC_ID = "host_descriptor_ID";
        public static final String SERVICE_DESC_ID = "service_descriptor_ID";
        public static final String APPLICATION_DESC_XML = "application_descriptor_xml";
    }

    public final class ServiceDescriptorConstants {
        public static final String GATEWAY_NAME = "gateway_name";
        public static final String UPDATED_USER = "updated_user";
        public static final String SERVICE_DESC_ID = "service_descriptor_ID";
        public static final String SERVICE_DESC_XML = "service_descriptor_xml";
    }

    public final class HostDescriptorConstants {
        public static final String GATEWAY_NAME = "gateway_name";
        public static final String UPDATED_USER = "updated_user";
        public static final String HOST_DESC_ID = "host_descriptor_ID";
        public static final String HOST_DESC_XML = "host_descriptor_xml";
    }

    public final class UserWorkflowConstants {
        public static final String GATEWAY_NAME = "gateway_name";
        public static final String OWNER = "owner";
        public static final String TEMPLATE_NAME = "template_name";
        public static final String LAST_UPDATED_DATE = "last_updated_date";
        public static final String PATH = "path";
        public static final String WORKFLOW_GRAPH = "workflow_graph";
    }

    public final class PublishedWorkflowConstants {
        public static final String GATEWAY_NAME = "gateway_name";
        public static final String CREATED_USER = "created_user";
        public static final String PUBLISH_WORKFLOW_NAME = "publish_workflow_name";
        public static final String VERSION = "version";
        public static final String PUBLISHED_DATE = "published_date";
        public static final String PATH = "path";
        public static final String WORKFLOW_CONTENT = "workflow_content";
    }

    public final class ProjectConstants {
        public static final String GATEWAY_NAME = "gateway_name";
        public static final String USERNAME = "user_name";
        public static final String PROJECT_NAME = "project_name";
    }

    public final class GatewayWorkerConstants {
        public static final String USERNAME = "user_name";
        public static final String GATEWAY_NAME = "gateway_name";
    }

    public final class UserConstants {
        public static final String USERNAME = "user_name";
        public static final String PASSWORD = "password";
    }

    public final class ConfigurationConstants {
        public static final String CONFIG_KEY = "config_key";
        public static final String CONFIG_VAL = "config_val";
        public static final String EXPIRE_DATE = "expire_date";
    }

    public final class GatewayConstants {
        public static final String GATEWAY_NAME = "gateway_name";
        public static final String GATEWAY_OWNER = "owner";
    }
}

