/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Configuration;
import org.apache.airavata.persistance.registry.jpa.model.Configuration_PK;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.Utils;
import org.apache.airavata.persistance.registry.jpa.utils.QueryGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationResource.class);
    private String configKey;
    private String configVal;
    private Timestamp expireDate;

    public ConfigurationResource() {
    }

    public ConfigurationResource(String configKey, String configVal) {
        this.configKey = configKey;
        this.configVal = configVal;
    }

    @Override
    public Resource create(ResourceType type) {
        logger.error("Unsupported operation for configuration resource since there are no child resources generated by configuration resource.. ", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) {
        logger.error("Unsupported operation for configuration resource since there are no child resources generated by configuration resource.. ", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) {
        logger.error("Unsupported operation for configuration resource since there are no child resources generated by configuration resource.. ", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    public List<Resource> populate(Object[] keys) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        QueryGenerator queryGenerator = new QueryGenerator("Configuration", new Object[0][]);
        queryGenerator.setParameter("config_key", keys[0]);
        Query q = queryGenerator.selectQuery(em);
        List resultList = q.getResultList();
        if (resultList.size() != 0) {
            for (Object result : resultList) {
                Configuration configuration = (Configuration)result;
                ConfigurationResource configurationResource = (ConfigurationResource)Utils.getResource(ResourceType.CONFIGURATION, configuration);
                list.add(configurationResource);
            }
        }
        em.getTransaction().commit();
        em.close();
        return list;
    }

    @Override
    public List<Resource> get(ResourceType type) {
        logger.error("Unsupported operation for configuration resource since there are no child resources generated by configuration resource.. ", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    public void setExpireDate(Timestamp expireDate) {
        this.expireDate = expireDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void save() {
        Lock lock = ResourceUtils.getLock();
        lock.lock();
        try {
            EntityManager em = ResourceUtils.getEntityManager();
            Configuration existing = (Configuration)em.find(Configuration.class, (Object)new Configuration_PK(this.configKey, this.configVal));
            em.close();
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Configuration configuration = new Configuration();
            configuration.setConfig_key(this.configKey);
            configuration.setConfig_val(this.configVal);
            configuration.setExpire_date(this.expireDate);
            if (existing != null) {
                existing.setExpire_date(this.expireDate);
                configuration = (Configuration)em.merge((Object)existing);
            } else {
                em.merge((Object)configuration);
            }
            em.getTransaction().commit();
            em.close();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean isExists(ResourceType type, Object name) {
        logger.error("Unsupported operation for configuration resource since there are no child resources generated by configuration resource.. ", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    public String getConfigVal() {
        return this.configVal;
    }

    public void setConfigKey(String configKey) {
        this.configKey = configKey;
    }

    public void setConfigVal(String configVal) {
        this.configVal = configVal;
    }
}

