/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Application_Descriptor;
import org.apache.airavata.persistance.registry.jpa.model.Gateway;
import org.apache.airavata.persistance.registry.jpa.model.Host_Descriptor;
import org.apache.airavata.persistance.registry.jpa.model.Host_Descriptor_PK;
import org.apache.airavata.persistance.registry.jpa.model.Users;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.ApplicationDescriptorResource;
import org.apache.airavata.persistance.registry.jpa.resources.Utils;
import org.apache.airavata.persistance.registry.jpa.utils.QueryGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostDescriptorResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(HostDescriptorResource.class);
    private String hostDescName;
    private String gatewayName;
    private String userName;
    private String content;

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getHostDescName() {
        return this.hostDescName;
    }

    public String getGatewayName() {
        return this.gatewayName;
    }

    public String getContent() {
        return this.content;
    }

    public void setGatewayName(String gatewayName) {
        this.gatewayName = gatewayName;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public Resource create(ResourceType type) {
        if (type == ResourceType.APPLICATION_DESCRIPTOR) {
            ApplicationDescriptorResource applicationDescriptorResource = new ApplicationDescriptorResource();
            applicationDescriptorResource.setGatewayName(this.gatewayName);
            applicationDescriptorResource.setHostDescName(this.getHostDescName());
            return applicationDescriptorResource;
        }
        logger.error("Unsupported resource type for host descriptor resource.", (Throwable)new IllegalArgumentException());
        throw new IllegalArgumentException("Unsupported resource type for host descriptor resource.");
    }

    @Override
    public void remove(ResourceType type, Object name) {
        logger.error("Unsupported resource type for host descriptor resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) {
        logger.error("Unsupported resource type for host descriptor resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    public List<Resource> populate(Object[] keys) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        QueryGenerator generator = new QueryGenerator("Host_Descriptor", new Object[0][]);
        generator.setParameter("gateway_name", keys[0]);
        generator.setParameter("host_descriptor_ID", keys[1]);
        Query q = generator.selectQuery(em);
        Host_Descriptor hostDescriptor = (Host_Descriptor)q.getSingleResult();
        HostDescriptorResource hostDescriptorResource = (HostDescriptorResource)Utils.getResource(ResourceType.HOST_DESCRIPTOR, hostDescriptor);
        em.getTransaction().commit();
        em.close();
        list.add(hostDescriptorResource);
        return list;
    }

    @Override
    public List<Resource> get(ResourceType type) {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        if (type == ResourceType.APPLICATION_DESCRIPTOR) {
            EntityManager em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            QueryGenerator generator = new QueryGenerator("Application_Descriptor", new Object[0][]);
            generator.setParameter("gateway_name", this.gatewayName);
            generator.setParameter("host_descriptor_ID", this.getHostDescName());
            Query q = generator.selectQuery(em);
            List results = q.getResultList();
            if (results.size() != 0) {
                for (Object result : results) {
                    Application_Descriptor applicationDescriptor = (Application_Descriptor)result;
                    ApplicationDescriptorResource applicationDescriptorResource = (ApplicationDescriptorResource)Utils.getResource(ResourceType.APPLICATION_DESCRIPTOR, applicationDescriptor);
                    resourceList.add(applicationDescriptorResource);
                }
            }
            em.getTransaction().commit();
            em.close();
        }
        return resourceList;
    }

    @Override
    public void save() {
        try {
            EntityManager em = ResourceUtils.getEntityManager();
            Host_Descriptor existingHost_desc = (Host_Descriptor)em.find(Host_Descriptor.class, (Object)new Host_Descriptor_PK(this.gatewayName, this.hostDescName));
            em.close();
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Host_Descriptor hostDescriptor = new Host_Descriptor();
            Gateway gateway = new Gateway();
            gateway.setGateway_name(this.gatewayName);
            Users user = new Users();
            user.setUser_name(this.userName);
            hostDescriptor.setHost_descriptor_ID(this.getHostDescName());
            hostDescriptor.setGateway(gateway);
            byte[] contentBytes = this.content.getBytes();
            hostDescriptor.setHost_descriptor_xml(contentBytes);
            hostDescriptor.setUser(user);
            if (existingHost_desc != null) {
                existingHost_desc.setUser(user);
                existingHost_desc.setHost_descriptor_xml(contentBytes);
                hostDescriptor = (Host_Descriptor)em.merge((Object)existingHost_desc);
            } else {
                em.merge((Object)hostDescriptor);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isExists(ResourceType type, Object name) {
        logger.error("Unsupported resource type for host descriptor resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    public void setHostDescName(String hostDescName) {
        this.hostDescName = hostDescName;
    }
}

