/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Experiment_Data;
import org.apache.airavata.persistance.registry.jpa.model.Gram_Data;
import org.apache.airavata.persistance.registry.jpa.model.Node_Data;
import org.apache.airavata.persistance.registry.jpa.model.Workflow_Data;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.GramDataResource;
import org.apache.airavata.persistance.registry.jpa.resources.NodeDataResource;
import org.apache.airavata.persistance.registry.jpa.resources.Utils;
import org.apache.airavata.persistance.registry.jpa.utils.QueryGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowDataResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowDataResource.class);
    public static final String NODE_DATA = "Node_Data";
    public static final String GRAM_DATA = "Gram_Data";
    private String experimentID;
    private String workflowInstanceID;
    private String templateName;
    private String status;
    private Timestamp startTime;
    private Timestamp lastUpdatedTime;

    public String getExperimentID() {
        return this.experimentID;
    }

    public String getWorkflowInstanceID() {
        return this.workflowInstanceID;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getStatus() {
        return this.status;
    }

    public void setExperimentID(String experimentID) {
        this.experimentID = experimentID;
    }

    public void setWorkflowInstanceID(String workflowInstanceID) {
        this.workflowInstanceID = workflowInstanceID;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public Timestamp getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void setStartTime(Timestamp startTime) {
        this.startTime = startTime;
    }

    public void setLastUpdatedTime(Timestamp lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    @Override
    public Resource create(ResourceType type) {
        switch (type) {
            case NODE_DATA: {
                NodeDataResource nodeDataResource = new NodeDataResource();
                nodeDataResource.setWorkflowDataResource(this);
                return nodeDataResource;
            }
            case GRAM_DATA: {
                GramDataResource gramDataResource = new GramDataResource();
                gramDataResource.setWorkflowDataResource(this);
                return gramDataResource;
            }
        }
        logger.error("Unsupported resource type for workflow data resource.", (Throwable)new IllegalArgumentException());
        throw new IllegalArgumentException("Unsupported resource type for workflow data resource.");
    }

    @Override
    public void remove(ResourceType type, Object name) {
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        switch (type) {
            case NODE_DATA: {
                QueryGenerator generator = new QueryGenerator(NODE_DATA, new Object[0][]);
                generator.setParameter("workflow_instanceID", this.workflowInstanceID);
                generator.setParameter("node_id", name);
                Query q = generator.deleteQuery(em);
                q.executeUpdate();
                break;
            }
            case GRAM_DATA: {
                QueryGenerator generator = new QueryGenerator(GRAM_DATA, new Object[0][]);
                generator.setParameter("workflow_instanceID", this.workflowInstanceID);
                generator.setParameter("node_id", name);
                Query q = generator.deleteQuery(em);
                q.executeUpdate();
                break;
            }
            default: {
                logger.error("Unsupported resource type for workflow data resource.", (Throwable)new IllegalArgumentException());
            }
        }
        em.getTransaction().commit();
        em.close();
    }

    @Override
    public Resource get(ResourceType type, Object name) {
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        switch (type) {
            case NODE_DATA: {
                QueryGenerator generator = new QueryGenerator(NODE_DATA, new Object[0][]);
                generator.setParameter("workflow_instanceID", this.workflowInstanceID);
                generator.setParameter("node_id", name);
                Query q = generator.selectQuery(em);
                Node_Data enodeDeata = (Node_Data)q.getSingleResult();
                NodeDataResource nodeDataResource = (NodeDataResource)Utils.getResource(ResourceType.NODE_DATA, enodeDeata);
                em.getTransaction().commit();
                em.close();
                return nodeDataResource;
            }
            case GRAM_DATA: {
                QueryGenerator generator = new QueryGenerator(GRAM_DATA, new Object[0][]);
                generator.setParameter("workflow_instanceID", this.workflowInstanceID);
                generator.setParameter("node_id", name);
                Query q = generator.selectQuery(em);
                Gram_Data egramData = (Gram_Data)q.getSingleResult();
                GramDataResource gramDataResource = (GramDataResource)Utils.getResource(ResourceType.GRAM_DATA, egramData);
                em.getTransaction().commit();
                em.close();
                return gramDataResource;
            }
        }
        em.getTransaction().commit();
        em.close();
        logger.error("Unsupported resource type for workflow data resource.", (Throwable)new IllegalArgumentException());
        throw new IllegalArgumentException("Unsupported resource type for workflow data resource.");
    }

    @Override
    public List<Resource> get(ResourceType type) {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        switch (type) {
            case NODE_DATA: {
                QueryGenerator generator = new QueryGenerator(NODE_DATA, new Object[0][]);
                generator.setParameter("workflow_instanceID", this.workflowInstanceID);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() == 0) break;
                for (Object result : results) {
                    Node_Data nodeData = (Node_Data)result;
                    NodeDataResource nodeDataResource = (NodeDataResource)Utils.getResource(ResourceType.NODE_DATA, nodeData);
                    resourceList.add(nodeDataResource);
                }
                break;
            }
            case GRAM_DATA: {
                QueryGenerator generator = new QueryGenerator(GRAM_DATA, new Object[0][]);
                generator.setParameter("workflow_instanceID", this.workflowInstanceID);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() == 0) break;
                for (Object result : results) {
                    Gram_Data gramData = (Gram_Data)result;
                    GramDataResource gramDataResource = (GramDataResource)Utils.getResource(ResourceType.GRAM_DATA, gramData);
                    resourceList.add(gramDataResource);
                }
                break;
            }
            default: {
                em.getTransaction().commit();
                em.close();
                logger.error("Unsupported resource type for workflow data resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for workflow data resource.");
            }
        }
        em.getTransaction().commit();
        em.close();
        return resourceList;
    }

    @Override
    public void save() {
        if (this.lastUpdatedTime == null) {
            Date date = new Date();
            this.lastUpdatedTime = new Timestamp(date.getTime());
        }
        EntityManager em = ResourceUtils.getEntityManager();
        Workflow_Data existingWFData = (Workflow_Data)em.find(Workflow_Data.class, (Object)this.workflowInstanceID);
        em.close();
        em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        Workflow_Data workflowData = new Workflow_Data();
        Experiment_Data expData = (Experiment_Data)em.find(Experiment_Data.class, (Object)this.experimentID);
        workflowData.setExperiment_data(expData);
        workflowData.setWorkflow_instanceID(this.workflowInstanceID);
        workflowData.setLast_update_time(this.lastUpdatedTime);
        workflowData.setStart_time(this.startTime);
        workflowData.setTemplate_name(this.templateName);
        workflowData.setStatus(this.status);
        if (existingWFData != null) {
            existingWFData.setExperiment_data(expData);
            existingWFData.setLast_update_time(this.lastUpdatedTime);
            existingWFData.setStart_time(this.startTime);
            existingWFData.setStatus(this.status);
            existingWFData.setTemplate_name(this.templateName);
            workflowData = (Workflow_Data)em.merge((Object)existingWFData);
        } else {
            em.persist((Object)workflowData);
        }
        em.getTransaction().commit();
        em.close();
    }

    public boolean isNodeExists(String nodeId) {
        return this.isExists(ResourceType.NODE_DATA, nodeId);
    }

    public boolean isGramDataExists(String nodeId) {
        return this.isExists(ResourceType.GRAM_DATA, nodeId);
    }

    public NodeDataResource getNodeData(String nodeId) {
        return (NodeDataResource)this.get(ResourceType.NODE_DATA, nodeId);
    }

    public GramDataResource getGramData(String nodeId) {
        return (GramDataResource)this.get(ResourceType.GRAM_DATA, nodeId);
    }

    public List<NodeDataResource> getNodeData() {
        return WorkflowDataResource.getResourceList(this.get(ResourceType.NODE_DATA), NodeDataResource.class);
    }

    public List<GramDataResource> getGramData() {
        return WorkflowDataResource.getResourceList(this.get(ResourceType.GRAM_DATA), GramDataResource.class);
    }

    public NodeDataResource createNodeData(String nodeId) {
        NodeDataResource data = (NodeDataResource)this.create(ResourceType.NODE_DATA);
        data.setNodeID(nodeId);
        return data;
    }

    public GramDataResource createGramData(String nodeId) {
        GramDataResource data = (GramDataResource)this.create(ResourceType.GRAM_DATA);
        data.setNodeID(nodeId);
        return data;
    }

    public void removeNodeData(String nodeId) {
        this.remove(ResourceType.NODE_DATA, nodeId);
    }

    public void removeGramData(String nodeId) {
        this.remove(ResourceType.GRAM_DATA, nodeId);
    }
}

