/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Application_Descriptor;
import org.apache.airavata.persistance.registry.jpa.model.Application_Descriptor_PK;
import org.apache.airavata.persistance.registry.jpa.model.Experiment;
import org.apache.airavata.persistance.registry.jpa.model.Gateway;
import org.apache.airavata.persistance.registry.jpa.model.Gateway_Worker;
import org.apache.airavata.persistance.registry.jpa.model.Gateway_Worker_PK;
import org.apache.airavata.persistance.registry.jpa.model.Host_Descriptor;
import org.apache.airavata.persistance.registry.jpa.model.Host_Descriptor_PK;
import org.apache.airavata.persistance.registry.jpa.model.Project;
import org.apache.airavata.persistance.registry.jpa.model.Published_Workflow;
import org.apache.airavata.persistance.registry.jpa.model.Published_Workflow_PK;
import org.apache.airavata.persistance.registry.jpa.model.Service_Descriptor;
import org.apache.airavata.persistance.registry.jpa.model.Service_Descriptor_PK;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.ApplicationDescriptorResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentResource;
import org.apache.airavata.persistance.registry.jpa.resources.HostDescriptorResource;
import org.apache.airavata.persistance.registry.jpa.resources.ProjectResource;
import org.apache.airavata.persistance.registry.jpa.resources.PublishWorkflowResource;
import org.apache.airavata.persistance.registry.jpa.resources.ServiceDescriptorResource;
import org.apache.airavata.persistance.registry.jpa.resources.UserResource;
import org.apache.airavata.persistance.registry.jpa.resources.UserWorkflowResource;
import org.apache.airavata.persistance.registry.jpa.resources.Utils;
import org.apache.airavata.persistance.registry.jpa.resources.WorkerResource;
import org.apache.airavata.persistance.registry.jpa.utils.QueryGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(GatewayResource.class);
    private String gatewayName;
    private String owner;

    public GatewayResource(String gatewayName) {
        this.setGatewayName(gatewayName);
    }

    public GatewayResource() {
    }

    public String getGatewayName() {
        return this.gatewayName;
    }

    public void setGatewayName(String gatewayName) {
        this.gatewayName = gatewayName;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public Resource create(ResourceType type) {
        switch (type) {
            case PROJECT: {
                ProjectResource projectResource = new ProjectResource();
                projectResource.setGateway(this);
                return projectResource;
            }
            case USER: {
                UserResource userResource = new UserResource();
                userResource.setGatewayName(this.getGatewayName());
                return userResource;
            }
            case PUBLISHED_WORKFLOW: {
                PublishWorkflowResource publishWorkflowResource = new PublishWorkflowResource();
                publishWorkflowResource.setGateway(this);
                return publishWorkflowResource;
            }
            case USER_WORKFLOW: {
                UserWorkflowResource userWorkflowResource = new UserWorkflowResource();
                userWorkflowResource.setGateway(this);
                return userWorkflowResource;
            }
            case HOST_DESCRIPTOR: {
                HostDescriptorResource hostDescriptorResource = new HostDescriptorResource();
                hostDescriptorResource.setGatewayName(this.gatewayName);
                return hostDescriptorResource;
            }
            case SERVICE_DESCRIPTOR: {
                ServiceDescriptorResource serviceDescriptorResource = new ServiceDescriptorResource();
                serviceDescriptorResource.setGatewayName(this.gatewayName);
                return serviceDescriptorResource;
            }
            case APPLICATION_DESCRIPTOR: {
                ApplicationDescriptorResource applicationDescriptorResource = new ApplicationDescriptorResource();
                applicationDescriptorResource.setGatewayName(this.gatewayName);
                return applicationDescriptorResource;
            }
            case EXPERIMENT: {
                ExperimentResource experimentResource = new ExperimentResource();
                experimentResource.setGateway(this);
                return experimentResource;
            }
            case GATEWAY_WORKER: {
                WorkerResource workerResource = new WorkerResource();
                workerResource.setGateway(this);
                return workerResource;
            }
        }
        logger.error("Unsupported resource type for gateway resource.", (Throwable)new IllegalArgumentException());
        throw new IllegalArgumentException("Unsupported resource type for gateway resource.");
    }

    @Override
    public void remove(ResourceType type, Object name) {
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        switch (type) {
            case USER: {
                QueryGenerator generator = new QueryGenerator("Users", new Object[0][]);
                generator.setParameter("user_name", name);
                Query q = generator.deleteQuery(em);
                q.executeUpdate();
                break;
            }
            case PUBLISHED_WORKFLOW: {
                QueryGenerator generator = new QueryGenerator("Published_Workflow", new Object[0][]);
                generator.setParameter("publish_workflow_name", name);
                generator.setParameter("gateway_name", this.gatewayName);
                Query q = generator.deleteQuery(em);
                q.executeUpdate();
                break;
            }
            case HOST_DESCRIPTOR: {
                QueryGenerator generator = new QueryGenerator("Host_Descriptor", new Object[0][]);
                generator.setParameter("host_descriptor_ID", name);
                generator.setParameter("gateway_name", this.gatewayName);
                Query q = generator.deleteQuery(em);
                q.executeUpdate();
                break;
            }
            case SERVICE_DESCRIPTOR: {
                QueryGenerator generator = new QueryGenerator("Service_Descriptor", new Object[0][]);
                generator.setParameter("service_descriptor_ID", name);
                generator.setParameter("gateway_name", this.gatewayName);
                Query q = generator.deleteQuery(em);
                q.executeUpdate();
                break;
            }
            case EXPERIMENT: {
                QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
                generator.setParameter("experiment_ID", name);
                generator.setParameter("gateway_name", this.gatewayName);
                Query q = generator.deleteQuery(em);
                q.executeUpdate();
                break;
            }
            case APPLICATION_DESCRIPTOR: {
                QueryGenerator generator = new QueryGenerator("Application_Descriptor", new Object[0][]);
                generator.setParameter("application_descriptor_ID", name);
                generator.setParameter("gateway_name", this.gatewayName);
                Query q = generator.deleteQuery(em);
                q.executeUpdate();
                break;
            }
            default: {
                logger.error("Unsupported resource type for gateway resource.", (Throwable)new IllegalArgumentException());
            }
        }
        em.getTransaction().commit();
        em.close();
    }

    @Override
    public Resource get(ResourceType type, Object name) {
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        switch (type) {
            case USER: {
                QueryGenerator generator = new QueryGenerator("Gateway_Worker", new Object[0][]);
                generator.setParameter("user_name", name);
                generator.setParameter("gateway_name", this.gatewayName);
                Query q = generator.selectQuery(em);
                Gateway_Worker worker = (Gateway_Worker)q.getSingleResult();
                WorkerResource workerResource = (WorkerResource)Utils.getResource(ResourceType.GATEWAY_WORKER, worker);
                em.getTransaction().commit();
                em.close();
                return workerResource;
            }
            case PUBLISHED_WORKFLOW: {
                QueryGenerator generator = new QueryGenerator("Published_Workflow", new Object[0][]);
                generator.setParameter("publish_workflow_name", name);
                generator.setParameter("gateway_name", this.gatewayName);
                Query q = generator.selectQuery(em);
                Published_Workflow ePub_workflow = (Published_Workflow)q.getSingleResult();
                PublishWorkflowResource publishWorkflowResource = (PublishWorkflowResource)Utils.getResource(ResourceType.PUBLISHED_WORKFLOW, ePub_workflow);
                em.getTransaction().commit();
                em.close();
                return publishWorkflowResource;
            }
            case HOST_DESCRIPTOR: {
                QueryGenerator generator = new QueryGenerator("Host_Descriptor", new Object[0][]);
                generator.setParameter("host_descriptor_ID", name);
                generator.setParameter("gateway_name", this.gatewayName);
                Query q = generator.selectQuery(em);
                Host_Descriptor eHostDesc = (Host_Descriptor)q.getSingleResult();
                HostDescriptorResource hostDescriptorResource = (HostDescriptorResource)Utils.getResource(ResourceType.HOST_DESCRIPTOR, eHostDesc);
                em.getTransaction().commit();
                em.close();
                return hostDescriptorResource;
            }
            case EXPERIMENT: {
                QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
                generator.setParameter("experiment_ID", name);
                generator.setParameter("gateway_name", this.gatewayName);
                Query q = generator.selectQuery(em);
                Experiment experiment = (Experiment)q.getSingleResult();
                ExperimentResource experimentResource = (ExperimentResource)Utils.getResource(ResourceType.EXPERIMENT, experiment);
                em.getTransaction().commit();
                em.close();
                return experimentResource;
            }
            case SERVICE_DESCRIPTOR: {
                QueryGenerator generator = new QueryGenerator("Service_Descriptor", new Object[0][]);
                generator.setParameter("service_descriptor_ID", name);
                generator.setParameter("gateway_name", this.gatewayName);
                Query q = generator.selectQuery(em);
                Service_Descriptor eServiceDesc = (Service_Descriptor)q.getSingleResult();
                ServiceDescriptorResource serviceDescriptorResource = (ServiceDescriptorResource)Utils.getResource(ResourceType.SERVICE_DESCRIPTOR, eServiceDesc);
                em.getTransaction().commit();
                em.close();
                return serviceDescriptorResource;
            }
            case APPLICATION_DESCRIPTOR: {
                QueryGenerator generator = new QueryGenerator("Application_Descriptor", new Object[0][]);
                generator.setParameter("application_descriptor_ID", name);
                generator.setParameter("gateway_name", this.gatewayName);
                Query q = generator.selectQuery(em);
                Application_Descriptor eAppDesc = (Application_Descriptor)q.getSingleResult();
                ApplicationDescriptorResource applicationDescriptorResource = (ApplicationDescriptorResource)Utils.getResource(ResourceType.APPLICATION_DESCRIPTOR, eAppDesc);
                em.getTransaction().commit();
                em.close();
                return applicationDescriptorResource;
            }
        }
        em.getTransaction().commit();
        em.close();
        logger.error("Unsupported resource type for gateway resource.", (Throwable)new IllegalArgumentException());
        throw new IllegalArgumentException("Unsupported resource type for gateway resource.");
    }

    @Override
    public List<Resource> get(ResourceType type) {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        switch (type) {
            case PROJECT: {
                QueryGenerator generator = new QueryGenerator("Project", new Object[0][]);
                Gateway gatewayModel = (Gateway)em.find(Gateway.class, (Object)this.gatewayName);
                generator.setParameter("gateway", gatewayModel);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() == 0) break;
                for (Object result : results) {
                    Project project = (Project)result;
                    ProjectResource projectResource = (ProjectResource)Utils.getResource(ResourceType.PROJECT, project);
                    resourceList.add(projectResource);
                }
                break;
            }
            case GATEWAY_WORKER: {
                QueryGenerator generator = new QueryGenerator("Gateway_Worker", new Object[0][]);
                generator.setParameter("gateway_name", this.gatewayName);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() == 0) break;
                for (Object result : results) {
                    Gateway_Worker gatewayWorker = (Gateway_Worker)result;
                    WorkerResource workerResource = (WorkerResource)Utils.getResource(ResourceType.GATEWAY_WORKER, gatewayWorker);
                    resourceList.add(workerResource);
                }
                break;
            }
            case PUBLISHED_WORKFLOW: {
                QueryGenerator generator = new QueryGenerator("Published_Workflow", new Object[0][]);
                generator.setParameter("gateway_name", this.gatewayName);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() == 0) break;
                for (Object result : results) {
                    Published_Workflow publishedWorkflow = (Published_Workflow)result;
                    PublishWorkflowResource publishWorkflowResource = (PublishWorkflowResource)Utils.getResource(ResourceType.PUBLISHED_WORKFLOW, publishedWorkflow);
                    resourceList.add(publishWorkflowResource);
                }
                break;
            }
            case HOST_DESCRIPTOR: {
                QueryGenerator generator = new QueryGenerator("Host_Descriptor", new Object[0][]);
                generator.setParameter("gateway_name", this.gatewayName);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() == 0) break;
                for (Object result : results) {
                    Host_Descriptor hostDescriptor = (Host_Descriptor)result;
                    HostDescriptorResource hostDescriptorResource = (HostDescriptorResource)Utils.getResource(ResourceType.HOST_DESCRIPTOR, hostDescriptor);
                    resourceList.add(hostDescriptorResource);
                }
                break;
            }
            case SERVICE_DESCRIPTOR: {
                QueryGenerator generator = new QueryGenerator("Service_Descriptor", new Object[0][]);
                generator.setParameter("gateway_name", this.gatewayName);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() == 0) break;
                for (Object result : results) {
                    Service_Descriptor serviceDescriptor = (Service_Descriptor)result;
                    ServiceDescriptorResource serviceDescriptorResource = (ServiceDescriptorResource)Utils.getResource(ResourceType.SERVICE_DESCRIPTOR, serviceDescriptor);
                    resourceList.add(serviceDescriptorResource);
                }
                break;
            }
            case APPLICATION_DESCRIPTOR: {
                QueryGenerator generator = new QueryGenerator("Application_Descriptor", new Object[0][]);
                generator.setParameter("gateway_name", this.gatewayName);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() == 0) break;
                for (Object result : results) {
                    Application_Descriptor applicationDescriptor = (Application_Descriptor)result;
                    ApplicationDescriptorResource applicationDescriptorResource = (ApplicationDescriptorResource)Utils.getResource(ResourceType.APPLICATION_DESCRIPTOR, applicationDescriptor);
                    resourceList.add(applicationDescriptorResource);
                }
                break;
            }
            case EXPERIMENT: {
                QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
                generator.setParameter("gateway_name", this.gatewayName);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() == 0) break;
                for (Object result : results) {
                    Experiment experiment = (Experiment)result;
                    ExperimentResource experimentResource = (ExperimentResource)Utils.getResource(ResourceType.EXPERIMENT, experiment);
                    resourceList.add(experimentResource);
                }
                break;
            }
            default: {
                em.getTransaction().commit();
                em.close();
                logger.error("Unsupported resource type for gateway resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for gateway resource.");
            }
        }
        em.getTransaction().commit();
        em.close();
        return resourceList;
    }

    @Override
    public void save() {
        EntityManager em = ResourceUtils.getEntityManager();
        Gateway existingGateway = (Gateway)em.find(Gateway.class, (Object)this.gatewayName);
        em.close();
        em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        Gateway gateway = new Gateway();
        gateway.setGateway_name(this.gatewayName);
        gateway.setOwner(this.owner);
        if (existingGateway != null) {
            existingGateway.setOwner(this.owner);
            gateway = (Gateway)em.merge((Object)existingGateway);
        } else {
            em.persist((Object)gateway);
        }
        em.getTransaction().commit();
        em.close();
    }

    @Override
    public boolean isExists(ResourceType type, Object name) {
        switch (type) {
            case USER: {
                EntityManager em = ResourceUtils.getEntityManager();
                Gateway_Worker existingWorker = (Gateway_Worker)em.find(Gateway_Worker.class, (Object)new Gateway_Worker_PK(this.gatewayName, name.toString()));
                em.close();
                return existingWorker != null;
            }
            case PUBLISHED_WORKFLOW: {
                EntityManager em = ResourceUtils.getEntityManager();
                Published_Workflow existingWf = (Published_Workflow)em.find(Published_Workflow.class, (Object)new Published_Workflow_PK(this.gatewayName, name.toString()));
                em.close();
                boolean a = existingWf != null;
                return existingWf != null;
            }
            case HOST_DESCRIPTOR: {
                EntityManager em = ResourceUtils.getEntityManager();
                Host_Descriptor existingHostDesc = (Host_Descriptor)em.find(Host_Descriptor.class, (Object)new Host_Descriptor_PK(this.gatewayName, name.toString()));
                em.close();
                return existingHostDesc != null;
            }
            case SERVICE_DESCRIPTOR: {
                EntityManager em = ResourceUtils.getEntityManager();
                Service_Descriptor existingServiceDesc = (Service_Descriptor)em.find(Service_Descriptor.class, (Object)new Service_Descriptor_PK(this.gatewayName, name.toString()));
                em.close();
                return existingServiceDesc != null;
            }
            case APPLICATION_DESCRIPTOR: {
                EntityManager em = ResourceUtils.getEntityManager();
                Application_Descriptor existingAppDesc = (Application_Descriptor)em.find(Application_Descriptor.class, (Object)new Application_Descriptor_PK(this.gatewayName, name.toString()));
                em.close();
                return existingAppDesc != null;
            }
            case EXPERIMENT: {
                EntityManager em = ResourceUtils.getEntityManager();
                Experiment existingExp = (Experiment)em.find(Experiment.class, (Object)name.toString());
                em.close();
                return existingExp != null;
            }
        }
        logger.error("Unsupported resource type for gateway resource.", (Throwable)new IllegalArgumentException());
        throw new IllegalArgumentException("Unsupported resource type for gateway resource.");
    }

    public boolean isHostDescriptorExists(String descriptorName) {
        return this.isExists(ResourceType.HOST_DESCRIPTOR, descriptorName);
    }

    public HostDescriptorResource createHostDescriptorResource(String hostDescriptorName) {
        HostDescriptorResource hdr = (HostDescriptorResource)this.create(ResourceType.HOST_DESCRIPTOR);
        hdr.setHostDescName(hostDescriptorName);
        return hdr;
    }

    public HostDescriptorResource getHostDescriptorResource(String hostDescriptorName) {
        return (HostDescriptorResource)this.get(ResourceType.HOST_DESCRIPTOR, hostDescriptorName);
    }

    public void removeHostDescriptor(String descriptorName) {
        this.remove(ResourceType.HOST_DESCRIPTOR, descriptorName);
    }

    public List<HostDescriptorResource> getHostDescriptorResources() {
        ArrayList<HostDescriptorResource> results = new ArrayList<HostDescriptorResource>();
        List<Resource> list = this.get(ResourceType.HOST_DESCRIPTOR);
        for (Resource resource : list) {
            results.add((HostDescriptorResource)resource);
        }
        return results;
    }

    public boolean isServiceDescriptorExists(String descriptorName) {
        return this.isExists(ResourceType.SERVICE_DESCRIPTOR, descriptorName);
    }

    public ServiceDescriptorResource createServiceDescriptorResource(String descriptorName) {
        ServiceDescriptorResource hdr = (ServiceDescriptorResource)this.create(ResourceType.SERVICE_DESCRIPTOR);
        hdr.setServiceDescName(descriptorName);
        return hdr;
    }

    public ServiceDescriptorResource getServiceDescriptorResource(String descriptorName) {
        return (ServiceDescriptorResource)this.get(ResourceType.SERVICE_DESCRIPTOR, descriptorName);
    }

    public void removeServiceDescriptor(String descriptorName) {
        this.remove(ResourceType.SERVICE_DESCRIPTOR, descriptorName);
    }

    public List<ServiceDescriptorResource> getServiceDescriptorResources() {
        ArrayList<ServiceDescriptorResource> results = new ArrayList<ServiceDescriptorResource>();
        List<Resource> list = this.get(ResourceType.SERVICE_DESCRIPTOR);
        for (Resource resource : list) {
            results.add((ServiceDescriptorResource)resource);
        }
        return results;
    }

    public boolean isApplicationDescriptorExists(String descriptorName) {
        return this.isExists(ResourceType.APPLICATION_DESCRIPTOR, descriptorName);
    }

    public ApplicationDescriptorResource createApplicationDescriptorResource(String descriptorName) {
        ApplicationDescriptorResource hdr = (ApplicationDescriptorResource)this.create(ResourceType.APPLICATION_DESCRIPTOR);
        hdr.setName(descriptorName);
        return hdr;
    }

    public ApplicationDescriptorResource getApplicationDescriptorResource(String descriptorName) {
        return (ApplicationDescriptorResource)this.get(ResourceType.APPLICATION_DESCRIPTOR, descriptorName);
    }

    public void removeApplicationDescriptor(String descriptorName) {
        this.remove(ResourceType.APPLICATION_DESCRIPTOR, descriptorName);
    }

    public List<ApplicationDescriptorResource> getApplicationDescriptorResources() {
        ArrayList<ApplicationDescriptorResource> results = new ArrayList<ApplicationDescriptorResource>();
        List<Resource> list = this.get(ResourceType.APPLICATION_DESCRIPTOR);
        for (Resource resource : list) {
            results.add((ApplicationDescriptorResource)resource);
        }
        return results;
    }

    public List<ApplicationDescriptorResource> getApplicationDescriptorResources(String serviceName, String hostName) {
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        String qString = "SELECT p FROM Application_Descriptor p WHERE p.gateway_name =:gate_name";
        if (hostName != null) {
            qString = qString + " and p.host_descriptor_ID =:host_name";
        }
        if (serviceName != null) {
            qString = qString + " and p.service_descriptor_ID =:service_name";
        }
        Query q = em.createQuery(qString);
        q.setParameter("gate_name", (Object)this.gatewayName);
        if (serviceName != null) {
            q.setParameter("service_name", (Object)serviceName);
        }
        if (hostName != null) {
            q.setParameter("host_name", (Object)hostName);
        }
        List results = q.getResultList();
        ArrayList<ApplicationDescriptorResource> resourceList = new ArrayList<ApplicationDescriptorResource>();
        if (results.size() != 0) {
            for (Object result : results) {
                Application_Descriptor applicationDescriptor = (Application_Descriptor)result;
                ApplicationDescriptorResource applicationDescriptorResource = new ApplicationDescriptorResource(applicationDescriptor.getApplication_descriptor_ID(), applicationDescriptor.getGateway().getGateway_name());
                applicationDescriptorResource.setContent(new String(applicationDescriptor.getApplication_descriptor_xml()));
                applicationDescriptorResource.setUpdatedUser(applicationDescriptor.getUser().getUser_name());
                applicationDescriptorResource.setHostDescName(applicationDescriptor.getHost_descriptor_ID());
                applicationDescriptorResource.setServiceDescName(applicationDescriptor.getService_descriptor_ID());
                resourceList.add(applicationDescriptorResource);
            }
        }
        em.getTransaction().commit();
        em.close();
        return resourceList;
    }

    public boolean isPublishedWorkflowExists(String workflowTemplateName) {
        return this.isExists(ResourceType.PUBLISHED_WORKFLOW, workflowTemplateName);
    }

    public PublishWorkflowResource createPublishedWorkflow(String workflowTemplateName) {
        PublishWorkflowResource publishedWorkflowResource = (PublishWorkflowResource)this.create(ResourceType.PUBLISHED_WORKFLOW);
        publishedWorkflowResource.setName(workflowTemplateName);
        publishedWorkflowResource.setPath("/");
        publishedWorkflowResource.setVersion("1.0");
        return publishedWorkflowResource;
    }

    public PublishWorkflowResource getPublishedWorkflow(String workflowTemplateName) {
        return (PublishWorkflowResource)this.get(ResourceType.PUBLISHED_WORKFLOW, workflowTemplateName);
    }

    public List<PublishWorkflowResource> getPublishedWorkflows() {
        ArrayList<PublishWorkflowResource> result = new ArrayList<PublishWorkflowResource>();
        List<Resource> list = this.get(ResourceType.PUBLISHED_WORKFLOW);
        for (Resource resource : list) {
            result.add((PublishWorkflowResource)resource);
        }
        return result;
    }

    public void removePublishedWorkflow(String workflowTemplateName) {
        this.remove(ResourceType.PUBLISHED_WORKFLOW, workflowTemplateName);
    }
}

