/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import javax.persistence.Persistence;
import javax.persistence.Query;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.model.Configuration;
import org.apache.airavata.persistance.registry.jpa.model.Configuration_PK;
import org.apache.airavata.persistance.registry.jpa.model.Gateway;
import org.apache.airavata.persistance.registry.jpa.model.Gateway_Worker;
import org.apache.airavata.persistance.registry.jpa.model.Gateway_Worker_PK;
import org.apache.airavata.persistance.registry.jpa.model.Users;
import org.apache.airavata.persistance.registry.jpa.resources.ConfigurationResource;
import org.apache.airavata.persistance.registry.jpa.resources.GatewayResource;
import org.apache.airavata.persistance.registry.jpa.resources.UserResource;
import org.apache.airavata.persistance.registry.jpa.resources.Utils;
import org.apache.airavata.persistance.registry.jpa.resources.WorkerResource;
import org.apache.airavata.persistance.registry.jpa.utils.QueryGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtils {
    private static final Logger logger = LoggerFactory.getLogger(ResourceUtils.class);
    private static final String PERSISTENCE_UNIT_NAME = "airavata_data";
    protected static EntityManagerFactory factory;
    private static Lock lock;

    public static EntityManager getEntityManager() {
        if (factory == null) {
            String connectionProperties = "DriverClassName=" + Utils.getJDBCDriver() + "," + "Url=" + Utils.getJDBCURL() + "," + "Username=" + Utils.getJDBCUser() + "," + "Password=" + Utils.getJDBCPassword() + ",validationQuery=" + Utils.getValidationQuery() + "," + Utils.getJPAConnectionProperties();
            System.out.println(connectionProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("openjpa.ConnectionDriverName", "org.apache.commons.dbcp.BasicDataSource");
            properties.put("openjpa.ConnectionProperties", connectionProperties);
            properties.put("openjpa.DynamicEnhancementAgent", "true");
            properties.put("openjpa.RuntimeUnenhancedClasses", "unsupported");
            properties.put("openjpa.Log", "SQL=ERROR");
            properties.put("openjpa.ReadLockLevel", "none");
            properties.put("openjpa.WriteLockLevel", "none");
            properties.put("openjpa.LockTimeout", "30000");
            properties.put("openjpa.LockManager", "none");
            properties.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
            properties.put("openjpa.ConnectionFactoryProperties", "PrettyPrint=true, PrettyPrintLineLength=72, PrintParameters=true, MaxActive=10, MaxIdle=5, MinIdle=2, MaxWait=60000");
            properties.put("openjpa.jdbc.QuerySQLCache", "false");
            factory = Persistence.createEntityManagerFactory((String)PERSISTENCE_UNIT_NAME, properties);
        }
        return factory.createEntityManager();
    }

    public static Resource createGateway(String gatewayName) {
        if (!ResourceUtils.isGatewayExist(gatewayName)) {
            GatewayResource gatewayResource = new GatewayResource();
            gatewayResource.setGatewayName(gatewayName);
            return gatewayResource;
        }
        return null;
    }

    public static Resource getGateway(String gatewayName) {
        if (ResourceUtils.isGatewayExist(gatewayName)) {
            EntityManager em = ResourceUtils.getEntityManager();
            Gateway gateway = (Gateway)em.find(Gateway.class, (Object)gatewayName);
            GatewayResource gatewayResource = (GatewayResource)Utils.getResource(ResourceType.GATEWAY, gateway);
            em.close();
            return gatewayResource;
        }
        return null;
    }

    public static Resource getWorker(String gatewayName, String userName) {
        EntityManager em = ResourceUtils.getEntityManager();
        Gateway_Worker gatewayWorker = (Gateway_Worker)em.find(Gateway_Worker.class, (Object)new Gateway_Worker_PK(gatewayName, userName));
        WorkerResource workerResource = (WorkerResource)Utils.getResource(ResourceType.GATEWAY_WORKER, gatewayWorker);
        em.close();
        return workerResource;
    }

    public static boolean isGatewayExist(String gatewayName) {
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        QueryGenerator generator = new QueryGenerator("Gateway", new Object[0][]);
        generator.setParameter("gateway_name", gatewayName);
        Query q = generator.selectQuery(em);
        Gateway gateway = (Gateway)q.getSingleResult();
        em.getTransaction().commit();
        em.close();
        return gateway != null;
    }

    public static boolean removeGateway(String gatewayName) {
        try {
            EntityManager em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            QueryGenerator generator = new QueryGenerator("Gateway", new Object[0][]);
            generator.setParameter("gateway_name", gatewayName);
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            em.close();
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static void addGatewayWorker(GatewayResource gatewayResource, UserResource userResource) {
        try {
            EntityManager em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Gateway gateway = new Gateway();
            gateway.setGateway_name(gatewayResource.getGatewayName());
            Users user = new Users();
            user.setUser_name(userResource.getUserName());
            Gateway_Worker gatewayWorker = new Gateway_Worker();
            gatewayWorker.setGateway(gateway);
            gatewayWorker.setUser(user);
            em.persist((Object)gatewayWorker);
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean removeGatewayWorker(GatewayResource gatewayResource, UserResource userResource) {
        try {
            EntityManager em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            QueryGenerator generator = new QueryGenerator("Gateway_Worker", new Object[0][]);
            generator.setParameter("gateway_name", gatewayResource.getGatewayName());
            generator.setParameter("user_name", userResource.getUserName());
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            em.close();
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static List<ConfigurationResource> getConfigurations(String configKey) {
        ArrayList<ConfigurationResource> list = new ArrayList<ConfigurationResource>();
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        QueryGenerator generator = new QueryGenerator("Configuration", new Object[0][]);
        generator.setParameter("config_key", configKey);
        Query q = generator.selectQuery(em);
        List resultList = q.getResultList();
        if (resultList.size() != 0) {
            for (Object result : resultList) {
                ConfigurationResource configurationResource = ResourceUtils.createConfigurationResourceObject(result);
                list.add(configurationResource);
            }
        }
        em.getTransaction().commit();
        em.close();
        return list;
    }

    public static ConfigurationResource getConfiguration(String configKey) {
        List<ConfigurationResource> configurations = ResourceUtils.getConfigurations(configKey);
        return configurations != null && configurations.size() > 0 ? configurations.get(0) : null;
    }

    public static boolean isConfigurationExist(String configKey) {
        List<ConfigurationResource> configurations = ResourceUtils.getConfigurations(configKey);
        return configurations != null && configurations.size() > 0;
    }

    public static ConfigurationResource createConfiguration(String configKey) {
        ConfigurationResource config = new ConfigurationResource();
        config.setConfigKey(configKey);
        return config;
    }

    private static ConfigurationResource createConfigurationResourceObject(Object result) {
        Configuration configuration = (Configuration)result;
        ConfigurationResource configurationResource = new ConfigurationResource(configuration.getConfig_key(), configuration.getConfig_val());
        configurationResource.setExpireDate(configuration.getExpire_date());
        return configurationResource;
    }

    public static void removeConfiguration(String configkey, String configValue) {
        QueryGenerator queryGenerator = new QueryGenerator("Configuration", new Object[0][]);
        queryGenerator.setParameter("config_key", configkey);
        queryGenerator.setParameter("config_val", configValue);
        if (ResourceUtils.isConfigurationExists(configkey, configValue)) {
            EntityManager em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Query q = queryGenerator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            em.close();
        }
    }

    public static void removeConfiguration(String configkey) {
        QueryGenerator queryGenerator = new QueryGenerator("Configuration", new Object[0][]);
        queryGenerator.setParameter("config_key", configkey);
        if (ResourceUtils.isConfigurationExist(configkey)) {
            EntityManager em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Query q = queryGenerator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            em.close();
        }
    }

    public static boolean isConfigurationExists(String configKey, String configVal) {
        try {
            EntityManager em = ResourceUtils.getEntityManager();
            Configuration existing = (Configuration)em.find(Configuration.class, (Object)new Configuration_PK(configKey, configVal, "SYSTEM"));
            em.close();
            return existing != null;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new EntityNotFoundException();
        }
    }

    public static Lock getLock() {
        return lock;
    }

    static {
        lock = new ReentrantLock();
    }
}

