/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.sql.Timestamp;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Execution_Error;
import org.apache.airavata.persistance.registry.jpa.model.Experiment_Data;
import org.apache.airavata.persistance.registry.jpa.model.Workflow_Data;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentDataResource;
import org.apache.airavata.persistance.registry.jpa.resources.WorkflowDataResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionErrorResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionErrorResource.class);
    private ExperimentDataResource experimentDataResource;
    private WorkflowDataResource workflowDataResource;
    private String nodeID;
    private String gfacJobID;
    private String sourceType;
    private Timestamp errorTime;
    private String errorMsg;
    private String errorDes;
    private String errorCode;
    private int errorID;
    private String errorReporter;
    private String errorLocation;
    private String actionTaken;
    private int errorReference;

    @Override
    public Resource create(ResourceType type) {
        logger.error("Unsupported resource type for node error resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) {
        logger.error("Unsupported resource type for node error resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) {
        logger.error("Unsupported resource type for node error resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Resource> get(ResourceType type) {
        logger.error("Unsupported resource type for node error resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() {
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        Execution_Error execution_error = new Execution_Error();
        execution_error.setNode_id(this.nodeID);
        Experiment_Data experiment_data = (Experiment_Data)em.find(Experiment_Data.class, (Object)this.experimentDataResource.getExperimentID());
        execution_error.setExperiment_data(experiment_data);
        Workflow_Data workflow_data = (Workflow_Data)em.find(Workflow_Data.class, (Object)this.workflowDataResource.getWorkflowInstanceID());
        execution_error.setExperiment_ID(experiment_data.getExperiment_ID());
        execution_error.setWorkflow_Data(workflow_data);
        execution_error.setWorkflow_instanceID(workflow_data.getWorkflow_instanceID());
        execution_error.setError_code(this.errorCode);
        execution_error.setError_date(this.errorTime);
        execution_error.setError_des(this.errorDes);
        execution_error.setError_msg(this.errorMsg);
        execution_error.setSource_type(this.sourceType);
        execution_error.setGfacJobID(this.gfacJobID);
        em.persist((Object)execution_error);
        this.errorID = execution_error.getError_id();
        em.getTransaction().commit();
        em.close();
    }

    public ExperimentDataResource getExperimentDataResource() {
        return this.experimentDataResource;
    }

    public WorkflowDataResource getWorkflowDataResource() {
        return this.workflowDataResource;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public String getGfacJobID() {
        return this.gfacJobID;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public Timestamp getErrorTime() {
        return this.errorTime;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String getErrorDes() {
        return this.errorDes;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setExperimentDataResource(ExperimentDataResource experimentDataResource) {
        this.experimentDataResource = experimentDataResource;
    }

    public void setWorkflowDataResource(WorkflowDataResource workflowDataResource) {
        this.workflowDataResource = workflowDataResource;
    }

    public void setNodeID(String nodeID) {
        this.nodeID = nodeID;
    }

    public void setGfacJobID(String gfacJobID) {
        this.gfacJobID = gfacJobID;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public void setErrorTime(Timestamp errorTime) {
        this.errorTime = errorTime;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public void setErrorDes(String errorDes) {
        this.errorDes = errorDes;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public int getErrorID() {
        return this.errorID;
    }

    public void setErrorID(int errorID) {
        this.errorID = errorID;
    }

    public String getErrorReporter() {
        return this.errorReporter;
    }

    public String getErrorLocation() {
        return this.errorLocation;
    }

    public String getActionTaken() {
        return this.actionTaken;
    }

    public void setErrorReporter(String errorReporter) {
        this.errorReporter = errorReporter;
    }

    public void setErrorLocation(String errorLocation) {
        this.errorLocation = errorLocation;
    }

    public void setActionTaken(String actionTaken) {
        this.actionTaken = actionTaken;
    }

    public int getErrorReference() {
        return this.errorReference;
    }

    public void setErrorReference(int errorReference) {
        this.errorReference = errorReference;
    }
}

