/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Execution_Error;
import org.apache.airavata.persistance.registry.jpa.model.Experiment_Data;
import org.apache.airavata.persistance.registry.jpa.model.Experiment_Metadata;
import org.apache.airavata.persistance.registry.jpa.model.GFac_Job_Data;
import org.apache.airavata.persistance.registry.jpa.model.Workflow_Data;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExecutionErrorResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentMetadataResource;
import org.apache.airavata.persistance.registry.jpa.resources.GFacJobDataResource;
import org.apache.airavata.persistance.registry.jpa.resources.Utils;
import org.apache.airavata.persistance.registry.jpa.resources.WorkflowDataResource;
import org.apache.airavata.persistance.registry.jpa.utils.QueryGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentDataResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ExperimentDataResource.class);
    private String experimentID;
    private String expName;
    private String userName;

    public String getExperimentID() {
        return this.experimentID;
    }

    public String getExpName() {
        return this.expName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setExperimentID(String experimentID) {
        this.experimentID = experimentID;
    }

    public void setExpName(String expName) {
        this.expName = expName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public Resource create(ResourceType type) {
        switch (type) {
            case WORKFLOW_DATA: {
                WorkflowDataResource workflowDataResource = new WorkflowDataResource();
                workflowDataResource.setExperimentID(this.experimentID);
                return workflowDataResource;
            }
            case EXECUTION_ERROR: {
                ExecutionErrorResource executionErrorResource = new ExecutionErrorResource();
                executionErrorResource.setExperimentDataResource(this);
                return executionErrorResource;
            }
            case EXPERIMENT_METADATA: {
                ExperimentMetadataResource experimentMetadataResource = new ExperimentMetadataResource();
                experimentMetadataResource.setExpID(this.experimentID);
                return experimentMetadataResource;
            }
            case GFAC_JOB_DATA: {
                GFacJobDataResource gFacJobDataResource = new GFacJobDataResource();
                gFacJobDataResource.setExperimentDataResource(this);
                return gFacJobDataResource;
            }
        }
        logger.error("Unsupported resource type for experiment data resource... ", (Throwable)new UnsupportedOperationException());
        throw new IllegalArgumentException("Unsupported resource type for experiment data resource.");
    }

    @Override
    public void remove(ResourceType type, Object name) {
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        switch (type) {
            case WORKFLOW_DATA: {
                QueryGenerator generator = new QueryGenerator("Workflow_Data", new Object[0][]);
                generator.setParameter("workflow_instanceID", name);
                Query q = generator.deleteQuery(em);
                q.executeUpdate();
                break;
            }
            case EXPERIMENT_METADATA: {
                QueryGenerator generator = new QueryGenerator("Experiment_Metadata", new Object[0][]);
                generator.setParameter("experiment_ID", name);
                Query q = generator.deleteQuery(em);
                q.executeUpdate();
                break;
            }
            case GFAC_JOB_DATA: {
                QueryGenerator generator = new QueryGenerator("GFac_Job_Data", new Object[0][]);
                generator.setParameter("local_Job_ID", name);
                Query q = generator.deleteQuery(em);
                q.executeUpdate();
                break;
            }
        }
        em.getTransaction().commit();
        em.close();
    }

    @Override
    public Resource get(ResourceType type, Object name) {
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        switch (type) {
            case WORKFLOW_DATA: {
                QueryGenerator generator = new QueryGenerator("Workflow_Data", new Object[0][]);
                generator.setParameter("workflow_instanceID", name);
                Query q = generator.selectQuery(em);
                Workflow_Data eworkflowData = (Workflow_Data)q.getSingleResult();
                WorkflowDataResource workflowDataResource = (WorkflowDataResource)Utils.getResource(ResourceType.WORKFLOW_DATA, eworkflowData);
                em.getTransaction().commit();
                em.close();
                return workflowDataResource;
            }
            case EXPERIMENT_METADATA: {
                QueryGenerator generator = new QueryGenerator("Experiment_Metadata", new Object[0][]);
                generator.setParameter("experiment_ID", name);
                Query q = generator.selectQuery(em);
                Experiment_Metadata expMetadata = (Experiment_Metadata)q.getSingleResult();
                ExperimentMetadataResource experimentMetadataResource = (ExperimentMetadataResource)Utils.getResource(ResourceType.EXPERIMENT_METADATA, expMetadata);
                em.getTransaction().commit();
                em.close();
                return experimentMetadataResource;
            }
            case GFAC_JOB_DATA: {
                QueryGenerator generator = new QueryGenerator("GFac_Job_Data", new Object[0][]);
                generator.setParameter("local_Job_ID", name);
                Query q = generator.selectQuery(em);
                GFac_Job_Data gFacJobData = (GFac_Job_Data)q.getSingleResult();
                GFacJobDataResource gFacJobDataResource = (GFacJobDataResource)Utils.getResource(ResourceType.GFAC_JOB_DATA, gFacJobData);
                em.getTransaction().commit();
                em.close();
                return gFacJobDataResource;
            }
        }
        em.getTransaction().commit();
        em.close();
        logger.error("Unsupported resource type for experiment data resource... ", (Throwable)new UnsupportedOperationException());
        throw new IllegalArgumentException("Unsupported resource type for experiment data resource.");
    }

    @Override
    public List<Resource> get(ResourceType type) {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        switch (type) {
            case WORKFLOW_DATA: {
                QueryGenerator generator = new QueryGenerator("Workflow_Data", new Object[0][]);
                Experiment_Data experiment_data = (Experiment_Data)em.find(Experiment_Data.class, (Object)this.experimentID);
                generator.setParameter("experiment_data", experiment_data);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() == 0) break;
                for (Object result : results) {
                    Workflow_Data workflowData = (Workflow_Data)result;
                    WorkflowDataResource workflowDataResource = (WorkflowDataResource)Utils.getResource(ResourceType.WORKFLOW_DATA, workflowData);
                    resourceList.add(workflowDataResource);
                }
                break;
            }
            case EXPERIMENT_METADATA: {
                QueryGenerator generator = new QueryGenerator("Experiment_Metadata", new Object[0][]);
                generator.setParameter("experiment_ID", this.experimentID);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() == 0) break;
                for (Object result : results) {
                    Experiment_Metadata expMetadata = (Experiment_Metadata)result;
                    ExperimentMetadataResource experimentMetadataResource = (ExperimentMetadataResource)Utils.getResource(ResourceType.EXPERIMENT_METADATA, expMetadata);
                    resourceList.add(experimentMetadataResource);
                }
                break;
            }
            case EXECUTION_ERROR: {
                QueryGenerator generator = new QueryGenerator("Execution_Error", new Object[0][]);
                generator.setParameter("experiment_ID", this.experimentID);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() == 0) break;
                for (Object result : results) {
                    Execution_Error executionError = (Execution_Error)result;
                    ExecutionErrorResource executionErrorResource = (ExecutionErrorResource)Utils.getResource(ResourceType.EXECUTION_ERROR, executionError);
                    resourceList.add(executionErrorResource);
                }
                break;
            }
            case GFAC_JOB_DATA: {
                QueryGenerator generator = new QueryGenerator("GFac_Job_Data", new Object[0][]);
                generator.setParameter("experiment_ID", this.experimentID);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() == 0) break;
                for (Object result : results) {
                    GFac_Job_Data gFacJobData = (GFac_Job_Data)result;
                    GFacJobDataResource gFacJobDataResource = (GFacJobDataResource)Utils.getResource(ResourceType.GFAC_JOB_DATA, gFacJobData);
                    resourceList.add(gFacJobDataResource);
                }
                break;
            }
            default: {
                em.getTransaction().commit();
                em.close();
                logger.error("Unsupported resource type for experiment data resource... ", (Throwable)new UnsupportedOperationException());
                throw new IllegalArgumentException("Unsupported resource type for experiment data resource.");
            }
        }
        em.getTransaction().commit();
        em.close();
        return resourceList;
    }

    @Override
    public void save() {
        EntityManager em = ResourceUtils.getEntityManager();
        Experiment_Data existingExpData = (Experiment_Data)em.find(Experiment_Data.class, (Object)this.experimentID);
        em.close();
        em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        Experiment_Data experimentData = new Experiment_Data();
        experimentData.setExperiment_ID(this.experimentID);
        experimentData.setName(this.expName);
        experimentData.setUsername(this.userName);
        if (existingExpData != null) {
            existingExpData.setName(this.expName);
            existingExpData.setUsername(this.userName);
            experimentData = (Experiment_Data)em.merge((Object)existingExpData);
        } else {
            em.persist((Object)experimentData);
        }
        em.getTransaction().commit();
        em.close();
    }

    public boolean isWorkflowInstancePresent(String workflowInstanceId) {
        return this.isExists(ResourceType.WORKFLOW_DATA, workflowInstanceId);
    }

    public boolean isGFacJobPresent(String jobId) {
        return this.isExists(ResourceType.GFAC_JOB_DATA, jobId);
    }

    public boolean isExperimentMetadataPresent() {
        return this.isExists(ResourceType.EXPERIMENT_METADATA, this.getExperimentID());
    }

    public WorkflowDataResource getWorkflowInstance(String workflowInstanceId) {
        return (WorkflowDataResource)this.get(ResourceType.WORKFLOW_DATA, workflowInstanceId);
    }

    public List<Resource> getGFacJobs() {
        return this.get(ResourceType.GFAC_JOB_DATA);
    }

    public ExperimentMetadataResource getExperimentMetadata() {
        return (ExperimentMetadataResource)this.get(ResourceType.EXPERIMENT_METADATA, this.getExperimentID());
    }

    public List<WorkflowDataResource> getWorkflowInstances() {
        return ExperimentDataResource.getResourceList(this.get(ResourceType.WORKFLOW_DATA), WorkflowDataResource.class);
    }

    public WorkflowDataResource createWorkflowInstanceResource(String workflowInstanceID) {
        WorkflowDataResource r = (WorkflowDataResource)this.create(ResourceType.WORKFLOW_DATA);
        r.setWorkflowInstanceID(workflowInstanceID);
        return r;
    }

    public GFacJobDataResource createGFacJob(String jobID) {
        GFacJobDataResource r = (GFacJobDataResource)this.create(ResourceType.GFAC_JOB_DATA);
        r.setLocalJobID(jobID);
        return r;
    }

    public ExperimentMetadataResource createExperimentMetadata() {
        return (ExperimentMetadataResource)this.create(ResourceType.EXPERIMENT_METADATA);
    }

    public ExecutionErrorResource createExecutionError() {
        return (ExecutionErrorResource)this.create(ResourceType.EXECUTION_ERROR);
    }

    public void removeWorkflowInstance(String workflowInstanceId) {
        this.remove(ResourceType.WORKFLOW_DATA, workflowInstanceId);
    }

    public void removeExperimentMetadata() {
        this.remove(ResourceType.EXPERIMENT_METADATA, this.getExperimentID());
    }

    public List<ExecutionErrorResource> getExecutionErrors(String type, String experimentId, String workflowInstanceId, String nodeId, String gfacJobId) {
        Query q;
        List results;
        ArrayList<ExecutionErrorResource> resourceList = new ArrayList<ExecutionErrorResource>();
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        QueryGenerator generator = new QueryGenerator("Execution_Error", new Object[0][]);
        if (experimentId != null) {
            generator.setParameter("experiment_ID", experimentId);
        }
        if (type != null) {
            generator.setParameter("source_type", type);
        }
        if (workflowInstanceId != null) {
            generator.setParameter("workflow_instanceID", workflowInstanceId);
        }
        if (nodeId != null) {
            generator.setParameter("node_id", nodeId);
        }
        if (gfacJobId != null) {
            generator.setParameter("gfacJobID", gfacJobId);
        }
        if ((results = (q = generator.selectQuery(em)).getResultList()).size() != 0) {
            for (Object result : results) {
                Execution_Error executionError = (Execution_Error)result;
                ExecutionErrorResource executionErrorResource = (ExecutionErrorResource)Utils.getResource(ResourceType.EXECUTION_ERROR, executionError);
                resourceList.add(executionErrorResource);
            }
        }
        em.getTransaction().commit();
        em.close();
        return resourceList;
    }
}

