/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.client;

import javax.xml.namespace.QName;
import org.apache.airavata.wsmg.client.SubscriptionStub;
import org.apache.airavata.wsmg.client.WidgetStub;
import org.apache.airavata.wsmg.commons.NameSpaceConstants;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.axis2.client.ServiceClient;

public class NotificationProducerStub
extends WidgetStub {
    private static final String RMASSERTION = "RMAssertion";
    private static final String WSRM_NAMESPACE = "http://schemas.xmlsoap.org/ws/2005/02/rm";
    private static final String WSRM = "wsrm";
    private static final OMFactory factory = OMAbstractFactory.getOMFactory();
    private static final SOAPFactory soapfactory = OMAbstractFactory.getSOAP11Factory();

    public NotificationProducerStub(EndpointReference widgetEpr, long timeout) {
        super(widgetEpr, timeout);
    }

    public OMElement getCurrentMessage(OMElement topicExp) throws AxisFault {
        OMElement message = factory.createOMElement("GetCurrentMessage", NameSpaceConstants.WSNT_NS);
        message.addChild((OMNode)topicExp);
        ServiceClient client = this.createServiceClient(message);
        OMElement responseMessage = client.sendReceive(message);
        client.cleanupTransport();
        if (responseMessage.getFirstElement() == null) {
            return null;
        }
        return (OMElement)responseMessage.getChildren().next();
    }

    private ServiceClient createServiceClient(OMElement message) throws AxisFault {
        String uuid = UUIDGenerator.getUUID();
        ServiceClient client = new ServiceClient();
        if (client.getAxisConfiguration().getModule("addressing") != null) {
            client.engageModule("addressing");
        } else {
            SOAPHeaderBlock msgId = soapfactory.createSOAPHeaderBlock("MessageID", NameSpaceConstants.WSA_NS);
            msgId.setText(uuid);
            SOAPHeaderBlock to = soapfactory.createSOAPHeaderBlock("To", NameSpaceConstants.WSA_NS);
            to.setText(this.opts.getTo().getAddress());
            SOAPHeaderBlock action = soapfactory.createSOAPHeaderBlock("Action", NameSpaceConstants.WSA_NS);
            action.setText(message.getNamespace().getNamespaceURI() + "/" + message.getLocalName());
            client.addHeader(action);
            client.addHeader(msgId);
            client.addHeader(to);
        }
        this.opts.setMessageId(uuid);
        this.opts.setAction(message.getNamespace().getNamespaceURI() + "/" + message.getLocalName());
        this.opts.setProperty("__CHUNKED__", (Object)Boolean.FALSE);
        this.opts.setTimeOutInMilliSeconds(this.getTimeoutInMilliSeconds());
        client.setOptions(this.opts);
        return client;
    }

    public SubscriptionStub subscribe(EndpointReference consumerReference, OMElement topicExpression, boolean useNotfy) throws AxisFault {
        return this.subscribe(consumerReference, topicExpression, null, useNotfy, false);
    }

    public SubscriptionStub subscribe(EndpointReference consumerReference, OMElement topicExpression, OMElement xpathExpression, boolean useNotfy) throws AxisFault {
        return this.subscribe(consumerReference, topicExpression, xpathExpression, useNotfy, false);
    }

    public SubscriptionStub subscribe(EndpointReference consumerReference, OMElement topicExpression, boolean useNotfy, boolean wsrm) throws AxisFault {
        return this.subscribe(consumerReference, topicExpression, null, useNotfy, wsrm);
    }

    public SubscriptionStub subscribe(EndpointReference consumerReference, OMElement topicExpression, OMElement xpathExpression, boolean useNotfy, boolean wsrm) throws AxisFault {
        OMElement message = factory.createOMElement("SubscribeRequest", NameSpaceConstants.WSNT_NS);
        message.declareNamespace(NameSpaceConstants.WSNT_NS);
        OMElement eprCrEl = EndpointReferenceHelper.toOM((OMFactory)factory, (EndpointReference)consumerReference, (QName)new QName("ConsumerReference"), (String)NameSpaceConstants.WSA_NS.getNamespaceURI());
        message.addChild((OMNode)eprCrEl);
        eprCrEl.setNamespace(message.getNamespace());
        if (topicExpression != null) {
            message.addChild((OMNode)topicExpression);
            topicExpression.setNamespace(message.getNamespace());
        }
        if (xpathExpression != null) {
            message.addChild((OMNode)xpathExpression);
            xpathExpression.setNamespace(message.getNamespace());
        }
        OMElement useNotifyEl = factory.createOMElement("UseNotify", message.getNamespace(), (OMContainer)message);
        useNotifyEl.setText(useNotfy ? "true" : "false");
        if (wsrm) {
            this.setPolicyAttachment(message);
        }
        ServiceClient client = this.createServiceClient(message);
        OMElement responseMessage = client.sendReceive(message);
        client.cleanupTransport();
        OMElement sr = responseMessage.getFirstChildWithName(new QName(NameSpaceConstants.WSNT_NS.getNamespaceURI(), "SubscriptionReference"));
        if (sr == null) {
            throw new AxisFault("unable to subscribe, invalid response returned by broker");
        }
        return new SubscriptionStub(EndpointReferenceHelper.fromOM((OMElement)sr), this.getTimeoutInMilliSeconds());
    }

    public static void verbose(String msg) {
        System.err.println(msg);
    }

    protected void setPolicyAttachment(OMElement message) {
        OMElement policy = factory.createOMElement("SubscriptionPolicy", message.getNamespace(), (OMContainer)message);
        OMElement childEl = factory.createOMElement(new QName(WSRM_NAMESPACE, WSRM));
        policy.addChild((OMNode)childEl);
    }
}

