/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.client;

import org.apache.airavata.wsmg.client.WsrfResourceStub;
import org.apache.airavata.wsmg.commons.NameSpaceConstants;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.ServiceClient;

public class WidgetStub
extends WsrfResourceStub {
    private static final OMFactory factory = OMAbstractFactory.getOMFactory();
    private static final SOAPFactory soapfactory = OMAbstractFactory.getSOAP11Factory();

    public WidgetStub(EndpointReference widgetEpr, long timeout) {
        super(widgetEpr, timeout);
    }

    public void generateNotification() throws AxisFault {
        OMElement message = factory.createOMElement("generateNotification", NameSpaceConstants.WIDGET_NS);
        ServiceClient client = this.createServiceClient(message);
        client.sendReceive(message);
        client.cleanupTransport();
    }

    private ServiceClient createServiceClient(OMElement message) throws AxisFault {
        ServiceClient client = new ServiceClient();
        String uuid = UUIDGenerator.getUUID();
        if (client.getAxisConfiguration().getModule("addressing") != null) {
            client.engageModule("addressing");
        } else {
            SOAPHeaderBlock msgId = soapfactory.createSOAPHeaderBlock("MessageID", NameSpaceConstants.WSA_NS);
            msgId.setText(uuid);
            SOAPHeaderBlock to = soapfactory.createSOAPHeaderBlock("To", NameSpaceConstants.WSA_NS);
            to.setText(this.opts.getTo().getAddress());
            SOAPHeaderBlock action = soapfactory.createSOAPHeaderBlock("Action", NameSpaceConstants.WSA_NS);
            action.setText(message.getNamespace().getNamespaceURI() + "/" + message.getLocalName());
            client.addHeader(action);
            client.addHeader(msgId);
            client.addHeader(to);
        }
        this.opts.setProperty("__CHUNKED__", (Object)Boolean.FALSE);
        this.opts.setMessageId(uuid);
        this.opts.setAction(message.getNamespace().getNamespaceURI() + "/generateEvent");
        this.opts.setTimeOutInMilliSeconds(this.getTimeoutInMilliSeconds());
        client.setOptions(this.opts);
        return client;
    }
}

