/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.client;

import javax.xml.namespace.QName;
import org.apache.airavata.wsmg.commons.NameSpaceConstants;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;

public class WseCreateSubscription {
    private final OMFactory factory = OMAbstractFactory.getOMFactory();
    private static final SOAPFactory soapfactory = OMAbstractFactory.getSOAP11Factory();
    protected EndpointReference brokerEndPointReference;
    protected long timeoutInMilliSeconds;

    public WseCreateSubscription(EndpointReference brokerLocationEPR, long timeout) {
        this.brokerEndPointReference = brokerLocationEPR;
        this.timeoutInMilliSeconds = timeout;
    }

    public long getTimeoutInMilliSeconds() {
        return this.timeoutInMilliSeconds;
    }

    public void setTimeoutInMilliSeconds(long timeout) {
        this.timeoutInMilliSeconds = timeout;
    }

    public OMElement subscribe(EndpointReference eventSinkReference, OMElement filterEl, boolean useNotfy) throws AxisFault {
        return this.subscribe(eventSinkReference, filterEl, useNotfy, 259200000L);
    }

    public OMElement subscribe(EndpointReference eventSinkReferenceEPR, OMElement filterEl, boolean useNotfy, long expireTime) throws AxisFault {
        OMElement message = this.createMessageEl(eventSinkReferenceEPR, filterEl, expireTime);
        ServiceClient serviceClient = this.createServiceClient(message);
        OMElement responseMessage = serviceClient.sendReceive(message);
        serviceClient.cleanupTransport();
        if (responseMessage == null) {
            throw AxisFault.makeFault((Throwable)new RuntimeException("no response recieved for subscription message"));
        }
        OMElement responseSubscriptionsManagerElement = responseMessage.getFirstChildWithName(new QName(NameSpaceConstants.WSE_NS.getNamespaceURI(), "SubscriptionManager"));
        return responseSubscriptionsManagerElement;
    }

    private ServiceClient createServiceClient(OMElement message) throws AxisFault {
        Options opts = new Options();
        opts.setProperty("__CHUNKED__", (Object)Boolean.FALSE);
        opts.setTo(this.brokerEndPointReference);
        opts.setAction(message.getNamespace().getNamespaceURI() + "/" + message.getLocalName());
        opts.setTimeOutInMilliSeconds(this.getTimeoutInMilliSeconds());
        opts.setMessageId(UUIDGenerator.getUUID());
        ServiceClient client = new ServiceClient();
        if (client.getAxisConfiguration().getModule("addressing") != null) {
            client.engageModule("addressing");
        } else {
            SOAPHeaderBlock msgId = soapfactory.createSOAPHeaderBlock("MessageID", NameSpaceConstants.WSA_NS);
            msgId.setText(UUIDGenerator.getUUID());
            SOAPHeaderBlock to = soapfactory.createSOAPHeaderBlock("To", NameSpaceConstants.WSA_NS);
            to.setText(opts.getTo().getAddress());
            SOAPHeaderBlock action = soapfactory.createSOAPHeaderBlock("Action", NameSpaceConstants.WSA_NS);
            action.setText(message.getNamespace().getNamespaceURI() + "/" + message.getLocalName());
            client.addHeader(action);
            client.addHeader(msgId);
            client.addHeader(to);
        }
        client.setOptions(opts);
        return client;
    }

    private OMElement createMessageEl(EndpointReference eventSinkReferenceEPR, OMElement filterEl, long expireTime) throws AxisFault {
        OMElement message = this.factory.createOMElement("Subscribe", NameSpaceConstants.WSE_NS);
        OMElement delivery = this.factory.createOMElement("Delivery", NameSpaceConstants.WSE_NS);
        OMElement expires = this.factory.createOMElement("Expires", NameSpaceConstants.WSE_NS);
        expires.setText(Long.toString(expireTime));
        message.addChild((OMNode)expires);
        OMElement notifyTo = EndpointReferenceHelper.toOM((OMFactory)this.factory, (EndpointReference)eventSinkReferenceEPR, (QName)new QName(NameSpaceConstants.WSE_NS.getNamespaceURI(), "NotifyTo"), (String)NameSpaceConstants.WSA_NS.getNamespaceURI());
        delivery.addChild((OMNode)notifyTo);
        message.addChild((OMNode)delivery);
        if (filterEl != null) {
            message.addChild((OMNode)filterEl);
        }
        message.declareNamespace(NameSpaceConstants.WSA_NS);
        return message;
    }
}

