/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.client;

import javax.xml.namespace.QName;
import org.apache.airavata.wsmg.client.WidgetStub;
import org.apache.airavata.wsmg.client.WseCreateSubscription;
import org.apache.airavata.wsmg.client.WsrfResourceStub;
import org.apache.airavata.wsmg.commons.NameSpaceConstants;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.axis2.client.ServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsntCreatePublishReg
extends WidgetStub {
    private static final Logger logger = LoggerFactory.getLogger(WseCreateSubscription.class);
    private OMFactory factory = OMAbstractFactory.getOMFactory();
    private static final SOAPFactory soapfactory = OMAbstractFactory.getSOAP11Factory();

    public WsntCreatePublishReg(EndpointReference widgetEpr, long timeout) {
        super(widgetEpr, timeout);
    }

    public WsrfResourceStub registerPublisher(EndpointReference omEndpointReference) throws AxisFault {
        OMElement message = this.factory.createOMElement(new QName(NameSpaceConstants.WSBR_NS.getNamespaceURI(), "RegisterPublisher"));
        OMElement publisherRef = null;
        publisherRef = EndpointReferenceHelper.toOM((OMFactory)this.factory, (EndpointReference)omEndpointReference, (QName)new QName(NameSpaceConstants.WSBR_NS.getNamespaceURI(), "PublisherReference"), (String)NameSpaceConstants.WSA_NS.getNamespaceURI());
        message.addChild((OMNode)publisherRef);
        ServiceClient client = this.createServiceClient(message);
        OMElement responseMessage = client.sendReceive(message);
        client.cleanupTransport();
        OMElement publisherRegistrationRef = responseMessage.getFirstChildWithName(new QName(NameSpaceConstants.WSBR_NS.getNamespaceURI(), "PublisherRegistrationReference"));
        EndpointReference epr = EndpointReferenceHelper.fromOM((OMElement)publisherRegistrationRef);
        return new WsrfResourceStub(epr, this.getTimeoutInMilliSeconds());
    }

    private ServiceClient createServiceClient(OMElement message) throws AxisFault {
        String uuid = UUIDGenerator.getUUID();
        this.opts.setProperty("__CHUNKED__", (Object)Boolean.FALSE);
        this.opts.setMessageId(uuid);
        this.opts.setAction(message.getNamespace().getNamespaceURI() + "/" + message.getLocalName());
        this.opts.setTimeOutInMilliSeconds(this.getTimeoutInMilliSeconds());
        ServiceClient client = new ServiceClient();
        if (client.getAxisConfiguration().getModule("addressing") != null) {
            client.engageModule("addressing");
        } else {
            SOAPHeaderBlock msgId = soapfactory.createSOAPHeaderBlock("MessageID", NameSpaceConstants.WSA_NS);
            msgId.setText(uuid);
            SOAPHeaderBlock to = soapfactory.createSOAPHeaderBlock("To", NameSpaceConstants.WSA_NS);
            to.setText(this.opts.getTo().getAddress());
            SOAPHeaderBlock action = soapfactory.createSOAPHeaderBlock("Action", NameSpaceConstants.WSA_NS);
            action.setText(message.getNamespace().getNamespaceURI() + "/" + message.getLocalName());
            client.addHeader(action);
            client.addHeader(msgId);
            client.addHeader(to);
        }
        client.setOptions(this.opts);
        return client;
    }
}

