/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.client;

import javax.xml.namespace.QName;
import org.apache.airavata.wsmg.client.CommonMsgBrokerClient;
import org.apache.airavata.wsmg.client.ConsumerNotificationHandler;
import org.apache.airavata.wsmg.client.ConsumerServerHandler;
import org.apache.airavata.wsmg.client.MessageBrokerClient;
import org.apache.airavata.wsmg.client.MsgBrokerClientException;
import org.apache.airavata.wsmg.client.commons.NotificationProducer;
import org.apache.airavata.wsmg.client.protocol.WSNTProtocolClient;
import org.apache.airavata.wsmg.client.util.ClientUtil;
import org.apache.airavata.wsmg.commons.CommonRoutines;
import org.apache.airavata.wsmg.commons.NameSpaceConstants;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;

public class WsntMsgBrokerClient
extends CommonMsgBrokerClient
implements MessageBrokerClient {
    protected long timeoutInMilliSeconds = 300000L;
    protected NotificationProducer notifProducer = new NotificationProducer();
    protected ConsumerServerHandler consumerServerHandler = new ConsumerServerHandler();
    private EndpointReference brokerEndpointRef = null;

    public static EndpointReference createEndpointReference(String brokerURL, String topic) {
        return null;
    }

    @Override
    public void init(String brokerLocation) {
        this.brokerEndpointRef = new EndpointReference(ClientUtil.formatURLString(brokerLocation));
    }

    @Override
    public void publish(String topic, String plainText) throws MsgBrokerClientException {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement wrappedMsg = factory.createOMElement("plainTextWrapper", NameSpaceConstants.WSMG_NS);
        wrappedMsg.setText(plainText);
        this.publish(topic, wrappedMsg);
    }

    @Override
    public void publish(String topic, OMElement message) throws MsgBrokerClientException {
        String producerURl = ClientUtil.formatURLString(ClientUtil.getHostIP());
        EndpointReference producerReference = new EndpointReference(producerURl);
        try {
            OMElement messageToNotify = WSNTProtocolClient.encodeNotification(topic, message, producerReference);
            this.notifProducer.deliverMessage(messageToNotify, "wsnt", this.brokerEndpointRef, this.getTimeoutInMilliSeconds());
        }
        catch (AxisFault e) {
            throw new MsgBrokerClientException("unable to publish msg", e);
        }
    }

    @Override
    public String subscribe(String eventSinkLocation, String topicExpression, String xpathExpression) throws MsgBrokerClientException {
        return this.subscribe(new EndpointReference(eventSinkLocation), topicExpression, xpathExpression);
    }

    @Override
    public String subscribe(EndpointReference eventSinkLocation, String topicExpression, String xpathExpression) throws MsgBrokerClientException {
        return this.subscribe(eventSinkLocation, topicExpression, xpathExpression, 259200000L);
    }

    @Override
    public String subscribe(EndpointReference eventSinkLocation, String topicExpression, String xpathExpression, long expireTime) throws MsgBrokerClientException {
        String subscriptionId = null;
        try {
            OMElement message = WSNTProtocolClient.createSubscriptionMsg(eventSinkLocation, topicExpression, xpathExpression);
            ServiceClient client = this.createServiceClient(message);
            OMElement responseMessage = client.sendReceive(message);
            client.cleanupTransport();
            OMElement sr = responseMessage.getFirstChildWithName(new QName(NameSpaceConstants.WSNT_NS.getNamespaceURI(), "SubscriptionReference"));
            if (sr == null) {
                throw new MsgBrokerClientException("unable to subscribe, invalid response returned by broker");
            }
            subscriptionId = WSNTProtocolClient.decodeSubscriptionResponse(sr);
        }
        catch (AxisFault f) {
            throw new MsgBrokerClientException("unable to send the subscription msg", f);
        }
        return subscriptionId;
    }

    private ServiceClient createServiceClient(OMElement message) throws AxisFault {
        String soapAction = message.getNamespace().getNamespaceURI() + "/" + message.getLocalName();
        Options opts = CommonRoutines.getOptions((String)soapAction, (long)this.getTimeoutInMilliSeconds(), (EndpointReference)this.brokerEndpointRef);
        ServiceClient client = new ServiceClient();
        CommonRoutines.setHeaders((String)soapAction, (String)this.brokerEndpointRef.getAddress(), (ServiceClient)client, (OMElement[])new OMElement[0]);
        client.setOptions(opts);
        return client;
    }

    @Override
    public boolean unSubscribe(String subscriptionId) throws MsgBrokerClientException {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement message = WSNTProtocolClient.createUnsubscribeMsg();
        OMElement identifierEl = factory.createOMElement("Identifier", message.getNamespace());
        identifierEl.setText(subscriptionId);
        String soapAction = message.getNamespace().getNamespaceURI() + "/" + message.getLocalName();
        Options opts = CommonRoutines.getOptions((String)soapAction, (long)this.getTimeoutInMilliSeconds(), (EndpointReference)this.brokerEndpointRef);
        try {
            ServiceClient client = new ServiceClient();
            client.setOptions(opts);
            CommonRoutines.setHeaders((String)soapAction, (String)this.brokerEndpointRef.getAddress(), (ServiceClient)client, (OMElement[])new OMElement[]{identifierEl});
            client.sendReceive(message);
            client.cleanupTransport();
        }
        catch (AxisFault e) {
            throw new MsgBrokerClientException("unable to send subscribe msg", e);
        }
        return true;
    }

    public long getTimeoutInMilliSeconds() {
        return this.timeoutInMilliSeconds;
    }

    public void setTimeoutInMilliSeconds(long timeout) {
        this.timeoutInMilliSeconds = timeout;
    }

    @Override
    public String[] startConsumerService(int port, ConsumerNotificationHandler handler) throws MsgBrokerClientException {
        this.consumerServerHandler.createConsumerServer(port, handler);
        return this.consumerServerHandler.getConsumerServiceEndpointReference();
    }

    @Override
    public void shutdownConsumerService() {
        this.consumerServerHandler.shutdownConsumerService();
    }
}

