/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.client;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.airavata.wsmg.client.util.DcDate;
import org.apache.airavata.wsmg.commons.NameSpaceConstants;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsrfResourceStub {
    private static final Logger logger = LoggerFactory.getLogger(WsrfResourceStub.class);
    private static final OMFactory factory = OMAbstractFactory.getOMFactory();
    private static final SOAPFactory soapfactory = OMAbstractFactory.getSOAP11Factory();
    protected Options opts;
    private EndpointReference resourceEndpointReference;
    private long timeoutInMilliSeconds;

    protected WsrfResourceStub(EndpointReference resourceEpr, long timeout) {
        this.resourceEndpointReference = resourceEpr;
        logger.info("resourceEprInWsrfResourceStub Constructor" + resourceEpr.toString());
        this.timeoutInMilliSeconds = timeout;
        this.opts = new Options();
        this.opts.setProperty("__CHUNKED__", (Object)Boolean.FALSE);
        this.opts.setTo(resourceEpr);
        this.opts.setTimeOutInMilliSeconds(timeout);
    }

    public EndpointReference getResourceEpr() {
        return this.resourceEndpointReference;
    }

    public long getTimeoutInMilliSeconds() {
        return this.timeoutInMilliSeconds;
    }

    public void setTimeoutInMilliSeconds(long timeout) {
        this.timeoutInMilliSeconds = timeout;
    }

    public void destroy() throws AxisFault {
        String uuid = UUIDGenerator.getUUID();
        this.opts.setMessageId(uuid);
        OMElement message = factory.createOMElement("Destroy", NameSpaceConstants.WSRL_NS);
        this.opts.setAction(message.getNamespace().getNamespaceURI() + "/" + message.getLocalName());
        this.opts.setTimeOutInMilliSeconds(this.getTimeoutInMilliSeconds());
        ServiceClient client = new ServiceClient();
        if (client.getAxisConfiguration().getModule("addressing") != null) {
            client.engageModule("addressing");
        } else {
            SOAPHeaderBlock msgId = soapfactory.createSOAPHeaderBlock("MessageID", NameSpaceConstants.WSA_NS);
            msgId.setText(uuid);
            SOAPHeaderBlock to = soapfactory.createSOAPHeaderBlock("To", NameSpaceConstants.WSA_NS);
            to.setText(this.resourceEndpointReference.getAddress());
            SOAPHeaderBlock action = soapfactory.createSOAPHeaderBlock("Action", NameSpaceConstants.WSA_NS);
            action.setText(message.getNamespace().getNamespaceURI() + "/" + message.getLocalName());
            client.addHeader(action);
            client.addHeader(msgId);
            client.addHeader(to);
        }
        client.setOptions(this.opts);
        client.sendRobust(message);
    }

    public void setTerminationTime(Calendar cal) throws AxisFault {
        String uuid = UUIDGenerator.getUUID();
        this.opts.setMessageId(uuid);
        OMElement message = factory.createOMElement("SetTerminationTime", NameSpaceConstants.WSRL_NS);
        this.opts.setAction(message.getNamespace().getNamespaceURI() + "/" + message.getLocalName());
        this.opts.setTimeOutInMilliSeconds(this.getTimeoutInMilliSeconds());
        OMElement child = factory.createOMElement("RequestedTerminationTime", message.getNamespace(), (OMContainer)message);
        if (cal == null) {
            OMNamespace XSI_NS = factory.createOMNamespace("http://www.w3.org/2001/XMLSchema", "xsd");
            child.addAttribute("nill", "true", XSI_NS);
        } else {
            DcDate dcDate = new DcDate(cal);
            child.setText(dcDate.toString());
        }
        ServiceClient client = new ServiceClient();
        if (client.getAxisConfiguration().getModule("addressing") != null) {
            client.engageModule("addressing");
        } else {
            SOAPHeaderBlock msgId = soapfactory.createSOAPHeaderBlock("MessageID", NameSpaceConstants.WSA_NS);
            msgId.setText(uuid);
            SOAPHeaderBlock to = soapfactory.createSOAPHeaderBlock("To", NameSpaceConstants.WSA_NS);
            to.setText(this.resourceEndpointReference.getAddress());
            SOAPHeaderBlock action = soapfactory.createSOAPHeaderBlock("Action", NameSpaceConstants.WSA_NS);
            action.setText(message.getNamespace().getNamespaceURI() + "/" + message.getLocalName());
            client.addHeader(action);
            client.addHeader(msgId);
            client.addHeader(to);
        }
        client.setOptions(this.opts);
        client.sendRobust(message);
    }

    public List<OMElement> getResourceProperty(QName qn) throws AxisFault {
        ServiceClient client;
        OMElement messageEl = factory.createOMElement("GetResourceProperty", NameSpaceConstants.WSRP_NS);
        String uuid = UUIDGenerator.getUUID();
        this.opts.setTimeOutInMilliSeconds(this.getTimeoutInMilliSeconds());
        this.opts.setMessageId(uuid);
        this.opts.setAction(messageEl.getNamespace().getNamespaceURI() + "/" + messageEl.getLocalName());
        QName textQName = new QName(qn.getNamespaceURI(), qn.getLocalPart(), qn.getPrefix());
        factory.createOMText((OMContainer)messageEl, textQName);
        if (qn.getPrefix() != null) {
            OMNamespace ns = factory.createOMNamespace(qn.getNamespaceURI(), qn.getPrefix());
            messageEl.declareNamespace(ns);
        }
        if ((client = new ServiceClient()).getAxisConfiguration().getModule("addressing") != null) {
            client.engageModule("addressing");
        } else {
            SOAPHeaderBlock msgId = soapfactory.createSOAPHeaderBlock("MessageID", NameSpaceConstants.WSA_NS);
            msgId.setText(uuid);
            SOAPHeaderBlock to = soapfactory.createSOAPHeaderBlock("To", NameSpaceConstants.WSA_NS);
            to.setText(this.resourceEndpointReference.getAddress());
            SOAPHeaderBlock action = soapfactory.createSOAPHeaderBlock("Action", NameSpaceConstants.WSA_NS);
            action.setText(messageEl.getNamespace().getNamespaceURI() + "/" + messageEl.getLocalName());
            client.addHeader(action);
            client.addHeader(msgId);
            client.addHeader(to);
        }
        client.setOptions(this.opts);
        OMElement responseMessage = client.sendReceive(messageEl);
        client.cleanupTransport();
        List<OMElement> list = this.elementsAsList(responseMessage);
        return list;
    }

    public List<OMElement> getMultipleResourceProperties(QName[] qnamez) throws AxisFault {
        OMElement messageEl = factory.createOMElement("GetMultipleResourceProperties", NameSpaceConstants.WSRP_NS);
        String uuid = UUIDGenerator.getUUID();
        this.opts.setMessageId(uuid);
        this.opts.setAction(messageEl.getNamespace().getNamespaceURI() + "/" + messageEl.getLocalName());
        this.opts.setTimeOutInMilliSeconds(this.getTimeoutInMilliSeconds());
        for (QName qn : qnamez) {
            OMNamespace ns = factory.createOMNamespace(qn.getNamespaceURI(), qn.getPrefix());
            OMElement child = factory.createOMElement("ResourceProperty", NameSpaceConstants.WSRP_NS);
            QName textQName = new QName(qn.getNamespaceURI(), qn.getLocalPart(), qn.getPrefix());
            factory.createOMText((OMContainer)child, textQName);
            if (qn.getPrefix() == null) continue;
            messageEl.declareNamespace(ns);
        }
        ServiceClient client = new ServiceClient();
        if (client.getAxisConfiguration().getModule("addressing") != null) {
            client.engageModule("addressing");
        } else {
            SOAPHeaderBlock msgId = soapfactory.createSOAPHeaderBlock("MessageID", NameSpaceConstants.WSA_NS);
            msgId.setText(uuid);
            SOAPHeaderBlock to = soapfactory.createSOAPHeaderBlock("To", NameSpaceConstants.WSA_NS);
            to.setText(this.resourceEndpointReference.getAddress());
            SOAPHeaderBlock action = soapfactory.createSOAPHeaderBlock("Action", NameSpaceConstants.WSA_NS);
            action.setText(messageEl.getNamespace().getNamespaceURI() + "/" + messageEl.getLocalName());
            client.addHeader(action);
            client.addHeader(msgId);
            client.addHeader(to);
        }
        client.setOptions(this.opts);
        OMElement responseMessage = client.sendReceive(messageEl);
        client.cleanupTransport();
        List<OMElement> list = this.elementsAsList(responseMessage);
        return list;
    }

    public List<OMNode> queryResourcePropertiesByXpath(String query) throws AxisFault {
        if (query == null) {
            throw new IllegalArgumentException();
        }
        String uuid = UUIDGenerator.getUUID();
        this.opts.setMessageId(uuid);
        this.opts.setTimeOutInMilliSeconds(this.getTimeoutInMilliSeconds());
        OMElement messageEl = factory.createOMElement("QueryResourceProperties", NameSpaceConstants.WSRP_NS);
        this.opts.setAction(messageEl.getNamespace().getNamespaceURI() + "/" + messageEl.getLocalName());
        OMElement queryExpressionEl = factory.createOMElement("QueryExpression", NameSpaceConstants.WSRP_NS);
        queryExpressionEl.addAttribute("dialect", "http://www.w3.org/TR/1999/REC-xpath-19991116", null);
        queryExpressionEl.setText(query);
        ServiceClient client = new ServiceClient();
        if (client.getAxisConfiguration().getModule("addressing") != null) {
            client.engageModule("addressing");
        } else {
            SOAPHeaderBlock msgId = soapfactory.createSOAPHeaderBlock("MessageID", NameSpaceConstants.WSA_NS);
            msgId.setText(uuid);
            SOAPHeaderBlock to = soapfactory.createSOAPHeaderBlock("To", NameSpaceConstants.WSA_NS);
            to.setText(this.resourceEndpointReference.getAddress());
            SOAPHeaderBlock action = soapfactory.createSOAPHeaderBlock("Action", NameSpaceConstants.WSA_NS);
            action.setText(messageEl.getNamespace().getNamespaceURI() + "/" + messageEl.getLocalName());
            client.addHeader(action);
            client.addHeader(msgId);
            client.addHeader(to);
        }
        client.setOptions(this.opts);
        OMElement responseMessage = client.sendReceive(messageEl);
        client.cleanupTransport();
        List<OMNode> list = this.childrenAsList(responseMessage);
        return list;
    }

    public void setResourceProperties(OMElement[] requests) throws AxisFault {
        if (requests.length == 0) {
            throw new IllegalArgumentException("at least one request is required");
        }
        OMElement messageEl = factory.createOMElement("SetResourceProperties", NameSpaceConstants.WSRP_NS);
        String uuid = UUIDGenerator.getUUID();
        this.opts.setMessageId(uuid);
        this.opts.setTimeOutInMilliSeconds(this.getTimeoutInMilliSeconds());
        this.opts.setAction(messageEl.getNamespace().getNamespaceURI() + "/" + messageEl.getLocalName());
        for (int i = 0; i < requests.length; ++i) {
            messageEl.addChild((OMNode)requests[i]);
        }
        ServiceClient client = new ServiceClient();
        if (client.getAxisConfiguration().getModule("addressing") != null) {
            client.engageModule("addressing");
        } else {
            SOAPHeaderBlock msgId = soapfactory.createSOAPHeaderBlock("MessageID", NameSpaceConstants.WSA_NS);
            msgId.setText(uuid);
            SOAPHeaderBlock to = soapfactory.createSOAPHeaderBlock("To", NameSpaceConstants.WSA_NS);
            to.setText(this.resourceEndpointReference.getAddress());
            SOAPHeaderBlock action = soapfactory.createSOAPHeaderBlock("Action", NameSpaceConstants.WSA_NS);
            action.setText(messageEl.getNamespace().getNamespaceURI() + "/" + messageEl.getLocalName());
            client.addHeader(action);
            client.addHeader(msgId);
            client.addHeader(to);
        }
        client.setOptions(this.opts);
        client.sendRobust(messageEl);
    }

    private List<OMElement> elementsAsList(OMElement responseMessage) {
        ArrayList<OMElement> list = new ArrayList<OMElement>();
        Iterator it = responseMessage.getChildElements();
        while (it.hasNext()) {
            OMElement current = (OMElement)it.next();
            list.add(current);
        }
        return list;
    }

    private List<OMNode> childrenAsList(OMElement responseMessage) {
        ArrayList<OMNode> list = new ArrayList<OMNode>();
        Iterator it = responseMessage.getChildren();
        while (it.hasNext()) {
            OMNode child = (OMNode)it.next();
            list.add(child);
        }
        return list;
    }

    public static void verbose(String msg) {
        System.err.println(msg);
    }
}

