/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.client.msgbox;

import java.util.Iterator;
import org.apache.airavata.wsmg.client.NotificationHandler;
import org.apache.airavata.wsmg.msgbox.client.MsgBoxClient;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.addressing.EndpointReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagePuller {
    private static final Logger logger = LoggerFactory.getLogger(MessagePuller.class);
    MsgBoxClient msgBoxUser = null;
    EndpointReference msgBoxId = null;
    NotificationHandler handler = null;
    long backoff = 1000L;
    long unavailableInterval = 300000L;
    long timeout = 1000L;
    boolean stopPulling = false;

    public MessagePuller() {
    }

    public MessagePuller(MsgBoxClient msgBoxUser, EndpointReference msgBoxAddr, NotificationHandler handler, long backoff, long timeout) {
        this.msgBoxUser = msgBoxUser;
        this.msgBoxId = msgBoxAddr;
        this.handler = handler;
        this.backoff = backoff;
        this.timeout = timeout;
    }

    public MessagePuller(MsgBoxClient msgBoxUser, EndpointReference msgBoxId, NotificationHandler handler) {
        this(msgBoxUser, msgBoxId, handler, 1000L, 500L);
    }

    public void startPulling() {
        Puller puller = new Puller();
        new Thread(puller).start();
    }

    public void stopPulling() {
        this.stopPulling = true;
    }

    protected class Puller
    implements Runnable {
        protected Puller() {
        }

        @Override
        public void run() {
            long backofftime = MessagePuller.this.backoff;
            while (!MessagePuller.this.stopPulling) {
                Iterator<OMElement> messages = null;
                try {
                    messages = MessagePuller.this.msgBoxUser.takeMessagesFromMsgBox(MessagePuller.this.msgBoxId, MessagePuller.this.timeout);
                    try {
                        if (messages == null || !messages.hasNext()) {
                            Thread.sleep(MessagePuller.this.backoff);
                        }
                    }
                    catch (InterruptedException ex) {
                        logger.error("the message puller thread was interruped", (Throwable)ex);
                    }
                    if (messages == null || !messages.hasNext()) continue;
                    backofftime = MessagePuller.this.backoff;
                    while (messages.hasNext()) {
                        String notification = messages.next().toStringWithConsume();
                        try {
                            MessagePuller.this.handler.handleNotification(notification);
                        }
                        catch (Throwable e) {
                            logger.info("Error occured in the user callback for message" + notification + e.toString());
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("exception on MessagePuller", (Throwable)e);
                    try {
                        Thread.sleep(Math.min(backofftime *= 2L, MessagePuller.this.unavailableInterval));
                        backofftime = Math.min(backofftime, MessagePuller.this.unavailableInterval);
                    }
                    catch (InterruptedException e1) {
                        logger.error("message puller was interruped while sleeping", (Throwable)e1);
                    }
                }
            }
        }
    }
}

