/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.client.protocol;

import javax.xml.namespace.QName;
import org.apache.airavata.wsmg.commons.NameSpaceConstants;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.EndpointReferenceHelper;

public class WSEProtocolClient {
    public static EndpointReference createEndpointReference(String brokerURL, String topic) {
        if (brokerURL == null) {
            throw new IllegalArgumentException("Broker URL is null.");
        }
        if (topic == null) {
            throw new IllegalArgumentException("Topic is null.");
        }
        String sinkLocation = brokerURL.endsWith("/") ? brokerURL + "topic/" + topic : brokerURL + "/topic/" + topic;
        EndpointReference eventSinkReference = new EndpointReference(sinkLocation);
        return eventSinkReference;
    }

    private static OMElement createFilter(String topicExpression, String xpathExpression) {
        boolean hasTopicExpression = topicExpression != null && topicExpression.length() != 0;
        boolean hasXPathExpression = xpathExpression != null && xpathExpression.length() != 0;
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement filterEl = null;
        if (hasTopicExpression && hasXPathExpression) {
            filterEl = factory.createOMElement("Filter", NameSpaceConstants.WSE_NS);
            filterEl.addAttribute("Dialect", "http://docs.oasis-open.org/wsn", null);
            OMElement topicExpressionEl = factory.createOMElement("TopicExpression", NameSpaceConstants.WSNT_NS);
            topicExpressionEl.addAttribute("Dialect", "http://www.ibm.com/xmlns/stdwip/web-services/WS-Topics/TopicExpression/simple", null);
            topicExpressionEl.declareNamespace(NameSpaceConstants.WIDGET_NS);
            topicExpressionEl.setText(NameSpaceConstants.WIDGET_NS.getPrefix() + ":" + topicExpression);
            filterEl.addChild((OMNode)topicExpressionEl);
            OMElement xpathEl = factory.createOMElement("MessageContent", NameSpaceConstants.WSNT_NS);
            xpathEl.addAttribute("Dialect", "http://www.w3.org/TR/1999/REC-xpath-19991116", null);
            xpathEl.setText(xpathExpression);
            filterEl.addChild((OMNode)xpathEl);
        } else if (hasTopicExpression) {
            filterEl = factory.createOMElement("Filter", NameSpaceConstants.WSE_NS);
            filterEl.addAttribute("Dialect", "http://www.ibm.com/xmlns/stdwip/web-services/WS-Topics/TopicExpression/simple", null);
            filterEl.declareNamespace(NameSpaceConstants.WIDGET_NS);
            filterEl.setText(NameSpaceConstants.WIDGET_NS.getPrefix() + ":" + topicExpression);
        } else if (hasXPathExpression) {
            filterEl = factory.createOMElement("Filter", NameSpaceConstants.WSE_NS);
            filterEl.addAttribute("Dialect", "http://www.w3.org/TR/1999/REC-xpath-19991116", null);
            filterEl.setText(xpathExpression);
        }
        return filterEl;
    }

    public static OMElement createSubscription(EndpointReference eventSink, String topicExpression, String xpathExpression, long expireTime) throws AxisFault {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement subscribeMsg = factory.createOMElement("Subscribe", NameSpaceConstants.WSE_NS);
        OMElement delivery = factory.createOMElement("Delivery", NameSpaceConstants.WSE_NS);
        OMElement expires = factory.createOMElement("Expires", NameSpaceConstants.WSE_NS);
        expires.setText(Long.toString(expireTime));
        subscribeMsg.addChild((OMNode)expires);
        OMElement notifyTo = EndpointReferenceHelper.toOM((OMFactory)factory, (EndpointReference)eventSink, (QName)new QName(NameSpaceConstants.WSE_NS.getNamespaceURI(), "NotifyTo"), (String)NameSpaceConstants.WSA_NS.getNamespaceURI());
        delivery.addChild((OMNode)notifyTo);
        subscribeMsg.addChild((OMNode)delivery);
        OMElement filterEl = WSEProtocolClient.createFilter(topicExpression, xpathExpression);
        if (filterEl != null) {
            subscribeMsg.addChild((OMNode)filterEl);
        }
        subscribeMsg.declareNamespace(NameSpaceConstants.WSA_NS);
        return subscribeMsg;
    }

    public static String decodeSubscribeResponse(OMElement responseSubscriptionsManagerElement) throws AxisFault {
        OMElement identifierEl;
        String subscriptionId = null;
        OMElement referencePropertiesEl = responseSubscriptionsManagerElement.getFirstChildWithName(new QName(NameSpaceConstants.WSA_NS.getNamespaceURI(), "ReferenceProperties"));
        if (referencePropertiesEl == null) {
            referencePropertiesEl = responseSubscriptionsManagerElement.getFirstChildWithName(new QName(NameSpaceConstants.WSA_NS.getNamespaceURI(), "ReferenceParameters"));
        }
        if ((identifierEl = referencePropertiesEl.getFirstChildWithName(new QName(NameSpaceConstants.WSE_NS.getNamespaceURI(), "Identifier"))) == null) {
            throw new AxisFault("invalid response message, subscription id was not sent by broker");
        }
        subscriptionId = identifierEl.getText();
        return subscriptionId;
    }

    public static OMElement createUnsubscribeMsg() {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement message = factory.createOMElement("Unsubscribe", NameSpaceConstants.WSE_NS);
        return message;
    }
}

