/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.msgbox.client;

import java.rmi.RemoteException;
import java.util.Iterator;
import org.apache.airavata.wsmg.msgbox.client.CreateMsgBox;
import org.apache.airavata.wsmg.msgbox.client.DestroyMsgBox;
import org.apache.airavata.wsmg.msgbox.client.StoreMessage;
import org.apache.airavata.wsmg.msgbox.client.TakeMessages;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.addressing.EndpointReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgBoxClient {
    int msgsAtOnce = 10;
    static Logger logger = LoggerFactory.getLogger(MsgBoxClient.class);

    public EndpointReference createMessageBox(String msgBoxLocation, long timeout) throws RemoteException {
        CreateMsgBox msgBox = new CreateMsgBox(msgBoxLocation, timeout);
        return msgBox.execute();
    }

    public String storeMessage(EndpointReference msgBoxEpr, long timeout, OMElement messageIn) throws RemoteException {
        StoreMessage strMsg = new StoreMessage(msgBoxEpr, timeout);
        return strMsg.execute(messageIn);
    }

    public Iterator<OMElement> takeMessagesFromMsgBox(EndpointReference msgBoxEpr, long timeout) throws RemoteException {
        TakeMessages takeMsgs = new TakeMessages(msgBoxEpr, timeout);
        return takeMsgs.execute();
    }

    public String deleteMsgBox(EndpointReference msgBoxEpr, long timeout) throws RemoteException {
        DestroyMsgBox destroyMsgBox = new DestroyMsgBox(msgBoxEpr, timeout);
        return destroyMsgBox.execute();
    }
}

