/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.msgbox.client;

import org.apache.airavata.wsmg.commons.NameSpaceConstants;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreMessage {
    private static final Logger logger = LoggerFactory.getLogger(StoreMessage.class);
    protected EndpointReference msgBoxEndPointReference;
    protected long timeoutInMilliSeconds;

    public StoreMessage(EndpointReference msgBoxEpr, long timeout) throws AxisFault {
        this.msgBoxEndPointReference = msgBoxEpr;
        this.timeoutInMilliSeconds = timeout;
        String address = msgBoxEpr.getAddress();
        int biginIndex = address.indexOf("clientid");
        if (biginIndex == -1) {
            throw new AxisFault("Invalid Message Box EPR cannot find message box ID");
        }
    }

    public long getTimeoutInMilliSeconds() {
        return this.timeoutInMilliSeconds;
    }

    public void setTimeoutInMilliSeconds(long timeout) {
        this.timeoutInMilliSeconds = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(OMElement messageIn) throws AxisFault {
        ServiceClient serviceClient = this.createServiceClient();
        OMElement responseMessage = null;
        try {
            responseMessage = serviceClient.sendReceive(messageIn);
        }
        finally {
            serviceClient.cleanupTransport();
        }
        if (responseMessage == null) {
            throw AxisFault.makeFault((Throwable)new RuntimeException("no response recieved for subscription message"));
        }
        return responseMessage.getFirstElement().getText();
    }

    private ServiceClient createServiceClient() throws AxisFault {
        ServiceClient client;
        Options opts;
        block3: {
            String uuid = UUIDGenerator.getUUID();
            opts = new Options();
            opts.setProperty("__CHUNKED__", (Object)Boolean.FALSE);
            opts.setTo(this.msgBoxEndPointReference);
            opts.setMessageId(uuid);
            opts.setAction(NameSpaceConstants.MSG_BOX.getNamespaceURI() + "/" + "storeMessages");
            opts.setTimeOutInMilliSeconds(this.getTimeoutInMilliSeconds());
            client = new ServiceClient();
            try {
                client.engageModule("addressing");
                if (logger.isDebugEnabled()) {
                    logger.debug("Addressing module engaged");
                }
            }
            catch (AxisFault e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Addressing module not engaged :" + (Object)((Object)e));
            }
        }
        client.setOptions(opts);
        return client;
    }
}

