/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.msgbox.client;

import java.util.Iterator;
import org.apache.airavata.wsmg.commons.NameSpaceConstants;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TakeMessages {
    private static final Logger logger = LoggerFactory.getLogger(TakeMessages.class);
    private final OMFactory factory = OMAbstractFactory.getOMFactory();
    protected EndpointReference msgBoxEndPointReference;
    protected long timeoutInMilliSeconds;
    private String msgBoxId;

    public TakeMessages(EndpointReference msgBoxEpr, long timeout) throws AxisFault {
        this.msgBoxEndPointReference = msgBoxEpr;
        this.timeoutInMilliSeconds = timeout;
        String address = msgBoxEpr.getAddress();
        int biginIndex = address.indexOf("clientid");
        if (biginIndex == -1) {
            throw new AxisFault("Invalid Message Box EPR cannot find message box ID");
        }
        this.msgBoxId = address.substring(biginIndex + "clientid".length() + 1);
    }

    public long getTimeoutInMilliSeconds() {
        return this.timeoutInMilliSeconds;
    }

    public void setTimeoutInMilliSeconds(long timeout) {
        this.timeoutInMilliSeconds = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<OMElement> execute() throws AxisFault {
        OMElement message = this.createMessageEl(this.msgBoxId);
        ServiceClient serviceClient = this.createServiceClient(message);
        OMElement responseMessage = null;
        try {
            responseMessage = serviceClient.sendReceive(message);
            if (responseMessage == null) {
                throw AxisFault.makeFault((Throwable)new RuntimeException("no response recieved for subscription message"));
            }
            responseMessage.build();
        }
        finally {
            serviceClient.cleanupTransport();
        }
        return responseMessage.getFirstElement().getChildren();
    }

    private OMElement createMessageEl(String msgboxid) throws AxisFault {
        OMElement message = this.factory.createOMElement("takeMessages", NameSpaceConstants.MSG_BOX);
        OMElement msgBoxId = this.factory.createOMElement("MsgBoxId", NameSpaceConstants.MSG_BOX);
        msgBoxId.setText(msgboxid);
        message.addChild((OMNode)msgBoxId);
        message.declareNamespace(NameSpaceConstants.MSG_BOX);
        return message;
    }

    private ServiceClient createServiceClient(OMElement message) throws AxisFault {
        ServiceClient client;
        Options opts;
        block3: {
            String uuid = UUIDGenerator.getUUID();
            opts = new Options();
            opts.setProperty("__CHUNKED__", (Object)Boolean.FALSE);
            opts.setTo(this.msgBoxEndPointReference);
            opts.setMessageId(uuid);
            opts.setAction(message.getNamespace().getNamespaceURI() + "/" + message.getLocalName());
            opts.setTimeOutInMilliSeconds(this.getTimeoutInMilliSeconds());
            client = new ServiceClient();
            try {
                client.engageModule("addressing");
                if (logger.isDebugEnabled()) {
                    logger.debug("Addressing module engaged");
                }
            }
            catch (AxisFault e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Addressing module not engaged :" + (Object)((Object)e));
            }
        }
        client.setOptions(opts);
        return client;
    }
}

