/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.configuration;

import java.io.IOException;
import java.util.Properties;
import org.apache.any23.configuration.Configuration;
import org.apache.any23.configuration.DefaultModifiableConfiguration;
import org.apache.any23.configuration.ModifiableConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfiguration
implements Configuration {
    public static final String DEFAULT_CONFIG_FILE = "/default-configuration.properties";
    public static final String FLAG_PROPERTY_ON = "on";
    public static final String FLAG_PROPERTY_OFF = "off";
    protected static final Logger logger = LoggerFactory.getLogger(DefaultConfiguration.class);
    protected static final DefaultConfiguration singleton = new DefaultConfiguration();
    protected final Properties properties;

    protected DefaultConfiguration(Properties properties) {
        this.properties = properties;
    }

    private DefaultConfiguration() {
        this(DefaultConfiguration.loadDefaultProperties());
    }

    public static synchronized DefaultConfiguration singleton() {
        return singleton;
    }

    public static synchronized ModifiableConfiguration copy() {
        Properties propertiesCopy = (Properties)DefaultConfiguration.singleton.properties.clone();
        return new DefaultModifiableConfiguration(propertiesCopy);
    }

    private static Properties loadDefaultProperties() {
        Properties properties = new Properties();
        try {
            properties.load(DefaultConfiguration.class.getResourceAsStream(DEFAULT_CONFIG_FILE));
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error while loading default configuration.", ioe);
        }
        return properties;
    }

    @Override
    public synchronized String[] getProperties() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    @Override
    public synchronized boolean defineProperty(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    @Override
    public synchronized String getProperty(String propertyName, String defaultValue) {
        String value = this.getPropertyValue(propertyName);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public synchronized String getPropertyOrFail(String propertyName) {
        String propertyValue = this.getPropertyValue(propertyName);
        if (propertyValue == null) {
            throw new IllegalArgumentException("The property '" + propertyName + "' is expected to be declared.");
        }
        if (propertyValue.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid value '" + propertyValue + "' for property '" + propertyName + "'");
        }
        return propertyValue;
    }

    @Override
    public synchronized int getPropertyIntOrFail(String propertyName) {
        String value = this.getPropertyOrFail(propertyName);
        String trimValue = value.trim();
        try {
            return Integer.parseInt(trimValue);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException("The retrieved property is not a valid Integer: '" + trimValue + "'");
        }
    }

    @Override
    public synchronized boolean getFlagProperty(String propertyName) {
        String value = this.getPropertyOrFail(propertyName);
        if (value == null) {
            return false;
        }
        if (FLAG_PROPERTY_ON.equals(value)) {
            return true;
        }
        if (FLAG_PROPERTY_OFF.equals(value)) {
            return false;
        }
        throw new IllegalArgumentException(String.format("Invalid value [%s] for flag property [%s]. Supported values are %s|%s", value, propertyName, FLAG_PROPERTY_ON, FLAG_PROPERTY_OFF));
    }

    @Override
    public synchronized String getConfigurationDump() {
        String[] defaultProperties = this.getProperties();
        StringBuilder sb = new StringBuilder();
        sb.append("\n======================= Configuration Properties =======================\n");
        for (String defaultProperty : defaultProperties) {
            sb.append(defaultProperty).append('=').append(this.getPropertyValue(defaultProperty)).append('\n');
        }
        sb.append("========================================================================\n");
        return sb.toString();
    }

    private String getPropertyValue(String propertyName) {
        if (!this.defineProperty(propertyName)) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Property '%s' is not declared in default configuration file [%s]", propertyName, DEFAULT_CONFIG_FILE));
            }
            return null;
        }
        String systemValue = System.getProperties().getProperty(propertyName);
        if (systemValue == null) {
            return this.properties.getProperty(propertyName);
        }
        return systemValue;
    }
}

