/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor;

import org.eclipse.rdf4j.model.IRI;

public class ExtractionContext {
    public static final String ROOT_EXTRACTION_RESULT_ID = "root-extraction-result-id";
    private final String extractorName;
    private final IRI documentIRI;
    private String defaultLanguage;
    private final String uniqueID;

    public ExtractionContext(String extractorName, IRI documentIRI, String defaultLanguage, String localID) {
        this.checkNotNull(extractorName, "extractor name");
        this.checkNotNull(documentIRI, "document IRI");
        this.extractorName = extractorName;
        this.documentIRI = documentIRI;
        this.defaultLanguage = defaultLanguage;
        this.uniqueID = "urn:x-any23:" + extractorName + ":" + (localID == null ? "" : localID) + ":" + documentIRI;
    }

    public ExtractionContext(String extractorName, IRI documentIRI, String defaultLanguage) {
        this(extractorName, documentIRI, defaultLanguage, ROOT_EXTRACTION_RESULT_ID);
    }

    public ExtractionContext(String extractorName, IRI documentIRI) {
        this(extractorName, documentIRI, null);
    }

    public ExtractionContext copy(String localID) {
        return new ExtractionContext(this.getExtractorName(), this.getDocumentIRI(), this.getDefaultLanguage(), localID);
    }

    public String getExtractorName() {
        return this.extractorName;
    }

    public IRI getDocumentIRI() {
        return this.documentIRI;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    public int hashCode() {
        return this.uniqueID.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ExtractionContext)) {
            return false;
        }
        return ((ExtractionContext)other).uniqueID.equals(this.uniqueID);
    }

    public String toString() {
        return "ExtractionContext(" + this.uniqueID + ")";
    }

    private void checkNotNull(Object data, String desc) {
        if (data == null) {
            throw new NullPointerException(desc + " cannot be null.");
        }
    }
}

